/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.ianywhere.errorreporting.ExceptionHandler;
import com.sybase.central.SCViewerSupport5;
import com.sybase.central.editor.SCEditor;
import com.sybase.central.lang.ScjResourceConstants;
import com.sybase.central.viewer.Configuration;
import com.sybase.central.viewer.ProviderEntry;
import com.sybase.central.viewer.Providers;
import com.sybase.central.viewer.Register;
import com.sybase.central.viewer.SCImageLoader;
import com.sybase.central.viewer.SCRepository;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.ScjViewerSupport;
import com.sybase.central.viewer.Version;
import com.sybase.central.viewer.Viewer;
import com.sybase.util.AppCounter;
import com.sybase.util.ExceptionHandlerClient;
import com.sybase.util.ImageUtils;
import com.sybase.util.JREUtils;
import com.sybase.util.OEMSupport;
import com.sybase.util.Platform;
import com.sybase.util.SplashScreen;
import com.sybase.util.UIUtils;
import java.awt.Image;
import java.io.File;
import java.io.PrintStream;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class SybaseCentral
implements ExceptionHandlerClient,
com.ianywhere.errorreporting.ExceptionHandlerClient,
ScjResourceConstants {
    private JApplet _applet;
    ScjSession session;
    private ScjViewerSupport _vs;
    protected Viewer _viewer;
    private static AppCounter _appCounter = null;
    protected static SybaseCentral _program = null;
    private static Boolean IQInstallation = null;

    public SybaseCentral() {
        this(null);
    }

    public SybaseCentral(JApplet jApplet) {
        this._applet = jApplet;
    }

    public void initialize(String[] stringArray) {
        this.session = new ScjSession(this._applet, stringArray);
    }

    public void run() {
        Configuration configuration = this.session.getConfiguration();
        SplashScreen splashScreen = null;
        if (this._applet == null && configuration.isSplashscreenEnabled()) {
            Image image = configuration.getSplashscreenImage(this.session);
            if (image == null) {
                String string;
                Image image2 = configuration.getIconImage(this.session);
                if (image2 == null) {
                    image2 = SCImageLoader.getImage("scj64", 1006);
                }
                if ((string = configuration.getTitle()) == null) {
                    string = ScjSession.getString("STR_APP_NAME");
                }
                splashScreen = new SplashScreen(SCImageLoader.getImage("splashscreen", 1006), ScjSession.getString("STR_COPYRIGHT"), "", image2, string);
            } else {
                splashScreen = new SplashScreen(image);
            }
        }
        if (splashScreen != null) {
            splashScreen.setStatusMessage(ScjSession.getString("STR_SPLASH_INIT"));
        }
        this._vs = new ScjViewerSupport(this.session, _appCounter);
        this._vs.AppStarted();
        this._viewer = new Viewer(this.session, this._vs);
        this.session.startWait();
        this._viewer.getFrame().setVisible(true);
        if (splashScreen != null) {
            splashScreen.setVisible(false);
            splashScreen.setVisible(true);
        }
        this._vs.initialize(this._viewer, splashScreen);
        if (splashScreen != null) {
            splashScreen.close();
        }
        this.session.updateConnectionOptions();
        this._viewer.getViewerManager().getMainPanel().open();
        ScjSession.startup = false;
        this.session.endWait();
        SCEditor.setHelpFolder((String)this.session.getCommandLineProperties().getProperty("installdir"), (String)"scvw", (String)(Integer.toString(6) + Integer.toString(0) + Integer.toString(0)));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SybaseCentral.this._viewer.getViewerManager().startupCompleted();
            }
        });
    }

    public static void main(AppCounter appCounter, String[] stringArray) {
        _appCounter = appCounter;
        SybaseCentral.main(stringArray);
    }

    private static String stripQuotes(String string) {
        if (string.length() >= 2 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private static void processInstallerOptions(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = false;
        Object var7_3 = null;
        String string2 = "-screpository=";
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].startsWith(string2)) continue;
            string = stringArray[n].substring(string2.length());
            string = SybaseCentral.stripQuotes(string);
            break;
        }
        if (string == null) {
            string = ".";
        }
        for (n = 0; n < stringArray.length - 1; ++n) {
            String string3;
            String string4;
            if (stringArray[n].equalsIgnoreCase("-register")) {
                Register.main(new String[]{"-p", string, SybaseCentral.stripQuotes(stringArray[++n])});
                bl = true;
            }
            if (stringArray[n].equalsIgnoreCase("-unregister")) {
                Register.main(new String[]{"-pu", string, SybaseCentral.stripQuotes(stringArray[++n])});
                bl = true;
            }
            if (stringArray[n].equalsIgnoreCase("-write")) {
                if (n > stringArray.length - 3) continue;
                string4 = SybaseCentral.stripQuotes(stringArray[n + 1]);
                string3 = SybaseCentral.stripQuotes(stringArray[n + 2]);
                Register.main(new String[]{"-r", string, string4, string3});
                n += 2;
                bl = true;
            }
            if (stringArray[n].equalsIgnoreCase("-writeuser")) {
                if (n > stringArray.length - 3) continue;
                string4 = SybaseCentral.stripQuotes(stringArray[n + 1]);
                string3 = SybaseCentral.stripQuotes(stringArray[n + 2]);
                Register.main(new String[]{"-u", string4, string3});
                n += 2;
                bl = true;
            }
            if (stringArray[n].equalsIgnoreCase("-writeenc")) {
                if (n > stringArray.length - 3) continue;
                string4 = SybaseCentral.stripQuotes(stringArray[n + 1]);
                string3 = SybaseCentral.stripQuotes(stringArray[n + 2]);
                Register.main(new String[]{"-re", string, string4, string3});
                n += 2;
                bl = true;
            }
            if (stringArray[n].equalsIgnoreCase("-writeuserenc")) {
                if (n > stringArray.length - 3) continue;
                string4 = SybaseCentral.stripQuotes(stringArray[n + 1]);
                string3 = SybaseCentral.stripQuotes(stringArray[n + 2]);
                Register.main(new String[]{"-ue", string4, string3});
                n += 2;
                bl = true;
            }
            if (!stringArray[n].equalsIgnoreCase("-importconnectionprofiles") || n > stringArray.length - 5) continue;
            String string5 = SybaseCentral.stripQuotes(stringArray[n + 2]);
            string5 = string5.charAt(string5.length() - 1) != File.separatorChar ? string5 + File.separatorChar + SCRepository.SC_REP_NAME : string5 + SCRepository.SC_REP_NAME;
            Register.main(new String[]{"-ccp", SybaseCentral.stripQuotes(stringArray[n + 1]), string5, SybaseCentral.stripQuotes(stringArray[n + 3]), SybaseCentral.stripQuotes(stringArray[n + 4]), string + SCRepository.SC_REP_NAME});
            n += 4;
            bl = true;
        }
        if (bl) {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        SybaseCentral.processInstallerOptions(stringArray);
        Platform.installJREFixes();
        _program = new SybaseCentral(null);
        try {
            ExceptionHandler.init((com.ianywhere.errorreporting.ExceptionHandlerClient)_program);
            ExceptionHandler.install();
            UIUtils.installLookAndFeel();
            if (JREUtils.getJDKVersion() >= 1.4) {
                _program.initialize(stringArray);
                File file = new File(SybaseCentral._program.session.getSCRepository().getLocation() + "sc.policy");
                if (file.exists()) {
                    System.setProperty("java.security.policy", file.getCanonicalPath());
                    System.setSecurityManager(new SecurityManager());
                }
                _program.run();
            } else {
                System.out.println("The viewer requires at least version 1.4 of the Java VM to run.");
            }
        }
        catch (Throwable throwable) {
            if (_program != null && SybaseCentral._program.session != null) {
                SybaseCentral._program.session.endWait();
            }
            ExceptionHandler.handleException((Throwable)throwable);
        }
    }

    public boolean useGUI() {
        return true;
    }

    public void printApplicationInformation(PrintStream printStream) {
        printStream.println(this.getApplicationInformation());
    }

    public String getDefaultFileName() {
        return "scj_errors";
    }

    public JFrame getParent() {
        if (this.session != null) {
            SybaseCentral sybaseCentral = this;
            return sybaseCentral.session.getViewerFrame();
        }
        return null;
    }

    public String getDialogTitle() {
        return ScjSession.getString("STR_ERROR_REPORTING_TITLE");
    }

    public String getContactInformation() {
        return "Please report this information to Sybase";
    }

    public String getApplicationInformation() {
        Providers providers;
        Enumeration enumeration;
        StringBuffer stringBuffer = new StringBuffer(1024);
        if (this.session != null) {
            this.session.endWait();
        }
        stringBuffer.append(ExceptionHandler.printBox((String)"Sybase Central", (int)80)).append("\n");
        stringBuffer.append("Sybase Central Version: ").append(Version.getVersionString()).append("\n");
        stringBuffer.append(Calendar.getInstance().getTime()).append("\n");
        stringBuffer.append("\n");
        if (this._vs != null && (enumeration = (providers = this._vs.getProviders()).getProviderList()).hasMoreElements()) {
            stringBuffer.append("Registered Plug-ins:").append("\n");
            stringBuffer.append("--------------------").append("\n");
            while (enumeration.hasMoreElements()) {
                File file;
                String string;
                ProviderEntry providerEntry = (ProviderEntry)enumeration.nextElement();
                stringBuffer.append("Plug-in: ").append(providerEntry.getName()).append("\n");
                stringBuffer.append("Plug-in Version: ").append(providerEntry.getVersion()).append("\n");
                stringBuffer.append("Plug-in Classpath: ").append(providerEntry.getClasspath()).append("\n");
                StringTokenizer stringTokenizer = new StringTokenizer(providerEntry.getClasspath(), File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    file = new File(string);
                    if (!file.isFile()) continue;
                    stringBuffer.append("    Classpath File: ").append(string).append("\n");
                    stringBuffer.append("            Length: ").append(file.length()).append("\n");
                    stringBuffer.append("         Timestamp: ").append(new Timestamp(file.lastModified())).append("\n\n");
                }
                stringBuffer.append("Plug-in Additional Classpath: ").append(providerEntry.getAdditionalClasspath()).append("\n");
                stringTokenizer = new StringTokenizer(providerEntry.getAdditionalClasspath(), File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    file = new File(string);
                    if (!file.isFile()) continue;
                    stringBuffer.append("    Additional Classpath File: ").append(string).append("\n");
                    stringBuffer.append("                       Length: ").append(file.length()).append("\n");
                    stringBuffer.append("                    Timestamp: ").append(new Timestamp(file.lastModified())).append("\n\n");
                }
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public String getVendorName() {
        return "Sybase";
    }

    public String getProductName() {
        return ScjSession.getString("STR_ERROR_PRODUCT_NAME");
    }

    public String getApplicationName() {
        return "Sybase Central";
    }

    public int getApplicationVersionMajor() {
        return 6;
    }

    public int getApplicationVersionMinor() {
        return 0;
    }

    public int getApplicationVersionPatch() {
        return 0;
    }

    public int getApplicationVersionBuild() {
        return 4790;
    }

    public String getModuleName() {
        return "";
    }

    public int getModuleVersionMajor() {
        return 0;
    }

    public int getModuleVersionMinor() {
        return 0;
    }

    public int getModuleVersionPatch() {
        return 0;
    }

    public int getModuleVersionBuild() {
        return 0;
    }

    public Image getIconImage() {
        return ImageUtils.loadImage(this.getClass(), (String)"SybaseCentral64.png");
    }

    public boolean showCheckForUpdates() {
        return false;
    }

    public String getCheckForUpdatesURL() {
        return "";
    }

    public boolean showErrorReporter() {
        return OEMSupport.getOEMSupport().getReportErrors();
    }

    public boolean showTechSupportLink() {
        return true;
    }

    public String getTechSupportURL() {
        return "http://www.ianywhere.com/support/sql_anywhere.html";
    }

    public String getErrorReportingServiceSubmissionURL() {
        return "http://www.ianywhere.com/projects/submission/sa_submission";
    }

    public String getErrorReportingServiceStatusURL() {
        return "http://www.ianywhere.com/projects/submission/sa_status";
    }

    public String getDataCollectionPolicyURL() {
        return null;
    }

    private void doMenuMergeTest() {
    }

    public static SCViewerSupport5 getDummySCViewerSupport5ForTestingOnly(String[] stringArray) {
        ScjSession scjSession = new ScjSession(null, stringArray);
        ScjViewerSupport scjViewerSupport = new ScjViewerSupport(scjSession, null);
        return scjViewerSupport;
    }

    private void postPassOrFail(boolean bl, int n) {
    }
}

