/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.viewer.DetailsList;
import com.sybase.central.viewer.IConstants;
import com.sybase.central.viewer.ScjTableModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

class TableSorter
extends AbstractTableModel
implements TableModelListener,
IConstants {
    private DetailsList _detailsList;
    private JTable _table;
    private TableModel _model;
    private Integer[] _mappingIndexes;
    private boolean _ascending = true;
    private int _lastSortedColumn = -1;

    TableSorter(DetailsList detailsList, JTable jTable) {
        this._detailsList = detailsList;
        this._table = jTable;
        this._model = this._table.getModel();
        this.addMouseListenerToHeaderInTable();
    }

    TableSorter(JTable jTable, TableModel tableModel) {
        this._table = jTable;
        this.setModel(tableModel);
        this.resetIndexes();
        this.addMouseListenerToHeaderInTable();
    }

    void setModel(TableModel tableModel) {
        this._model = tableModel;
        this._model.addTableModelListener(this);
        this.resetIndexes();
        this._table.createDefaultColumnsFromModel();
        this._lastSortedColumn = -1;
        this._ascending = true;
    }

    TableModel getModel() {
        return this._model;
    }

    int getDataIndexForTableIndex(int n) {
        return this._mappingIndexes[n];
    }

    private void addMouseListenerToHeaderInTable() {
        this._table.setColumnSelectionAllowed(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){
            private int[] _oldWidths;
            private int _col;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = TableSorter.this._table.getColumnModel();
                this._oldWidths = new int[tableColumnModel.getColumnCount()];
                for (int i = 0; i < this._oldWidths.length; ++i) {
                    this._oldWidths[i] = tableColumnModel.getColumn(i).getWidth();
                }
                this._col = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n;
                TableColumnModel tableColumnModel = TableSorter.this._table.getColumnModel();
                boolean bl = false;
                int[] nArray = new int[tableColumnModel.getColumnCount()];
                if (this._oldWidths != null) {
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = tableColumnModel.getColumn(i).getWidth();
                        if (nArray.length == this._oldWidths.length) {
                            if (nArray[i] == this._oldWidths[i]) continue;
                            bl = true;
                            continue;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    TableSorter.this._detailsList.columnWidthsChanged(nArray);
                    return;
                }
                int n2 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                if (this._col == n2 && (n = TableSorter.this._table.convertColumnIndexToModel(n2)) != -1) {
                    TableSorter.this.sortColumn(n);
                }
            }
        };
        JTableHeader jTableHeader = this._table.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
    }

    void sortColumn(int n) {
        this._ascending = n == this._lastSortedColumn ? !this._ascending : true;
        this._lastSortedColumn = n;
        int n2 = this._detailsList.columnSort(n, this._ascending);
        if (n2 == 2 || n2 == 1) {
            this.sortByColumn(n, n2);
        }
    }

    void setSort(int n, boolean bl) {
        this._lastSortedColumn = n;
        this._ascending = bl;
    }

    private void sortByColumn(int n, int n2) {
        this.resetIndexes();
        Arrays.sort(this._mappingIndexes, new SortComparator(n, n2));
        this.tableChanged(new TableModelEvent(this));
    }

    private void resetIndexes() {
        this._mappingIndexes = new Integer[this.getRowCount()];
        for (int i = 0; i < this.getRowCount(); ++i) {
            this._mappingIndexes[i] = new Integer(i);
        }
    }

    public void updateRowData(int n, Vector vector) {
        ((ScjTableModel)this._model).updateRowData(n, vector);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this._mappingIndexes.length < n + 1) {
            return null;
        }
        return this._model.getValueAt(this._mappingIndexes[n], n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this._mappingIndexes.length < n + 1) {
            return;
        }
        this._model.setValueAt(object, this._mappingIndexes[n], n2);
    }

    @Override
    public int getRowCount() {
        if (this._model == null) {
            return 0;
        }
        return this._model.getRowCount();
    }

    @Override
    public int getColumnCount() {
        if (this._model == null) {
            return 0;
        }
        return this._model.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this._model.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this._model.getColumnClass(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this._model.isCellEditable(n, n2);
    }

    public void insertRow(int n, Object[] objectArray) {
        if (this._model instanceof DefaultTableModel) {
            ((DefaultTableModel)this._model).insertRow(n, objectArray);
            this.resetIndexes();
        }
    }

    public void insertRow(int n, Vector vector) {
        if (this._model instanceof DefaultTableModel) {
            ((DefaultTableModel)this._model).insertRow(n, vector);
            this.resetIndexes();
        }
    }

    public void removeRow(int n) {
        if (this._model instanceof DefaultTableModel) {
            ((DefaultTableModel)this._model).removeRow(n);
            this.resetIndexes();
        }
    }

    public void addRow(Vector vector) {
        if (this._model instanceof DefaultTableModel) {
            ((DefaultTableModel)this._model).addRow(vector);
            this.resetIndexes();
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.fireTableChanged(tableModelEvent);
    }

    class SortComparator
    implements Comparator<Integer> {
        private int _column = 0;
        private int _sortIndicator;
        private Collator _localeSpecificCollator = Collator.getInstance();

        SortComparator(int n, int n2) {
            this._column = n;
            this._sortIndicator = n2;
        }

        @Override
        public int compare(Integer n, Integer n2) {
            int n3 = this.compareRowsByColumn(n, n2, this._column);
            if (n3 != 0) {
                return TableSorter.this._ascending ? n3 : -n3;
            }
            return 0;
        }

        public boolean equals(Integer n) {
            return super.equals(n);
        }

        private int compareRowsByColumn(int n, int n2, int n3) {
            Object object;
            String string;
            Class<?> clazz = TableSorter.this._model.getColumnClass(n3);
            Object object2 = TableSorter.this._model.getValueAt(n, n3);
            Object object3 = TableSorter.this._model.getValueAt(n2, n3);
            if (object2 == null && object3 == null) {
                return 0;
            }
            if (object2 == null) {
                return -1;
            }
            if (object3 == null) {
                return 1;
            }
            if (this._sortIndicator == 1) {
                Object object4 = TableSorter.this._model.getValueAt(n, n3);
                Object object5 = TableSorter.this._model.getValueAt(n2, n3);
                try {
                    int n4 = Integer.valueOf(object4.toString().trim());
                    int n5 = Integer.valueOf(object5.toString().trim());
                    if (n4 > n5) {
                        return 1;
                    }
                    if (n4 < n5) {
                        return -1;
                    }
                    return 0;
                }
                catch (NumberFormatException numberFormatException) {
                    return 0;
                }
            }
            Object object6 = TableSorter.this._model.getValueAt(n, n3);
            String string2 = object6.toString();
            int n6 = this._localeSpecificCollator.compare(string2, string = (object = TableSorter.this._model.getValueAt(n2, n3)).toString());
            if (n6 < 0) {
                return -1;
            }
            if (n6 > 0) {
                return 1;
            }
            return 0;
        }
    }
}

