/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.SCContainer5;
import com.sybase.central.SCProvider;
import com.sybase.central.SCProvider2;
import com.sybase.central.SCTaskItem;
import com.sybase.central.SCTaskList;
import com.sybase.central.SCWelcomeTaskDialog;
import com.sybase.central.lang.ScjResourceConstants;
import com.sybase.central.viewer.HypertextButtonListener;
import com.sybase.central.viewer.ProviderEntry;
import com.sybase.central.viewer.SCScrollPane;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.TreeItem;
import com.sybase.central.viewer.ViewerManager;
import com.sybase.util.CollapsiblePanel;
import com.sybase.util.DialogUtils;
import com.sybase.util.SybLabel;
import com.sybase.util.UIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

class TaskPane
implements ScjResourceConstants {
    private JFrame _viewerFrame = null;
    private ScjSession _session = null;
    private ViewerManager _viewerManager = null;
    private SCScrollPane _scrollPane = null;
    private JPanel _taskPanel = null;
    private SybLabel _noneLabel = null;
    private ArrayList<CollapsiblePanelListener> _panelListeners = null;
    private ArrayList<HypertextButtonListener> _buttonListeners = null;
    static final Insets INSETS = new Insets(5, 5, 5, 5);
    static final Insets XP_TASK_PANEL_INSETS = new Insets(10, 10, 10, 10);

    TaskPane(JFrame jFrame, ScjSession scjSession) {
        this._viewerFrame = jFrame;
        this._session = scjSession;
        this.init();
    }

    JComponent getPane() {
        return this._scrollPane;
    }

    void requestFocusInWindow() {
        this._taskPanel.requestFocusInWindow();
    }

    void initialize(ViewerManager viewerManager) {
        this._viewerManager = viewerManager;
    }

    private void init() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this._scrollPane = new SCScrollPane();
        this._scrollPane.setMinimumSize(new Dimension(0, this._scrollPane.getHeight()));
        this._scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this._taskPanel = UIUtils.createExplorerBar();
        this._scrollPane.getViewport().setView(this._taskPanel);
        this._panelListeners = new ArrayList();
        this._buttonListeners = new ArrayList();
        this._noneLabel = new SybLabel(ScjSession.getString("STR_NO_TASK_LABEL"));
        this._taskPanel.setLayout(gridBagLayout);
    }

    void updateTasks() {
        int n = 0;
        TreeItem treeItem = null;
        Enumeration enumeration = null;
        ProviderEntry providerEntry = null;
        SCProvider sCProvider = null;
        SCTaskList sCTaskList = null;
        SCTaskList[] sCTaskListArray = null;
        GridBagLayout gridBagLayout = null;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (this._viewerManager != null && this._viewerManager.getViewerSupport().getProviders() != null && this._viewerManager.getMainPanel().isTaskPaneVisible()) {
            gridBagLayout = (GridBagLayout)this._taskPanel.getLayout();
            this.clearTaskPanel();
            gridBagConstraints.anchor = 10;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.insets = UIUtils.isXPLookAndFeelActive() ? XP_TASK_PANEL_INSETS : INSETS;
            treeItem = this._viewerManager.getSelectedTreeItem();
            if (treeItem == null || treeItem.getContainer() == this._session.getRootContainer()) {
                enumeration = this._viewerManager.getViewerSupport().getProviders().getProviderList();
                while (enumeration.hasMoreElements()) {
                    providerEntry = (ProviderEntry)enumeration.nextElement();
                    if (!providerEntry.isLoaded() || !((sCProvider = providerEntry.getProvider()) instanceof SCWelcomeTaskDialog) || !(sCProvider instanceof SCProvider2) || (sCTaskList = ((SCWelcomeTaskDialog)((Object)sCProvider)).getWelcomeTasks()) == null) continue;
                    this.addWelcomeTaskList((SCProvider2)sCProvider, sCTaskList, n);
                    ++n;
                }
            } else if (treeItem.getContainer() instanceof SCContainer5 && (sCTaskListArray = ((SCContainer5)treeItem.getContainer()).getSCTaskLists()) != null && sCTaskListArray.length > 0) {
                n = this.addTaskLists((SCContainer5)treeItem.getContainer(), sCTaskListArray, n);
            }
            if (n == 0) {
                gridBagConstraints.anchor = 18;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = UIUtils.isXPLookAndFeelActive() ? XP_TASK_PANEL_INSETS : INSETS;
                this._taskPanel.add((Component)this._noneLabel, gridBagConstraints);
                ++n;
            }
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = INSETS;
            this._taskPanel.add(Box.createGlue(), gridBagConstraints);
            this._taskPanel.validate();
            this._taskPanel.repaint();
        }
    }

    private void addWelcomeTaskList(SCProvider2 sCProvider2, SCTaskList sCTaskList, int n) {
        GridBagLayout gridBagLayout = null;
        GridBagConstraints gridBagConstraints = null;
        CollapsiblePanel collapsiblePanel = null;
        CollapsiblePanelListener collapsiblePanelListener = null;
        SCTaskItem[] sCTaskItemArray = null;
        HypertextButtonListener hypertextButtonListener = null;
        gridBagLayout = (GridBagLayout)this._taskPanel.getLayout();
        gridBagConstraints = new GridBagConstraints();
        collapsiblePanelListener = new CollapsiblePanelListener(sCProvider2, sCTaskList);
        this._panelListeners.add(collapsiblePanelListener);
        sCTaskItemArray = sCTaskList.getTasks();
        if (sCTaskItemArray != null) {
            collapsiblePanel = collapsiblePanelListener.getPanel();
            Color color = UIUtils.getExplorerBarGroupTextColor();
            for (int i = 0; i < sCTaskItemArray.length; ++i) {
                hypertextButtonListener = new HypertextButtonListener(this._viewerFrame, this._viewerManager, sCProvider2, sCTaskItemArray[i], 200, color);
                this._buttonListeners.add(hypertextButtonListener);
                collapsiblePanel.add((JComponent)hypertextButtonListener.getButton());
            }
        }
        collapsiblePanelListener.getPanel().setExpanded(sCTaskList.isExpanded());
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = UIUtils.isXPLookAndFeelActive() ? XP_TASK_PANEL_INSETS : INSETS;
        this._taskPanel.add((Component)collapsiblePanelListener.getPanel(), gridBagConstraints);
    }

    private int addTaskLists(SCContainer5 sCContainer5, SCTaskList[] sCTaskListArray, int n) {
        GridBagLayout gridBagLayout = null;
        GridBagConstraints gridBagConstraints = null;
        CollapsiblePanelListener collapsiblePanelListener = null;
        SCTaskItem[] sCTaskItemArray = null;
        HypertextButtonListener hypertextButtonListener = null;
        CollapsiblePanel collapsiblePanel = null;
        gridBagLayout = (GridBagLayout)this._taskPanel.getLayout();
        gridBagConstraints = new GridBagConstraints();
        for (int i = 0; i < sCTaskListArray.length; ++i) {
            collapsiblePanelListener = new CollapsiblePanelListener(sCContainer5, sCTaskListArray[i], i);
            this._panelListeners.add(collapsiblePanelListener);
            sCTaskItemArray = sCTaskListArray[i].getTasks();
            if (sCTaskItemArray != null) {
                collapsiblePanel = collapsiblePanelListener.getPanel();
                Color color = UIUtils.getExplorerBarGroupTextColor();
                for (int j = 0; j < sCTaskItemArray.length; ++j) {
                    hypertextButtonListener = new HypertextButtonListener(this._viewerFrame, this._viewerManager, sCContainer5, sCTaskItemArray[j], 200, color);
                    this._buttonListeners.add(hypertextButtonListener);
                    collapsiblePanel.add((JComponent)hypertextButtonListener.getButton());
                }
                collapsiblePanel.setExpanded(sCTaskListArray[i].isExpanded());
            }
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = UIUtils.isXPLookAndFeelActive() ? XP_TASK_PANEL_INSETS : INSETS;
            this._taskPanel.add((Component)collapsiblePanelListener.getPanel(), gridBagConstraints);
            ++n;
        }
        return n;
    }

    private void clearTaskPanel() {
        Iterator<CollapsiblePanelListener> iterator = null;
        Iterator<HypertextButtonListener> iterator2 = null;
        this._taskPanel.removeAll();
        iterator = this._panelListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().releaseResources();
        }
        this._panelListeners.clear();
        iterator2 = this._buttonListeners.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().releaseResources();
        }
        this._buttonListeners.clear();
    }

    void releaseResources() {
        this.clearTaskPanel();
        this._session = null;
        this._viewerFrame = null;
        this._viewerManager = null;
        DialogUtils.removeComponents((Container)this._scrollPane);
        this._scrollPane = null;
        this._taskPanel = null;
        this._panelListeners = null;
        this._buttonListeners = null;
        this._noneLabel = null;
    }

    class CollapsiblePanelListener
    implements ActionListener {
        SCProvider2 _provider = null;
        SCContainer5 _container = null;
        SCTaskList _list = null;
        int _listIndex = 0;
        CollapsiblePanel _cPanel = null;

        CollapsiblePanelListener(SCProvider2 sCProvider2, SCTaskList sCTaskList) {
            this._provider = sCProvider2;
            this._list = sCTaskList;
            this._cPanel = new CollapsiblePanel(sCTaskList.getTaskListName(), sCTaskList.getTaskListToolTip());
            this._cPanel.addActionListener((ActionListener)this);
        }

        CollapsiblePanelListener(SCContainer5 sCContainer5, SCTaskList sCTaskList, int n) {
            this._container = sCContainer5;
            this._list = sCTaskList;
            this._listIndex = n;
            this._cPanel = new CollapsiblePanel(sCTaskList.getTaskListName(), sCTaskList.getTaskListToolTip());
            this._cPanel.addActionListener((ActionListener)this);
        }

        CollapsiblePanel getPanel() {
            return this._cPanel;
        }

        void releaseResources() {
            this._cPanel.removeActionListener((ActionListener)this);
            this._cPanel.releaseResources();
            this._cPanel = null;
            this._provider = null;
            this._container = null;
            this._list = null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this._provider != null) {
                if (this._cPanel.isExpanded()) {
                    this._provider.onCommand(TaskPane.this._viewerFrame, 210, TaskPane.this._viewerManager.getCurrentlySelectedItemsToNotify(), this._listIndex);
                } else {
                    this._provider.onCommand(TaskPane.this._viewerFrame, 211, TaskPane.this._viewerManager.getCurrentlySelectedItemsToNotify(), this._listIndex);
                }
            } else if (this._cPanel.isExpanded()) {
                this._container.onCommand(TaskPane.this._viewerFrame, 210, TaskPane.this._viewerManager.getCurrentlySelectedItemsToNotify(), this._listIndex);
            } else {
                this._container.onCommand(TaskPane.this._viewerFrame, 211, TaskPane.this._viewerManager.getCurrentlySelectedItemsToNotify(), this._listIndex);
            }
        }
    }
}

