/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.SCContainer;
import com.sybase.central.viewer.ContainerListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

class TreeItem
implements MutableTreeNode {
    private boolean _isExpanded;
    private boolean _isSelected;
    private boolean _hasBeenOpened = false;
    private SCContainer _cont;
    private ContainerListener _containerListener;
    private MutableTreeNode _parent;
    private Vector<TreeNode> _children = new Vector(5);
    private Icon _closedImage = null;
    private Icon _openedImage = null;

    TreeItem(SCContainer sCContainer, TreeItem treeItem) {
        this._cont = sCContainer;
        this._parent = treeItem;
    }

    @Override
    public void insert(MutableTreeNode mutableTreeNode, int n) {
        this._children.insertElementAt(mutableTreeNode, n);
    }

    @Override
    public void remove(int n) {
        this._children.removeElementAt(n);
    }

    @Override
    public void remove(MutableTreeNode mutableTreeNode) {
        this._children.removeElement(mutableTreeNode);
    }

    @Override
    public void removeFromParent() {
        this._parent = null;
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
        this._parent = mutableTreeNode;
    }

    @Override
    public void setUserObject(Object object) {
        this._cont = (SCContainer)object;
    }

    public Enumeration children() {
        return this._children.elements();
    }

    @Override
    public boolean getAllowsChildren() {
        return (this._cont.getAttributes() & 1) != 0;
    }

    @Override
    public TreeNode getChildAt(int n) {
        return this._children.elementAt(n);
    }

    @Override
    public int getChildCount() {
        return this._children.size();
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this._children.indexOf(treeNode);
    }

    @Override
    public TreeNode getParent() {
        return this._parent;
    }

    @Override
    public boolean isLeaf() {
        return !this.getAllowsChildren();
    }

    public String toString() {
        return this._cont.getDisplayName(0);
    }

    public SCContainer getContainer() {
        return this._cont;
    }

    public Icon getOpenedImage() {
        if (this._cont != null) {
            this._openedImage = this._cont.getImage(true);
        }
        return this._openedImage;
    }

    public Icon getClosedImage() {
        if (this._cont != null) {
            this._closedImage = this._cont.getImage(false);
        }
        return this._closedImage;
    }

    public boolean hasBeenOpened() {
        return this._hasBeenOpened;
    }

    public void setOpened(boolean bl) {
        this._hasBeenOpened = bl;
    }

    public void setExpanded(boolean bl) {
        this._isExpanded = bl;
    }

    public boolean isExpanded() {
        return this._isExpanded;
    }

    public void setSelected(boolean bl) {
        this._isSelected = bl;
    }

    public boolean isSelected() {
        return this._isSelected;
    }

    public TreeItem[] getPath() {
        TreeNode treeNode = this.getParent();
        if (treeNode == null) {
            TreeItem[] treeItemArray = new TreeItem[]{this};
            return treeItemArray;
        }
        TreeItem[] treeItemArray = ((TreeItem)treeNode).getPath();
        TreeItem[] treeItemArray2 = new TreeItem[treeItemArray.length + 1];
        System.arraycopy(treeItemArray, 0, treeItemArray2, 0, treeItemArray.length);
        treeItemArray2[treeItemArray.length] = this;
        return treeItemArray2;
    }

    void setContainerListener(ContainerListener containerListener) {
        this._containerListener = containerListener;
    }

    ContainerListener getContainerListener() {
        return this._containerListener;
    }
}

