/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.viewer.RepositoryKey;
import com.sybase.central.viewer.UserPrefRepository;
import java.awt.Rectangle;
import java.util.StringTokenizer;

class UserPrefRepositoryInfo {
    private UserPrefRepository _upRepository;
    private RepositoryKey _key;
    private boolean _isNewUser;
    private static final int SPLITTER_DEFAULT = 265;
    private static final int TOOLBAR_SPLITTER_DEFAULT = 200;
    private static final int BOTTOM_SPLITTER_DEFAULT = 200;
    private static final int REPOSITORY_VERSION = 5;
    static final String REP_INFO_KEY = "UserPrefRepositoryInfo";
    private static final String REP_INFO_PANE = "Pane";
    private static final String REP_INFO_PREVIOUS_SEARCHES = "Searches";
    private static final String REP_INFO_MATCH_CASE = "SearchMatchCase";
    private static final String REP_INFO_WHOLE_WORD = "SearchWholeWord";
    private static final String REP_INFO_BOTTOM_SPLITTER = "BottomSplitter";
    private static final String REP_INFO_TOOLBAR = "ToolbarVisible";
    private static final String REP_INFO_CONTEXT_COMBOBOX = "ContextBarVisible";
    private static final String REP_INFO_CONTEXT_LABEL = "ContextLabelVisible";
    private static final String REP_INFO_STATUSBAR = "StatusbarVisible";
    private static final String REP_INFO_SPLITTER = "Splitter";
    private static final String REP_INFO_LOCATION = "Location";
    private static final String REP_INFO_STATE = "State";
    private static final String REP_INFO_VERSION = "Version";
    private static final String REP_INFO_TAB_PLACEMENT = "TabPlacement";
    private static final String REP_INFO_MRU_CONN_PROF = "MRUConnectionProfiles";
    private static final String REP_INFO_BROWSE_DIR = "LastBrowseDir";
    private static final String REP_INFO_WELCOME_TASK = "ShowWelcomeTaskDialog";
    private static final String REP_INFO_STARTUP_TIPS = "ShowStartupTips";
    private static final String REP_INFO_LAST_TIP_PROVIDER_ID = "LastTipProviderId";
    private static final String REP_INFO_TIP_COUNT = "TipCount";
    private static final String REP_INFO_NEXT_TIP_NUMBER = "NextTipNumber";
    private static final String REP_INFO_SEARCH_COL_WIDTHS = "SearchColumnWidths";
    static final String REP_INFO_PROVIDER_KEY = "ProviderData";
    static final String REP_INFO_PROVIDERS_AUTOLOAD = "Autoload";
    static final String REP_INFO_CP_KEY = "ConnectionProfileData";
    static final String REP_INFO_CP_AUTOSTART = "Autostart";
    public static final int DEFAULT_TAB_PLACEMENT = 1;
    static final String SEARCH = "search";
    static final String TASKS = "tasks";
    static final String FOLDERS = "folders";
    static final String NONE = "none";
    private static final String REP_INFO_FAST_LAUNCHER_ENABLED = "FastLauncherEnabled";
    private static final String REP_INFO_FAST_LAUNCHER_PORT = "FastLauncherPort";
    private static final String REP_INFO_FAST_LAUNCHER_TIMEOUT = "FastLauncherTimeout";
    static final boolean DEFAULT_FAST_LAUNCHER_ENABLED = true;
    static final int DEFAULT_FAST_LAUNCHER_PORT = 6220;
    static final int DEFAULT_FAST_LAUNCHER_TIMEOUT = 30;

    UserPrefRepositoryInfo(UserPrefRepository userPrefRepository, boolean bl) {
        this._upRepository = userPrefRepository;
        this._isNewUser = bl;
        this._key = userPrefRepository.openKey(REP_INFO_KEY, false);
        this.setRepositoryVersion(5);
    }

    boolean isToolBarVisible() {
        Boolean bl = this._key.getBooleanValue(REP_INFO_TOOLBAR);
        if (bl == null) {
            this.setToolBarVisible(true);
            return true;
        }
        return bl;
    }

    void setToolBarVisible(boolean bl) {
        this._key.setBooleanValue(REP_INFO_TOOLBAR, bl);
    }

    boolean isContextComboBoxVisible() {
        Boolean bl = this._key.getBooleanValue(REP_INFO_CONTEXT_COMBOBOX);
        if (bl == null) {
            this.setContextComboBoxVisible(true);
            return true;
        }
        return bl;
    }

    void setContextComboBoxVisible(boolean bl) {
        this._key.setBooleanValue(REP_INFO_CONTEXT_COMBOBOX, bl);
    }

    boolean isContextLabelVisible() {
        Boolean bl = this._key.getBooleanValue(REP_INFO_CONTEXT_LABEL);
        if (bl == null) {
            this.setContextLabelVisible(true);
            return true;
        }
        return bl;
    }

    void setContextLabelVisible(boolean bl) {
        this._key.setBooleanValue(REP_INFO_CONTEXT_LABEL, bl);
    }

    String getVisiblePane() {
        if (this.isSearchPaneVisible()) {
            return SEARCH;
        }
        if (this.isTaskPaneVisible()) {
            return TASKS;
        }
        if (this.isFolderPaneVisible()) {
            return FOLDERS;
        }
        return NONE;
    }

    private boolean isSearchPaneVisible() {
        String string = this._key.getStringValue(REP_INFO_PANE);
        if (string == null) {
            this.setPaneVisible(TASKS);
            return false;
        }
        return string.equals(SEARCH);
    }

    private boolean isTaskPaneVisible() {
        String string = this._key.getStringValue(REP_INFO_PANE);
        if (string == null) {
            this.setPaneVisible(TASKS);
            return false;
        }
        return string.equals(TASKS);
    }

    private boolean isFolderPaneVisible() {
        String string = this._key.getStringValue(REP_INFO_PANE);
        if (string == null) {
            this.setPaneVisible(TASKS);
            return true;
        }
        return string.equals(FOLDERS);
    }

    void setPaneVisible(String string) {
        this._key.setStringValue(REP_INFO_PANE, string);
    }

    String getPreviousSearches() {
        return this._key.getStringValue(REP_INFO_PREVIOUS_SEARCHES);
    }

    void setPreviousSearches(String string) {
        this._key.setStringValue(REP_INFO_PREVIOUS_SEARCHES, string);
    }

    boolean isSearchMatchCase() {
        Boolean bl = this._key.getBooleanValue(REP_INFO_MATCH_CASE);
        if (bl == null) {
            this.setSearchMatchCase(false);
            return false;
        }
        return bl;
    }

    void setSearchMatchCase(boolean bl) {
        this._key.setBooleanValue(REP_INFO_MATCH_CASE, bl);
    }

    boolean isSearchWholeWord() {
        Boolean bl = this._key.getBooleanValue(REP_INFO_WHOLE_WORD);
        if (bl == null) {
            this.setSearchWholeWord(false);
            return false;
        }
        return bl;
    }

    void setSearchWholeWord(boolean bl) {
        this._key.setBooleanValue(REP_INFO_WHOLE_WORD, bl);
    }

    boolean isStatusBarVisible() {
        Boolean bl = this._key.getBooleanValue(REP_INFO_STATUSBAR);
        if (bl == null) {
            this.setStatusBarVisible(true);
            return true;
        }
        return bl;
    }

    void setStatusBarVisible(boolean bl) {
        this._key.setBooleanValue(REP_INFO_STATUSBAR, bl);
    }

    Rectangle getViewerBounds() {
        String string = this._key.getStringValue(REP_INFO_LOCATION);
        Rectangle rectangle = new Rectangle();
        rectangle.x = 10;
        rectangle.y = 10;
        rectangle.width = 800;
        rectangle.height = 570;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.hasMoreTokens()) {
                rectangle.x = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                rectangle.y = Integer.parseInt(stringTokenizer.nextToken());
                if (rectangle.y < 0) {
                    rectangle.y = 0;
                }
            }
            if (stringTokenizer.hasMoreTokens()) {
                rectangle.width = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                rectangle.height = Integer.parseInt(stringTokenizer.nextToken());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rectangle;
    }

    void setViewerBounds(Rectangle rectangle) {
        if (rectangle.y < 0) {
            rectangle.y = 0;
        }
        String string = Integer.toString(rectangle.x);
        String string2 = Integer.toString(rectangle.y);
        String string3 = Integer.toString(rectangle.width);
        String string4 = Integer.toString(rectangle.height);
        String string5 = string.trim() + " " + string2.trim() + " " + string3.trim() + " " + string4.trim();
        this._key.setStringValue(REP_INFO_LOCATION, string5);
    }

    int getViewerState() {
        Integer n = this._key.getIntegerValue(REP_INFO_STATE);
        if (n == null) {
            return 0;
        }
        int n2 = n;
        if ((n2 & 6) == 6) {
            return 6;
        }
        if ((n2 & 2) == 2) {
            return 2;
        }
        if ((n2 & 4) == 4) {
            return 4;
        }
        return 0;
    }

    void setViewerState(int n) {
        if ((n & 6) == 6) {
            this._key.setIntegerValue(REP_INFO_STATE, 6);
        } else if ((n & 2) == 2) {
            this._key.setIntegerValue(REP_INFO_STATE, 2);
        } else if ((n & 4) == 4) {
            this._key.setIntegerValue(REP_INFO_STATE, 4);
        } else {
            this._key.setIntegerValue(REP_INFO_STATE, 0);
        }
    }

    int getBottomSplitterLocation() {
        Integer n = this._key.getIntegerValue(REP_INFO_BOTTOM_SPLITTER);
        if (n == null) {
            return 200;
        }
        return n;
    }

    void setBottomSplitterLocation(int n) {
        this._key.setIntegerValue(REP_INFO_BOTTOM_SPLITTER, n);
    }

    int getSplitterLocation() {
        Integer n = this._key.getIntegerValue(REP_INFO_SPLITTER);
        if (n == null) {
            return 265;
        }
        return n;
    }

    void setSplitterLocation(int n) {
        this._key.setIntegerValue(REP_INFO_SPLITTER, n);
    }

    int getRepositoryVersion() {
        Integer n = this._key.getIntegerValue(REP_INFO_VERSION);
        return n;
    }

    void setRepositoryVersion(int n) {
        this._key.setIntegerValue(REP_INFO_VERSION, n);
    }

    int getTabPlacement() {
        Integer n = this._key.getIntegerValue(REP_INFO_TAB_PLACEMENT);
        if (n == null) {
            return 1;
        }
        return n;
    }

    void setTabPlacement(int n) {
        this._key.setIntegerValue(REP_INFO_TAB_PLACEMENT, n);
    }

    String getMRUConnectionProfiles() {
        String string = this._key.getStringValue(REP_INFO_MRU_CONN_PROF);
        if (string == null) {
            return "";
        }
        return string;
    }

    void setMRUConnectionProfiles(String string) {
        this._key.setStringValue(REP_INFO_MRU_CONN_PROF, string);
    }

    String getLastBrowseDir() {
        String string = this._key.getStringValue(REP_INFO_BROWSE_DIR);
        if (string == null) {
            return "";
        }
        return string;
    }

    void setLastBrowseDir(String string) {
        this._key.setStringValue(REP_INFO_BROWSE_DIR, string);
    }

    boolean isWelcomeTaskDialogShown() {
        Boolean bl = this._key.getBooleanValue(REP_INFO_WELCOME_TASK);
        if (bl == null) {
            this.setWelcomeTaskDialogShown(true);
            return true;
        }
        return bl;
    }

    void setWelcomeTaskDialogShown(boolean bl) {
        this._key.setBooleanValue(REP_INFO_WELCOME_TASK, bl);
    }

    boolean areStartupTipsShown() {
        Boolean bl = this._key.getBooleanValue(REP_INFO_STARTUP_TIPS);
        if (bl == null) {
            this.setStartupTipsShown(true);
            return true;
        }
        return bl;
    }

    void setStartupTipsShown(boolean bl) {
        this._key.setBooleanValue(REP_INFO_STARTUP_TIPS, bl);
    }

    String getLastTipProviderId() {
        String string = this._key.getStringValue(REP_INFO_LAST_TIP_PROVIDER_ID);
        if (string == null) {
            return "";
        }
        return string;
    }

    void setLastTipProviderId(String string) {
        this._key.setStringValue(REP_INFO_LAST_TIP_PROVIDER_ID, string);
    }

    int getTipCount() {
        int n = this._key.getIntValue(REP_INFO_TIP_COUNT);
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    void setTipCount(int n) {
        this._key.setIntegerValue(REP_INFO_TIP_COUNT, n);
    }

    int getNextTipNumber() {
        int n = this._key.getIntValue(REP_INFO_NEXT_TIP_NUMBER);
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    void setNextTipNumber(int n) {
        this._key.setIntegerValue(REP_INFO_NEXT_TIP_NUMBER, n);
    }

    String getSearchColumnWidths() {
        String string = this._key.getStringValue(REP_INFO_SEARCH_COL_WIDTHS);
        if (string == null) {
            return "170,80,800";
        }
        return string;
    }

    void setSearchColumnWidths(String string) {
        this._key.setStringValue(REP_INFO_SEARCH_COL_WIDTHS, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isProviderAutoload(String string) {
        RepositoryKey repositoryKey = this._upRepository.openKey("ProviderData/" + string, true);
        if (repositoryKey != null) {
            Boolean bl = repositoryKey.getBooleanValue(REP_INFO_PROVIDERS_AUTOLOAD);
            if (bl != null) return bl;
            this.setProviderAutoload(string, true);
            return true;
        } else {
            this.setProviderAutoload(string, true);
        }
        return true;
    }

    void setProviderAutoload(String string, boolean bl) {
        RepositoryKey repositoryKey = this._upRepository.openKey("ProviderData/" + string, false);
        repositoryKey.setBooleanValue(REP_INFO_PROVIDERS_AUTOLOAD, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isConnProfAutostart(String string, boolean bl) {
        RepositoryKey repositoryKey = this._upRepository.openKey("ConnectionProfileData/" + string, true);
        if (repositoryKey != null) {
            Boolean bl2 = repositoryKey.getBooleanValue(REP_INFO_CP_AUTOSTART);
            if (bl2 != null) return bl2;
            this.setConnProfAutostart(string, bl);
            return bl;
        } else {
            this.setConnProfAutostart(string, bl);
        }
        return bl;
    }

    void setConnProfAutostart(String string, boolean bl) {
        RepositoryKey repositoryKey = this._upRepository.openKey("ConnectionProfileData/" + string, false);
        repositoryKey.setBooleanValue(REP_INFO_CP_AUTOSTART, bl);
    }

    boolean getFastLauncherEnabled() {
        Boolean bl = this._key.getBooleanValue(REP_INFO_FAST_LAUNCHER_ENABLED);
        if (bl == null) {
            return true;
        }
        return bl;
    }

    void setFastLauncherEnabled(boolean bl) {
        this._key.setBooleanValue(REP_INFO_FAST_LAUNCHER_ENABLED, bl);
    }

    int getFastLauncherPort() {
        Integer n = this._key.getIntegerValue(REP_INFO_FAST_LAUNCHER_PORT);
        if (n == null) {
            return 6220;
        }
        return n;
    }

    void setFastLauncherPort(int n) {
        this._key.setIntegerValue(REP_INFO_FAST_LAUNCHER_PORT, n);
    }

    int getFastLauncherTimeout() {
        Integer n = this._key.getIntegerValue(REP_INFO_FAST_LAUNCHER_TIMEOUT);
        if (n == null) {
            return 30;
        }
        return n;
    }

    void setFastLauncherTimeout(int n) {
        this._key.setIntegerValue(REP_INFO_FAST_LAUNCHER_TIMEOUT, n);
    }
}

