/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.viewer.SCLabel;
import com.sybase.central.viewer.SCViewerToolBarButton;
import com.sybase.util.Platform;
import com.sybase.util.SybFileChooser;
import com.sybase.util.SybFileFilter;
import com.sybase.util.win32.Win32Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class Utilities {
    private static final String DELIMETER = ",";
    private static final char SINGLE_QUOTE_CHAR = '\'';
    private static final char QUOTE_CHAR = '\"';
    private static final char ESC_CHAR = '\u0000';
    private static final String REGEXP_PROFILE_STRING = "\"([^\"]+|(\"\"))*\"";

    Utilities() {
    }

    static File showFileChooser(Component component, String string, String string2, SybFileFilter[] sybFileFilterArray, int n, boolean bl) {
        Window window;
        int n2 = 1;
        if (n == 0) {
            n2 |= 0x10;
        } else if (n == 1) {
            n2 |= 0x20;
        } else if (n == 2) {
            n2 |= 0x30;
        }
        SybFileChooser sybFileChooser = new SybFileChooser(n2);
        sybFileChooser.setFilters(sybFileFilterArray, 0);
        File file = null;
        File file2 = null;
        if (string2 != null && string2.length() > 0) {
            file = new File(string2);
            if (file.exists()) {
                if (file.isFile()) {
                    file2 = file;
                    file = null;
                }
            } else {
                File file3 = file.getParentFile();
                file = file3 != null && file3.exists() ? file3 : new File(string);
                file2 = new File(string2);
            }
        } else {
            file = new File(string);
        }
        File file4 = sybFileChooser.showDialog(window = (Window)SwingUtilities.getAncestorOfClass(Window.class, component), file, file2) ? sybFileChooser.getSelectedFile() : null;
        return file4;
    }

    static File showFileChooser(Component component, String string, SybFileFilter[] sybFileFilterArray, boolean bl) {
        int n = 18;
        SybFileChooser sybFileChooser = new SybFileChooser(n);
        sybFileChooser.setFilters(sybFileFilterArray, 0);
        File file = string != null && string.length() != 0 ? new File(string) : null;
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, component);
        File file2 = sybFileChooser.showDialog(window, file, null) ? sybFileChooser.getSelectedFile() : null;
        return file2;
    }

    static boolean doesFileExist(String string) {
        File file = null;
        try {
            file = new File(string);
            if (file.exists()) {
                file = null;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        file = null;
        return false;
    }

    static String buildProfileStringList(ArrayList<String> arrayList) {
        String[] stringArray = null;
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : arrayList.toArray(new String[arrayList.size()])) {
            if (string == null || string.length() == 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(DELIMETER);
            }
            stringBuffer.append(Utilities.quote(string));
        }
        return stringBuffer.toString();
    }

    static ArrayList<String> parseProfileStringListIntoArrayList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern pattern = Pattern.compile(REGEXP_PROFILE_STRING);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group();
            arrayList.add(Utilities.unquote(string2));
        }
        return arrayList;
    }

    static String quote(String string) {
        if (string == null) {
            return string;
        }
        int n = string != null ? string.length() : 0;
        char[] cArray = new char[n * 2 + 2];
        int n2 = 0;
        cArray[n2++] = 34;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            cArray[n2++] = c;
            if (c != '\"') continue;
            cArray[n2++] = 34;
        }
        cArray[n2++] = 34;
        return new String(cArray, 0, n2);
    }

    static String unquote(String string) {
        int n;
        int n2;
        if (string == null || string.length() <= 1 || string.indexOf(34) == -1 && string.indexOf(0) == -1) {
            return string;
        }
        int n3 = string.length();
        if (string.indexOf(34) == 0 && string.lastIndexOf(34) == n3 - 1) {
            n2 = 1;
            n = n3 - 1;
        } else {
            n2 = 0;
            n = n3;
        }
        char[] cArray = new char[n - n2];
        int n4 = 0;
        for (int i = n2; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"' && i < n - 1 && string.charAt(i + 1) == '\"') {
                cArray[n4++] = 34;
                ++i;
                continue;
            }
            cArray[n4++] = c;
        }
        return new String(cArray, 0, n4);
    }

    static ArrayList<JComponent> addHeaderToComponent(JComponent jComponent, String string) {
        return Utilities.addHeaderToComponent(jComponent, string, null);
    }

    static ArrayList<JComponent> addHeaderToComponent(final JComponent jComponent, String string, SCViewerToolBarButton sCViewerToolBarButton) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        JPanel jPanel = new JPanel((LayoutManager)gridBagLayout){

            @Override
            public void requestFocus() {
                jComponent.requestFocus();
            }

            @Override
            public boolean requestFocusInWindow() {
                return jComponent.requestFocusInWindow();
            }
        };
        arrayList.add(jPanel);
        JPanel jPanel2 = new JPanel(gridBagLayout2);
        SCLabel sCLabel = new SCLabel(string);
        arrayList.add((JComponent)((Object)sCLabel));
        ((JComponent)((Object)sCLabel)).setForeground(jPanel2.getForeground());
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel2.add((Component)((Object)sCLabel));
        if (sCViewerToolBarButton != null) {
            jPanel2.add((Component)((Object)sCViewerToolBarButton));
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        gridBagLayout2.setConstraints((Component)((Object)sCLabel), gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        if (sCViewerToolBarButton != null) {
            gridBagLayout2.setConstraints((Component)((Object)sCViewerToolBarButton), gridBagConstraints);
        }
        jPanel.add(jPanel2);
        jPanel.add(jComponent);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        return arrayList;
    }

    static String[] readJPRFile(String string) throws Exception {
        BufferedReader bufferedReader = null;
        String[] stringArray = new String[]{null, null, null, null, null, null, null, null};
        if (Platform.isWindows() && Win32Util.isInstalled()) {
            String string2 = Win32Util.getCharsetNameForCodePage((int)Win32Util.getANSICodePage());
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), string2));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (bufferedReader == null) {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        String string3 = bufferedReader.readLine().trim();
        while (string3 != null) {
            if (string3.startsWith("PluginName")) {
                stringArray[0] = string3.substring("PluginName".length() + 1, string3.length());
            } else if (string3.startsWith("PluginId")) {
                stringArray[1] = string3.substring("PluginId".length() + 1, string3.length());
            } else if (string3.startsWith("PluginClass")) {
                stringArray[2] = string3.substring("PluginClass".length() + 1, string3.length());
            } else if (string3.startsWith("PluginFile")) {
                stringArray[3] = Utilities.stripExtraBackslashes(string3.substring("PluginFile".length() + 1, string3.length()));
            } else if (string3.startsWith("AdditionalClasspath")) {
                stringArray[4] = Utilities.stripExtraBackslashes(string3.substring("AdditionalClasspath".length() + 1, string3.length()));
            } else if (string3.startsWith("ClassloaderId")) {
                stringArray[5] = string3.substring("ClassloaderId".length() + 1, string3.length());
            } else if (string3.startsWith("GrantStatements")) {
                stringArray[6] = string3.substring("GrantStatements".length() + 1, string3.length());
                if (stringArray[6].trim().length() == 0) {
                    stringArray[6] = null;
                }
            } else if (string3.startsWith("InitialLoadOrder")) {
                stringArray[7] = string3.substring("InitialLoadOrder".length() + 1, string3.length());
            }
            string3 = bufferedReader.readLine();
        }
        bufferedReader.close();
        return stringArray;
    }

    static String stripExtraBackslashes(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while ((n = string.indexOf(92, n2)) >= 0) {
            stringBuffer.append(string.substring(n2, n));
            if (string.length() <= n + 1) break;
            n2 = string.charAt(n + 1) == '\\' ? n + 2 : n + 1;
            stringBuffer.append('\\');
        }
        stringBuffer.append(string.substring(n2, string.length()));
        return stringBuffer.toString();
    }
}

