/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.central.viewer;

import com.sybase.central.lang.ScjResourceConstants;
import com.sybase.central.viewer.IConstants;
import com.sybase.central.viewer.ProviderEntry;
import com.sybase.central.viewer.SCImageLoader;
import com.sybase.central.viewer.ScjSession;
import com.sybase.central.viewer.ScjViewerSupport;
import com.sybase.central.viewer.SybaseCentral;
import com.sybase.central.viewer.ViewerManager;
import com.sybase.util.DialogUtils;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.JFrame;

class Viewer
extends WindowAdapter
implements Cloneable,
ScjResourceConstants,
IConstants {
    private ScjSession _session;
    private ScjViewerSupport _vsupport;
    private JFrame _frame;
    private ViewerManager _viewerManager;
    private static int _instanceCount = 0;

    Viewer(ScjSession scjSession, ScjViewerSupport scjViewerSupport) {
        Image image;
        this._session = scjSession;
        this._vsupport = scjViewerSupport;
        this._frame = new JFrame();
        this._frame.setExtendedState(this._session.getUserPrefRepositoryInfo().getViewerState());
        this._frame.setDefaultCloseOperation(0);
        this._frame.addWindowListener(this);
        String string = this._session.getConfiguration().getTitle();
        if (string == null) {
            string = ScjSession.getString("STR_APP_NAME");
        }
        this._frame.setTitle(string);
        if (this._session.isApplet()) {
            this._frame.getContentPane().add((Component)this._session.getApplet(), "Center");
        }
        if ((image = scjSession.getConfiguration().getIconImage(scjSession)) == null) {
            image = SCImageLoader.getImage("scj64", 1006);
        }
        this._frame.setIconImage(image);
        this._viewerManager = new ViewerManager(this._session, this._vsupport, this);
        this._frame.setBounds(this._session.getUserPrefRepositoryInfo().getViewerBounds());
        UIUtils.ensureWindowIsVisible((Window)this._frame);
        this.addInstance();
        this._session.addViewer(this);
    }

    ViewerManager getViewerManager() {
        return this._viewerManager;
    }

    int getInstanceCount() {
        return _instanceCount;
    }

    private void addInstance() {
        ++_instanceCount;
    }

    private void removeInstance() {
        --_instanceCount;
    }

    Viewer cloneMe() {
        Viewer viewer = null;
        try {
            viewer = (Viewer)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        viewer.getFrame().setVisible(true);
        viewer.getViewerManager().getMainPanel().setVisible(true);
        viewer.getFrame().setLocation(this.getFrame().getBounds().x + 25, this.getFrame().getBounds().y + 25);
        return viewer;
    }

    protected Object clone() throws CloneNotSupportedException {
        Viewer viewer = null;
        try {
            viewer = new Viewer(this._session, this._vsupport);
        }
        catch (Exception exception) {
            throw new CloneNotSupportedException();
        }
        return viewer;
    }

    void handleExit() {
        this.removeInstance();
        if (_instanceCount == 0) {
            Object object;
            ProviderEntry providerEntry;
            Enumeration enumeration = this._vsupport.getProviders().getProviderList();
            while (enumeration.hasMoreElements()) {
                providerEntry = (ProviderEntry)enumeration.nextElement();
                if (!providerEntry.isLoaded() || (object = providerEntry.getProvider()).isOkToShutdown(this._frame)) continue;
                this.addInstance();
                return;
            }
            if (!this._viewerManager.getContentPane().notifyCurrentPageOfOnKillActive()) {
                this.addInstance();
                return;
            }
            this._viewerManager.setViewSettings();
            enumeration = this._vsupport.getProviders().getProviderList();
            while (enumeration.hasMoreElements()) {
                providerEntry = (ProviderEntry)enumeration.nextElement();
                if (!providerEntry.isLoaded()) continue;
                object = providerEntry.getProvider();
                object.shutdown();
            }
            enumeration = this._vsupport.getProviders().getProviderList();
            while (enumeration.hasMoreElements()) {
                providerEntry = (ProviderEntry)enumeration.nextElement();
                if (!providerEntry.isLoaded()) continue;
                object = providerEntry.getProvider();
                providerEntry.unloadProvider();
            }
            if (!this._session.isApplet()) {
                this._viewerManager.getMainPanel().getSearchPane().setSearchPreferences();
                this._session.getUserPrefRepositoryInfo().setViewerState(this._frame.getExtendedState());
                if (this._frame.getExtendedState() == 0) {
                    object = this._frame.getBounds();
                    this._session.getUserPrefRepositoryInfo().setViewerBounds((Rectangle)object);
                }
                Viewer viewer = this;
                viewer._session.saveUserPreferences();
                this._session.saveSCPreferences();
                this._frame.setVisible(false);
                this._vsupport.AppStopped();
                this._session.releaseResources();
                this._vsupport.releaseResources();
            }
            SybaseCentral._program._viewer = null;
            SybaseCentral._program = null;
        } else if (!this._viewerManager.getContentPane().notifyCurrentPageOfOnKillActive()) {
            this.addInstance();
            return;
        }
        this.releaseResources();
        System.gc();
    }

    void releaseResources() {
        this._frame.removeWindowListener(this);
        this._frame.setVisible(false);
        this._frame.dispose();
        this._viewerManager.releaseResources();
        this._viewerManager = null;
        this._session.removeViewer(this);
        this._session = null;
        this._vsupport = null;
        DialogUtils.removeComponents((Container)this._frame);
        this._frame = null;
    }

    JFrame getFrame() {
        return this._frame;
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (!this._session.isStartup()) {
            this._viewerManager.menuItemSelected(1000);
        }
    }
}

