/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.util;

import com.sun.jmx.remote.util.ClassLogger;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class EnvHelp {
    private static final String DEFAULT_CLASS_LOADER = "jmx.remote.default.class.loader";
    private static final String DEFAULT_CLASS_LOADER_NAME = "jmx.remote.default.class.loader.name";
    public static final String MAX_FETCH_NOTIFS = "jmx.remote.x.notification.fetch.max";
    public static final String FETCH_TIMEOUT = "jmx.remote.x.notification.fetch.timeout";
    public static final String DEFAULT_ORB = "java.naming.corba.orb";
    public static final String SERVER_CONNECTION_TIMEOUT = "jmx.remote.x.server.connection.timeout";
    public static final String CLIENT_CONNECTION_CHECK_PERIOD = "jmx.remote.x.client.connection.check.period";
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "EnvHelp");
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$javax$management$ObjectName;
    static /* synthetic */ Class class$java$lang$Throwable;

    public static ClassLoader resolveServerClassLoader(Map map, MBeanServer mBeanServer) throws InstanceNotFoundException {
        if (map == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        Object v = map.get(DEFAULT_CLASS_LOADER);
        Object v2 = map.get(DEFAULT_CLASS_LOADER_NAME);
        if (v != null && v2 != null) {
            throw new IllegalArgumentException("Only one of jmx.remote.default.class.loader or jmx.remote.default.class.loader.name should be specified.");
        }
        if (v == null && v2 == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        if (v != null) {
            if (v instanceof ClassLoader) {
                return (ClassLoader)v;
            }
            String string = "ClassLoader object is not an instance of " + (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = EnvHelp.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getName() + " : " + v.getClass().getName();
            throw new IllegalArgumentException(string);
        }
        if (!(v2 instanceof ObjectName)) {
            String string = "ClassLoader name is not an instance of " + (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = EnvHelp.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName() + " : " + v2.getClass().getName();
            throw new IllegalArgumentException(string);
        }
        ObjectName objectName = (ObjectName)v2;
        if (mBeanServer == null) {
            throw new IllegalArgumentException("Null MBeanServer object");
        }
        return mBeanServer.getClassLoader(objectName);
    }

    public static ClassLoader resolveClientClassLoader(Map map) {
        if (map == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        Object v = map.get(DEFAULT_CLASS_LOADER);
        if (v == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        if (v instanceof ClassLoader) {
            return (ClassLoader)v;
        }
        String string = "ClassLoader object is not an instance of " + (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = EnvHelp.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getName() + " : " + v.getClass().getName();
        throw new IllegalArgumentException(string);
    }

    public static Throwable initCause(Throwable throwable, Throwable throwable2) {
        try {
            Method method = throwable.getClass().getMethod("initCause", class$java$lang$Throwable == null ? (class$java$lang$Throwable = EnvHelp.class$("java.lang.Throwable")) : class$java$lang$Throwable);
            method.invoke((Object)throwable, throwable2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return throwable;
    }

    public static Throwable getCause(Throwable throwable) {
        Throwable throwable2 = throwable;
        try {
            Method method = throwable.getClass().getMethod("getCause", null);
            throwable2 = (Throwable)method.invoke((Object)throwable, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return throwable2 != null ? throwable2 : throwable;
    }

    public static int getMaxFetchNotifNumber(Map map) {
        return (int)EnvHelp.getIntegerAttribute(map, MAX_FETCH_NOTIFS, 1000L, 1L, Integer.MAX_VALUE);
    }

    public static long getFetchTimeout(Map map) {
        return EnvHelp.getIntegerAttribute(map, FETCH_TIMEOUT, 60000L, 0L, Long.MAX_VALUE);
    }

    public static long getIntegerAttribute(Map map, String string, long l, long l2, long l3) {
        long l4;
        Object v;
        if (map == null || (v = map.get(string)) == null) {
            return l;
        }
        if (v instanceof Number) {
            l4 = ((Number)v).longValue();
        } else if (v instanceof String) {
            l4 = Long.parseLong((String)v);
        } else {
            String string2 = "Attribute " + string + " value must be Integer or String: " + v;
            throw new IllegalArgumentException(string2);
        }
        if (l4 < l2) {
            String string3 = "Attribute " + string + " value must be at least " + l2 + ": " + l4;
            throw new IllegalArgumentException(string3);
        }
        if (l4 > l3) {
            String string4 = "Attribute " + string + " value must be at most " + l3 + ": " + l4;
            throw new IllegalArgumentException(string4);
        }
        return l4;
    }

    public static void checkAttributes(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (k instanceof String) continue;
            String string = "Attributes contain key that is not a string: " + k;
            throw new IllegalArgumentException(string);
        }
    }

    public static Map serializableAttributes(Map map) {
        if (logger.traceOn()) {
            logger.trace("serializableAttributes", "starts");
        }
        HashMap hashMap = new HashMap(map);
        ObjectOutputStream objectOutputStream = null;
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v == null || v instanceof String) {
                if (!logger.traceOn()) continue;
                logger.trace("serializableAttributes", "Attribute trivially serializable: " + string);
                continue;
            }
            try {
                if (objectOutputStream == null) {
                    objectOutputStream = new ObjectOutputStream(new SinkOutputStream());
                }
                objectOutputStream.writeObject(v);
                if (!logger.traceOn()) continue;
                logger.trace("serializableAttributes", "Attribute serializable: " + string);
            }
            catch (IOException iOException) {
                if (logger.traceOn()) {
                    logger.trace("serializableAttributes", "Attribute not serializable: " + string + ": " + iOException);
                }
                iterator.remove();
                objectOutputStream = null;
            }
        }
        return hashMap;
    }

    public static long getServerConnectionTimeout(Map map) {
        return EnvHelp.getIntegerAttribute(map, SERVER_CONNECTION_TIMEOUT, 120000L, 0L, Long.MAX_VALUE);
    }

    public static long getConnectionCheckPeriod(Map map) {
        return EnvHelp.getIntegerAttribute(map, CLIENT_CONNECTION_CHECK_PERIOD, 60000L, 0L, Long.MAX_VALUE);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class SinkOutputStream
    extends OutputStream {
        private SinkOutputStream() {
        }

        public void write(byte[] byArray, int n, int n2) {
        }

        public void write(int n) {
        }
    }
}

