/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.codec;

import com.certicom.ecc.codec.ECCodec;

public class ECKeyRawCodec
extends ECCodec {
    protected ECKeyRawCodec() {
        super("RAW encoding");
    }

    public int outputSize() {
        if (this.mode == 2 && this.curve != null && this.curve[0] instanceof Integer) {
            return super.outputSize() + 2 + this.curve.length;
        }
        if (this.mode == 2) {
            return super.outputSize() + 2;
        }
        if (this.mode == 1) {
            return super.outputSize() + 1;
        }
        throw new IllegalStateException("wrong mode.");
    }

    protected void encode() {
        this.initResult(this.outputSize());
        byte[] byArray = new byte[this.doff];
        System.arraycopy(this.data, 0, byArray, 0, this.doff);
        this.result[1] = byArray;
    }

    protected void decode() {
        this.initResult(this.outputSize());
        byte[] byArray = new byte[this.doff];
        System.arraycopy(this.data, 0, byArray, 0, this.doff);
        this.result[2] = byArray;
        if (this.curve == null) {
            this.result[1] = "ImplicitlyCA";
        } else if (this.curve[0] instanceof String) {
            this.result[1] = this.curve[0];
        } else {
            this.result[1] = "ECParameters";
            int n2 = 3;
            for (int i2 = 0; i2 < this.curve.length; ++i2) {
                this.result[n2] = this.curve[i2];
                ++n2;
            }
        }
    }
}

