/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.rsa;

import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.rsa.RSAKey;
import com.certicom.ecc.util.Conversion;
import java.math.BigInteger;

public class RSAPrivateKey
implements RSAKey,
Zeroizeable {
    private BigInteger I;
    private BigInteger L;
    private BigInteger K;
    private BigInteger J;
    private BigInteger M;
    protected BigInteger H;
    protected BigInteger G;
    protected BigInteger O;
    protected BigInteger N;
    protected BigInteger Q;
    private boolean P = false;

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this(bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
        if (bigInteger.signum() == -1 || bigInteger2.signum() == -1 || bigInteger3.signum() == -1) {
            throw new IllegalArgumentException("nonnegative integers only.");
        }
        this.I = bigInteger;
        this.K = this.L = bigInteger2;
        this.J = this.L;
        this.M = bigInteger3;
    }

    public RSAPrivateKey(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, byte[] byArray7, byte[] byArray8) {
        this(byArray4, byArray5, byArray6, byArray7, byArray8);
        this.I = Conversion.OS2IP(byArray);
        this.K = this.L = Conversion.OS2IP(byArray2);
        this.J = this.L;
        this.M = Conversion.OS2IP(byArray3);
    }

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) {
        BigInteger bigInteger6 = new BigInteger("1");
        BigInteger bigInteger7 = new BigInteger("65537");
        if (bigInteger.signum() == -1 || bigInteger2.signum() == -1 || bigInteger3.signum() == -1 || bigInteger4.signum() == -1 || bigInteger5.signum() == -1) {
            throw new IllegalArgumentException("nonnegative integers only.");
        }
        this.H = bigInteger;
        this.G = bigInteger2;
        this.O = bigInteger3;
        this.N = bigInteger4;
        this.Q = bigInteger5;
        if (0 == bigInteger7.multiply(bigInteger3).mod(bigInteger.subtract(bigInteger6)).compareTo(bigInteger6) && 0 == bigInteger7.multiply(bigInteger4).mod(bigInteger2.subtract(bigInteger6)).compareTo(bigInteger6)) {
            this.K = this.L = bigInteger7;
            this.J = this.L;
        } else {
            this.K = bigInteger3.modInverse(bigInteger.subtract(bigInteger6));
            this.J = bigInteger4.modInverse(bigInteger2.subtract(bigInteger6));
        }
    }

    public RSAPrivateKey(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        this(Conversion.OS2IP(byArray), Conversion.OS2IP(byArray2), Conversion.OS2IP(byArray3), Conversion.OS2IP(byArray4), Conversion.OS2IP(byArray5));
    }

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        if (bigInteger.signum() == -1 || bigInteger2.signum() == -1 || bigInteger3.signum() == -1) {
            throw new IllegalArgumentException("nonnegative integers only.");
        }
        this.I = bigInteger;
        this.K = this.L = bigInteger2;
        this.J = this.L;
        this.M = bigInteger3;
    }

    public RSAPrivateKey(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.I = Conversion.OS2IP(byArray);
        this.K = this.L = Conversion.OS2IP(byArray2);
        this.J = this.L;
        this.M = Conversion.OS2IP(byArray3);
    }

    public boolean hasCRT() {
        return this.H != null;
    }

    public boolean hasExponents() {
        return this.I != null;
    }

    public BigInteger n() {
        return this.I;
    }

    public BigInteger e() {
        return this.L;
    }

    public BigInteger eP() {
        return this.K;
    }

    public BigInteger eQ() {
        return this.J;
    }

    public BigInteger d() {
        return this.M;
    }

    public BigInteger p() {
        return this.H;
    }

    public BigInteger q() {
        return this.G;
    }

    public BigInteger dP() {
        return this.O;
    }

    public BigInteger dQ() {
        return this.N;
    }

    public BigInteger qInv() {
        return this.Q;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ ");
        if (this.hasExponents()) {
            stringBuffer.append(" n = ").append(this.I.toString(16));
            stringBuffer.append(" e = ").append(this.L.toString(16));
            stringBuffer.append(" d = ").append(this.M.toString(16));
        }
        if (this.hasCRT()) {
            stringBuffer.append(" p = ").append(this.H.toString(16));
            stringBuffer.append(" q = ").append(this.G.toString(16));
            stringBuffer.append(" dP = ").append(this.O.toString(16));
            stringBuffer.append(" dQ = ").append(this.N.toString(16));
            stringBuffer.append(" qInv = ").append(this.Q.toString(16));
        }
        return stringBuffer.append(" ]").toString();
    }

    public boolean isZeroized() {
        return this.P;
    }

    public boolean testZeroizationState() {
        return this.P;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        this.I = BigInteger.ZERO;
        this.L = BigInteger.ZERO;
        this.K = BigInteger.ZERO;
        this.J = BigInteger.ZERO;
        this.M = BigInteger.ZERO;
        this.H = BigInteger.ZERO;
        this.G = BigInteger.ZERO;
        this.O = BigInteger.ZERO;
        this.N = BigInteger.ZERO;
        this.Q = BigInteger.ZERO;
        this.P = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }
}

