/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.rsa;

import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.rsa.RSAKey;
import com.certicom.ecc.util.Conversion;
import java.math.BigInteger;

public class RSAPublicKey
implements RSAKey,
Zeroizeable {
    private BigInteger T;
    private BigInteger S;
    private boolean R = false;

    public RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger.signum() == -1 || bigInteger2.signum() == -1) {
            throw new IllegalArgumentException("nonnegative integers only.");
        }
        this.T = bigInteger;
        this.S = bigInteger2;
    }

    public RSAPublicKey(byte[] byArray, byte[] byArray2) {
        this.T = Conversion.OS2IP(byArray);
        this.S = Conversion.OS2IP(byArray2);
    }

    public BigInteger n() {
        return this.T;
    }

    public BigInteger e() {
        return this.S;
    }

    public String toString() {
        return "[n = " + this.T.toString(16) + " e = " + this.S.toString(16) + " ]";
    }

    public boolean isZeroized() {
        return this.R;
    }

    public boolean testZeroizationState() {
        return this.R;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        this.T = BigInteger.ZERO;
        this.S = BigInteger.ZERO;
        this.R = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }
}

