/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.util.Conversion;
import java.math.BigInteger;
import java.util.Random;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DH
extends CryptoTransform {
    private byte[] try;

    public DH() {
        super("DH");
    }

    public void reset() {
        super.reset();
        if (this.try != null) {
            int n2 = 0;
            while (n2 < this.try.length) {
                this.try[n2++] = 0;
            }
        }
        this.try = null;
    }

    public void init(int n2, Object[] objectArray, Random random) throws IllegalArgumentException {
        if (n2 != 6 || objectArray == null || objectArray.length < 2) {
            throw new IllegalArgumentException("wrong params");
        }
        super.init(n2, objectArray, random);
        try {
            BigInteger bigInteger = new BigInteger(1, (byte[])objectArray[0]);
            BigInteger bigInteger2 = new BigInteger(1, (byte[])objectArray[1]);
            BigInteger bigInteger3 = new BigInteger(1, (byte[])objectArray[2]);
            BigInteger bigInteger4 = bigInteger2.modPow(bigInteger3, bigInteger);
            byte[] byArray = Conversion.I2OSP(bigInteger4, -1);
            int n3 = ((byte[])objectArray[0]).length;
            this.try = new byte[n3];
            if (n3 + 1 == byArray.length) {
                System.arraycopy(byArray, 1, this.try, 0, n3);
            } else if (n3 > byArray.length) {
                System.arraycopy(byArray, 0, this.try, n3 - byArray.length, byArray.length);
            } else if (n3 == byArray.length) {
                this.try = byArray;
            }
        }
        catch (Exception exception) {
            this.reset();
            exception.printStackTrace();
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    public int outputSize(int n2, boolean bl) throws IllegalStateException {
        if (this.for == 6) {
            return this.try.length;
        }
        throw new IllegalStateException("wrong mode");
    }

    public int transform(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (this.for != 6) {
            throw new IllegalStateException("wrong mode");
        }
        if (byArray2 == null || byArray2.length - n4 < this.try.length) {
            throw new IllegalArgumentException("out buf error");
        }
        System.arraycopy(this.try, 0, byArray2, n4, this.try.length);
        return this.try.length;
    }
}

