/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.ECA;
import com.certicom.ecc.ECFactory;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.ECPrivateKey;
import com.certicom.ecc.interfaces.ECPublicKey;
import com.certicom.ecc.scheme.KeyAgreement;
import com.certicom.ecc.spec.SharedInfoParameterSpec;
import java.math.BigInteger;
import java.util.Random;

public final class ECDH
extends KeyAgreement {
    private Boolean bR = null;

    public ECDH() {
        super("ECDH");
    }

    public void init(int n2, Object[] objectArray, Random random) throws IllegalArgumentException {
        if (n2 != 6 && n2 != 7 || objectArray == null || objectArray.length < 2) {
            throw new IllegalArgumentException("wrong params");
        }
        ECPrivateKey eCPrivateKey = (ECPrivateKey)objectArray[0];
        ECPublicKey eCPublicKey = (ECPublicKey)objectArray[1];
        if (objectArray.length == 3 && objectArray[2] != null) {
            if (objectArray[2] instanceof Boolean) {
                this.bR = new Boolean((Boolean)objectArray[2]);
            } else {
                this.bO = ((SharedInfoParameterSpec)objectArray[2]).getSharedInfo(0);
            }
        } else if (objectArray.length == 4) {
            if (objectArray[2] != null) {
                this.bO = ((SharedInfoParameterSpec)objectArray[2]).getSharedInfo(0);
            }
            if (objectArray[3] != null) {
                this.bR = new Boolean((Boolean)objectArray[3]);
            }
        }
        super.init(n2, objectArray, random);
        ECParams eCParams = eCPrivateKey.getECParams();
        try {
            ECFactory eCFactory = ECFactory.a(eCParams);
            ECA eCA = eCFactory.a(eCPublicKey.getX(), eCPublicKey.getY());
            eCA = this.a(eCA, eCPrivateKey.getExp(), eCParams);
            if (eCA.equals(eCA.if())) {
                this.reset();
                throw new IllegalArgumentException("keys are invalid.");
            }
            this.bP = eCA.new().try();
        }
        catch (Exception exception) {
            this.reset();
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    private ECA a(ECA eCA, byte[] byArray, ECParams eCParams) {
        BigInteger bigInteger = new BigInteger(1, byArray);
        if (this.bR == null && this.if == 32 || Boolean.TRUE.equals(this.bR)) {
            return eCA.a(bigInteger.multiply(BigInteger.valueOf(eCParams.getCofactor())).mod(new BigInteger(1, eCParams.getPointOrder())));
        }
        return eCA.a(bigInteger.mod(new BigInteger(1, eCParams.getPointOrder())));
    }
}

