/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.ECA;
import com.certicom.ecc.ECException;
import com.certicom.ecc.ECFactory;
import com.certicom.ecc.interfaces.ECKey;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.scheme.ECDSA;
import com.certicom.ecc.scheme.ECTransform;
import com.certicom.ecc.spec.ECPrivateKeySpec;
import com.certicom.ecc.spec.ECPublicKeySpec;
import com.certicom.ecc.spec.PointSpec;
import com.certicom.ecc.util.Conversion;
import com.certicom.ecc.util.RandomValue;
import java.math.BigInteger;
import java.util.Random;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ECKeyGen
extends ECTransform {
    private ECParams bX = null;
    private int bY;
    private ECFactory bW = null;

    public ECKeyGen() {
        super("ECKeyGen");
    }

    public void reset() {
        super.reset();
        this.bX = null;
        this.bY = 0;
        this.bW = null;
    }

    public void init(int n2, Object[] objectArray, Random random) throws IllegalArgumentException {
        this.reset();
        super.init(n2, objectArray, random);
        if (n2 != 5 || random == null || objectArray == null) {
            this.reset();
            throw new IllegalArgumentException("wrong params");
        }
        this.bX = (ECParams)objectArray[0];
        this.bY = this.bX.getSize();
        this.goto();
    }

    public int outputSize(int n2, boolean bl) {
        return 0;
    }

    public int transform(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, boolean bl) throws IllegalArgumentException, IllegalStateException {
        return 0;
    }

    public Object transformToObject(byte[] byArray, int n2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (this.do == null || this.bX == null) {
            throw new IllegalStateException("no rnd or no curve");
        }
        BigInteger bigInteger = new BigInteger(1, RandomValue.inRange(this.do, this.bX.getPointOrder(), true));
        ECA eCA = this.bW.for().a(bigInteger);
        return new ECKey[]{new ECPrivateKeySpec(this.bN, bigInteger, this.bX), new ECPublicKeySpec(this.bN, this.bM, new PointSpec(eCA.new().try(), eCA.int().try(), this.bX), this.bX)};
    }

    private void goto() {
        try {
            this.bW = ECFactory.a(this.bX);
        }
        catch (ECException eCException) {
            throw new IllegalStateException("cannot do cryptography.");
        }
    }

    protected boolean a(byte[] byArray, int n2, int n3, boolean bl, Object object) {
        ECPrivateKeySpec eCPrivateKeySpec = (ECPrivateKeySpec)((Object[])object)[0];
        ECPublicKeySpec eCPublicKeySpec = (ECPublicKeySpec)((Object[])object)[1];
        byte[] byArray2 = "Romanes eunt domus".getBytes();
        ECDSA eCDSA = new ECDSA();
        try {
            eCDSA.init(1, new Object[]{eCPrivateKeySpec}, this.do);
            byte[] byArray3 = eCDSA.transform(byArray2, 0, byArray2.length, true);
            if (this.a()) {
                System.out.println("EC Keygen: modifying signature 5th byte");
                System.out.println("Old: " + Conversion.OS2Hex(byArray3, 2));
                byArray3[4] = (byte)(byArray3[4] & 0xFF ^ 1);
                System.out.println("New: " + Conversion.OS2Hex(byArray3, 2));
            }
            eCDSA.init(2, new Object[]{eCPublicKeySpec}, null);
            eCDSA.transform(byArray2, 0, byArray2.length, true);
            return eCDSA.verify(byArray3, 0, byArray3.length);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }
}

