/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.spec;

import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.interfaces.F2mParams;
import com.certicom.ecc.spec.FFParameterSpec;
import com.certicom.ecc.util.Conversion;

public class F2mParameterSpec
extends FFParameterSpec
implements F2mParams {
    private int t = -1;
    private int v = -1;
    private int u = -1;

    public F2mParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, int n2, int n3, int n4, int n5, int n6, String string, String string2) {
        super(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, n2, n3, string, string2);
        this.t = n4;
        this.v = n5;
        this.u = n6;
    }

    public F2mParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, int n2, int n3, int n4, String string, String string2) {
        this(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, n2, n3, n4, -1, -1, string, string2);
    }

    public F2mParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, int n2, int n3, String string, String string2) {
        this(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, n2, n3, -1, -1, -1, string, string2);
    }

    public F2mParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, int n2, int n3, int[] nArray, String string, String string2) {
        super(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, n2, n3, string, string2);
        if (nArray != null) {
            if (nArray.length == 1) {
                this.t = nArray[0];
            } else if (nArray.length == 3) {
                this.t = nArray[0];
                this.v = nArray[1];
                this.u = nArray[2];
            } else {
                throw new IllegalArgumentException("basis not recognized");
            }
        }
    }

    public int basisType() {
        return this.t == -1 ? 0 : (this.v == -1 ? 1 : 2);
    }

    public int[] getBasis() {
        switch (this.basisType()) {
            case 0: {
                return null;
            }
            case 1: {
                return new int[]{this.t};
            }
        }
        return new int[]{this.t, this.v, this.u};
    }

    public boolean equals(Object object) {
        if (object instanceof F2mParameterSpec) {
            F2mParameterSpec f2mParameterSpec = (F2mParameterSpec)object;
            return super.equals(object) & this.getSize() == f2mParameterSpec.getSize() & this.t == f2mParameterSpec.t & this.v == this.v & this.u == this.u;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ FieldType: F2m");
        return stringBuffer.append(" curveAtA: ").append(Conversion.OS2Hex(this.n, 8)).append(" curveAtB: ").append(Conversion.OS2Hex(this.m, 8)).append(" seed: ").append(this.k == null ? "NULL" : Conversion.OS2Hex(this.k, 8)).append(" baseAtX: ").append(Conversion.OS2Hex(this.p, 8)).append(" baseAtY: ").append(Conversion.OS2Hex(this.o, 8)).append(" order: ").append(Conversion.OS2Hex(this.j, 8)).append(" cf: ").append(Integer.toString(this.i)).append(" size: ").append(Integer.toString(this.getSize())).append(" basis: ").append(" k: ").append(this.t == -1 ? "NULL " : Integer.toString(this.t)).append(" k2: ").append(this.v == -1 ? "NULL " : Integer.toString(this.v)).append(" k3: ").append(this.u == -1 ? "NULL " : Integer.toString(this.u)).append(" ]").toString();
    }

    public void zeroize() throws FIPSException {
        this.t = -1;
        this.v = -1;
        this.u = -1;
        super.zeroize();
    }
}

