/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.spec;

import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.PointParams;
import com.certicom.ecc.spec.PointSpec;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class FFParameterSpec
implements ECParams,
Zeroizeable {
    protected int s;
    protected byte[] n;
    protected byte[] m;
    protected byte[] k;
    protected byte[] p;
    protected byte[] o;
    protected byte[] j;
    protected int i;
    protected String l;
    protected String r;
    protected boolean q = false;

    protected FFParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, int n2, int n3, String string, String string2) {
        if (byArray == null || byArray2 == null || byArray4 == null || byArray5 == null || byArray6 == null) {
            throw new NullPointerException("parameter(s) cannot be null!");
        }
        this.s = n3;
        n3 = (n3 + 7) / 8;
        this.n = this.do(byArray, 0, byArray.length, n3);
        this.m = this.do(byArray2, 0, byArray2.length, n3);
        if (byArray3 != null) {
            this.k = this.do(byArray3, 0, byArray3.length, -1);
        }
        this.p = this.do(byArray4, 0, byArray4.length, n3);
        this.o = this.do(byArray5, 0, byArray5.length, n3);
        this.j = this.do(byArray6, 0, byArray6.length, -1);
        this.i = n2;
        this.l = string;
        this.r = string2;
    }

    public int getSize() {
        return this.s;
    }

    public byte[] getA() {
        return this.do(this.n, 0, this.n.length, -1);
    }

    public byte[] getB() {
        return this.do(this.m, 0, this.m.length, -1);
    }

    public byte[] getSeed() {
        if (this.k != null) {
            return this.do(this.k, 0, this.k.length, -1);
        }
        return null;
    }

    public PointParams getPoint() {
        return new PointSpec(this.p, this.o, this);
    }

    public byte[] getPointOrder() {
        return this.do(this.j, 0, this.j.length, -1);
    }

    public int getCofactor() {
        return this.i;
    }

    public String getName() {
        String string;
        if (this.l == null) {
            string = this.getOID();
            if (string == null) {
                string = "ImplicitlyCA";
            }
        } else {
            string = new String(this.l);
        }
        return string;
    }

    public String getOID() {
        if (this.r == null) {
            return null;
        }
        return new String(this.r);
    }

    public boolean equals(Object object) {
        if (object instanceof FFParameterSpec) {
            FFParameterSpec fFParameterSpec = (FFParameterSpec)object;
            return this.s == fFParameterSpec.s && this.i == fFParameterSpec.i && this.a(this.n, fFParameterSpec.n) && this.a(this.m, fFParameterSpec.m) && this.a(this.p, fFParameterSpec.p) && this.a(this.o, fFParameterSpec.o) && this.a(this.j, fFParameterSpec.j);
        }
        return false;
    }

    protected final byte[] do(byte[] byArray, int n2, int n3, int n4) {
        if (byArray == null || byArray.length - n2 < n3) {
            throw new IllegalArgumentException("parameter(s) relating to input buffer invalid");
        }
        int n5 = n3;
        while (n3 > 0 && byArray[n2] == 0) {
            ++n2;
            --n3;
        }
        if (n3 == 0) {
            return new byte[n5];
        }
        if (n4 == -1) {
            n4 = n3;
        }
        if (n3 > n4) {
            throw new IllegalArgumentException("output buffer is too small.");
        }
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n2, byArray2, n4 - n3, n3);
        return byArray2;
    }

    protected final boolean a(byte[] byArray, byte[] byArray2) {
        int n2;
        int n3;
        if (byArray == null || byArray2 == null) {
            throw new IllegalArgumentException("null array(s)");
        }
        for (n3 = 0; n3 < byArray.length && byArray[n3] == 0; ++n3) {
        }
        for (n2 = 0; n2 < byArray2.length && byArray2[n2] == 0; ++n2) {
        }
        if (byArray.length - n3 != byArray2.length - n2) {
            return false;
        }
        n3 = byArray.length - n2;
        n2 = 0;
        while (n3-- > 0) {
            if (byArray[byArray.length - ++n2] == byArray2[byArray2.length - n2]) continue;
            return false;
        }
        return true;
    }

    public boolean isZeroized() {
        return this.q;
    }

    public boolean testZeroizationState() {
        return this.q;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        Arrays.fill(this.n, (byte)0);
        Arrays.fill(this.m, (byte)0);
        if (this.k != null) {
            Arrays.fill(this.k, (byte)0);
        }
        Arrays.fill(this.p, (byte)0);
        Arrays.fill(this.o, (byte)0);
        Arrays.fill(this.j, (byte)0);
        this.i = 0;
        this.s = 0;
        this.r = "0.0.0.0";
        this.l = "0.0.0.0";
        this.q = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }
}

