/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.spec;

import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.util.Conversion;
import java.util.Arrays;

public class SharedInfoParameterSpec
implements Zeroizeable {
    private byte[][] dO = null;
    private boolean dP = false;

    public SharedInfoParameterSpec(byte[][] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("sharedInfo is null.");
        }
        this.dO = new byte[byArray.length][];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == null) continue;
            this.dO[i2] = new byte[byArray[i2].length];
            System.arraycopy(byArray[i2], 0, this.dO[i2], 0, byArray[i2].length);
        }
    }

    public SharedInfoParameterSpec(byte[][] byArray, int[] nArray, int[] nArray2) {
        if (byArray == null || nArray == null || nArray2 == null) {
            throw new IllegalArgumentException("sharedInfo is null.");
        }
        if (byArray.length != nArray.length || nArray.length != nArray2.length) {
            throw new IllegalArgumentException("different length arguments");
        }
        this.dO = new byte[byArray.length][];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == null) continue;
            if (nArray[i2] + nArray2[i2] > byArray[i2].length) {
                throw new IllegalArgumentException("wrong length arguments.");
            }
            this.dO[i2] = new byte[byArray[i2].length];
            System.arraycopy(byArray[i2], nArray[i2], this.dO[i2], 0, nArray2[i2]);
        }
    }

    public byte[][] getSharedInfo() {
        byte[][] byArrayArray = new byte[this.dO.length][];
        for (int i2 = 0; i2 < this.dO.length; ++i2) {
            if (this.dO[i2] == null) continue;
            byArrayArray[i2] = new byte[this.dO[i2].length];
            System.arraycopy(this.dO[i2], 0, byArrayArray[i2], 0, byArrayArray[i2].length);
        }
        return byArrayArray;
    }

    public byte[] getSharedInfo(int n2) {
        if (n2 < 0 || n2 > this.dO.length) {
            throw new IllegalArgumentException("index incorrect.");
        }
        if (this.dO[n2] == null) {
            return null;
        }
        byte[] byArray = new byte[this.dO[n2].length];
        System.arraycopy(this.dO[n2], 0, byArray, 0, byArray.length);
        return byArray;
    }

    public boolean isZeroized() {
        return this.dP;
    }

    public boolean testZeroizationState() {
        return this.dP;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        for (int i2 = 0; i2 < this.dO.length; ++i2) {
            if (this.dO[i2] == null) continue;
            Arrays.fill(this.dO[i2], (byte)0);
        }
        this.dP = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ ");
        for (int i2 = 0; i2 < this.dO.length; ++i2) {
            stringBuffer.append(Integer.toString(i2)).append(" = ");
            if (this.dO[i2] != null) {
                stringBuffer.append(Conversion.OS2Hex(this.dO[i2], 2)).append(" ");
                continue;
            }
            stringBuffer.append("null ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

