/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.config.impl;

import com.sybase.ase.sdcadmin.config.ClusterConfigException;
import com.sybase.ase.sdcadmin.config.ClusterConfigFactory;
import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.config.impl.EntryBase;
import com.sybase.ase.sdcadmin.config.impl.EntryServer;
import com.sybase.ase.sdcadmin.quorum.Quorum;
import com.sybase.ase.sdcadmin.quorum.QuorumCluster;
import com.sybase.ase.sdcadmin.quorum.QuorumException;
import com.sybase.ase.sdcadmin.quorum.QuorumInstance;
import com.sybase.ase.sdcadmin.quorum.QuorumStatus;
import com.sybase.ase.sdcadmin.util.FileUtil;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Entry
extends EntryBase
implements ICluster,
ISdConstants {
    private static Log log = LogFactory.getLog(Entry.class);
    private String description = "Cluster Administration (sdadmin) Generated Entry";
    private Integer maxInstances = new Integer(255);
    private String quorumDevice = null;
    private Integer bootCoord = null;
    private String primaryInterconnect = null;
    private String secondaryInterconnect = null;
    private String pageSize = null;
    private String masterDevice = null;
    private String masterDeviceSize = null;
    private String masterDatabaseSize = null;
    private String systemProcedureDevice = null;
    private String systemProcedureDeviceSize = null;
    private String systemProcedureDatabaseSize = null;
    private String systemDevice = null;
    private String systemDeviceSize = null;
    private String systemDatabaseSize = null;
    private String pciDevice = null;
    private String pciDeviceSize = null;
    private String pciDatabaseSize = null;
    private boolean usesLDAP = false;
    private boolean multipleBackupServersPresent = false;
    private String backupServersPolicy = null;
    private boolean isUpgradeCheck = false;
    private String oldServerName = null;
    private String installationMode = "shared";
    TreeMap servers = null;

    private Entry() {
        super("");
    }

    public Entry(String string) {
        super(string);
    }

    @Override
    public String getInstallationMode() {
        return this.installationMode;
    }

    @Override
    public void setInstallationMode(String string) {
        this.installationMode = string;
    }

    @Override
    public String getPrimaryInterconnect() {
        return this.primaryInterconnect;
    }

    @Override
    public void setPrimaryInterconnect(String string) {
        this.primaryInterconnect = string;
    }

    @Override
    public String getSecondaryInterconnect() {
        return this.secondaryInterconnect;
    }

    @Override
    public void setSecondaryInterconnect(String string) {
        this.secondaryInterconnect = string;
    }

    @Override
    public void setRunParameters(Integer n, String string) throws ClusterConfigException {
        IServer iServer = this.getServer(n);
        if (iServer == null) {
            iServer = ClusterConfigFactory.createServer(null);
            iServer.setId(n);
            this.addServer(n, iServer);
        }
        iServer.setAddlRunParameters(string);
    }

    @Override
    public void setErrorlogPath(Integer n, String string) throws ClusterConfigException {
        IServer iServer = this.getServer(n);
        if (iServer == null) {
            iServer = ClusterConfigFactory.createServer(null);
            iServer.setId(n);
            this.addServer(n, iServer);
        }
        iServer.setLogFile(string);
    }

    @Override
    public String getQuorum() {
        return this.quorumDevice;
    }

    @Override
    public void setQuorum(String string) {
        this.quorumDevice = string;
    }

    @Override
    public IServer[] getServersArray() {
        IServer[] iServerArray = new EntryServer[]{};
        if (this.servers != null && this.servers.size() > 0) {
            iServerArray = new EntryServer[this.servers.size()];
            this.servers.values().toArray(iServerArray);
        }
        return iServerArray;
    }

    @Override
    public Integer getNextId() {
        int n;
        IServer[] iServerArray = this.getServersArray();
        int n2 = Integer.MIN_VALUE;
        boolean[] blArray = null;
        if (this.getMaxInstances() == null) {
            log.warn((Object)"Warning - Maximum Server Instances was not set.  Setting it to one.");
            this.setMaxInstances(new Integer(1));
        }
        int n3 = this.getMaxInstances();
        blArray = new boolean[n3];
        for (n = 0; n < n3; ++n) {
            blArray[n] = false;
        }
        for (n = 0; n < iServerArray.length; ++n) {
            int n4 = iServerArray[n].getId();
            if (n4 < n3) {
                blArray[n4 - 1] = true;
            }
            n2 = Math.max(n4, n2);
        }
        for (n = 0; n < n3; ++n) {
            if (blArray[n]) continue;
            return new Integer(n + 1);
        }
        return new Integer(n2);
    }

    @Override
    public boolean containsServer(IServer iServer) {
        boolean bl = false;
        IServer[] iServerArray = this.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            if (!iServer.getName().equalsIgnoreCase(iServerArray[i].getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public boolean containsServer(String string) {
        boolean bl = false;
        IServer[] iServerArray = this.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            if (!string.equalsIgnoreCase(iServerArray[i].getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public boolean containsServer(Integer n) {
        if (this.servers == null) {
            return false;
        }
        return this.servers.containsKey(n);
    }

    @Override
    public IServer getServer(Integer n) {
        if (this.servers == null) {
            return null;
        }
        return (EntryServer)this.servers.get(n);
    }

    @Override
    public IServer getServer(String string) {
        IServer iServer = null;
        IServer[] iServerArray = this.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            if (!string.equalsIgnoreCase(iServerArray[i].getName())) continue;
            iServer = iServerArray[i];
            break;
        }
        return iServer;
    }

    @Override
    public void addServer(Integer n, IServer iServer) throws ClusterConfigException {
        if (this.servers == null) {
            this.servers = new TreeMap();
        }
        if (n > this.getMaxInstances()) {
            throw new ClusterConfigException("ConfigDriver.maximum.instances.exceeded", this.getMaxInstances(), (Object)iServer.getName());
        }
        iServer.setId(n);
        if (this.servers.containsKey(n)) {
            this.servers.remove(n);
        }
        this.servers.put(n, iServer);
    }

    @Override
    public void dropServer(String string) throws ClusterConfigException {
        if (this.containsServer(string)) {
            IServer[] iServerArray = this.getServersArray();
            for (int i = 0; i < iServerArray.length; ++i) {
                if (!string.equalsIgnoreCase(iServerArray[i].getName())) continue;
                this.servers.remove(iServerArray[i].getId());
                break;
            }
        }
        if (this.servers.size() == 0) {
            this.servers = null;
        }
    }

    @Override
    public String getUid() {
        return this.quorumUid;
    }

    @Override
    public void setUid(String string) {
        this.quorumUid = string;
    }

    @Override
    public String getInterfPath() {
        return this.interfacesPath;
    }

    @Override
    public void setInterfPath(String string) {
        this.interfacesPath = string;
    }

    @Override
    public Integer getMaxInstances() {
        return this.maxInstances;
    }

    @Override
    public void setMaxInstances(Integer n) {
        this.maxInstances = n;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getMasterDevice() {
        return this.masterDevice;
    }

    @Override
    public String getMasterDatabaseSize() {
        return this.masterDatabaseSize;
    }

    @Override
    public String getMasterDeviceSize() {
        return this.masterDeviceSize;
    }

    @Override
    public String getSystemDatabaseSize() {
        return this.systemDatabaseSize;
    }

    @Override
    public String getSystemDevice() {
        return this.systemDevice;
    }

    @Override
    public String getSystemDeviceSize() {
        return this.systemDeviceSize;
    }

    @Override
    public String getSystemProcedureDatabaseSize() {
        return this.systemProcedureDatabaseSize;
    }

    @Override
    public String getSystemProcedureDevice() {
        return this.systemProcedureDevice;
    }

    @Override
    public String getSystemProcedureDeviceSize() {
        return this.systemProcedureDeviceSize;
    }

    @Override
    public String getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public void setMasterDevice(String string) {
        this.masterDevice = string;
    }

    @Override
    public void setMasterDatabaseSize(String string) {
        this.masterDatabaseSize = string;
    }

    @Override
    public void setMasterDeviceSize(String string) {
        this.masterDeviceSize = string;
    }

    @Override
    public void setSystemDatabaseSize(String string) {
        this.systemDatabaseSize = string;
    }

    @Override
    public void setSystemDevice(String string) {
        this.systemDevice = string;
    }

    @Override
    public void setSystemDeviceSize(String string) {
        this.systemDeviceSize = string;
    }

    @Override
    public void setSystemProcedureDatabaseSize(String string) {
        this.systemProcedureDatabaseSize = string;
    }

    @Override
    public void setSystemProcedureDevice(String string) {
        this.systemProcedureDevice = string;
    }

    @Override
    public void setSystemProcedureDeviceSize(String string) {
        this.systemProcedureDeviceSize = string;
    }

    @Override
    public void setPageSize(String string) {
        this.pageSize = string;
    }

    @Override
    public void dump() {
        block27: {
            try {
                int n;
                log.debug((Object)("** Cluster dump of \"" + this.name + "\" **"));
                if (this.quorumUid != null) {
                    log.debug((Object)("\tIdentifier: \"" + this.quorumUid + "\""));
                }
                if (this.interfacesPath != null) {
                    log.debug((Object)("\tInterface Path \"" + this.interfacesPath + "\""));
                }
                if (this.configFile != null) {
                    log.debug((Object)("\tConfiguration File \"" + this.configFile + "\""));
                }
                log.debug((Object)"\tTrace Flags:");
                if (this.tracesflags != null) {
                    for (int i = 0; i < this.tracesflags.size(); ++i) {
                        log.debug((Object)("\t\t[" + i + "] = " + ((Integer)this.tracesflags.get(i)).toString()));
                    }
                } else {
                    log.debug((Object)"\tThere were are no trace flags.");
                }
                if (this.maxInstances != null && this.maxInstances != -1) {
                    log.debug((Object)("\tMaximum Instances \"" + this.maxInstances + "\""));
                } else {
                    log.debug((Object)"\tWarning - Maximum Instances is not set.");
                }
                if (this.quorumDevice != null) {
                    log.debug((Object)("\tQuorum \"" + this.quorumDevice + "\""));
                } else {
                    log.warn((Object)"\tWarning - Quorum is null.");
                }
                if (this.masterDevice != null) {
                    log.debug((Object)FileUtil.removeControlCharacter("\tMaster Device \"" + this.masterDevice + "\""));
                } else {
                    log.warn((Object)"\tWarning - Master Device is null.");
                }
                IServer[] iServerArray = this.getServersArray();
                if (this.servers == null || this.servers.size() == 0) {
                    log.warn((Object)"\tWarning - No instances are defined.");
                } else {
                    for (n = 0; n < iServerArray.length; ++n) {
                        log.debug((Object)FileUtil.removeControlCharacter("\t\tlogfile " + iServerArray[n].getName() + " " + iServerArray[n].getLogFile()));
                        log.debug((Object)("\t\trun_parameters " + iServerArray[n].getName() + " " + iServerArray[n].getAddlRunParameters()));
                    }
                }
                if (this.primaryInterconnect != null) {
                    log.debug((Object)("\tPrimary Interconnect \"" + this.primaryInterconnect + "\""));
                } else {
                    log.warn((Object)"\tWarning - Primary Interconnect is not defined.");
                }
                if (this.servers == null || this.servers.size() == 0) {
                    log.warn((Object)"\tWarning - No Primary servers are defined.");
                } else {
                    for (n = 0; n < iServerArray.length; ++n) {
                        log.debug((Object)("\t\tServer[" + iServerArray[n].getId() + "] " + iServerArray[n].getName() + " " + iServerArray[n].getPrimaryAddress() + " " + iServerArray[n].getPrimaryPortStart()));
                    }
                }
                if (this.secondaryInterconnect != null && !this.secondaryInterconnect.equals("")) {
                    log.debug((Object)("\tSecondary Interconnect \"" + this.secondaryInterconnect + "\""));
                    if (this.servers == null || this.servers.size() == 0) {
                        log.warn((Object)"\tWarning - No Secondary servers are defined.");
                    } else {
                        for (n = 0; n < iServerArray.length; ++n) {
                            log.debug((Object)("\t\tServer[" + iServerArray[n].getId() + "] " + iServerArray[n].getName() + " " + iServerArray[n].getSecondaryAddress() + " " + iServerArray[n].getSecondaryPortStart()));
                        }
                    }
                }
                if (this.oldServerName != null) {
                    log.debug((Object)"Upgrade - this cluster will be created by upgrading an existing installation");
                    log.debug((Object)("\tServer " + this.oldServerName + " in " + this.oldSybaseHome + " will be upgraded"));
                    log.debug((Object)("\tExisting installation versions: ASE=" + this.oldASEHome + " OCS=" + this.oldOCSHome));
                    log.debug((Object)("\tUpgrade mode: " + (this.isUpgradeCheck ? "CHECK_ONLY" : "EXECUTE")));
                }
                log.debug((Object)("** Cluster dump of \"" + this.name + "\" completed **"));
            }
            catch (Exception exception) {
                log.debug((Object)"The dump of the cluster has failed.", (Throwable)exception);
                if (!log.isDebugEnabled()) break block27;
                System.out.println(exception);
                log.debug((Object)exception, (Throwable)exception);
            }
        }
    }

    public Integer getBootCoord() {
        return this.bootCoord;
    }

    public void setBootCoord(Integer n) {
        this.bootCoord = n;
    }

    @Override
    public int getNodeInstanceStrategy() {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        IServer[] iServerArray = this.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            InetAddress inetAddress;
            try {
                inetAddress = InetAddress.getByName(iServerArray[i].getNode());
            }
            catch (UnknownHostException unknownHostException) {
                log.debug((Object)("Unknown Host: " + iServerArray[i].getNode()));
                continue;
            }
            for (int j = 0; j < iServerArray.length; ++j) {
                if (iServerArray[i].getId().intValue() == iServerArray[j].getId().intValue()) continue;
                try {
                    InetAddress inetAddress2 = InetAddress.getByName(iServerArray[j].getNode());
                    if (inetAddress.equals(inetAddress2)) {
                        bl = true;
                        continue;
                    }
                    bl2 = true;
                    continue;
                }
                catch (UnknownHostException unknownHostException) {
                    log.debug((Object)("Unknown Host: " + iServerArray[i].getNode()));
                }
            }
        }
        if (bl && bl2) {
            n = 3;
        } else if (bl) {
            n = 2;
        } else if (bl2) {
            n = 1;
        }
        return n;
    }

    @Override
    public int getNodeCount() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        IServer[] iServerArray = this.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            if (treeMap.containsKey(iServerArray[i].getNode())) continue;
            treeMap.put(iServerArray[i].getNode(), iServerArray[i].getNode());
        }
        return treeMap.size();
    }

    @Override
    public String[] getNodeNames() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        IServer[] iServerArray = this.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            if (treeMap.containsKey(iServerArray[i].getNode())) continue;
            treeMap.put(iServerArray[i].getNode(), iServerArray[i].getNode());
        }
        Set set = treeMap.keySet();
        String[] stringArray = set.toArray(new String[set.size()]);
        return stringArray;
    }

    @Override
    public void loadQuorum(Quorum quorum) throws QuorumException {
        if (quorum.isClusterDefined()) {
            QuorumCluster quorumCluster = new QuorumCluster();
            QuorumInstance[] quorumInstanceArray = quorum.loadQuorum(quorumCluster);
            super.loadQuorum(quorum, quorumCluster);
            this.maxInstances = new Integer(quorumCluster.getMaxInstances());
            log.debug((Object)("Entry - loadQuorum() maxInstances: " + this.maxInstances));
            this.masterDevice = quorumCluster.getMasterDevice();
            this.quorumDevice = quorum.getQuorumDevice();
            this.primaryInterconnect = quorumCluster.getPrimaryNetType();
            this.secondaryInterconnect = quorumCluster.getSecondaryNetType();
            QuorumStatus quorumStatus = quorum.getQuorumStatus();
            this.status = quorumStatus.getClusterStatus();
            QuorumInstance quorumInstance = null;
            if (this.servers == null) {
                this.servers = new TreeMap();
            }
            EntryServer entryServer = null;
            for (int i = 0; i < this.maxInstances; ++i) {
                Integer n = new Integer(i + 1);
                log.debug((Object)("Entry - loadQuorum() maxInstances: " + this.maxInstances));
                quorumInstance = quorumInstanceArray[i];
                if (quorumInstance == null) {
                    if (!this.servers.containsKey(n)) continue;
                    this.servers.remove(n);
                    continue;
                }
                if (!this.servers.containsKey(n)) {
                    entryServer = (EntryServer)ClusterConfigFactory.createServer(quorumInstance.getName());
                    entryServer.loadQuorum(quorum, quorumInstance);
                    this.servers.put(n, entryServer);
                    continue;
                }
                entryServer = (EntryServer)this.servers.get(n);
                entryServer.loadQuorum(quorum, quorumInstance);
            }
        } else {
            throw new QuorumException("");
        }
    }

    @Override
    public Properties getProperties() {
        Properties properties = super.getProperties();
        properties.put("ClusterName", this.name);
        properties.put("MaxInstances", this.maxInstances.toString());
        properties.put("QuorumDevice", this.quorumDevice);
        properties.put("PrimaryNetTtype", this.primaryInterconnect);
        properties.put("SecondaryNetTtype", this.secondaryInterconnect);
        properties.put("MasterDevice", this.masterDevice);
        return properties;
    }

    @Override
    public boolean isUpgradeCheck() {
        return this.isUpgradeCheck;
    }

    @Override
    public String getOldServerName() {
        return this.oldServerName;
    }

    @Override
    public void setUpgradeCheck(boolean bl) {
        this.isUpgradeCheck = bl;
    }

    @Override
    public void setOldServerName(String string) {
        this.oldServerName = string;
    }

    @Override
    public boolean areMultipleBackupServersPresent() {
        return this.multipleBackupServersPresent;
    }

    @Override
    public void setMultipleBackupServersPresent(boolean bl) {
        this.multipleBackupServersPresent = bl;
    }

    @Override
    public String getBackupServersPolicy() {
        return this.backupServersPolicy;
    }

    @Override
    public void setBackupServersPolicy(String string) {
        this.backupServersPolicy = string;
    }

    @Override
    public boolean isLDAPconfigured() {
        return this.usesLDAP;
    }

    @Override
    public void setLDAPConfigured(boolean bl) {
        this.usesLDAP = bl;
    }

    @Override
    public String getPCIDatabaseSize() {
        return this.pciDatabaseSize;
    }

    @Override
    public void setPCIDatabaseSize(String string) {
        this.pciDatabaseSize = string;
    }

    @Override
    public String getPCIDevice() {
        return this.pciDevice;
    }

    @Override
    public void setPCIDevice(String string) {
        this.pciDevice = string;
    }

    @Override
    public String getPCIDeviceSize() {
        return this.pciDeviceSize;
    }

    @Override
    public void setPCIDeviceSize(String string) {
        this.pciDeviceSize = string;
    }
}

