/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.config.impl;

import com.sybase.ase.sdcadmin.quorum.Quorum;
import com.sybase.ase.sdcadmin.quorum.QuorumBase;
import com.sybase.ase.sdcadmin.quorum.QuorumException;
import com.sybase.ase.sdcadmin.quorum.QuorumIdentifiers;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class EntryBase
implements ISdConstants {
    private static Log log = LogFactory.getLog(EntryBase.class);
    protected int status;
    protected String name;
    protected String configFile = null;
    protected String interfacesPath = null;
    protected Vector tracesflags = null;
    protected String addlRunParameters = null;
    protected String sybaseHome = null;
    protected String aseHome = null;
    protected String envShellPath = null;
    protected String oldSybaseHome = null;
    protected String oldASEHome = null;
    protected String oldOCSHome = null;
    protected String quorumUid;
    protected String masterUid;
    protected String configUid;
    protected String bootUid;
    protected String backupServerName = null;
    protected String backupServerLogFile = null;

    private EntryBase() {
    }

    public EntryBase(String string) {
        this.name = string;
    }

    public void addTracesflag(Integer n) {
        if (this.tracesflags == null) {
            this.tracesflags = new Vector();
        }
        this.tracesflags.add(n);
    }

    public void clearAllTracesflags() {
        this.tracesflags = null;
    }

    public String getAddlRunParameters() {
        return this.addlRunParameters;
    }

    public String getAseHome() {
        return this.aseHome;
    }

    public String getBootUid() {
        return this.bootUid;
    }

    public String getClusterConfigHome() {
        return this.configFile;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getConfigUid() {
        return this.configUid;
    }

    public String getEnvShellPath() {
        return this.envShellPath;
    }

    public String getInterfacesPath() {
        return this.interfacesPath;
    }

    public String getMasterUid() {
        return this.masterUid;
    }

    public String getName() {
        return this.name;
    }

    public String getQuorumUid() {
        return this.quorumUid;
    }

    public String getSybaseHome() {
        return this.sybaseHome;
    }

    public String getOldSybaseHome() {
        return this.oldSybaseHome;
    }

    public String getOldASEHome() {
        return this.oldASEHome;
    }

    public String getOldOCSHome() {
        return this.oldOCSHome;
    }

    public String getTraceflagsString() {
        String string = "";
        Enumeration enumeration = this.getTracesflags();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                if (string.equals("")) {
                    string = n.toString();
                    continue;
                }
                string = string + "," + n.toString();
            }
        }
        return string;
    }

    public Enumeration getTracesflags() {
        if (this.tracesflags == null) {
            return null;
        }
        return this.tracesflags.elements();
    }

    public void removeTracesflags(Integer n) {
        if (this.tracesflags != null && n != null) {
            if (this.tracesflags.contains(n)) {
                this.tracesflags.remove(n);
            }
            if (this.tracesflags.size() == 0) {
                this.tracesflags = null;
            }
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setAddlRunParameters(String string) {
        this.addlRunParameters = string;
    }

    public void setAseHome(String string) {
        this.aseHome = string;
    }

    public void setBootUid(String string) {
        this.bootUid = string;
    }

    public void setClusterConfigHome(String string) {
        this.configFile = string;
    }

    public void setConfigFile(String string) {
        this.configFile = string;
    }

    public void setConfigUid(String string) {
        this.configUid = string;
    }

    public void setEnvShellPath(String string) {
        this.envShellPath = string;
    }

    public void setInterfacesPath(String string) {
        this.interfacesPath = string;
    }

    public void setMasterUid(String string) {
        this.masterUid = string;
    }

    public void setQuorumUid(String string) {
        this.quorumUid = string;
    }

    public void setSybaseHome(String string) {
        this.sybaseHome = string;
    }

    public void setOldSybaseHome(String string) {
        this.oldSybaseHome = string;
    }

    public void setOldASEHome(String string) {
        int n = string.lastIndexOf("ASE-");
        this.oldASEHome = n >= 0 ? string.substring(n) : null;
    }

    public void setOldOCSHome(String string) {
        int n = string.lastIndexOf("OCS-");
        this.oldOCSHome = n >= 0 ? string.substring(n) : null;
    }

    public void loadQuorum(Quorum quorum, QuorumBase quorumBase) throws QuorumException {
        this.setTraceflags(quorumBase.getTraceflags());
        this.addlRunParameters = quorumBase.getAddlRunParameters();
        this.configFile = quorumBase.getConfigFile();
        this.interfacesPath = quorumBase.getInterfacesPath();
        QuorumIdentifiers quorumIdentifiers = quorumBase.getQuorumIdentifiers();
        if (quorumIdentifiers == null) {
            quorumIdentifiers = quorum.getQuorumIdentifers();
        }
        this.configUid = quorumIdentifiers.getConfigUid();
        this.bootUid = quorumIdentifiers.getBootUid();
        this.masterUid = quorumIdentifiers.getMasterUid();
        this.quorumUid = quorumIdentifiers.getQuorumUid();
    }

    public void setTraceflags(String string) {
        log.debug((Object)("Quorum Traceflags: " + string));
        this.clearAllTracesflags();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            log.debug((Object)("Traceflag: " + string2));
            Integer n = new Integer(string2);
            this.addTracesflag(n);
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.put("Name", this.name);
        properties.put("QuorumId", this.quorumUid);
        properties.put("BootId", this.bootUid);
        properties.put("MasterId", this.masterUid);
        properties.put("ConfigId", this.configUid);
        properties.put("InterfacePath", this.interfacesPath);
        properties.put("ConfigFile", this.configFile);
        properties.put("Traceflags", this.getTraceflagsString());
        properties.put("Status", String.valueOf(this.status));
        properties.put("RunParams", this.addlRunParameters);
        properties.put("SybaseHome", this.sybaseHome);
        properties.put("AseHome", this.aseHome);
        properties.put("EnvShellPath", this.envShellPath);
        return properties;
    }

    public String getBackupServerLogFile() {
        return this.backupServerLogFile;
    }

    public void setBackupServerLogFile(String string) {
        this.backupServerLogFile = string;
    }

    public String getBackupServerName() {
        return this.backupServerName;
    }

    public void setBackupServerName(String string) {
        this.backupServerName = string;
    }
}

