/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.config.impl;

import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.config.impl.EntryBase;
import com.sybase.ase.sdcadmin.quorum.Quorum;
import com.sybase.ase.sdcadmin.quorum.QuorumException;
import com.sybase.ase.sdcadmin.quorum.QuorumInstance;
import com.sybase.ase.sdcadmin.quorum.QuorumStatus;
import com.sybase.ase.sdcadmin.util.FileUtil;
import com.sybase.ase.sdcadmin.util.PortUtil;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntryServer
extends EntryBase
implements IServer,
Comparable {
    private static Log log = LogFactory.getLog(EntryServer.class);
    private Integer id;
    private String node;
    private String publicAddress;
    private String primaryAddress;
    private String primaryPortStart;
    private String secondaryAddress;
    private String secondaryPortStart;
    private String logFile;
    private String queryPort;
    private String queryTransport;
    private String agentPort;
    private String xpServerPort;
    private String tempdbDeviceName;
    private String tempdbDevicePath;
    private String tempdbDeviceSize;
    private String tempdbDbName;
    private String tempdbDbSize;
    private String tempdbDbPageSize;
    private String backupServerPort;
    private String monitorServerPort;
    private String monitorServerLogFile;
    public static final int STATE_NOTRUNNING = 0;
    public static final int STATE_RUNNING = 1;
    private int runState;

    private EntryServer() {
        super("");
    }

    public EntryServer(String string) {
        super(string);
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer n) {
        this.id = n;
    }

    public int compareTo(Object object) throws ClassCastException {
        int n = 0;
        if (this.getId() != null) {
            n = -1;
            EntryServer entryServer = (EntryServer)object;
            if (entryServer.getId() != null) {
                n = this.getId() - entryServer.getId();
            }
        }
        return n;
    }

    @Override
    public String getPrimaryAddress() {
        return this.primaryAddress;
    }

    @Override
    public void setPrimaryAddress(String string) {
        this.primaryAddress = string;
    }

    @Override
    public String getSecondaryAddress() {
        return this.secondaryAddress;
    }

    @Override
    public void setSecondaryAddress(String string) {
        this.secondaryAddress = string;
    }

    @Override
    public String getPrimaryProtocolStart() {
        return this.primaryPortStart;
    }

    @Override
    public void setSecondaryProtocolStart(String string) {
        this.secondaryPortStart = string;
    }

    @Override
    public String getSecondaryProtocolStart() {
        return this.secondaryPortStart;
    }

    @Override
    public void setPrimaryProtocolStart(String string) {
        this.primaryPortStart = string;
    }

    @Override
    public void logDebug() {
        try {
            log.debug((Object)("Cluster Instance[" + this.id + "] \"" + this.name + "\" Information:"));
            log.debug((Object)("\tNode:                        " + this.node));
            log.debug((Object)("\tQuery Port:                  " + this.queryPort));
            log.debug((Object)("\tQueryTransport:              " + this.queryTransport));
            log.debug((Object)("\tAgent Port:                  " + this.agentPort));
            log.debug((Object)("\tPrimary Address:             " + this.primaryAddress));
            log.debug((Object)("\tPrimary Protocol Start:      " + this.primaryPortStart));
            log.debug((Object)("\tSecondary Address:           " + this.secondaryAddress));
            log.debug((Object)("\tSecondary Protocol Start:    " + this.secondaryPortStart));
            log.debug((Object)FileUtil.removeControlCharacter("\tError Log File:              " + this.logFile));
            log.debug((Object)FileUtil.removeControlCharacter("\tTemporary Device Name:       " + this.tempdbDeviceName));
            log.debug((Object)FileUtil.removeControlCharacter("\tTemporary Device Path:       " + this.tempdbDevicePath));
            log.debug((Object)("\tTemporary Device Size:       " + this.tempdbDeviceSize));
            log.debug((Object)("\tTemporary Database Name:     " + this.tempdbDbName));
            log.debug((Object)("\tTemporary Database Size:     " + this.tempdbDbSize));
            log.debug((Object)("\tTemporary Database Page Size:" + this.tempdbDbPageSize));
            log.debug((Object)("\tAddl Run Parameters:         " + this.addlRunParameters));
        }
        catch (Exception exception) {
            log.debug((Object)exception);
        }
    }

    @Override
    public String getHost() {
        return this.node;
    }

    @Override
    public void setHost(String string) {
        this.node = string;
    }

    @Override
    public String getQueryPort() {
        return this.queryPort;
    }

    @Override
    public void setQueryPort(String string) {
        this.queryPort = string;
    }

    @Override
    public String getQueryTransport() {
        return this.queryTransport;
    }

    @Override
    public void setQueryTransport(String string) {
        this.queryTransport = string;
    }

    @Override
    public String getAgentPort() {
        return this.agentPort;
    }

    @Override
    public void setAgentPort(String string) {
        this.agentPort = string;
    }

    @Override
    public int getRunState() {
        return this.runState;
    }

    @Override
    public String getRunParameters() {
        return this.addlRunParameters;
    }

    @Override
    public String getErrorlogPath() {
        return this.logFile;
    }

    @Override
    public String getTempdbDbSize() {
        return this.tempdbDbSize;
    }

    @Override
    public String getTempdbDbPageSize() {
        return this.tempdbDbPageSize;
    }

    @Override
    public String getTempdbDevicePath() {
        return this.tempdbDevicePath;
    }

    @Override
    public String getTempdbDeviceSize() {
        return this.tempdbDeviceSize;
    }

    @Override
    public String getTempdbDbName() {
        return this.tempdbDbName;
    }

    @Override
    public String getTempdbDeviceName() {
        return this.tempdbDeviceName;
    }

    @Override
    public void setRunState(int n) {
        this.runState = n;
    }

    @Override
    public void setRunParameters(String string) {
        this.addlRunParameters = string;
    }

    @Override
    public void setErrorlogPath(String string) {
        this.logFile = string;
    }

    @Override
    public void setTempdbDbSize(String string) {
        this.tempdbDbSize = string;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void setTempdbDbPageSize(String string) {
        this.tempdbDbPageSize = string;
    }

    @Override
    public void setTempdbDevicePath(String string) {
        this.tempdbDevicePath = string;
    }

    @Override
    public void setTempdbDeviceSize(String string) {
        this.tempdbDeviceSize = string;
    }

    @Override
    public void setTempdbDbName(String string) {
        this.tempdbDbName = string;
    }

    @Override
    public void setTempdbDeviceName(String string) {
        this.tempdbDeviceName = string;
    }

    @Override
    public String getNode() {
        return this.node;
    }

    @Override
    public void setNode(String string) {
        this.node = string;
    }

    @Override
    public String getPrimaryPortStart() {
        return this.primaryPortStart;
    }

    @Override
    public void setPrimaryPortStart(String string) {
        this.primaryPortStart = string;
    }

    @Override
    public String getSecondaryPortStart() {
        return this.secondaryPortStart;
    }

    @Override
    public void setSecondaryPortStart(String string) {
        this.secondaryPortStart = string;
    }

    @Override
    public String getLogFile() {
        return this.logFile;
    }

    @Override
    public void setLogFile(String string) {
        this.logFile = string;
    }

    @Override
    public String getPrimaryProtocolEnd(int n) {
        return this.getPrimaryProtocolEnd(new Integer(n));
    }

    @Override
    public String getPrimaryProtocolEnd(Integer n) {
        return String.valueOf(PortUtil.calculatePortEnd(n, this.primaryPortStart));
    }

    @Override
    public String getSecondaryProtocolEnd(int n) {
        return this.getSecondaryProtocolEnd(new Integer(n));
    }

    @Override
    public String getSecondaryProtocolEnd(Integer n) {
        return String.valueOf(PortUtil.calculatePortEnd(n, this.secondaryPortStart));
    }

    @Override
    public void loadQuorum(Quorum quorum) throws QuorumException {
        int n = quorum.getInstanceId(this.name);
        QuorumInstance quorumInstance = quorum.getQuorumInstance(n);
        this.loadQuorum(quorum, quorumInstance);
    }

    public void loadQuorum(Quorum quorum, QuorumInstance quorumInstance) throws QuorumException {
        super.loadQuorum(quorum, quorumInstance);
        this.id = new Integer(quorumInstance.getInstanceId());
        this.node = quorumInstance.getInstanceNode();
        this.primaryAddress = quorumInstance.getPrimaryAddress();
        this.primaryPortStart = quorumInstance.getPrimaryPortStart();
        this.secondaryAddress = quorumInstance.getSecondaryAddress();
        this.secondaryPortStart = quorumInstance.getSecondaryPortStart();
        this.logFile = quorumInstance.getLogFile();
        QuorumStatus quorumStatus = quorum.getQuorumStatus();
        this.status = quorumStatus.getInstanceStatus()[this.id - 1];
    }

    @Override
    public Properties getProperties() {
        Properties properties = super.getProperties();
        properties.put("InstanceName", this.name);
        properties.put("NodeName", this.node);
        properties.put("PublicNetAddr", this.publicAddress);
        properties.put("QueryPort", this.queryPort);
        properties.put("InstanceId", this.id);
        properties.put("ASELogFile", this.logFile);
        properties.put("PrimaryNetAddr", this.primaryAddress);
        properties.put("SecondaryNetAddr", this.secondaryAddress);
        properties.put("PrimaryPortStart", this.primaryPortStart);
        properties.put("SecondaryPortStart", this.secondaryPortStart);
        properties.put("QueryTransport", this.queryTransport);
        properties.put("AgentPort", this.agentPort);
        properties.put("TempdbDeviceName", this.tempdbDeviceName);
        properties.put("TempdbDevicePath", this.tempdbDevicePath);
        properties.put("TempdbDeviceSize", this.tempdbDeviceSize);
        properties.put("TempdbDbName", this.tempdbDbName);
        properties.put("TempdbDbSize", this.tempdbDbSize);
        return properties;
    }

    @Override
    public String getPublicAddress() {
        return this.publicAddress;
    }

    @Override
    public void setPublicAddress(String string) {
        this.publicAddress = string;
    }

    @Override
    public String getBackupServerPort() {
        return this.backupServerPort;
    }

    @Override
    public void setBackupServerPort(String string) {
        this.backupServerPort = string;
    }

    @Override
    public String getXpServerPort() {
        return this.xpServerPort;
    }

    @Override
    public void setXpServerPort(String string) {
        this.xpServerPort = string;
    }

    @Override
    public String getMonitorServerPort() {
        return this.monitorServerPort;
    }

    @Override
    public void setMonitorServerPort(String string) {
        this.monitorServerPort = string;
    }

    @Override
    public String getMonitorServerLogFile() {
        return this.monitorServerLogFile;
    }

    @Override
    public void setMonitorServerLogFile(String string) {
        this.monitorServerLogFile = string;
    }
}

