/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.create;

import com.sybase.ase.sdcadmin.IConstants;
import com.sybase.ase.sdcadmin.config.ClusterConfigException;
import com.sybase.ase.sdcadmin.config.ClusterConfigFactory;
import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.create.SqlUpgradeRes;
import com.sybase.ase.sdcadmin.create.SrvBuildRes;
import com.sybase.ase.sdcadmin.create.SystemTemporaryDatabase;
import com.sybase.ase.sdcadmin.ex.SdClusterException;
import com.sybase.ase.sdcadmin.quorum.QuorumInputFile;
import com.sybase.ase.sdcadmin.sdk.SdClusterBase;
import com.sybase.ase.sdcadmin.util.EnvironmentVariables;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import com.sybase.ase.sdcadmin.util.InterfacesHelper;
import com.sybase.ase.sdcadmin.util.Message;
import com.sybase.ase.sdcadmin.util.PortUtil;
import com.sybase.ase.sdcadmin.util.XMLCluster;
import com.sybase.ua.util.jdom.JDomUtil;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ServerConfig
implements IConstants,
ISdConstants {
    private static Log log = LogFactory.getLog(ServerConfig.class);
    ResourceBundle resourceBundle = null;

    public ServerConfig() {
        this.resourceBundle = ResourceBundle.getBundle("com.sybase.ase.sdcadmin.lang.Res");
    }

    public ServerConfig(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public int create(String string, String string2, String string3, char[] cArray, Message message) throws SdClusterException {
        message.output(this.resourceBundle, "sdcadmin.create.serverconfig.processing.info", string);
        ICluster iCluster = this.convertXmlToICluster(message, string, string2);
        if (iCluster == null) {
            return -113;
        }
        message.output(this.resourceBundle, "sdcadmin.create.serverconfig.choose.create.server.info");
        IServer iServer = this.selectLocalInstance(message, iCluster);
        if (iServer == null) {
            return -112;
        }
        int n = this.validateConfiguration(message, iCluster, iServer);
        if (n != 0) {
            return n;
        }
        return this.createFirstClusterInstance(message, iCluster, iServer, string3, cArray);
    }

    public int upgrade(String string, String string2, String string3, String string4, String string5, Message message) throws SdClusterException {
        message.output(this.resourceBundle, "sdcadmin.upgrade.serverconfig.processing.info", string, string2);
        ICluster iCluster = this.convertXmlToICluster(message, string2, string5);
        if (iCluster == null) {
            return -113;
        }
        message.output(this.resourceBundle, "sdcadmin.upgrade.serverconfig.choose.create.server.info");
        IServer iServer = this.selectLocalInstance(message, iCluster);
        if (iServer == null) {
            return -112;
        }
        int n = this.validateClusterConfigurationForUpgrade(message, iCluster, iServer);
        if (n != 0) {
            return n;
        }
        n = this.validateConfigurationForUpgrade(message, iCluster, iServer);
        if (n != 0) {
            return n;
        }
        int n2 = this.upgradeToSingleInstance(message, iCluster, iServer, string3, string4);
        return n2;
    }

    public int createFirstClusterInstance(Message message, ICluster iCluster, IServer iServer, String string, char[] cArray) {
        String string2 = "sa";
        String string3 = "";
        return this.createFirstClusterInstance(message, iCluster, iServer, string2, string3, string, cArray);
    }

    public int createFirstClusterInstance(Message message, ICluster iCluster, IServer iServer, String string, String string2, String string3, char[] cArray) {
        int n = 0;
        message.output(this.resourceBundle, "sdcadmin.create.serverconfig.firstserver.info", iServer.getName());
        String[] stringArray = null;
        File file = new File(iServer.getEnvShellPath());
        try {
            log.debug((Object)"Retrieving the environment variables");
            stringArray = EnvironmentVariables.retrieve(message, this.resourceBundle, "sh", file);
            if (stringArray.length == 0) {
                message.output(this.resourceBundle, "sdcadmin.create.serverconfig.env.retrieve.error", file.getAbsolutePath());
                return -103;
            }
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "sdcadmin.create.serverconfig.env.retrieve.error", file.getAbsolutePath());
            return -103;
        }
        if (string2 == null) {
            string2 = "";
        }
        log.debug((Object)"Creating the cluster input file.");
        File file2 = new File(iServer.getSybaseHome());
        File file3 = this.createClusterInputFile(message, iCluster.getName(), file2, iCluster);
        if (file3 == null) {
            return -108;
        }
        log.debug((Object)"Running srvbuildres.");
        log.debug((Object)("The Number of environment variables is " + stringArray.length));
        n = this.runSrvBuildRes(message, iCluster, iServer, string, string2, stringArray, file3);
        if (n != 0) {
            return n;
        }
        String string4 = SdClusterBase.getInterfacePath(iCluster);
        InterfacesHelper interfacesHelper = new InterfacesHelper(string4);
        log.debug((Object)"Update the interface file or LDAP.");
        try {
            interfacesHelper.deleteEntry(iServer.getName());
            interfacesHelper.addClusterEntry(iCluster);
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "sdcadmin.create.serverconfig.ds.error");
            log.error((Object)exception.getMessage());
            return -133;
        }
        if (iCluster.getInstallationMode().equals("private") && !iCluster.isLDAPconfigured()) {
            Object object;
            IServer[] iServerArray = iCluster.getServersArray();
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            for (int i = 0; i < iServerArray.length; ++i) {
                object = iServerArray[i].getName();
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("query:" + iServerArray[i].getNode() + ":" + iServerArray[i].getQueryPort() + ":0");
                arrayList.add("master:" + iServerArray[i].getNode() + ":" + iServerArray[i].getQueryPort() + ":0");
                hashMap.put(object, arrayList);
            }
            String string5 = iCluster.getName();
            object = new ArrayList();
            for (int i = 0; i < iServerArray.length; ++i) {
                object.add("query:" + iServerArray[i].getNode() + ":" + iServerArray[i].getQueryPort() + ":1");
            }
            hashMap.put(string5, object);
            InterfacesHelper.addToRemoteInterfaces(iCluster, hashMap, string3, cArray, string4);
        }
        if (n != 0) {
            return n;
        }
        n = this.postInstallTasks(message, iCluster, iServer, string, string2);
        if (n != 0) {
            return n;
        }
        log.debug((Object)"CreateCluster completed.");
        message.output(this.resourceBundle, "sdcadmin.create.cluster.successful", iCluster.getName());
        return n;
    }

    private int postInstallTasks(Message message, ICluster iCluster, IServer iServer, String string, String string2) {
        int n = 0;
        log.debug((Object)"Remove the run file.");
        File file = new File(iServer.getAseHome());
        n = this.removeRunFile(file, iServer.getName());
        if (n != 0) {
            return n;
        }
        log.debug((Object)"Connect to the newly created dataserver.");
        message.output(this.resourceBundle, "sdcadmin.jdbc.connect.info", iServer.getNode(), iServer.getQueryPort());
        Connection connection = null;
        try {
            connection = this.createConnection(message, iServer.getNode(), iServer.getQueryPort(), string, string2);
            if (connection == null) {
                return -107;
            }
        }
        catch (Exception exception) {
            String string3 = "Check log";
            message.output(this.resourceBundle, "sdcadmin.create.serverconfig.connection.error", string3);
            return -107;
        }
        log.debug((Object)"Create the temporary devices.");
        n = this.createTemporaryDevices(message, iCluster, iCluster.getServersArray(), connection);
        if (n != 0) {
            return n;
        }
        log.debug((Object)"Create the local temporary databases.");
        n = SystemTemporaryDatabase.createTemporaryDatabases(message, this.resourceBundle, iCluster, iCluster.getServersArray(), connection);
        if (n != 0) {
            return n;
        }
        log.debug((Object)"Shutting down the instance.");
        message.output(this.resourceBundle, "sdcadmin.first.instance.shutdown.info");
        n = this.shutdownInstance(message, connection, iServer.getName());
        if (n != 0) {
            return n;
        }
        return n;
    }

    private int runSrvBuildRes(Message message, ICluster iCluster, IServer iServer, String string, String string2, String[] stringArray, File file) {
        Properties properties = new Properties();
        properties.setProperty("BootDirectory", iServer.getSybaseHome());
        properties.setProperty("ReleaseDirectory", iServer.getSybaseHome());
        properties.setProperty("ServerName", iServer.getName());
        properties.setProperty("Login", string);
        properties.setProperty("Password", " ");
        properties.setProperty("HostNames", iServer.getNode());
        properties.setProperty("PortNumbers", iServer.getQueryPort());
        properties.setProperty("AddlBuildParameters", " --cluster_input=" + file.getAbsolutePath() + " --buildquorum=force " + " --create_cluster_id " + " --quorum_dev=" + iCluster.getQuorum());
        properties.setProperty("AddlCmdlineParameters", " --quorum_dev=" + iCluster.getQuorum());
        properties.setProperty("Protocols", iServer.getQueryTransport());
        properties.setProperty("ErrorLog", iServer.getLogFile());
        properties.setProperty("ServerPageSize", iCluster.getPageSize() + "k");
        properties.setProperty("MasterDevice", iCluster.getMasterDevice());
        properties.setProperty("MasterDeviceSize", iCluster.getMasterDeviceSize());
        properties.setProperty("MasterDatabaseSize", iCluster.getMasterDatabaseSize());
        properties.setProperty("SybsystemdbDevice", iCluster.getSystemDevice());
        properties.setProperty("SybsystemdbDeviceSize", iCluster.getSystemDeviceSize());
        properties.setProperty("SybsystemdbDatabaseSize", iCluster.getSystemDatabaseSize());
        properties.setProperty("SybsystemprocsDevice", iCluster.getSystemProcedureDevice());
        properties.setProperty("SybsystemprocsDeviceSize", iCluster.getSystemProcedureDeviceSize());
        properties.setProperty("SybsystemprocsDatabaseSize", iCluster.getSystemProcedureDatabaseSize());
        if (iCluster.getPCIDevice() != null) {
            properties.setProperty("PCIConfigured", "true");
            properties.setProperty("PCIDevice", iCluster.getPCIDevice());
            properties.setProperty("PCIDeviceSize", iCluster.getPCIDeviceSize());
            properties.setProperty("PCIDatabaseSize", iCluster.getPCIDatabaseSize());
        } else {
            properties.setProperty("PCIConfigured", "false");
        }
        properties.setProperty("SortOrder", this.resourceBundle.getString("srvbuildres.default.sort.order"));
        properties.setProperty("DefaultCharacterset", this.resourceBundle.getString("srvbuildres.default.characterset"));
        properties.setProperty("DefaultLanguage", this.resourceBundle.getString("srvbuildres.default.language"));
        properties.setProperty("Charset", this.resourceBundle.getString("srvbuildres.default.characterset"));
        properties.setProperty("Language", this.resourceBundle.getString("srvbuildres.default.language"));
        properties.setProperty("Product", this.resourceBundle.getString("srvbuildres.default.product"));
        SrvBuildRes srvBuildRes = new SrvBuildRes();
        srvBuildRes.loadFromProperties(properties);
        try {
            srvBuildRes.run(message, this.resourceBundle, iServer.getSybaseHome(), iServer.getAseHome(), iServer.getInterfacesPath(), stringArray);
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "srvbuildres.run.exception.error", exception.getMessage());
            return -104;
        }
        return 0;
    }

    private int runSqlUpgradeRes(Message message, ICluster iCluster, IServer iServer, String string, String string2, String[] stringArray, File file) {
        Properties properties = new Properties();
        properties.setProperty("sybinit.release_directory", iCluster.getOldSybaseHome());
        properties.setProperty("sybinit.product", "sqlsrv");
        properties.setProperty("sqlsrv.server_name", iCluster.getOldServerName());
        properties.setProperty("sqlsrv.new_config", "no");
        properties.setProperty("sqlsrv.sa_login", string);
        properties.setProperty("sqlsrv.sa_password", string2);
        properties.setProperty("sqlsrv.do_reserved_word_check", "yes");
        properties.setProperty("sqlsrv.do_upgrade", iCluster.isUpgradeCheck() ? "no" : "yes");
        if (!iCluster.isUpgradeCheck()) {
            properties.setProperty("sqlsrv.quorum_device", iCluster.getQuorum());
            properties.setProperty("sqlsrv.cluster_input_file", file.getAbsolutePath());
            properties.setProperty("sqlsrv.first_instance_name", iServer.getName());
            properties.setProperty("sqlsrv.cluster_config_file", iCluster.getConfigFile());
        }
        SqlUpgradeRes sqlUpgradeRes = new SqlUpgradeRes(iCluster.getOldServerName(), properties);
        try {
            sqlUpgradeRes.run(message, this.resourceBundle, iServer.getSybaseHome(), iServer.getAseHome(), iServer.getInterfacesPath(), stringArray);
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "sqlupgraderes.run.exception.error", exception.getMessage());
            try {
                InterfacesHelper interfacesHelper = new InterfacesHelper(SdClusterBase.getInterfacePath(iCluster));
                interfacesHelper.deleteEntry(iCluster.getOldServerName());
            }
            catch (Exception exception2) {
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", "ServerConfig", iCluster.getName(), iCluster.getName(), exception.getMessage());
            }
            return -139;
        }
        return 0;
    }

    public int upgradeToSingleInstance(Message message, ICluster iCluster, IServer iServer, String string, String string2) {
        int n = 0;
        String string3 = "sa";
        String string4 = "";
        String[] stringArray = null;
        File file = new File(iServer.getEnvShellPath());
        try {
            log.debug((Object)"Retrieving the environment variables");
            stringArray = EnvironmentVariables.retrieve(message, this.resourceBundle, "sh", file);
            if (stringArray.length == 0) {
                message.output(this.resourceBundle, "sdcadmin.create.serverconfig.env.retrieve.error", file.getAbsolutePath());
                return -103;
            }
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "sdcadmin.create.serverconfig.env.retrieve.error", file.getAbsolutePath());
            return -103;
        }
        if (string2 == null) {
            string2 = "";
        }
        log.debug((Object)"Creating the cluster input file.");
        File file2 = new File(iServer.getSybaseHome());
        File file3 = this.createClusterInputFile(message, iCluster.getName(), file2, iCluster);
        if (file3 == null) {
            return -108;
        }
        String[] stringArray2 = new String[stringArray.length + 3];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[i++] = "OLDSYBASE=" + iCluster.getOldSybaseHome();
        stringArray2[i++] = "OLDSYBASE_ASE=" + iCluster.getOldASEHome();
        stringArray2[i++] = "OLDSYBASE_OCS=" + iCluster.getOldOCSHome();
        stringArray = stringArray2;
        log.debug((Object)"Running sqlupgraderes.");
        log.debug((Object)("The Number of environment variables is " + stringArray.length));
        n = this.runSqlUpgradeRes(message, iCluster, iServer, string, string2, stringArray, file3);
        if (n != 0) {
            return n;
        }
        if (iCluster.isUpgradeCheck()) {
            message.output(this.resourceBundle, "sdcadmin.upgrade.check.successful", iCluster.getOldServerName());
        } else {
            message.output(this.resourceBundle, "sdcadmin.upgrade.proceeding", iCluster.getOldServerName(), iCluster.getName());
            log.debug((Object)"Performing post-install tasks.");
            n = this.postInstallTasks(message, iCluster, iServer, string3, string4);
            if (n != 0) {
                return n;
            }
            log.debug((Object)"UpgradeServer completed.");
            message.output(this.resourceBundle, "sdcadmin.upgrade.server.successful", iCluster.getOldServerName(), iCluster.getName());
        }
        return n;
    }

    private int removeRunFile(File file, String string) {
        File file2 = new File(file, "install");
        File file3 = new File(file2, "RUN_" + string);
        if (file3.exists()) {
            file3.delete();
        }
        return 0;
    }

    private Connection createConnection(Message message, String string, String string2, String string3, String string4) throws SdClusterException, SQLException {
        String string5 = "jdbc:sybase:Tds:" + string + ":" + string2;
        Properties properties = new Properties();
        properties.put("user", string3);
        properties.put("password", string4);
        properties.put("applicationname", "SDCAdmin_ServerConfig");
        properties.put("LANGUAGE", this.resourceBundle.getString("srvbuildres.default.language"));
        properties.put("CHARSET", this.resourceBundle.getString("srvbuildres.default.characterset"));
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(string5, properties);
        }
        catch (SQLException sQLException) {
            message.output(this.resourceBundle, "sdcadmin.create.serverconfig.connect.error", string5, sQLException.getMessage());
        }
        try {
            if (connection.getAutoCommit()) {
                connection.setAutoCommit(false);
            }
        }
        catch (SQLException sQLException) {
            message.output(this.resourceBundle, "sdcadmin.sql.autocommit.error", sQLException.getMessage());
            connection.close();
            return null;
        }
        return connection;
    }

    private int shutdownInstance(Message message, Connection connection, String string) {
        try {
            String string2 = "shutdown " + string;
            Statement statement = connection.createStatement();
            statement.execute(string2);
            statement.close();
            connection.close();
            message.output(this.resourceBundle, "sdcadmin.create.shutdown.error");
            return -1;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private int createTemporaryDevices(Message message, ICluster iCluster, IServer[] iServerArray, Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("master", "master");
        hashMap.put("sysprocsdev", "sysprocsdev");
        hashMap.put("systemdbdev", "systemdbdev");
        hashMap.put("pci", "pci");
        Statement statement = null;
        try {
            statement = connection.createStatement();
        }
        catch (SQLException sQLException) {
            message.output(this.resourceBundle, "com.sybase.ase.cluster.instance.statement.error", sQLException.getMessage());
            return -123;
        }
        for (int i = 0; i < iServerArray.length; ++i) {
            String string = iServerArray[i].getTempdbDeviceName().trim();
            if (string.equals(iCluster.getMasterDevice()) || hashMap.containsKey(string)) continue;
            hashMap.put(string, string);
            String string2 = iServerArray[i].getTempdbDevicePath().trim();
            String string3 = iServerArray[i].getTempdbDeviceSize().trim();
            if ("0123456789".indexOf(string3.charAt(string3.length() - 1)) >= 0) {
                string3 = string3 + "M";
            }
            message.output(this.resourceBundle, "sdcadmin.temporary.device.creation.info", string, string2, string3);
            String string4 = "disk init name='" + string + "',physname='" + string2 + "',size='" + string3 + "'";
            try {
                statement.executeUpdate(string4);
                continue;
            }
            catch (SQLException sQLException) {
                message.output(this.resourceBundle, "com.sybase.ase.cluster.instance.tempdev.error", sQLException.getMessage(), string);
                return -124;
            }
        }
        try {
            connection.commit();
            statement.close();
        }
        catch (SQLException sQLException) {
            message.output(this.resourceBundle, "com.sybase.ase.cluster.instance.statement.error", sQLException.getMessage());
            return -125;
        }
        return 0;
    }

    private File createClusterInputFile(Message message, String string, File file, ICluster iCluster) {
        File file2 = null;
        try {
            QuorumInputFile quorumInputFile = new QuorumInputFile();
            file2 = quorumInputFile.writeTemporaryFile(iCluster, file);
            message.output(this.resourceBundle, "sdcadmin.cluster.input.file.name.debug", file2.getAbsolutePath());
            log.debug((Object)("ServerConfig.createClusterConfigFile - created as " + file2.getAbsolutePath()));
        }
        catch (Exception exception) {
            log.debug((Object)exception);
            message.output(this.resourceBundle, "sdcadmin.create.cluster.resource.file", file2.getAbsolutePath(), exception.getMessage());
            return null;
        }
        log.debug((Object)("ServerConfig.createClusterConfigFile - completed writing the cluster config file." + file2.getAbsolutePath()));
        return file2;
    }

    public ICluster convertXmlToICluster(Message message, String string, String string2) throws SdClusterException {
        log.debug((Object)("ServerConfig: Unpack the data for " + string + " using the XML: " + string2));
        ICluster iCluster = null;
        try {
            StringReader stringReader;
            SAXBuilder sAXBuilder = null;
            Document document = null;
            try {
                sAXBuilder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", false);
                stringReader = new StringReader(string2);
                document = sAXBuilder.build((Reader)stringReader);
                stringReader.close();
            }
            catch (JDOMException jDOMException) {
                throw new SdClusterException(jDOMException.getMessage());
            }
            stringReader = document.getRootElement();
            iCluster = ClusterConfigFactory.createCluster(string);
            iCluster = XMLCluster.getCluster(iCluster, (Element)stringReader);
        }
        catch (ClusterConfigException clusterConfigException) {
            message.output(this.resourceBundle, "com.sybase.ase.cluster.xml.format.error", clusterConfigException.getMessage());
            throw new SdClusterException("The create cluster configuration XML is improperly formated.");
        }
        catch (IOException iOException) {
            message.output(this.resourceBundle, "com.sybase.ase.cluster.xml.io.error", iOException.getMessage());
            throw new SdClusterException("An IO error occured while reading the cluster configuration XML string.  Check the UAF log for more details");
        }
        return iCluster;
    }

    public String convertIClusterToXml(Message message, ICluster iCluster) {
        String string;
        block2: {
            string = null;
            try {
                Element element = XMLCluster.getElement(iCluster);
                string = JDomUtil.toString((Element)element);
            }
            catch (Exception exception) {
                log.error((Object)"The cluster entry element could not be converted to a string.");
                if (!log.isDebugEnabled()) break block2;
                System.out.println(exception);
                log.debug((Object)exception, (Throwable)exception);
            }
        }
        return string;
    }

    private IServer selectLocalInstance(Message message, ICluster iCluster) throws SdClusterException {
        IServer iServer = null;
        IServer[] iServerArray = iCluster.getServersArray();
        int n = -1;
        for (int i = 0; i < iServerArray.length; ++i) {
            String string = iServerArray[i].getNode();
            if (!PortUtil.isThisHost(string)) continue;
            n = i;
            break;
        }
        if (n != -1) {
            iServer = iServerArray[n];
        }
        return iServer;
    }

    public int validateConfiguration(Message message, ICluster iCluster, IServer iServer) {
        log.debug((Object)"Checking the devices.");
        int n = this.validateDevice(message, iCluster.getQuorum());
        if (n != 0) {
            return n;
        }
        n = this.validateDevice(message, iCluster.getMasterDevice());
        if (n != 0) {
            return n;
        }
        n = this.validateDevice(message, iCluster.getSystemProcedureDevice());
        if (n != 0) {
            return n;
        }
        n = this.validateDevice(message, iCluster.getSystemDevice());
        if (n != 0) {
            return n;
        }
        if (iCluster.getPCIDevice() != null && (n = this.validateDevice(message, iCluster.getPCIDevice())) != 0) {
            return n;
        }
        IServer[] iServerArray = iCluster.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            n = this.validateDevice(message, iServerArray[i].getTempdbDevicePath());
            if (n == 0) continue;
            return n;
        }
        return this.validateInstallation(message, iCluster, iServer);
    }

    private int validateInstallation(Message message, ICluster iCluster, IServer iServer) {
        Object object;
        Object object2;
        InterfacesHelper interfacesHelper = null;
        int n = 0;
        if (!iCluster.isLDAPconfigured()) {
            log.debug((Object)"Checking the interfaces file");
            object2 = SdClusterBase.getInterfacePath(iCluster);
            File file = new File((String)object2);
            if (file == null || file.equals("")) {
                message.output(this.resourceBundle, "sdcadmin.interfacepath.notset.error");
                return -105;
            }
            if (!(file.isDirectory() && file.exists() && file.canRead() && file.canWrite())) {
                message.output(this.resourceBundle, "sdcadmin.create.serverconfig.interfaces.path.error", file.getAbsolutePath());
                return -114;
            }
            n = this.createIfNotExists(message, (String)object2);
            if (n != 0) {
                return n;
            }
            interfacesHelper = new InterfacesHelper((String)object2);
            log.debug((Object)"Checking the interface file to see if there are already entries.");
        } else {
            interfacesHelper = new InterfacesHelper(null);
        }
        try {
            if (interfacesHelper.entryExists(iCluster.getName())) {
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.interfaces.instance.entry.exists.error", iCluster.getName());
                return -126;
            }
            object2 = iCluster.getServersArray();
            for (int i = 0; i < ((IServer[])object2).length; ++i) {
                object = object2[i].getName();
                if (!interfacesHelper.entryExists((String)object)) continue;
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.interfaces.instance.entry.exists.error", object);
                return -126;
            }
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "sdcadmin.create.serverconfig.ds.error");
            log.error((Object)exception.getMessage());
            return -133;
        }
        log.debug((Object)"Checking the Sybase Home directory.");
        object2 = new File(iServer.getSybaseHome());
        if (!(((File)object2).isDirectory() && ((File)object2).exists() && ((File)object2).canRead() && ((File)object2).canWrite())) {
            message.output(this.resourceBundle, "sdcadmin.create.serverconfig.sybase.home.error", ((File)object2).getAbsolutePath());
            return -100;
        }
        message.output(this.resourceBundle, "sdcadmin.create.serverconfig.sybase.home.info", ((File)object2).getAbsolutePath());
        log.debug((Object)"Checking the ASE Home directory.");
        File file = new File(iServer.getAseHome());
        if (!(file.isDirectory() && file.exists() && file.canRead() && file.canWrite())) {
            message.output(this.resourceBundle, "sdcadmin.create.serverconfig.ase.home.error", file.getAbsolutePath());
            return -101;
        }
        message.output(this.resourceBundle, "sdcadmin.create.serverconfig.ase.home.info", file.getAbsolutePath());
        log.debug((Object)"Checking the Environment Variables path.");
        object = new File(iServer.getEnvShellPath());
        if (!(((File)object).isFile() && ((File)object).exists() && ((File)object).canRead())) {
            message.output(this.resourceBundle, "sdcadmin.create.serverconfig.env.file.error", ((File)object).getAbsolutePath());
            return -102;
        }
        message.output(this.resourceBundle, "sdcadmin.create.serverconfig.env.file.info", ((File)object).getAbsolutePath());
        return 0;
    }

    public int validateConfigurationForUpgrade(Message message, ICluster iCluster, IServer iServer) {
        log.debug((Object)"Checking upgrade parameters.");
        log.debug((Object)"Checking the Old Sybase Home directory.");
        File file = new File(iCluster.getOldSybaseHome());
        if (!(file.isDirectory() && file.exists() && file.canRead())) {
            message.output(this.resourceBundle, "sdcadmin.upgrade.serverconfig.old.sybase.home.error", file.getAbsolutePath());
            return -136;
        }
        message.output(this.resourceBundle, "sdcadmin.upgrade.serverconfig.old.sybase.home.info", file.getAbsolutePath());
        log.debug((Object)"Checking the ASE Home directory.");
        File file2 = new File(iCluster.getOldSybaseHome() + File.separator + iCluster.getOldASEHome());
        if (!(file2.isDirectory() && file2.exists() && file2.canRead())) {
            message.output(this.resourceBundle, "sdcadmin.upgrade.serverconfig.old.ase.home.error", file2.getAbsolutePath());
            return -137;
        }
        message.output(this.resourceBundle, "sdcadmin.upgrade.serverconfig.old.ase.home.info", file2.getAbsolutePath());
        log.debug((Object)"Checking the OCS Home directory.");
        File file3 = new File(iCluster.getOldSybaseHome() + File.separator + iCluster.getOldOCSHome());
        if (!(file3.isDirectory() && file3.exists() && file3.canRead())) {
            message.output(this.resourceBundle, "sdcadmin.upgrade.serverconfig.old.ocs.home.error", file3.getAbsolutePath());
            return -138;
        }
        message.output(this.resourceBundle, "sdcadmin.upgrade.serverconfig.old.ocs.home.info", file3.getAbsolutePath());
        return 0;
    }

    public int validateClusterConfigurationForUpgrade(Message message, ICluster iCluster, IServer iServer) {
        log.debug((Object)"Checking the devices.");
        int n = this.validateDevice(message, iCluster.getQuorum());
        if (n != 0) {
            return n;
        }
        IServer[] iServerArray = iCluster.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            boolean bl = iServerArray[i].getTempdbDevicePath().equals(iCluster.getMasterDevice());
            n = this.validateDevice(message, iServerArray[i].getTempdbDevicePath(), bl);
            if (n == 0) continue;
            return n;
        }
        return this.validateInstallation(message, iCluster, iServer);
    }

    private int validateDevice(Message message, String string) {
        return this.validateDevice(message, string, false);
    }

    private int validateDevice(Message message, String string, boolean bl) {
        File file = new File(string);
        if (file.exists()) {
            if (file.isFile() && !bl) {
                message.output(this.resourceBundle, "sdcadmin.device.exists.error", file.getAbsolutePath());
                return -127;
            }
            if (file.isDirectory()) {
                message.output(this.resourceBundle, "sdcadmin.device.directory.error", file.getAbsolutePath());
                return -128;
            }
            log.debug((Object)("Device: " + file.getAbsolutePath() + " is a raw device."));
            if (!file.canRead() || !file.canWrite()) {
                message.output(this.resourceBundle, "sdcadmin.device.access.error", file.getAbsolutePath());
                return -129;
            }
        } else {
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                message.output(this.resourceBundle, "sdcadmin.device.parent.missing.error", file2.getAbsolutePath());
                return -130;
            }
            if (!file2.canWrite() || !file2.canRead()) {
                message.output(this.resourceBundle, "sdcadmin.device.parent.access.error", file2.getAbsolutePath());
                return -131;
            }
            log.debug((Object)("Device: " + file.getAbsolutePath() + " is a regular file."));
        }
        return 0;
    }

    private int createIfNotExists(Message message, String string) {
        String string2 = InterfacesHelper.getInterfacePathspec(string);
        File file = new File(string2);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                message.output(this.resourceBundle, "sdcadmin.create.serverconfig.interface.create.error", file.getPath());
                return -132;
            }
        }
        if (!file.exists() || file.isDirectory() || !file.canRead() || !file.canWrite()) {
            message.output(this.resourceBundle, "sdcadmin.interfacepath.access.error", file.getPath());
            return -106;
        }
        return 0;
    }
}

