/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.create;

import com.sybase.ase.sdcadmin.IConstants;
import com.sybase.ase.sdcadmin.util.Message;
import com.sybase.ase.sdcadmin.util.ShellCommand;
import java.io.File;
import java.io.FileWriter;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SrvBuildRes
implements IConstants {
    private static Log log = LogFactory.getLog(SrvBuildRes.class);
    private String bootDirectory = null;
    private String releaseDirectory = null;
    private Boolean doAddServerToInterfaceFile = null;
    private String networkHostnameList = null;
    private String networkPortList = null;
    private String networkProtocolList = null;
    private Boolean newConfig = null;
    private String addlBuildParameters = null;
    private String addlCmdlineParameters = null;
    private String serverName = null;
    private char[] saPassword = null;
    private String saLogin = null;
    private String serverPageSize = null;
    private Boolean forceBuildMaster = null;
    private String masterDevicePhysicalName = null;
    private Integer masterDeviceSize = null;
    private Integer masterDatabaseSize = null;
    private Boolean pciConfigured = null;
    private String pciDevicePhysicalName = null;
    private Integer pciDeviceSize = null;
    private Integer pciDatabaseSize = null;
    private String sybsystemprocsDevicePhysicalName = null;
    private Integer sybsystemprocsDeviceSize = null;
    private Integer sybsystemprocsDatabaseSize = null;
    private String sybsystemdbDevicePhysicalName = null;
    private Integer sybsystemdbDeviceSize = null;
    private Integer sybsystemdbDatabaseSize = null;
    private String errorlog = null;
    private String sortOrder = null;
    private String defaultCharacterset = null;
    private String defaultLanguage = null;
    private Boolean doUpgrade = null;
    private String charset = null;
    private String language = null;
    private String product = null;
    private String defaultBackupServer = null;

    public void loadFromProperties(Properties properties) throws NumberFormatException {
        this.newConfig = new Boolean(true);
        this.doAddServerToInterfaceFile = new Boolean(true);
        this.forceBuildMaster = new Boolean(true);
        this.doUpgrade = new Boolean(false);
        this.bootDirectory = properties.getProperty("BootDirectory");
        this.releaseDirectory = properties.getProperty("ReleaseDirectory");
        this.serverName = properties.getProperty("ServerName");
        this.saLogin = properties.getProperty("Login");
        this.saPassword = properties.getProperty("Password").toCharArray();
        this.networkHostnameList = properties.getProperty("HostNames");
        this.networkPortList = properties.getProperty("PortNumbers");
        this.networkProtocolList = properties.getProperty("Protocols");
        this.addlBuildParameters = properties.getProperty("AddlBuildParameters");
        this.addlCmdlineParameters = properties.getProperty("AddlCmdlineParameters");
        this.serverPageSize = properties.getProperty("ServerPageSize");
        this.masterDevicePhysicalName = properties.getProperty("MasterDevice");
        this.masterDeviceSize = this.getIntegerProp(properties, "MasterDeviceSize");
        this.masterDatabaseSize = this.getIntegerProp(properties, "MasterDatabaseSize");
        this.sybsystemdbDevicePhysicalName = properties.getProperty("SybsystemdbDevice");
        this.sybsystemdbDeviceSize = this.getIntegerProp(properties, "SybsystemdbDeviceSize");
        this.sybsystemdbDatabaseSize = this.getIntegerProp(properties, "SybsystemdbDatabaseSize");
        this.sybsystemprocsDevicePhysicalName = properties.getProperty("SybsystemprocsDevice");
        this.sybsystemprocsDeviceSize = this.getIntegerProp(properties, "SybsystemprocsDeviceSize");
        this.sybsystemprocsDatabaseSize = this.getIntegerProp(properties, "SybsystemprocsDatabaseSize");
        this.pciConfigured = this.getBooleanProp(properties, "PCIConfigured");
        if (this.pciConfigured != null && this.pciConfigured.booleanValue()) {
            this.pciDevicePhysicalName = properties.getProperty("PCIDevice");
            this.pciDeviceSize = this.getIntegerProp(properties, "PCIDeviceSize");
            this.pciDatabaseSize = this.getIntegerProp(properties, "PCIDatabaseSize");
        }
        this.errorlog = properties.getProperty("ErrorLog");
        this.sortOrder = properties.getProperty("SortOrder");
        this.defaultCharacterset = properties.getProperty("DefaultCharacterset");
        this.defaultLanguage = properties.getProperty("DefaultLanguage");
        this.charset = properties.getProperty("Charset");
        this.language = properties.getProperty("Language");
        this.product = properties.getProperty("Product");
    }

    private Integer getIntegerProp(Properties properties, String string) throws NumberFormatException {
        String string2 = properties.getProperty(string);
        if (string2 == null || string2.equals("")) {
            return null;
        }
        log.debug((Object)("getIntegerProp: " + string + " Value: " + string2));
        return Integer.valueOf(string2);
    }

    private Boolean getBooleanProp(Properties properties, String string) throws NumberFormatException {
        String string2 = properties.getProperty(string);
        if (string2 == null || string2.equals("")) {
            return null;
        }
        log.debug((Object)("getBooleanProp: " + string + " Value: " + string2));
        return Boolean.valueOf(string2);
    }

    public String generateConfig() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bootDirectory != null && !this.bootDirectory.equals("")) {
            stringBuffer.append("sybinit.boot_directory: " + this.bootDirectory + "\n");
        }
        if (this.releaseDirectory != null && !this.releaseDirectory.equals("")) {
            stringBuffer.append("sybinit.release_directory: " + this.releaseDirectory + "\n");
        }
        if (this.doAddServerToInterfaceFile != null) {
            stringBuffer.append("sqlsrv.do_add_server: " + (this.doAddServerToInterfaceFile != false ? "yes" : "no") + "\n");
        }
        if (this.networkHostnameList != null && !this.networkHostnameList.equals("")) {
            stringBuffer.append("sqlsrv.network_hostname_list: " + this.networkHostnameList + "\n");
        }
        if (this.networkPortList != null && !this.networkPortList.equals("")) {
            stringBuffer.append("sqlsrv.network_port_list: " + this.networkPortList + "\n");
        }
        if (this.networkProtocolList != null && !this.networkProtocolList.equals("")) {
            stringBuffer.append("sqlsrv.network_protocol_list: " + this.networkProtocolList + "\n");
        }
        if (this.newConfig != null) {
            stringBuffer.append("sqlsrv.new_config: " + (this.newConfig != false ? "yes" : "no") + "\n");
        }
        if (this.addlBuildParameters != null && !this.addlBuildParameters.equals("")) {
            stringBuffer.append("sqlsrv.addl_build_parameters: " + this.addlBuildParameters + "\n");
        }
        if (this.addlCmdlineParameters != null && !this.addlCmdlineParameters.equals("")) {
            stringBuffer.append("sqlsrv.addl_cmdline_parameters: " + this.addlCmdlineParameters + "\n");
        }
        if (this.serverName != null && !this.serverName.equals("")) {
            stringBuffer.append("sqlsrv.server_name: " + this.serverName + "\n");
        }
        if (this.saPassword != null) {
            stringBuffer.append("sqlsrv.sa_password: " + new String(this.saPassword) + "\n");
        }
        if (this.saLogin != null && !this.saLogin.equals("")) {
            stringBuffer.append("sqlsrv.sa_login: " + this.saLogin + "\n");
        }
        if (this.serverPageSize != null && !this.serverPageSize.equals("")) {
            stringBuffer.append("sqlsrv.server_page_size: " + this.serverPageSize + "\n");
        }
        if (this.forceBuildMaster != null) {
            stringBuffer.append("sqlsrv.force_buildmaster: " + (this.forceBuildMaster != false ? "yes" : "no") + "\n");
        }
        if (this.masterDevicePhysicalName != null && !this.masterDevicePhysicalName.equals("")) {
            stringBuffer.append("sqlsrv.master_device_physical_name: " + this.masterDevicePhysicalName + "\n");
        }
        if (this.masterDeviceSize != null && !this.masterDeviceSize.equals("")) {
            stringBuffer.append("sqlsrv.master_device_size: " + this.masterDeviceSize + "\n");
        }
        if (this.masterDatabaseSize != null && this.masterDatabaseSize != 0) {
            stringBuffer.append("sqlsrv.master_database_size: " + this.masterDatabaseSize + "\n");
        }
        if (this.sybsystemprocsDevicePhysicalName != null && !this.sybsystemprocsDevicePhysicalName.equals("")) {
            stringBuffer.append("sqlsrv.sybsystemprocs_device_physical_name: " + this.sybsystemprocsDevicePhysicalName + "\n");
        }
        if (this.sybsystemprocsDeviceSize != null && this.sybsystemprocsDeviceSize != 0) {
            stringBuffer.append("sqlsrv.sybsystemprocs_device_size: " + this.sybsystemprocsDeviceSize + "\n");
        }
        if (this.sybsystemprocsDatabaseSize != null && this.sybsystemprocsDatabaseSize != 0) {
            stringBuffer.append("sqlsrv.sybsystemprocs_database_size: " + this.sybsystemprocsDatabaseSize + "\n");
        }
        if (this.sybsystemdbDevicePhysicalName != null && !this.sybsystemdbDevicePhysicalName.equals("")) {
            stringBuffer.append("sqlsrv.sybsystemdb_device_physical_name: " + this.sybsystemdbDevicePhysicalName + "\n");
        }
        if (this.sybsystemdbDeviceSize != null && this.sybsystemdbDeviceSize != 0) {
            stringBuffer.append("sqlsrv.sybsystemdb_device_size: " + this.sybsystemdbDeviceSize + "\n");
        }
        if (this.sybsystemdbDatabaseSize != null && this.sybsystemdbDatabaseSize != 0) {
            stringBuffer.append("sqlsrv.sybsystemdb_database_size: " + this.sybsystemdbDatabaseSize + "\n");
        }
        if (this.pciConfigured != null) {
            stringBuffer.append("srvbuild.do_configure_pci: " + (this.pciConfigured != false ? "yes" : "no") + "\n");
            if (this.pciConfigured.booleanValue()) {
                if (this.pciDevicePhysicalName != null && !this.pciDevicePhysicalName.equals("")) {
                    stringBuffer.append("srvbuild.sybpcidb_device_physical_name: " + this.pciDevicePhysicalName + "\n");
                }
                if (this.pciDeviceSize != null && !this.pciDeviceSize.equals("")) {
                    stringBuffer.append("srvbuild.sybpcidb_device_size: " + this.pciDeviceSize + "\n");
                }
                if (this.pciDatabaseSize != null && this.pciDatabaseSize != 0) {
                    stringBuffer.append("srvbuild.sybpcidb_database_size: " + this.pciDatabaseSize + "\n");
                }
            }
        }
        if (this.errorlog != null && !this.errorlog.equals("")) {
            stringBuffer.append("sqlsrv.errorlog: " + this.errorlog + "\n");
        }
        if (this.sortOrder != null && !this.sortOrder.equals("")) {
            stringBuffer.append("sqlsrv.sort_order: " + this.sortOrder + "\n");
        }
        if (this.defaultCharacterset != null && !this.defaultCharacterset.equals("")) {
            stringBuffer.append("sqlsrv.default_characterset: " + this.defaultCharacterset + "\n");
        }
        if (this.defaultLanguage != null && !this.defaultLanguage.equals("")) {
            stringBuffer.append("sqlsrv.default_language: " + this.defaultLanguage + "\n");
        }
        if (this.doUpgrade != null) {
            stringBuffer.append("sqlsrv.do_upgrade: " + (this.doUpgrade != false ? "yes" : "no") + "\n");
        }
        if (this.charset != null && !this.charset.equals("")) {
            stringBuffer.append("sybinit.charset: " + this.charset + "\n");
        }
        if (this.language != null && !this.language.equals("")) {
            stringBuffer.append("sybinit.language: " + this.language + "\n");
        }
        if (this.product != null && !this.product.equals("")) {
            stringBuffer.append("sybinit.product: " + this.product + "\n");
        }
        if (this.defaultBackupServer != null && !this.defaultBackupServer.equals("")) {
            stringBuffer.append("sqlsrv.default_backup_server: " + this.defaultBackupServer + "\n");
        }
        return stringBuffer.toString();
    }

    public void run(Message message, ResourceBundle resourceBundle, String string, String string2, String string3, String[] stringArray) throws Exception {
        File file = new File(string2, "bin");
        File file2 = File.createTempFile("BR" + this.serverName + "_", ".res", new File(string));
        FileWriter fileWriter = new FileWriter(file2);
        fileWriter.write(this.generateConfig());
        fileWriter.close();
        String[] stringArray2 = new String[]{"sh", "-c", string3 != null ? "./srvbuildres -s " + string + " -I " + string3 + "/interfaces" + " -r " + file2.getAbsolutePath() : "./srvbuildres -s " + string + " -r " + file2.getAbsolutePath()};
        log.debug((Object)("Running srvbuildres: " + stringArray2[0] + " " + stringArray2[1] + " " + stringArray2[2]));
        ShellCommand.exec(message, resourceBundle, stringArray2, stringArray, file);
    }

    public String getAddlBuildParameters() {
        return this.addlBuildParameters;
    }

    public void setAddlBuildParameters(String string) {
        this.addlBuildParameters = string;
    }

    public String getAddlCmdlineParameters() {
        return this.addlCmdlineParameters;
    }

    public void setAddlCmdlineParameters(String string) {
        this.addlCmdlineParameters = string;
    }

    public String getBootDirectory() {
        return this.bootDirectory;
    }

    public void setBootDirectory(String string) {
        this.bootDirectory = string;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public String getDefaultBackupServer() {
        return this.defaultBackupServer;
    }

    public void setDefaultBackupServer(String string) {
        this.defaultBackupServer = string;
    }

    public String getDefaultCharacterset() {
        return this.defaultCharacterset;
    }

    public void setDefaultCharacterset(String string) {
        this.defaultCharacterset = string;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(String string) {
        this.defaultLanguage = string;
    }

    public Boolean getDoUpgrade() {
        return this.doUpgrade;
    }

    public void setDoUpgrade(Boolean bl) {
        this.doUpgrade = bl;
    }

    public Boolean getDoAddServerToInterfaceFile() {
        return this.doAddServerToInterfaceFile;
    }

    public void setDoAddServerToInterfaceFile(Boolean bl) {
        this.doAddServerToInterfaceFile = bl;
    }

    public String getErrorlog() {
        return this.errorlog;
    }

    public void setErrorlog(String string) {
        this.errorlog = string;
    }

    public Boolean getForceBuildMaster() {
        return this.forceBuildMaster;
    }

    public void setForceBuildMaster(Boolean bl) {
        this.forceBuildMaster = bl;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public Integer getMasterDatabaseSize() {
        return this.masterDatabaseSize;
    }

    public void setMasterDatabaseSize(Integer n) {
        this.masterDatabaseSize = n;
    }

    public String getMasterDevicePhysicalName() {
        return this.masterDevicePhysicalName;
    }

    public void setMasterDevicePhysicalName(String string) {
        this.masterDevicePhysicalName = string;
    }

    public Integer getMasterDeviceSize() {
        return this.masterDeviceSize;
    }

    public void setMasterDeviceSize(Integer n) {
        this.masterDeviceSize = n;
    }

    public String getNetworkHostnameList() {
        return this.networkHostnameList;
    }

    public void setNetworkHostnameList(String string) {
        this.networkHostnameList = string;
    }

    public String getNetworkPortList() {
        return this.networkPortList;
    }

    public void setNetworkPortList(String string) {
        this.networkPortList = string;
    }

    public String getNetworkProtocolList() {
        return this.networkProtocolList;
    }

    public void setNetworkProtocolList(String string) {
        this.networkProtocolList = string;
    }

    public Boolean getNewConfig() {
        return this.newConfig;
    }

    public void setNewConfig(Boolean bl) {
        this.newConfig = bl;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String string) {
        this.product = string;
    }

    public String getReleaseDirectory() {
        return this.releaseDirectory;
    }

    public void setReleaseDirectory(String string) {
        this.releaseDirectory = string;
    }

    public String getSaLogin() {
        return this.saLogin;
    }

    public void setSaLogin(String string) {
        this.saLogin = string;
    }

    public char[] getSaPassword() {
        return this.saPassword;
    }

    public void setSaPassword(char[] cArray) {
        this.saPassword = cArray;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public String getServerPageSize() {
        return this.serverPageSize;
    }

    public void setServerPageSize(String string) {
        this.serverPageSize = string;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String string) {
        this.sortOrder = string;
    }

    public Integer getSybsystemdbDatabaseSize() {
        return this.sybsystemdbDatabaseSize;
    }

    public void setSybsystemdbDatabaseSize(Integer n) {
        this.sybsystemdbDatabaseSize = n;
    }

    public String getSybsystemdbDevicePhysicalName() {
        return this.sybsystemdbDevicePhysicalName;
    }

    public void setSybsystemdbDevicePhysicalName(String string) {
        this.sybsystemdbDevicePhysicalName = string;
    }

    public Integer getSybsystemdbDeviceSize() {
        return this.sybsystemdbDeviceSize;
    }

    public void setSybsystemdbDeviceSize(Integer n) {
        this.sybsystemdbDeviceSize = n;
    }

    public Integer getSybsystemprocsDatabaseSize() {
        return this.sybsystemprocsDatabaseSize;
    }

    public void setSybsystemprocsDatabaseSize(Integer n) {
        this.sybsystemprocsDatabaseSize = n;
    }

    public String getSybsystemprocsDevicePhysicalName() {
        return this.sybsystemprocsDevicePhysicalName;
    }

    public void setSybsystemprocsDevicePhysicalName(String string) {
        this.sybsystemprocsDevicePhysicalName = string;
    }

    public Integer getSybsystemprocsDeviceSize() {
        return this.sybsystemprocsDeviceSize;
    }

    public void setSybsystemprocsDeviceSize(Integer n) {
        this.sybsystemprocsDeviceSize = n;
    }
}

