/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.create;

import com.sybase.ase.sdcadmin.IConstants;
import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.create.ServerConfig;
import com.sybase.ase.sdcadmin.util.Message;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SystemTemporaryDatabase
implements IConstants {
    private static Log log = LogFactory.getLog(ServerConfig.class);

    public static int createTemporaryDatabases(Message message, ResourceBundle resourceBundle, ICluster iCluster, IServer[] iServerArray, Connection connection) {
        int n = 0;
        for (int i = 0; i < iServerArray.length; ++i) {
            try {
                log.debug((Object)("Creating temporary database for instance " + iServerArray[i].getName()));
                n = SystemTemporaryDatabase.createTemporaryDatabase(message, resourceBundle, iServerArray[i], connection);
                if (n == 0) continue;
                log.debug((Object)"Create temporary database failed");
                return n;
            }
            catch (Exception exception) {
                n = -99;
            }
        }
        return n;
    }

    public static String parseQuery(String string, Object[] objectArray) {
        try {
            return MessageFormat.format(string, objectArray);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int createTemporaryDatabase(Message message, ResourceBundle resourceBundle, IServer iServer, Connection connection) {
        int n = 0;
        String string = iServer.getTempdbDbSize();
        if ("0123456789".indexOf(string.charAt(string.length() - 1)) >= 0) {
            string = string + "M";
        }
        String string2 = "create system temporary database {0} for instance {1} on {2}  = ''{3}''";
        String string3 = SystemTemporaryDatabase.parseQuery(string2, new String[]{iServer.getTempdbDbName(), iServer.getName(), iServer.getTempdbDeviceName(), string});
        Statement statement = null;
        try {
            statement = connection.createStatement();
        }
        catch (SQLException sQLException) {
            message.output(resourceBundle, "com.sybase.ase.cluster.instance.statement.error", sQLException.getMessage());
            return -1;
        }
        message.output(resourceBundle, "sdcadmin.temporary.database.creation.info", iServer.getName(), iServer.getTempdbDeviceName(), iServer.getTempdbDbName(), string);
        log.debug((Object)("Adding temporary database using: " + string3));
        try {
            statement.executeUpdate(string3);
        }
        catch (SQLException sQLException) {
            message.output(resourceBundle, "sdcadmin.sql.execute.error", string3, sQLException.getMessage());
            n = -2;
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                message.output(resourceBundle, "sdcadmin.sql.statement.close.error", sQLException.getMessage());
                n = -3;
            }
        }
        log.debug((Object)("Done adding temporary database. Status: " + n));
        return n;
    }
}

