/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.quorum;

import com.sybase.ase.sdcadmin.lang.IResourceConstants;
import com.sybase.ase.sdcadmin.quorum.QHelperException;
import com.sybase.ase.sdcadmin.quorum.QuorumCluster;
import com.sybase.ase.sdcadmin.quorum.QuorumException;
import com.sybase.ase.sdcadmin.quorum.QuorumHandle;
import com.sybase.ase.sdcadmin.quorum.QuorumInstance;
import com.sybase.ase.sdcadmin.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QHelper
implements IResourceConstants {
    private static Log log = LogFactory.getLog(QHelper.class);
    public static final int QHELPER_VERSION_CURRENT = 3;
    public static final int QHELPER_VERSION_COMPATABLE = 3;
    public static final int QHELPER_TOKEN_CLUSTER_NAME = 1;
    public static final int QHELPER_TOKEN_MAX_INSTANCES = 2;
    public static final int QHELPER_TOKEN_MASTER_DEVICE = 3;
    public static final int QHELPER_TOKEN_PRIMARY_NET_TYPE = 4;
    public static final int QHELPER_TOKEN_SECONDARY_NET_TYPE = 5;
    public static final int QHELPER_TOKEN_INSTANCE_ID = 6;
    public static final int QHELPER_TOKEN_INSTANCE_NODE = 7;
    public static final int QHELPER_TOKEN_PRIMARY_ADDRESS = 8;
    public static final int QHELPER_TOKEN_SECONDARY_ADDRESS = 9;
    public static final int QHELPER_TOKEN_PRIMARY_PORT_START = 10;
    public static final int QHELPER_TOKEN_SECONDARY_PORT_START = 11;
    public static final int QHELPER_TOKEN_ERROR_LOG = 12;
    public static final int QHELPER_TOKEN_ADDL_RUN_PARAMETERS = 13;
    public static final int QHELPER_TOKEN_INSTANCE_NAME = 14;
    public static final int QHELPER_TOKEN_TRACEFLAGS = 15;
    public static final int QHELPER_TOKEN_CONFIG_FILE = 16;
    public static final int QHELPER_TOKEN_INTERFACES_PATH = 17;
    public static final int QHELPER_TOKEN_HOSTNAME = 18;
    public static final int QHELPER_TOKEN_RUNNING = 19;
    public static final int QHELPER_TOKEN_DEV_VERSION = 20;
    public static final int QHELPER_TOKEN_MSG_VERSION = 21;
    public static final int QHELPER_TOKEN_HEARTBEAT_INTERVAL = 22;
    public static final int QHELPER_TOKEN_HEARTBEAT_RETRIES = 23;
    public static final int QHELPER_TOKEN_CIPC_MESH_SIZE = 24;
    public static final int QHELPER_LOCK_CONFIG = 1;
    public static final int QHELPER_ID_MASTER = 1;
    public static final int QHELPER_ID_QUORUM = 2;
    public static final int QHELPER_ID_CONFIG = 3;
    public static final int QHELPER_ID_BOOT = 4;
    public static final int QHELPER_STATUS_UNDEFINED = 0;
    public static final int QHELPER_STATUS_INVALID = 1;
    public static final int QHELPER_STATUS_START = 2;
    public static final int QHELPER_STATUS_INIT = 3;
    public static final int QHELPER_STATUS_UP = 4;
    public static final int QHELPER_STATUS_QUIES = 5;
    public static final int QHELPER_STATUS_DOWN = 6;
    public static boolean loadedLibrary = false;
    private static final String LIBRARY_NAME = System.mapLibraryName("sybquorum");
    private static final int QHELPER_MINIMUM_VERSION = 3;
    private static final int QRM_MINIMUM_VERSION = 1;
    private QuorumHandle quorumHandle = null;
    private ResourceBundle resourceBundle = null;

    private QHelper() {
    }

    protected QHelper(ResourceBundle resourceBundle, File file, File file2) throws QuorumException {
        File file3;
        this.resourceBundle = resourceBundle;
        QHelperException qHelperException = null;
        if (file == null) {
            String string = resourceBundle.getString("sdcadmin.quorum.library.null.error");
            throw new QuorumException(string);
        }
        if (loadedLibrary) {
            log.debug((Object)"The quorum access library was already loaded.");
        } else {
            File file4 = new File(file, LIBRARY_NAME);
            log.debug((Object)FileUtil.removeControlCharacter("Loading quorum library " + file4.getAbsolutePath()));
            if (!file4.exists()) {
                qHelperException = new QHelperException("sdcadmin.quorum.library.notfound.error", file4.getAbsolutePath());
                throw new QuorumException(qHelperException.getMessage(resourceBundle), qHelperException);
            }
            String string = null;
            try {
                string = file4.getCanonicalPath();
            }
            catch (IOException iOException) {
                qHelperException = new QHelperException("sdcadmin.quorum.library.cannonical.error", file4.getAbsolutePath(), (Object)iOException.getLocalizedMessage());
                throw new QuorumException(qHelperException.getMessage(resourceBundle), qHelperException);
            }
            if (!file4.canRead()) {
                qHelperException = new QHelperException("sdcadmin.quorum.library.noaccess.error", string);
                throw new QuorumException(qHelperException.getMessage(resourceBundle), qHelperException);
            }
            try {
                Runtime.getRuntime().load(string);
                loadedLibrary = true;
                log.debug((Object)FileUtil.removeControlCharacter("The quorum access library " + string + " was successfully loaded."));
            }
            catch (Exception exception) {
                qHelperException = new QHelperException("sdcadmin.quorum.library.load.error", string, (Object)exception.getLocalizedMessage());
                throw new QuorumException(qHelperException.getMessage(resourceBundle), qHelperException);
            }
        }
        int n = this.qhelper_getversion_current();
        int n2 = this.qhelper_getversion_compat();
        log.debug((Object)("QUtils Library Current QHelper Version: " + n + "; Compatability Version: " + n2));
        log.debug((Object)"QUtils Minimum Required QHelper Version: 3");
        if (n < 3) {
            qHelperException = new QHelperException("sdcadmin.qhelper.minversion", new Integer(n2), (Object)new Integer(3));
            throw new QuorumException(qHelperException.getMessage(resourceBundle), qHelperException);
        }
        int n3 = this.qhelper_getlibversion_current();
        int n4 = this.qhelper_getlibversion_compat();
        log.debug((Object)("QUtils Library Current QRM Version:  " + n3 + "; Compatability Version: " + n4 + ")"));
        log.debug((Object)"QUtils Minimum Required QRM Version: 1");
        if (n4 < 1) {
            qHelperException = new QHelperException("sdcadmin.qhelper.qrm.minversion", new Integer(n4), (Object)new Integer(1));
            throw new QuorumException(qHelperException.getMessage(resourceBundle), qHelperException);
        }
        if (file2 == null) {
            qHelperException = new QHelperException("sdcadmin.quorum.device.null.error");
            throw new QuorumException(qHelperException.getMessage(resourceBundle), qHelperException);
        }
        if (file2.exists() && !file2.isFile() && !file2.isDirectory()) {
            try {
                file2.getCanonicalPath();
            }
            catch (IOException iOException) {
                qHelperException = new QHelperException("sdcadmin.quorum.device.cannonical.error", file2.getAbsolutePath());
                throw new QuorumException(qHelperException.getMessage(resourceBundle), qHelperException);
            }
        } else if (!file2.exists() && !(file3 = file2.getParentFile()).exists()) {
            qHelperException = new QHelperException("sdcadmin.quorum.file.parent.directory.error", file3);
            throw new QuorumException(qHelperException.getMessage(resourceBundle), qHelperException);
        }
        this.quorumHandle = new QuorumHandle();
        this.quorumHandle.qrmDev = file2.getAbsolutePath();
    }

    protected int getVersionCompat() {
        return this.qhelper_getversion_compat();
    }

    private native int qhelper_getversion_compat();

    protected int getVersionCurrent() {
        return this.qhelper_getversion_current();
    }

    private native int qhelper_getversion_current();

    protected int getQuorumVersionCompat() {
        return this.qhelper_getlibversion_compat();
    }

    private native int qhelper_getlibversion_compat();

    protected int getQuorumVersionCurrent() {
        return this.qhelper_getlibversion_current();
    }

    private native int qhelper_getlibversion_current();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void create(String string, boolean bl) throws QuorumException {
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before create()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)("qhelper_create( " + string + ", " + bl + " )"));
                this.qhelper_create(this.quorumHandle, string, bl);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(string);
                qHelperException.addArg(new Boolean(bl));
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
    }

    private native void qhelper_create(QuorumHandle var1, String var2, boolean var3) throws QHelperException, QuorumException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drop(boolean bl) throws QuorumException {
        int n = 0;
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before drop()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                if (bl) {
                    n = 1;
                }
                log.debug((Object)("qhelper_drop( " + n + " )"));
                this.qhelper_drop_cluster(this.quorumHandle, n);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(this.quorumHandle);
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
            finally {
                this.quorumHandle = null;
            }
        }
    }

    private native void qhelper_drop_cluster(QuorumHandle var1, int var2) throws QHelperException, QuorumException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getUid(int n) throws QuorumException {
        String string = "";
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before getUid()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)("qhelper_uid_getid( " + n + " )"));
                byte[] byArray = this.qhelper_cluster_getid(this.quorumHandle, n);
                string = QHelper.convertUidToString(byArray);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(new Integer(n));
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
        return string;
    }

    private native byte[] qhelper_cluster_getid(QuorumHandle var1, int var2) throws QHelperException, QuorumException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getClusterStatus() throws QuorumException {
        int n;
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before getClusterStatus()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)"qhelper_cluster_getStatus( )");
                n = this.qhelper_cluster_getstatus(this.quorumHandle);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(this.quorumHandle);
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
        return n;
    }

    private native int qhelper_cluster_getstatus(QuorumHandle var1) throws QHelperException, QuorumException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isClusterDefined() throws QuorumException {
        boolean bl = false;
        log.debug((Object)("Quorum device = " + this.quorumHandle.qrmDev));
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before isClusterDefined()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)"qhelper_cluster_isdefined( )");
                bl = this.qhelper_cluster_isdefined(this.quorumHandle);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(this.quorumHandle);
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
        return bl;
    }

    private native boolean qhelper_cluster_isdefined(QuorumHandle var1) throws QHelperException, QuorumException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addInstance(String string, int n, String string2, String string3) throws QuorumException {
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before addInstance()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)("qhelper_instance_add( " + string + ", " + n + ", " + string2 + ", " + string3 + " )"));
                this.qhelper_instance_add(this.quorumHandle, string, n, string2, string3);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(string, new Integer(n));
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
    }

    private native void qhelper_instance_add(QuorumHandle var1, String var2, int var3, String var4, String var5) throws QHelperException, QuorumException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropInstance(int n) throws QuorumException {
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before dropInstance()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)("qhelper_instance_drop( " + n + " )"));
                this.qhelper_instance_drop(this.quorumHandle, n);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(new Integer(n));
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
    }

    private native void qhelper_instance_drop(QuorumHandle var1, int var2) throws QHelperException, QuorumException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getInstanceId(String string) throws QuorumException {
        int n;
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before getInstanceId()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)("qhelper_instance_getid( " + string + " )"));
                n = this.qhelper_instance_getid(this.quorumHandle, string);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(this.quorumHandle);
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
        return n;
    }

    private native int qhelper_instance_getid(QuorumHandle var1, String var2) throws QHelperException, QuorumException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getInstanceStatus(int n) throws QuorumException {
        int n2;
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before getInstanceStatus()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)("qhelper_instance_getstatus( " + n + " )"));
                n2 = this.qhelper_instance_getstatus(this.quorumHandle, n);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(this.quorumHandle);
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
        return n2;
    }

    private native int qhelper_instance_getstatus(QuorumHandle var1, int var2) throws QHelperException, QuorumException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isInstanceDefined(int n) throws QuorumException {
        boolean bl = false;
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before isInstanceDefined()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)("qhelper_instance_isdefined( " + n + " )"));
                bl = this.qhelper_instance_isdefined(this.quorumHandle, n);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(this.quorumHandle);
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
        return bl;
    }

    private native boolean qhelper_instance_isdefined(QuorumHandle var1, int var2) throws QHelperException, QuorumException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerNode(String string) throws QuorumException {
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before registerNode()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)("qhelper_register_node( " + string + " )"));
                this.qhelper_register_node(this.quorumHandle, string);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(string);
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
    }

    private native void qhelper_register_node(QuorumHandle var1, String var2) throws QHelperException, QuorumException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterNode(String string) throws QuorumException {
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before unregisterNode()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)("qhelper_unregister_node( " + string + " )"));
                this.qhelper_unregister_node(this.quorumHandle, string);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(string);
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
    }

    private native void qhelper_unregister_node(QuorumHandle var1, String var2) throws QHelperException, QuorumException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean verifyNode(String string) throws QuorumException {
        boolean bl;
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before verifyNode()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)("qhelper_verify_node( " + string + " )"));
                bl = this.qhelper_verify_node(this.quorumHandle, string);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(string);
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
        return bl;
    }

    private native boolean qhelper_verify_node(QuorumHandle var1, String var2) throws QHelperException, QuorumException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getNodes() throws QuorumException {
        String[] stringArray;
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before getNodes()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)"qhelper_get_nodes( )");
                stringArray = this.qhelper_get_nodes(this.quorumHandle);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(this.quorumHandle);
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
        return stringArray;
    }

    private native String[] qhelper_get_nodes(QuorumHandle var1) throws QHelperException, QuorumException;

    protected int getMaxStringLength(int n) {
        log.debug((Object)("qhelper_getconfig_charsize( " + n + " )"));
        return this.qhelper_getconfig_charsize(n);
    }

    private native int qhelper_getconfig_charsize(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValue(int n, String string) throws QuorumException {
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before setValue()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)("qhelper_setconfig_char( 0, " + n + ", " + string + " )"));
                this.qhelper_setconfig_char(this.quorumHandle, 0, n, string);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(new Integer(n), string);
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValue(int n, int n2, String string) throws QuorumException {
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before setValue()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)("qhelper_setconfig_char( " + n + ", " + n2 + ", " + string + " )"));
                this.qhelper_setconfig_char(this.quorumHandle, n, n2, string);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(new Integer(n), new Integer(n2), string);
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
    }

    private native void qhelper_setconfig_char(QuorumHandle var1, int var2, int var3, String var4) throws QHelperException, QuorumException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getString(int n) throws QuorumException {
        String string;
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before getString()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)("qhelper_getconfig_char( 0, " + n + " )"));
                string = this.qhelper_getconfig_char(this.quorumHandle, 0, n);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(new Integer(n));
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getString(int n, int n2) throws QuorumException {
        String string;
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before getString()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)("qhelper_getconfig_char( " + n + ", " + n2 + " )"));
                string = this.qhelper_getconfig_char(this.quorumHandle, n, n2);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(new Integer(n), new Integer(n2));
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
        return string;
    }

    private native String qhelper_getconfig_char(QuorumHandle var1, int var2, int var3) throws QHelperException, QuorumException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValue(int n, int n2) throws QuorumException {
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before setValue()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)("qhelper_setconfig_int( 0, " + n + ", " + n2 + " )"));
                this.qhelper_setconfig_int(this.quorumHandle, 0, n, n2);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(new Integer(n2));
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValue(int n, int n2, int n3) throws QuorumException {
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before setValue()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)("qhelper_setconfig_char( " + n + ", " + n2 + ", " + n3 + " )"));
                this.qhelper_setconfig_int(this.quorumHandle, n, n2, n3);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(new Integer(n2), new Integer(n3));
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
    }

    private native void qhelper_setconfig_int(QuorumHandle var1, int var2, int var3, int var4) throws QHelperException, QuorumException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getInteger(int n) throws QuorumException {
        int n2;
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before getInteger()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                switch (n) {
                    case 19: 
                    case 20: 
                    case 21: {
                        log.debug((Object)("qhelper_getboot_int( " + n + " )"));
                        n2 = this.qhelper_getboot_int(this.quorumHandle, n);
                        break;
                    }
                    case 22: 
                    case 23: {
                        log.debug((Object)("qhelper_getmaster_int( " + n + " )"));
                        n2 = this.qhelper_getmaster_int(this.quorumHandle, n);
                        break;
                    }
                    default: {
                        log.debug((Object)("qhelper_getconfig_int( 0, " + n + " )"));
                        n2 = this.qhelper_getconfig_int(this.quorumHandle, 0, n);
                        break;
                    }
                }
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(new Integer(n));
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getInteger(int n, int n2) throws QuorumException {
        int n3;
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before getInteger()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)("qhelper_getconfig_int( " + n + ", " + n2 + " )"));
                n3 = this.qhelper_getconfig_int(this.quorumHandle, n, n2);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(new Integer(n2));
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
        return n3;
    }

    private native int qhelper_getconfig_int(QuorumHandle var1, int var2, int var3) throws QHelperException, QuorumException;

    private native int qhelper_getboot_int(QuorumHandle var1, int var2) throws QHelperException, QuorumException;

    private native int qhelper_getmaster_int(QuorumHandle var1, int var2) throws QHelperException, QuorumException;

    private native String qhelper_getmaster_char(QuorumHandle var1, int var2) throws QHelperException, QuorumException;

    protected int getConstantInt(int n) {
        return this.qhelper_getconstant_int(n);
    }

    private native int qhelper_getconstant_int(int var1);

    protected QuorumInstance[] loadQuorum(QuorumCluster quorumCluster) throws QuorumException {
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)"qhelper_loadquorum( quorumCluster )");
                return this.qhelper_loadquorum(this.quorumHandle, quorumCluster);
            }
            catch (QHelperException qHelperException) {
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
    }

    private native QuorumInstance[] qhelper_loadquorum(QuorumHandle var1, QuorumCluster var2) throws QHelperException, QuorumException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getInstanceHeartbeat(int n) throws QuorumException {
        int n2;
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before getInstanceHeartbeat()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)("qhelper_gethb_instance( " + n + " )"));
                n2 = this.qhelper_gethb_instance(this.quorumHandle, n);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(this.quorumHandle);
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
        return n2;
    }

    private native int qhelper_gethb_instance(QuorumHandle var1, int var2) throws QHelperException, QuorumException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] getClusterHeartbeat() throws QuorumException {
        int[] nArray;
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before getClusterHeartbeat()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)"qhelper_gethb_cluster( )");
                nArray = this.qhelper_gethb_cluster(this.quorumHandle);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(this.quorumHandle);
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
        return nArray;
    }

    private native int[] qhelper_gethb_cluster(QuorumHandle var1) throws QHelperException, QuorumException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadInputFile(String string) throws QuorumException {
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before loadInputFile()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)("qhelper_load_input_file( " + string + " )"));
                this.qhelper_load_input_file(this.quorumHandle, string);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(string);
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
    }

    private native void qhelper_load_input_file(QuorumHandle var1, String var2) throws QHelperException, QuorumException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateInputFile(String string) throws QuorumException {
        if (this.quorumHandle == null) {
            log.error((Object)"Internal Error - init() must be called before generateInputFile()");
            QHelperException qHelperException = new QHelperException("sdcadmin.internal.checklog.error");
            throw new QuorumException(qHelperException.getMessage(this.resourceBundle));
        }
        QuorumHandle quorumHandle = this.quorumHandle;
        synchronized (quorumHandle) {
            try {
                this.quorumHandle.clearError();
                log.debug((Object)("qhelper_generate_input_file( " + string + " )"));
                this.qhelper_generate_input_file(this.quorumHandle, string);
            }
            catch (QHelperException qHelperException) {
                qHelperException.addArg(string);
                throw new QuorumException(qHelperException.getMessage(this.resourceBundle), qHelperException);
            }
            catch (QuorumException quorumException) {
                quorumException.initCause(new QuorumException(this.qrmStatusToResKey(this.quorumHandle.getQrmStatus(), this.quorumHandle.getQrmErrno())));
                log.error((Object)quorumException.getCause());
                log.error((Object)quorumException);
                throw quorumException;
            }
        }
    }

    private native void qhelper_generate_input_file(QuorumHandle var1, String var2) throws QHelperException, QuorumException;

    private static String convertUidToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < byArray.length; ++i) {
            if (i > 0 && i % 4 == 0) {
                stringBuffer.append("-");
            }
            stringBuffer.append(QHelper.byteToHex(byArray[i]));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static String byteToHex(byte by) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(QHelper.toHexChar(by >>> 4 & 0xF));
        stringBuffer.append(QHelper.toHexChar(by & 0xF));
        return stringBuffer.toString();
    }

    private static char toHexChar(int n) {
        if (0 <= n && n <= 9) {
            return (char)(48 + n);
        }
        return (char)(97 + (n - 10));
    }

    private String qrmStatusToResKey(int n, int n2) {
        String string = "";
        switch (n) {
            case 1: {
                string = "quorum.enomem.error";
                break;
            }
            case 2: {
                string = "quorum.enomem.error";
                break;
            }
            case 3: {
                string = "quorum.einval.error";
                break;
            }
            case 4: {
                string = "quorum.eioerr.error";
                break;
            }
            case 5: {
                string = "quorum.ebadpath.error";
                break;
            }
            case 6: {
                string = "quorum.emagic.error";
                break;
            }
            case 7: {
                string = "quorum.eversion.error";
                break;
            }
            case 8: {
                string = "quorum.etoken.error";
                break;
            }
            case 9: {
                string = "quorum.econtext.error";
                break;
            }
            case 10: {
                string = "quorum.etoomany.error";
                break;
            }
            case 12: {
                string = "quorum.etimeout.error";
                break;
            }
            case 13: {
                string = "quorum.ebadinstance.error";
                break;
            }
            case 14: {
                string = "quorum.ebadkey.error";
                break;
            }
            case 15: {
                string = "quorum.enolock.error";
                break;
            }
            case 16: {
                string = "quorum.ewronglock.error";
                break;
            }
            case 17: {
                string = "quorum.elockheld.error";
                break;
            }
            case 18: {
                string = "quorum.ebadnode.error";
                break;
            }
            case 19: {
                string = "quorum.eof.error";
                break;
            }
            case 20: {
                string = "quorum.ebadstate.error";
                break;
            }
            case 21: {
                string = "quorum.eexists.error";
            }
        }
        return this.resourceBundle.getString(string) + ":  " + n2;
    }
}

