/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.quorum;

import com.sybase.ase.sdcadmin.lang.IResourceConstants;
import com.sybase.ase.sdcadmin.quorum.QHelper;
import com.sybase.ase.sdcadmin.quorum.QuorumCluster;
import com.sybase.ase.sdcadmin.quorum.QuorumException;
import com.sybase.ase.sdcadmin.quorum.QuorumIdentifiers;
import com.sybase.ase.sdcadmin.quorum.QuorumInstance;
import com.sybase.ase.sdcadmin.quorum.QuorumStatus;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import java.io.File;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Quorum
implements IResourceConstants,
ISdConstants {
    private static Log log = LogFactory.getLog(Quorum.class);
    protected QHelper qHelper;
    private File quorumDevice;
    private boolean conservative = true;

    private Quorum() {
    }

    public Quorum(File file, File file2) throws QuorumException {
        this.quorumDevice = file2;
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.sybase.ase.sdcadmin.lang.Res");
        this.qHelper = new QHelper(resourceBundle, file, file2);
    }

    public QuorumInstance addQuorumInstance(QuorumInstance quorumInstance) throws QuorumException {
        int n = quorumInstance.getInstanceId();
        this.qHelper.addInstance(quorumInstance.getName(), quorumInstance.getInstanceId(), quorumInstance.getPrimaryAddress(), quorumInstance.getPrimaryPortStart());
        this.setNonEmptyValue(n, 7, quorumInstance.getInstanceNode());
        this.setNonEmptyValue(n, 9, quorumInstance.getSecondaryAddress());
        this.setNonEmptyValue(n, 11, quorumInstance.getSecondaryPortStart());
        this.setNonEmptyValue(n, 12, quorumInstance.getLogFile());
        this.setNonEmptyValue(n, 16, quorumInstance.getConfigFile());
        if (quorumInstance.getInterfacesPath() != null) {
            this.setNonEmptyValue(n, 17, quorumInstance.getInterfacesPath());
        } else {
            this.qHelper.setValue(n, 17, "");
        }
        this.setNonEmptyValue(n, 15, quorumInstance.getTraceflags());
        this.setNonEmptyValue(n, 13, quorumInstance.getAddlRunParameters());
        return quorumInstance;
    }

    private void setNonEmptyValue(int n, int n2, String string) throws QuorumException {
        if (string == null || this.equals("")) {
            return;
        }
        if (n != 0) {
            this.qHelper.setValue(n, n2, string);
        }
    }

    public void create(File file, boolean bl) throws QuorumException {
        this.qHelper.create(file.getAbsolutePath(), bl);
    }

    public void dropQuorumCluster(boolean bl) throws QuorumException {
        this.qHelper.drop(bl);
    }

    public void dropQuorumInstance(int n) throws QuorumException {
        this.qHelper.dropInstance(n);
    }

    public void dropQuorumInstance(String string) throws QuorumException {
        int n = this.qHelper.getInstanceId(string);
        this.dropQuorumInstance(n);
    }

    public String getClusterName() throws QuorumException {
        return this.qHelper.getString(1);
    }

    public int getInstanceId(String string) throws QuorumException {
        return this.qHelper.getInstanceId(string);
    }

    public String getInstanceNode(int n) throws QuorumException {
        return this.qHelper.getString(n, 7);
    }

    public String getInterfacesDirectory() throws QuorumException {
        return this.qHelper.getString(17);
    }

    public int getMaxInstances() throws QuorumException {
        return this.qHelper.getInteger(2);
    }

    public String[] getNodes() throws QuorumException {
        String[] stringArray = this.qHelper.getNodes();
        return stringArray;
    }

    public QuorumCluster getQuorumCluster() throws QuorumException {
        QuorumCluster quorumCluster = null;
        if (this.isClusterDefined()) {
            quorumCluster = new QuorumCluster();
            quorumCluster.setMaxInstances(this.qHelper.getInteger(2));
            quorumCluster.setName(this.qHelper.getString(1));
            quorumCluster.setMasterDevice(this.qHelper.getString(3));
            quorumCluster.setConfigFile(this.qHelper.getString(16));
            quorumCluster.setInterfacesPath(this.qHelper.getString(17));
            quorumCluster.setTraceflags(this.qHelper.getString(15));
            quorumCluster.setPrimaryNetType(this.qHelper.getString(4));
            quorumCluster.setSecondaryNetType(this.qHelper.getString(5));
            quorumCluster.setAddlRunParameters(this.qHelper.getString(13));
            quorumCluster.setQuorumIdentifiers(this.loadQuorumIdentifiers(new QuorumIdentifiers()));
        }
        return quorumCluster;
    }

    public String getQuorumDevice() {
        return this.quorumDevice.getAbsolutePath();
    }

    public QuorumIdentifiers getQuorumIdentifers() throws QuorumException {
        QuorumIdentifiers quorumIdentifiers = null;
        if (this.qHelper.isClusterDefined()) {
            quorumIdentifiers = this.loadQuorumIdentifiers(new QuorumIdentifiers());
        }
        return quorumIdentifiers;
    }

    public QuorumInstance getQuorumInstance(int n) throws QuorumException {
        QuorumInstance quorumInstance = null;
        if (this.qHelper.isClusterDefined()) {
            int n2 = this.qHelper.getInteger(2);
            if (n > 0 && n <= n2 && this.qHelper.isInstanceDefined(n)) {
                quorumInstance = this.loadQuorumInstance(n);
            }
        }
        return quorumInstance;
    }

    public QuorumInstance getQuorumInstance(String string) throws QuorumException {
        QuorumInstance quorumInstance = null;
        if (this.qHelper.isClusterDefined()) {
            int n = this.qHelper.getInstanceId(string);
            if (n == 0) {
                return null;
            }
            quorumInstance = this.loadQuorumInstance(n);
        }
        return quorumInstance;
    }

    public QuorumInstance[] getQuorumInstances() throws QuorumException {
        QuorumCluster quorumCluster = new QuorumCluster();
        return this.getQuorumInstances(quorumCluster);
    }

    public QuorumInstance[] getQuorumInstances(QuorumCluster quorumCluster) throws QuorumException {
        return this.loadQuorum(quorumCluster);
    }

    public QuorumStatus getQuorumStatus() throws QuorumException {
        QuorumStatus quorumStatus = null;
        QuorumCluster quorumCluster = new QuorumCluster();
        QuorumInstance[] quorumInstanceArray = this.loadQuorum(quorumCluster);
        if (this.qHelper.isClusterDefined()) {
            int n = quorumCluster.getMaxInstances();
            quorumStatus = new QuorumStatus(n);
            quorumStatus.setClusterDefined(true);
            this.loadQuorumStatusValues(quorumStatus);
        }
        return quorumStatus;
    }

    public Boolean[] getInstancePulse() throws QuorumException {
        Boolean[] booleanArray = null;
        QuorumCluster quorumCluster = new QuorumCluster();
        if (this.qHelper.isClusterDefined()) {
            int n;
            QuorumInstance[] quorumInstanceArray = this.qHelper.loadQuorum(quorumCluster);
            int n2 = quorumCluster.getMaxInstances();
            booleanArray = new Boolean[n2];
            for (n = 0; n < n2; ++n) {
                booleanArray[n] = quorumInstanceArray[n] != null ? Boolean.FALSE : null;
            }
            n = this.qHelper.getInteger(22);
            int n3 = this.qHelper.getInteger(23);
            log.debug((Object)("Cluster Interval... " + n));
            log.debug((Object)("Cluster Retries.... " + n3));
            int[] nArray = this.qHelper.getClusterHeartbeat();
            for (int i = 0; i < n3; ++i) {
                log.debug((Object)("Cluster Retries remaining: " + (n3 - i)));
                log.debug((Object)("Sleeping for " + n + " seconds."));
                try {
                    Thread.sleep(n * 1000);
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
                log.debug((Object)"Sampling the cluster heartbeats");
                int[] nArray2 = this.qHelper.getClusterHeartbeat();
                for (int j = 0; j < n2; ++j) {
                    if (nArray[j] == nArray2[j]) continue;
                    booleanArray[j] = Boolean.TRUE;
                }
                nArray = nArray2;
            }
        }
        return booleanArray;
    }

    public boolean isClusterDefined() throws QuorumException {
        if (!new File(this.quorumDevice.getAbsolutePath()).exists()) {
            return false;
        }
        return this.qHelper.isClusterDefined();
    }

    public boolean isConservative() {
        return this.conservative;
    }

    public QuorumInstance[] loadQuorum(QuorumCluster quorumCluster) throws QuorumException {
        return this.qHelper.loadQuorum(quorumCluster);
    }

    private QuorumIdentifiers loadQuorumIdentifiers(QuorumIdentifiers quorumIdentifiers) throws QuorumException {
        if (quorumIdentifiers != null) {
            quorumIdentifiers.setBootUid(this.qHelper.getUid(4));
            quorumIdentifiers.setConfigUid(this.qHelper.getUid(3));
            quorumIdentifiers.setMasterUid(this.qHelper.getUid(1));
            quorumIdentifiers.setQuorumUid(this.qHelper.getUid(2));
        }
        return quorumIdentifiers;
    }

    private QuorumInstance loadQuorumInstance(int n) throws QuorumException {
        QuorumInstance quorumInstance = new QuorumInstance();
        quorumInstance.setInstanceId(this.qHelper.getInteger(n, 6));
        quorumInstance.setName(this.qHelper.getString(n, 14));
        quorumInstance.setInstanceNode(this.qHelper.getString(n, 7));
        quorumInstance.setPrimaryAddress(this.qHelper.getString(n, 8));
        quorumInstance.setPrimaryPortStart(this.qHelper.getString(n, 10));
        quorumInstance.setSecondaryAddress(this.qHelper.getString(n, 9));
        quorumInstance.setSecondaryPortStart(this.qHelper.getString(n, 11));
        quorumInstance.setLogFile(this.qHelper.getString(n, 12));
        quorumInstance.setConfigFile(this.qHelper.getString(n, 16));
        quorumInstance.setInterfacesPath(this.qHelper.getString(n, 17));
        quorumInstance.setTraceflags(this.qHelper.getString(n, 15));
        quorumInstance.setAddlRunParameters(this.qHelper.getString(n, 13));
        return quorumInstance;
    }

    private void loadQuorumStatusValues(QuorumStatus quorumStatus) throws QuorumException {
        quorumStatus.setRunning(new Boolean(this.qHelper.getInteger(19) == 1));
        quorumStatus.setClusterStatus(this.qHelper.getClusterStatus());
        int[] nArray = new int[quorumStatus.getMaxInstances()];
        for (int i = 0; i < quorumStatus.getMaxInstances(); ++i) {
            int n = i + 1;
            nArray[i] = this.qHelper.isInstanceDefined(n) ? this.qHelper.getInstanceStatus(n) : 0;
        }
        quorumStatus.setInstanceStatus(nArray);
    }

    public void registerNode(String string) throws QuorumException {
        this.qHelper.registerNode(string);
    }

    public QuorumCluster saveQuorumCluster(Properties properties) throws QuorumException {
        QuorumCluster quorumCluster = this.getQuorumCluster();
        QuorumCluster quorumCluster2 = (QuorumCluster)quorumCluster.clone();
        quorumCluster2.setProperties(properties);
        return this.saveQuorumCluster(quorumCluster2);
    }

    public QuorumCluster saveQuorumCluster(QuorumCluster quorumCluster) throws QuorumException {
        if (this.qHelper.isClusterDefined()) {
            QuorumCluster quorumCluster2 = this.getQuorumCluster();
            if (quorumCluster2.equals(quorumCluster)) {
                return quorumCluster;
            }
            if (quorumCluster.getMaxInstances() != quorumCluster2.getMaxInstances()) {
                this.qHelper.setValue(2, quorumCluster.getMaxInstances());
            }
            if (quorumCluster.getName().compareTo(quorumCluster2.getName()) != 0) {
                this.qHelper.setValue(1, quorumCluster.getName());
            }
            if (quorumCluster.getMasterDevice().compareTo(quorumCluster2.getMasterDevice()) != 0) {
                this.qHelper.setValue(3, quorumCluster.getMasterDevice());
            }
            if (quorumCluster.getConfigFile().compareTo(quorumCluster2.getConfigFile()) != 0) {
                this.qHelper.setValue(16, quorumCluster.getConfigFile());
            }
            if (quorumCluster.getInterfacesPath().compareTo(quorumCluster2.getInterfacesPath()) != 0) {
                this.qHelper.setValue(17, quorumCluster.getInterfacesPath());
            }
            if (quorumCluster.getTraceflags().compareTo(quorumCluster2.getTraceflags()) != 0) {
                this.qHelper.setValue(15, quorumCluster.getTraceflags());
            }
            if (quorumCluster.getPrimaryNetType().compareTo(quorumCluster2.getPrimaryNetType()) != 0) {
                this.qHelper.setValue(4, quorumCluster.getPrimaryNetType());
            }
            if (quorumCluster.getSecondaryNetType().compareTo(quorumCluster2.getSecondaryNetType()) != 0) {
                this.qHelper.setValue(5, quorumCluster.getSecondaryNetType());
            }
            if (quorumCluster.getAddlRunParameters().compareTo(quorumCluster2.getAddlRunParameters()) != 0) {
                this.qHelper.setValue(13, quorumCluster.getAddlRunParameters());
            }
            quorumCluster.setQuorumIdentifiers(this.loadQuorumIdentifiers(quorumCluster.getQuorumIdentifiers()));
        }
        return quorumCluster;
    }

    public QuorumInstance saveQuorumInstance(int n, Properties properties) throws QuorumException {
        QuorumInstance quorumInstance = this.getQuorumInstance(n);
        QuorumInstance quorumInstance2 = (QuorumInstance)quorumInstance.clone();
        quorumInstance2.setProperties(properties);
        return this.saveQuorumInstance(quorumInstance2);
    }

    public QuorumInstance saveQuorumInstance(QuorumInstance quorumInstance) throws QuorumException {
        if (this.qHelper.isClusterDefined()) {
            int n = quorumInstance.getInstanceId();
            QuorumInstance quorumInstance2 = this.getQuorumInstance(n);
            if (quorumInstance2.equals(quorumInstance)) {
                return quorumInstance;
            }
            if (quorumInstance.getInstanceId() != quorumInstance2.getInstanceId()) {
                this.qHelper.setValue(n, 6, quorumInstance.getInstanceId());
            }
            if (quorumInstance.getName().compareTo(quorumInstance2.getName()) != 0) {
                this.qHelper.setValue(n, 14, quorumInstance.getName());
            }
            if (quorumInstance.getInstanceNode().compareTo(quorumInstance2.getInstanceNode()) != 0) {
                this.qHelper.setValue(n, 7, quorumInstance.getInstanceNode());
            }
            if (quorumInstance.getPrimaryAddress().compareTo(quorumInstance2.getPrimaryAddress()) != 0) {
                this.qHelper.setValue(n, 8, quorumInstance.getPrimaryAddress());
            }
            if (quorumInstance.getPrimaryPortStart().compareTo(quorumInstance2.getPrimaryPortStart()) != 0) {
                this.qHelper.setValue(n, 10, quorumInstance.getPrimaryPortStart());
            }
            if (quorumInstance.getSecondaryAddress().compareTo(quorumInstance2.getSecondaryAddress()) != 0) {
                this.qHelper.setValue(n, 9, quorumInstance.getSecondaryAddress());
            }
            if (quorumInstance.getSecondaryPortStart().compareTo(quorumInstance2.getSecondaryPortStart()) != 0) {
                this.qHelper.setValue(n, 11, quorumInstance.getSecondaryPortStart());
            }
            if (quorumInstance.getLogFile().compareTo(quorumInstance2.getLogFile()) != 0) {
                this.qHelper.setValue(n, 12, quorumInstance.getLogFile());
            }
            if (quorumInstance.getConfigFile().compareTo(quorumInstance2.getConfigFile()) != 0) {
                this.qHelper.setValue(n, 16, quorumInstance.getConfigFile());
            }
            if (quorumInstance.getInterfacesPath().compareTo(quorumInstance2.getInterfacesPath()) != 0) {
                this.qHelper.setValue(n, 17, quorumInstance.getInterfacesPath());
            }
            if (quorumInstance.getTraceflags().compareTo(quorumInstance2.getTraceflags()) != 0) {
                this.qHelper.setValue(n, 15, quorumInstance.getTraceflags());
            }
            if (quorumInstance.getAddlRunParameters().compareTo(quorumInstance2.getAddlRunParameters()) != 0) {
                this.qHelper.setValue(n, 13, quorumInstance.getAddlRunParameters());
            }
        }
        return quorumInstance;
    }

    public void setConservative(boolean bl) {
        this.conservative = bl;
    }

    public void unregisterNode(String string) throws QuorumException {
        this.qHelper.unregisterNode(string);
    }

    public boolean verifyNode(String string) throws QuorumException {
        return this.qHelper.verifyNode(string);
    }
}

