/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.quorum;

import com.sybase.ase.sdcadmin.quorum.QuorumBase;
import com.sybase.ase.sdcadmin.quorum.QuorumIdentifiers;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import java.util.Properties;

public class QuorumCluster
extends QuorumBase
implements Cloneable,
ISdConstants {
    public static final int MAX_INSTANCES = 255;
    private QuorumIdentifiers quorumIdentifiers = null;
    private int maxInstances;
    private String masterDevice;
    private String primaryNetType;
    private String secondaryNetType;

    public int getMaxInstances() {
        return this.maxInstances;
    }

    public void setMaxInstances(int n) {
        this.maxInstances = n;
    }

    public String getMasterDevice() {
        return this.masterDevice;
    }

    public void setMasterDevice(String string) {
        this.masterDevice = string;
    }

    public String getPrimaryNetType() {
        return this.primaryNetType;
    }

    public void setPrimaryNetType(String string) {
        this.primaryNetType = string;
    }

    public String getSecondaryNetType() {
        return this.secondaryNetType;
    }

    public void setSecondaryNetType(String string) {
        this.secondaryNetType = string;
    }

    @Override
    public Properties getProperties() {
        Properties properties = super.getProperties();
        properties.setProperty("MaxInstances", String.valueOf(this.maxInstances));
        properties.setProperty("ClusterName", this.name);
        properties.setProperty("MasterDevice", this.masterDevice);
        properties.setProperty("PrimaryNetTtype", this.primaryNetType);
        properties.setProperty("SecondaryNetTtype", this.secondaryNetType);
        return properties;
    }

    @Override
    public void setProperties(Properties properties) {
        super.setProperties(properties);
        this.maxInstances = Integer.parseInt(properties.getProperty("MaxInstances", String.valueOf(this.maxInstances)));
        this.name = properties.getProperty("ClusterName", this.name);
        this.masterDevice = properties.getProperty("MasterDevice", this.masterDevice);
        this.primaryNetType = properties.getProperty("PrimaryNetTtype", this.primaryNetType);
        this.secondaryNetType = properties.getProperty("SecondaryNetTtype", this.secondaryNetType);
    }

    public Object clone() {
        QuorumCluster quorumCluster = new QuorumCluster();
        this.copy(quorumCluster);
        return quorumCluster;
    }

    public void copy(QuorumCluster quorumCluster) {
        super.copy(quorumCluster);
        quorumCluster.maxInstances = this.maxInstances;
        quorumCluster.name = new String(this.name);
        quorumCluster.masterDevice = new String(this.masterDevice);
        quorumCluster.primaryNetType = new String(this.primaryNetType);
        quorumCluster.secondaryNetType = new String(this.secondaryNetType);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof QuorumCluster) {
            QuorumCluster quorumCluster = (QuorumCluster)object;
            if (quorumCluster.maxInstances == this.maxInstances && quorumCluster.masterDevice.compareTo(this.masterDevice) == 0 && quorumCluster.primaryNetType.compareTo(this.primaryNetType) == 0 && quorumCluster.secondaryNetType.compareTo(this.secondaryNetType) == 0 && super.equals(quorumCluster)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getProperties().toString();
    }

    @Override
    public QuorumIdentifiers getQuorumIdentifiers() {
        return this.quorumIdentifiers;
    }

    @Override
    public void setQuorumIdentifiers(QuorumIdentifiers quorumIdentifiers) {
        this.quorumIdentifiers = quorumIdentifiers;
    }
}

