/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.quorum;

import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.quorum.IQuorumInputFile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QuorumInputFile
implements IQuorumInputFile {
    private static final Log LOG = LogFactory.getLog(QuorumInputFile.class);

    public File writeTemporaryFile(ICluster iCluster, File file) throws Exception, IOException {
        if (iCluster == null) {
            throw new Exception("A null cluster was passed when attempting to write the temporary file.");
        }
        String string = iCluster.getName();
        if (string == null || string.equals("")) {
            throw new Exception("The cluster name can not be null or blank.");
        }
        File file2 = File.createTempFile("QI" + string, ".inp", file);
        LOG.debug((Object)("The Cluster Input File is named: " + file2.getName()));
        boolean bl = false;
        IServer[] iServerArray = iCluster.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            String string2 = iServerArray[i].getConfigFile();
            for (int j = i; j < iServerArray.length; ++j) {
                String string3 = iServerArray[j].getConfigFile();
                if (string2.equals(string3)) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
        this.writeHeader(bufferedWriter, iCluster);
        this.writeSectionHead(bufferedWriter, "cluster");
        this.writeKeyValue(bufferedWriter, "name", iCluster.getName());
        this.writeKeyValue(bufferedWriter, "max instances", iCluster.getMaxInstances().toString());
        this.writeKeyValue(bufferedWriter, "master device", iCluster.getMasterDevice());
        this.writeKeyValue(bufferedWriter, "installation mode", iCluster.getInstallationMode());
        if (!bl) {
            this.writeKeyValue(bufferedWriter, "config file", iCluster.getConfigFile());
        }
        if (iCluster.getInterfacesPath() != null) {
            this.writeKeyValue(bufferedWriter, "interfaces path", iCluster.getInterfacesPath());
        } else {
            this.writeKeyValue(bufferedWriter, "interfaces path", "");
        }
        this.writeKeyValue(bufferedWriter, "traceflags", iCluster.getTraceflagsString());
        this.writeKeyValue(bufferedWriter, "primary protocol", iCluster.getPrimaryInterconnect());
        boolean bl2 = false;
        if (iCluster.getSecondaryInterconnect() != null && !iCluster.getSecondaryInterconnect().equals("")) {
            this.writeKeyValue(bufferedWriter, "secondary protocol", iCluster.getSecondaryInterconnect());
            bl2 = true;
        }
        bufferedWriter.newLine();
        bufferedWriter.flush();
        this.writeSectionHead(bufferedWriter, "management nodes");
        String[] stringArray = iCluster.getNodeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.writeKeyValue(bufferedWriter, "hostname", stringArray[i]);
        }
        bufferedWriter.newLine();
        bufferedWriter.flush();
        IServer[] iServerArray2 = iCluster.getServersArray();
        for (int i = 0; i < iServerArray2.length; ++i) {
            this.writeSectionHead(bufferedWriter, "instance");
            this.writeKeyValue(bufferedWriter, "id", iServerArray2[i].getId().toString());
            this.writeKeyValue(bufferedWriter, "name", iServerArray2[i].getName());
            this.writeKeyValue(bufferedWriter, "node", iServerArray2[i].getNode());
            this.writeKeyValue(bufferedWriter, "primary address", iServerArray2[i].getPrimaryAddress());
            this.writeKeyValue(bufferedWriter, "primary port start", iServerArray2[i].getPrimaryPortStart());
            if (bl2) {
                this.writeKeyValue(bufferedWriter, "secondary address", iServerArray2[i].getSecondaryAddress());
                this.writeKeyValue(bufferedWriter, "secondary port start", iServerArray2[i].getSecondaryPortStart());
            }
            this.writeKeyValue(bufferedWriter, "errorlog", iServerArray2[i].getLogFile());
            if (bl) {
                this.writeKeyValue(bufferedWriter, "config file", iServerArray2[i].getConfigFile());
            }
            if (iServerArray2[i].getInterfacesPath() != null) {
                this.writeKeyValue(bufferedWriter, "interfaces path", iServerArray2[i].getInterfacesPath());
            } else {
                this.writeKeyValue(bufferedWriter, "interfaces path", "");
            }
            this.writeKeyValue(bufferedWriter, "traceflags", iServerArray2[i].getTraceflagsString());
            this.writeKeyValue(bufferedWriter, "additional run parameters", iServerArray2[i].getAddlRunParameters());
            bufferedWriter.newLine();
            bufferedWriter.flush();
        }
        bufferedWriter.close();
        return file2;
    }

    private void writeSectionHead(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write("[" + string + "]" + "\n");
    }

    private void writeHeader(BufferedWriter bufferedWriter, ICluster iCluster) throws IOException {
        bufferedWriter.write("##############################################################################\n");
        bufferedWriter.write("#\n");
        bufferedWriter.write("#       Cluster Input File for Sybase Adaptive Server Enterprise\n");
        bufferedWriter.write("#\n");
        bufferedWriter.write("#               This file was generated by the cluster administration tools to\n");
        bufferedWriter.write("#               populate the configuration information on the cluster quorum device.\n");
        bufferedWriter.write("#               Changes to the contents of this file will not take effect unless\n");
        bufferedWriter.write("#               the file is re-loaded onto the quorum device.\n");
        bufferedWriter.write("#               See the Cluster Administration Guide for more details.\n");
        bufferedWriter.write("#");
        bufferedWriter.write("#       File generation data:\n");
        bufferedWriter.write("#               Cluster Name:" + iCluster.getName() + "\n");
        bufferedWriter.write("#               Quorum Device:" + iCluster.getQuorum() + "\n");
        bufferedWriter.write("#               File Creation Date:" + QuorumInputFile.getDateTimeString() + "\n");
        bufferedWriter.write("#               User: " + QuorumInputFile.getUserName() + "\n");
        bufferedWriter.write("#               Host: " + QuorumInputFile.getHostName() + "\n");
        bufferedWriter.write("#               Description: " + iCluster.getDescription() + "\n");
        bufferedWriter.write("#\n");
        bufferedWriter.write("##############################################################################\n");
        bufferedWriter.write("#\n");
        bufferedWriter.flush();
    }

    private static String getHostName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "<unknown>";
        }
    }

    private static String getUserName() {
        return System.getProperty("user.name");
    }

    private static String getDateTimeString() {
        return DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime());
    }

    private int writeKeyValue(BufferedWriter bufferedWriter, String string, String string2) throws IOException {
        try {
            bufferedWriter.write("\t" + string + " = " + string2 + "\n");
            return 0;
        }
        catch (IOException iOException) {
            LOG.error((Object)("I/O Error while writing the key \"" + string + "\" to the cluster input file."));
            if (iOException.getCause() != null) {
                LOG.debug((Object)iOException.getCause().getLocalizedMessage());
            }
            return 1;
        }
    }
}

