/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.quorum;

import com.sybase.ase.sdcadmin.quorum.QuorumBase;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import java.util.Properties;

public class QuorumInstance
extends QuorumBase
implements Cloneable,
ISdConstants {
    private int instanceId;
    private String instanceNode;
    private String primaryAddress;
    private String primaryPortStart;
    private String secondaryAddress;
    private String secondaryPortStart;
    private String logFile;

    public String getLogFile() {
        return this.logFile;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public String getInstanceNode() {
        return this.instanceNode;
    }

    public String getPrimaryAddress() {
        return this.primaryAddress;
    }

    public String getPrimaryPortStart() {
        return this.primaryPortStart;
    }

    public String getSecondaryAddress() {
        return this.secondaryAddress;
    }

    public String getSecondaryPortStart() {
        return this.secondaryPortStart;
    }

    public void setLogFile(String string) {
        this.logFile = string;
    }

    public void setInstanceId(int n) {
        this.instanceId = n;
    }

    public void setInstanceNode(String string) {
        this.instanceNode = string;
    }

    public void setPrimaryAddress(String string) {
        this.primaryAddress = string;
    }

    public void setPrimaryPortStart(String string) {
        this.primaryPortStart = string;
    }

    public void setSecondaryAddress(String string) {
        this.secondaryAddress = string;
    }

    public void setSecondaryPortStart(String string) {
        this.secondaryPortStart = string;
    }

    @Override
    public Properties getProperties() {
        Properties properties = super.getProperties();
        properties.setProperty("InstanceId", String.valueOf(this.instanceId));
        properties.setProperty("InstanceName", this.name);
        properties.setProperty("NodeName", this.instanceNode);
        properties.setProperty("PrimaryNetAddr", this.primaryAddress);
        properties.setProperty("PrimaryPortStart", this.primaryPortStart);
        if (this.secondaryAddress != null) {
            properties.setProperty("SecondaryNetAddr", this.secondaryAddress);
        }
        if (this.secondaryPortStart != null) {
            properties.setProperty("SecondaryPortStart", this.secondaryPortStart);
        }
        properties.setProperty("ASELogFile", this.logFile);
        return properties;
    }

    @Override
    public void setProperties(Properties properties) {
        super.setProperties(properties);
        this.instanceId = Integer.parseInt(properties.getProperty("InstanceId", String.valueOf(this.instanceId)));
        this.name = properties.getProperty("InstanceName", this.name);
        this.instanceNode = properties.getProperty("NodeName", this.instanceNode);
        this.primaryAddress = properties.getProperty("PrimaryNetAddr", this.primaryAddress);
        this.primaryPortStart = properties.getProperty("PrimaryPortStart", this.primaryPortStart);
        this.secondaryAddress = properties.getProperty("SecondaryNetAddr", this.secondaryAddress);
        this.secondaryPortStart = properties.getProperty("SecondaryPortStart", this.secondaryPortStart);
        this.logFile = properties.getProperty("ASELogFile", this.logFile);
    }

    public Object clone() {
        QuorumInstance quorumInstance = new QuorumInstance();
        super.clone(quorumInstance);
        quorumInstance.instanceId = this.instanceId;
        quorumInstance.name = new String(this.name);
        quorumInstance.instanceNode = new String(this.instanceNode);
        quorumInstance.primaryAddress = new String(this.primaryAddress);
        quorumInstance.primaryPortStart = new String(this.primaryPortStart);
        quorumInstance.secondaryAddress = new String(this.secondaryAddress);
        quorumInstance.secondaryPortStart = new String(this.secondaryPortStart);
        quorumInstance.logFile = new String(this.logFile);
        return quorumInstance;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof QuorumInstance) {
            QuorumInstance quorumInstance = (QuorumInstance)object;
            if (quorumInstance.instanceId == this.instanceId && quorumInstance.instanceNode.compareTo(this.instanceNode) == 0 && quorumInstance.primaryAddress.compareTo(this.primaryAddress) == 0 && quorumInstance.primaryPortStart.compareTo(this.primaryPortStart) == 0 && quorumInstance.secondaryAddress.compareTo(this.secondaryAddress) == 0 && quorumInstance.secondaryPortStart.compareTo(this.secondaryPortStart) == 0 && quorumInstance.logFile.compareTo(this.logFile) == 0 && super.equals(quorumInstance)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getProperties().toString();
    }
}

