/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.quorum;

import com.sybase.ase.sdcadmin.util.ISdConstants;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QuorumStatus
implements ISdConstants {
    private static Log log = LogFactory.getLog(QuorumStatus.class);
    boolean clusterDefined = false;
    private Boolean running = null;
    private int clusterStatus = 1;
    private int[] instanceStatus = null;
    private int maxInstances = 0;

    public QuorumStatus() {
    }

    public QuorumStatus(int n) {
        this.maxInstances = n;
        this.instanceStatus = new int[n];
        for (int i = 0; i < n; ++i) {
            this.instanceStatus[i] = 1;
        }
    }

    public String[] getStatusStrings(ResourceBundle resourceBundle) {
        String[] stringArray = new String[this.maxInstances];
        if (this.instanceStatus != null) {
            for (int i = 0; i < this.instanceStatus.length; ++i) {
                stringArray[i] = resourceBundle.getString(ISdConstants.CLUSTER_STATES_RESOURCE_KEYS[this.instanceStatus[i]]);
            }
        }
        return stringArray;
    }

    public int getClusterStatus() {
        return this.clusterStatus;
    }

    public int[] getInstanceStatus() {
        return this.instanceStatus;
    }

    public int getInstanceStatus(int n) {
        return this.instanceStatus[n - 1];
    }

    public Boolean getRunning() {
        return this.running;
    }

    public Boolean isRunning(int n) {
        return new Boolean(QuorumStatus.isAlive(this.instanceStatus[n - 1]));
    }

    public boolean isClusterDefined() {
        return this.clusterDefined;
    }

    public void setClusterDefined(boolean bl) {
        this.clusterDefined = bl;
    }

    public void setClusterStatus(int n) {
        this.clusterStatus = n;
    }

    public void setInstanceStatus(int[] nArray) {
        this.instanceStatus = nArray;
    }

    public void setRunning(Boolean bl) {
        this.running = bl;
    }

    public int getMaxInstances() {
        return this.maxInstances;
    }

    public static boolean isAlive(int n) {
        return n != 6 && n != 0 && n != 1;
    }

    public void dump() {
        log.debug((Object)"** QuorumStatus Dump **");
        log.debug((Object)("\tCluster Defined: " + this.clusterDefined));
        log.debug((Object)("\tMax Instances:   " + this.maxInstances));
        log.debug((Object)("\tCluster Running: " + this.running));
        log.debug((Object)("\tCluster Status:  " + this.clusterStatus));
        log.debug((Object)("\tInstance Status Count is " + this.instanceStatus.length));
        for (int i = 0; i < this.instanceStatus.length; ++i) {
            log.debug((Object)("\tInstance Status[" + i + "]: " + this.instanceStatus[i]));
        }
    }
}

