/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.sdk;

import com.sybase.ase.sdcadmin.IConstants;
import com.sybase.ase.sdcadmin.config.ClusterConfigException;
import com.sybase.ase.sdcadmin.config.ClusterConfigFactory;
import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.create.SystemTemporaryDatabase;
import com.sybase.ase.sdcadmin.ex.SdClusterException;
import com.sybase.ase.sdcadmin.lang.IResourceConstants;
import com.sybase.ase.sdcadmin.quorum.Quorum;
import com.sybase.ase.sdcadmin.quorum.QuorumException;
import com.sybase.ase.sdcadmin.quorum.QuorumInstance;
import com.sybase.ase.sdcadmin.sdk.AseBackupServer;
import com.sybase.ase.sdcadmin.sdk.AseCfgBase;
import com.sybase.ase.sdcadmin.sdk.AseMonitorServer;
import com.sybase.ase.sdcadmin.sdk.AseXPServer;
import com.sybase.ase.sdcadmin.sdk.DatabaseDevice;
import com.sybase.ase.sdcadmin.sdk.SdClusterBase;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import com.sybase.ase.sdcadmin.util.InterfacesHelper;
import com.sybase.ase.sdcadmin.util.Message;
import com.sybase.ase.sdcadmin.util.PortUtil;
import com.sybase.ase.sdcadmin.util.XMLCluster;
import com.sybase.ua.util.MessageListener;
import com.sybase.ua.util.jdom.JDomUtil;
import com.sybase.util.ds.interfaces.Service;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;

public class AseAddServer
extends AseCfgBase
implements ISdConstants,
IConstants,
IResourceConstants {
    private static final Log LOG = LogFactory.getLog(AseAddServer.class);

    public int addServer(MessageListener messageListener, String string, String string2, String string3, String string4, int n, String string5, String string6, String string7, char[] cArray) throws ClusterConfigException, SdClusterException {
        Document document = null;
        try {
            document = JDomUtil.getDocument((String)string5);
        }
        catch (IOException iOException) {
            LOG.error((Object)iOException);
            this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.cluster.xml.error", this.commandName, string, string2);
            return 10;
        }
        Element element = document.getRootElement();
        ICluster iCluster = ClusterConfigFactory.createCluster(string);
        iCluster = XMLCluster.getCluster(iCluster, element);
        try {
            document = JDomUtil.getDocument((String)string6);
        }
        catch (IOException iOException) {
            LOG.error((Object)iOException);
            this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.cluster.xml.error", this.commandName, string, string2);
            return 10;
        }
        element = document.getRootElement();
        ICluster iCluster2 = ClusterConfigFactory.createCluster(string);
        iCluster2 = XMLCluster.getCluster(iCluster2, element);
        IServer iServer = iCluster2.getServer(string2);
        return this.addServer(messageListener, string, string2, string3, string4, n, iCluster, iServer, string7, cArray);
    }

    public int addServer(MessageListener messageListener, String string, String string2, String string3, String string4, int n, ICluster iCluster, IServer iServer, String string5, char[] cArray) throws ClusterConfigException, SdClusterException {
        Object object;
        Object object2;
        String string6;
        String string7;
        DatabaseDevice[] databaseDeviceArray;
        Object object3;
        Message message = new Message(messageListener);
        if (string == null || string.equals("")) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.input.clustername.error", this.commandName, "", "");
            return 1;
        }
        this.dataSource.setClusterName(string);
        if (string2 == null || string2.equals("")) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.input.servername.error", this.commandName, this.dataSource.getClusterName(), string2);
            return 1;
        }
        this.dataSource.setDataserverName(string2);
        try {
            if (n > 0) {
                this.dataSource.setTimeoutInSeconds(n);
            } else {
                this.dataSource.setTimeoutInSeconds(60);
            }
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.input.timeout.warning", this.commandName, string, string2);
        }
        try {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.start.debug", this.getCommandName(), this.dataSource.getClusterName(), this.dataSource.getInstanceName());
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.timeout.debug", this.commandName, this.dataSource.getClusterName(), this.dataSource.getInstanceName(), new Integer(this.dataSource.getTimeoutInSeconds()));
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.showInfo.warn", this.commandName, string, string2);
        }
        Quorum quorum = this.getQuorum(message, new File(iServer.getAseHome(), "lib"), new File(iCluster.getQuorum()));
        QuorumInstance quorumInstance = new QuorumInstance();
        quorumInstance.setInstanceId(iServer.getId());
        quorumInstance.setName(iServer.getName());
        quorumInstance.setInstanceNode(iServer.getNode());
        quorumInstance.setPrimaryAddress(iServer.getPrimaryAddress());
        quorumInstance.setPrimaryPortStart(iServer.getPrimaryPortStart());
        quorumInstance.setSecondaryAddress(iServer.getSecondaryAddress());
        quorumInstance.setSecondaryPortStart(iServer.getSecondaryPortStart());
        quorumInstance.setLogFile(iServer.getLogFile());
        quorumInstance.setConfigFile(iServer.getConfigFile());
        quorumInstance.setInterfacesPath(iServer.getInterfacesPath());
        quorumInstance.setTraceflags(iServer.getTraceflagsString());
        quorumInstance.setAddlRunParameters(iServer.getAddlRunParameters());
        LOG.debug((Object)("New cluster " + string + " instance " + string2 + " info: " + quorumInstance.toString()));
        try {
            if (quorum.isClusterDefined() && !quorum.verifyNode((quorumInstance = quorum.addQuorumInstance(quorumInstance)).getInstanceNode())) {
                quorum.registerNode(quorumInstance.getInstanceNode());
            }
        }
        catch (QuorumException quorumException) {
            this.sendMessage(message, quorumException, string);
            return 15;
        }
        iCluster.addServer(iServer.getId(), iServer);
        int n2 = this.addInterfacesEntry(message, string, string2, iCluster, iServer, quorum, quorumInstance);
        if (n2 != 0) {
            try {
                quorum.dropQuorumInstance(quorumInstance.getInstanceId());
            }
            catch (QuorumException quorumException) {
                this.sendMessage(message, quorumException, string);
            }
            return n2;
        }
        IServer[] iServerArray = iCluster.getServersArray();
        String string8 = AseAddServer.getInterfacePath(iCluster);
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if (iCluster.getInstallationMode().equals("private") && !iCluster.isLDAPconfigured()) {
            object3 = iServer.getName();
            try {
                for (int i = 0; i < iServerArray.length; ++i) {
                    databaseDeviceArray = new ArrayList();
                    object3 = iServerArray[i].getName();
                    databaseDeviceArray.add("query:" + iServerArray[i].getNode() + ":" + iServerArray[i].getQueryPort() + ":0");
                    databaseDeviceArray.add("master:" + iServerArray[i].getNode() + ":" + iServerArray[i].getQueryPort() + ":0");
                    hashMap.put(object3, databaseDeviceArray);
                }
                string7 = iCluster.getName();
                databaseDeviceArray = new ArrayList();
                for (int i = 0; i < iServerArray.length; ++i) {
                    databaseDeviceArray.add("query:" + iServerArray[i].getNode() + ":" + iServerArray[i].getQueryPort() + ":1");
                }
                hashMap.put(string7, databaseDeviceArray);
            }
            catch (Exception exception) {
                System.out.println(exception);
                LOG.error((Object)exception, (Throwable)exception);
            }
        }
        this.dataSource.setUSER(string3);
        this.dataSource.setPassword(string4);
        object3 = null;
        try {
            LOG.debug((Object)"AseAddServer - Looking for a JDBC connection to the cluster...");
            object3 = this.getClusterJdbcConnection(message, iCluster, this.dataSource, null);
        }
        catch (SdClusterException sdClusterException) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, string, string2, sdClusterException.getMessage());
            try {
                quorum.dropQuorumInstance(quorumInstance.getInstanceId());
            }
            catch (QuorumException quorumException) {
                this.sendMessage(message, quorumException, string);
            }
            return 4;
        }
        n2 = 0;
        if (object3 == null) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.noservers.error", this.commandName, this.dataSource.getClusterName(), "");
            return 4;
        }
        LOG.debug((Object)("AseAddServer - Preparing to notify the cluster of the new instance using a connection to " + this.dataSource.getInstanceName() + "."));
        string7 = iCluster.getPrimaryInterconnect() + " " + iServer.getPrimaryAddress() + " " + iServer.getPrimaryPortStart() + " " + PortUtil.calculatePortEnd(iCluster.getMaxInstances(), iServer.getPrimaryPortStart());
        if (iCluster.getSecondaryInterconnect() != null && !iCluster.getSecondaryInterconnect().equals("")) {
            string7 = string7 + " " + iCluster.getSecondaryInterconnect() + " " + iServer.getSecondaryAddress() + " " + iServer.getSecondaryPortStart() + " " + PortUtil.calculatePortEnd(iCluster.getMaxInstances(), iServer.getSecondaryPortStart());
        }
        try {
            LOG.debug((Object)("AseAddServer - cluster_admin: " + string7));
            this.clusterAdmin(message, iCluster, (Connection)object3, "add_server", string2, iServer.getId(), string7);
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clusteradmin.warn", this.commandName, string, string2);
        }
        databaseDeviceArray = DatabaseDevice.getDevices(messageListener, iCluster, string3, string4, n, (Connection)object3);
        DatabaseDevice databaseDevice = null;
        for (int i = 0; i < databaseDeviceArray.length; ++i) {
            if (!databaseDeviceArray[i].getName().equals(iServer.getTempdbDeviceName())) continue;
            databaseDevice = databaseDeviceArray[i];
        }
        if (databaseDevice == null) {
            this.createTemporaryDevice(message, iServer, (Connection)object3);
        }
        SystemTemporaryDatabase.createTemporaryDatabase(message, this.resourceBundle, iServer, (Connection)object3);
        String string9 = iServer.getXpServerPort();
        InterfacesHelper interfacesHelper = new InterfacesHelper(string8);
        if (string9 != null) {
            if (iCluster.getInstallationMode().equals("private") && !iCluster.isLDAPconfigured()) {
                string6 = null;
                object2 = null;
                object = new ArrayList<String>();
                for (int i = 0; i < iServerArray.length - 1; ++i) {
                    object = new ArrayList();
                    string6 = AseXPServer.makeXPServerName(iServerArray[i].getName());
                    try {
                        object2 = interfacesHelper.getPort(string6);
                    }
                    catch (Exception exception) {
                        message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, string, string6, exception.getMessage());
                    }
                    object.add("query:" + iServerArray[i].getNode() + ":" + (String)object2 + ":0");
                    object.add("master:" + iServerArray[i].getNode() + ":" + (String)object2 + ":0");
                    hashMap.put(string6, object);
                }
                object = new ArrayList();
                string6 = AseXPServer.makeXPServerName(iServer.getName());
                object.add("query:" + iServer.getNode() + ":" + iServer.getXpServerPort() + ":0");
                object.add("master:" + iServer.getNode() + ":" + iServer.getXpServerPort() + ":0");
                hashMap.put(string6, object);
            }
            string6 = AseXPServer.makeXPServerName(iServer.getName());
            object2 = new AseXPServer();
            ((AseXPServer)object2).addXPServerInstance((Connection)object3, iServer, iCluster, string6);
        }
        if ((string6 = iServer.getMonitorServerPort()) != null) {
            if (iCluster.getInstallationMode().equals("private") && !iCluster.isLDAPconfigured()) {
                object2 = null;
                object = null;
                ArrayList<String> arrayList = null;
                for (int i = 0; i < iServerArray.length - 1; ++i) {
                    arrayList = new ArrayList<String>();
                    object2 = AseMonitorServer.makeMonitorServerName(iServerArray[i].getName());
                    try {
                        object = interfacesHelper.getPort((String)object2);
                    }
                    catch (Exception exception) {
                        message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, string, object2, exception.getMessage());
                    }
                    arrayList.add("query:" + iServerArray[i].getNode() + ":" + (String)object + ":0");
                    arrayList.add("master:" + iServerArray[i].getNode() + ":" + (String)object + ":0");
                    hashMap.put(object2, arrayList);
                }
                arrayList = new ArrayList();
                object2 = AseMonitorServer.makeMonitorServerName(iServer.getName());
                arrayList.add("query:" + iServer.getNode() + ":" + iServer.getMonitorServerPort() + ":0");
                arrayList.add("master:" + iServer.getNode() + ":" + iServer.getMonitorServerPort() + ":0");
                hashMap.put(object2, arrayList);
            }
            object2 = new AseMonitorServer();
            ((AseMonitorServer)object2).addMonitorServerInstance((Connection)object3, iServer, iCluster, string3, string4);
        }
        if (iServer.getBackupServerPort() != null) {
            object2 = new AseBackupServer();
            int n3 = ((AseBackupServer)object2).getNumberOfBackupServersDefined((Connection)object3);
            if (n3 > 1) {
                ((AseBackupServer)object2).createBackupServerForInstance(iServer, iCluster, (Connection)object3, string5, cArray);
                if (iCluster.getInstallationMode().equals("private") && !iCluster.isLDAPconfigured()) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    String string10 = null;
                    String string11 = null;
                    for (int i = 0; i < iServerArray.length - 1; ++i) {
                        string10 = ((SdClusterBase)object2).getSrvNetName(message, (Connection)object3, iServerArray[i].getName() + "_BS");
                        try {
                            string11 = interfacesHelper.getPort(string10);
                        }
                        catch (Exception exception) {
                            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, string, string10, exception.getMessage());
                        }
                        arrayList = new ArrayList();
                        arrayList.add("query:" + iServerArray[i].getNode() + ":" + string11 + ":0");
                        arrayList.add("master:" + iServerArray[i].getNode() + ":" + string11 + ":0");
                        hashMap.put(string10, arrayList);
                    }
                    arrayList = new ArrayList();
                    string10 = ((SdClusterBase)object2).getSrvNetName(message, (Connection)object3, iServer.getName() + "_BS");
                    arrayList.add("query:" + iServer.getNode() + ":" + iServer.getBackupServerPort() + ":0");
                    arrayList.add("master:" + iServer.getNode() + ":" + iServer.getBackupServerPort() + ":0");
                    hashMap.put(string10, arrayList);
                }
            } else if (n3 == 1) {
                String string12 = ((SdClusterBase)object2).getSrvNetName(message, (Connection)object3, "SYB_BACKUP");
                try {
                    iCluster.setBackupServerName(string12);
                    ((AseBackupServer)object2).addBackupServerToNode(iCluster, iServer.getNode(), iServer.getBackupServerPort(), string5, cArray);
                }
                catch (Exception exception) {
                    message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, string, string12, exception.getMessage());
                    try {
                        quorum.dropQuorumInstance(quorumInstance.getInstanceId());
                    }
                    catch (QuorumException quorumException) {
                        this.sendMessage(message, quorumException, string);
                    }
                    return 10;
                }
                if (iCluster.getInstallationMode().equals("private") && !iCluster.isLDAPconfigured()) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    try {
                        List list = interfacesHelper.getServices(string12);
                        for (Service service : list) {
                            arrayList.add(service.getType() + ":" + service.getHost() + ":" + service.getPort() + ":0");
                        }
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                        LOG.error((Object)exception, (Throwable)exception);
                    }
                    arrayList.add("query:" + iServer.getNode() + ":" + iServer.getBackupServerPort() + ":0");
                    arrayList.add("master:" + iServer.getNode() + ":" + iServer.getBackupServerPort() + ":0");
                    hashMap.put(string12, arrayList);
                }
            }
        }
        if (iCluster.getInstallationMode().equals("private") && !iCluster.isLDAPconfigured()) {
            InterfacesHelper.addToRemoteInterfaces(iCluster, hashMap, string5, cArray, string8);
        }
        return n2;
    }

    private int addInterfacesEntry(Message message, String string, String string2, ICluster iCluster, IServer iServer, Quorum quorum, QuorumInstance quorumInstance) {
        try {
            InterfacesHelper interfacesHelper = new InterfacesHelper(AseAddServer.getInterfacePath(iCluster));
            interfacesHelper.addInstance(iCluster, string2, iServer.getNode(), iServer.getQueryPort());
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, string, string2, exception.getMessage());
            return 9;
        }
        return 0;
    }

    private int createTemporaryDevice(Message message, IServer iServer, Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("master", "master");
        hashMap.put("sybsystemprocs", "sybsystemprocs");
        hashMap.put("sybsystemdb", "sybsystemdb");
        Statement statement = null;
        try {
            statement = connection.createStatement();
        }
        catch (SQLException sQLException) {
            message.output(this.resourceBundle, "com.sybase.ase.cluster.instance.statement.error", sQLException.getMessage());
            return -123;
        }
        String string = iServer.getTempdbDeviceName().trim();
        if (!hashMap.containsKey(string)) {
            hashMap.put(string, string);
            String string2 = iServer.getTempdbDevicePath().trim();
            String string3 = iServer.getTempdbDeviceSize().trim();
            if ("0123456789".indexOf(string3.charAt(string3.length() - 1)) >= 0) {
                string3 = string3 + "M";
            }
            message.output(this.resourceBundle, "sdcadmin.temporary.device.creation.info", string, string2, string3);
            String string4 = "disk init name='" + string + "',physname='" + string2 + "',size='" + string3 + "'";
            try {
                statement.executeUpdate(string4);
            }
            catch (SQLException sQLException) {
                message.output(this.resourceBundle, "com.sybase.ase.cluster.instance.tempdev.error", sQLException.getMessage(), string);
                return -124;
            }
        }
        try {
            connection.commit();
            statement.close();
        }
        catch (SQLException sQLException) {
            message.output(this.resourceBundle, "com.sybase.ase.cluster.instance.statement.error", sQLException.getMessage());
            return -125;
        }
        return 0;
    }

    public boolean doesHostPortExist(String string, String string2, String string3, boolean bl) throws Exception {
        InterfacesHelper interfacesHelper = new InterfacesHelper(bl ? null : string);
        return interfacesHelper.hostPortEntryExists(string2, string3);
    }
}

