/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.sdk;

import com.sybase.ase.sdcadmin.IConstants;
import com.sybase.ase.sdcadmin.config.ClusterConfigException;
import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.sdk.AseCfgBase;
import com.sybase.ase.sdcadmin.ua.AgentClient;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import com.sybase.ase.sdcadmin.util.InterfacesHelper;
import com.sybase.ase.sdcadmin.util.Message;
import com.sybase.ase.sdcadmin.util.PortUtil;
import com.sybase.ase.sdcadmin.util.XMLCluster;
import com.sybase.ua.util.MessageListener;
import com.sybase.util.ds.interfaces.Service;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AseBackupServer
extends AseCfgBase
implements ISdConstants,
IConstants {
    private static final Log LOG = LogFactory.getLog(AseBackupServer.class);
    private static final int CLEANUP_FLAG_INTERFACES = 1;
    private static final int CLEANUP_FLAG_JDBC_CONNECTION = 2;
    private static final int CLEANUP_FLAG_SYSERVERS = 4;
    private static final int CLEANUP_FLAG_HABACKUP = 8;

    public int createBackupServer(MessageListener messageListener, String string, int n, String string2, String string3, String string4, char[] cArray) throws ClusterConfigException {
        Message message = new Message(messageListener);
        ICluster iCluster = XMLCluster.getICluster(string);
        Connection connection = this.getClusterJdbcConnection(message, iCluster, n, string2, string3);
        if (connection == null) {
            return 4;
        }
        if (iCluster.areMultipleBackupServersPresent()) {
            return this.createMultipleBackupServers(messageListener, iCluster, connection, string4, cArray);
        }
        return this.createSingleBackupServer(message, iCluster, connection, string4, cArray);
    }

    private int createSingleBackupServer(Message message, ICluster iCluster, Connection connection, String string, char[] cArray) {
        int n = 0;
        n = this.setSysserversEntry("SYB_BACKUP", iCluster.getBackupServerName(), connection, true, message);
        if (n != 0) {
            this.cleanUp(iCluster, 2, connection, false);
            return n;
        }
        n = this.setHABackup(connection, true);
        if (n != 0) {
            this.cleanUp(iCluster, 6, connection, false);
            return n;
        }
        String string2 = AseBackupServer.getInterfacePath(iCluster);
        n = this.addInterfaces(iCluster, string2);
        if (n != 0) {
            this.cleanUp(iCluster, 14, connection, false);
            return n;
        }
        IServer[] iServerArray = iCluster.getServersArray();
        if (this.isLocalConfig(iCluster) && !iCluster.isLDAPconfigured()) {
            HashMap hashMap = new HashMap();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (int i = 0; i < iServerArray.length; ++i) {
                String string3 = iServerArray[i].getBackupServerPort();
                if (arrayList2.contains(iServerArray[i].getNode()) || string3 == null) continue;
                String string4 = "master:" + iServerArray[i].getNode() + ":" + string3 + ":0";
                arrayList.add(string4);
                string4 = "query:" + iServerArray[i].getNode() + ":" + string3 + ":0";
                arrayList.add(string4);
                arrayList2.add(iServerArray[i].getNode());
            }
            hashMap.put(iCluster.getBackupServerName(), arrayList);
            n = InterfacesHelper.addToRemoteInterfaces(iCluster, hashMap, string, cArray, string2);
            if (n != 0) {
                this.cleanUp(iCluster, 14, connection, false);
                return n;
            }
        }
        if (!this.isLocalConfig(iCluster)) {
            n = this.createRunFile(iCluster.getName(), iCluster.getBackupServerName(), iCluster.getQuorum(), iCluster.getAseHome(), iCluster.getInterfacesPath(), iCluster.getBackupServerLogFile(), message);
            if (n != 0) {
                this.cleanUp(iCluster, 14, connection, false);
                return n;
            }
        } else {
            for (int i = 0; i < iServerArray.length; ++i) {
                this.createRunFileForInstance(iCluster, iServerArray[i], string, cArray, string2);
            }
        }
        this.cleanUp(iCluster, 2, connection, false);
        return n;
    }

    boolean isLocalConfig(ICluster iCluster) {
        String string = iCluster.getInstallationMode();
        return string != null && string.equalsIgnoreCase("private");
    }

    private int createMultipleBackupServers(MessageListener messageListener, ICluster iCluster, Connection connection, String string, char[] cArray) {
        int n;
        int n2 = 0;
        Message message = new Message(messageListener);
        n2 = this.setSysserversEntry("SYB_BACKUP", iCluster.getBackupServersPolicy(), connection, true, message);
        if (n2 != 0) {
            this.cleanUp(iCluster, 2, connection, false);
            return n2;
        }
        IServer[] iServerArray = iCluster.getServersArray();
        for (n = 0; n < iServerArray.length; ++n) {
            n2 = this.setSysserversEntry(iServerArray[n].getName() + "_BS", iServerArray[n].getBackupServerName(), connection, true, message);
            if (n2 == 0) continue;
            this.cleanUp(iCluster, 6, connection, false);
            return n2;
        }
        n2 = this.setHABackup(connection, true);
        if (n2 != 0) {
            this.cleanUp(iCluster, 6, connection, false);
            return n2;
        }
        n = this.isLocalConfig(iCluster) ? 1 : 0;
        String string2 = AseBackupServer.getInterfacePath(iCluster);
        n2 = this.addInterfaces(iCluster, string2);
        if (n2 != 0) {
            this.cleanUp(iCluster, 14, connection, false);
            return n2;
        }
        if (n != 0 && !iCluster.isLDAPconfigured()) {
            HashMap hashMap = new HashMap();
            for (int i = 0; i < iServerArray.length; ++i) {
                ArrayList<String> arrayList = new ArrayList<String>();
                String string3 = "master:" + iServerArray[i].getNode() + ":" + iServerArray[i].getBackupServerPort() + ":0";
                arrayList.add(string3);
                string3 = "query:" + iServerArray[i].getNode() + ":" + iServerArray[i].getBackupServerPort() + ":0";
                arrayList.add(string3);
                hashMap.put(iServerArray[i].getBackupServerName(), arrayList);
            }
            n2 = InterfacesHelper.addToRemoteInterfaces(iCluster, hashMap, string, cArray, string2);
            if (n2 != 0) {
                this.cleanUp(iCluster, 14, connection, false);
                return n2;
            }
        }
        for (int i = 0; i < iServerArray.length; ++i) {
            n2 = this.createRunFileForInstance(iCluster, iServerArray[i], string, cArray, string2);
            if (n2 == 0) continue;
            this.cleanUp(iCluster, 14, connection, false);
            return n2;
        }
        return n2;
    }

    public int createBackupServerForInstance(IServer iServer, ICluster iCluster, Connection connection, String string, char[] cArray) {
        int n = 0;
        n = this.setSysserversEntry(iServer.getName() + "_BS", iServer.getBackupServerName(), connection, true, this.message);
        if (n != 0) {
            this.cleanUp(iCluster, 6, connection, false);
            return n;
        }
        String string2 = AseBackupServer.getInterfacePath(iCluster);
        InterfacesHelper interfacesHelper = new InterfacesHelper(string2);
        try {
            interfacesHelper.addEntry(iServer.getBackupServerName(), iServer.getNode(), iServer.getBackupServerPort());
        }
        catch (Exception exception) {
            this.cleanUp(iCluster, 6, connection, false);
            return 9;
        }
        this.createRunFileForInstance(iCluster, iServer, string, cArray, string2);
        return n;
    }

    int createRunFileForInstance(ICluster iCluster, IServer iServer, String string, char[] cArray, String string2) {
        if (iCluster.areMultipleBackupServersPresent()) {
            return this.createRunFileForInstance(iCluster.getName(), iServer.getBackupServerName(), iCluster.getQuorum(), iServer.getAseHome(), string2, iServer.getBackupServerLogFile(), iServer.getNode(), iServer.getAgentPort(), string, cArray, this.isLocalConfig(iCluster));
        }
        return this.createRunFileForInstance(iCluster.getName(), iCluster.getBackupServerName(), iCluster.getQuorum(), iCluster.getAseHome(), string2, iCluster.getBackupServerLogFile(), iServer.getNode(), iServer.getAgentPort(), string, cArray, this.isLocalConfig(iCluster));
    }

    int createRunFileForInstance(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, char[] cArray, boolean bl) {
        int n = 0;
        if (PortUtil.isThisHost(string7) || !bl) {
            n = this.createRunFile(string, string2, string3, string4, string5, string6, this.message);
            if (n != 0) {
                return n;
            }
        } else {
            Object[] objectArray = new Object[]{"_BS", string, string2, string3, string4, null, string5, string6, null, null, null};
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "com.sybase.ua.util.MessageListener"};
            try {
                AgentClient agentClient = new AgentClient(string, string7, string8, string9, cArray);
                n = (Integer)agentClient.invokeAseClusterMethod("createRunFile", objectArray, stringArray);
            }
            catch (Exception exception) {
                System.out.println(exception);
                LOG.error((Object)exception, (Throwable)exception);
                return 7;
            }
        }
        return n;
    }

    public int dropBackupServer(MessageListener messageListener, String string, int n, String string2, String string3, String string4, char[] cArray) throws ClusterConfigException {
        String string5;
        int n2;
        int n3 = 0;
        Message message = new Message(messageListener);
        ICluster iCluster = XMLCluster.getICluster(string);
        Connection connection = this.getClusterJdbcConnection(message, iCluster, n, string2, string3);
        if (connection == null) {
            return 4;
        }
        n3 = this.setHABackup(connection, false);
        if (n3 != 0) {
            this.cleanUp(iCluster, 2, connection, false);
            return n3;
        }
        IServer[] iServerArray = iCluster.getServersArray();
        if (this.getNumberOfBackupServersDefined(message, string, n, string2, string3) > 1) {
            iCluster.setMultipleBackupServersPresent(true);
        }
        if (iCluster.areMultipleBackupServersPresent()) {
            for (n2 = 0; n2 < iServerArray.length; ++n2) {
                string5 = iServerArray[n2].getName() + "_BS";
                iServerArray[n2].setBackupServerName(this.getSrvNetName(message, connection, string5));
                n3 = this.setSysserversEntry(string5, string5, connection, false, message);
                if (n3 == 0) continue;
                this.cleanUp(iCluster, 10, connection, false);
                return n3;
            }
        }
        if ((n3 = this.setSysserversEntry("SYB_BACKUP", "SYB_BACKUP", connection, false, message)) != 0) {
            this.cleanUp(iCluster, 10, connection, false);
            return n3;
        }
        n2 = this.isLocalConfig(iCluster) ? 1 : 0;
        try {
            string5 = AseBackupServer.getInterfacePath(iCluster);
            this.deleteInterfaces(iCluster, string5);
            if (n2 != 0 && !iCluster.isLDAPconfigured()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (!iCluster.areMultipleBackupServersPresent()) {
                    arrayList.add(iCluster.getBackupServerName());
                } else {
                    for (int i = 0; i < iServerArray.length; ++i) {
                        arrayList.add(iServerArray[i].getBackupServerName());
                    }
                }
                n3 = InterfacesHelper.deleteFromRemoteInterfaces(iCluster, arrayList, string4, cArray, string5);
                if (n3 != 0) {
                    this.cleanUp(iCluster, 14, connection, false);
                    return n3;
                }
            }
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, iCluster.getName(), iCluster.getBackupServerName(), exception.getMessage());
            this.cleanUp(iCluster, 14, connection, false);
            return 9;
        }
        this.cleanUp(iCluster, 2, connection, false);
        if (!iCluster.areMultipleBackupServersPresent() && n2 == 0) {
            this.deleteRunFile(iCluster.getBackupServerName(), iCluster.getAseHome());
        } else {
            for (int i = 0; i < iServerArray.length; ++i) {
                this.deleteRunFileForInstance(iCluster, iServerArray[i], string4, cArray, messageListener);
            }
        }
        if (iCluster.areMultipleBackupServersPresent()) {
            for (int i = 0; i < iServerArray.length; ++i) {
                this.shutdownServer(connection, iServerArray[i].getBackupServerName());
            }
        } else {
            this.shutdownServer(connection, iCluster.getBackupServerName());
        }
        return n3;
    }

    void dropBackupServerForInstance(ICluster iCluster, IServer iServer, Connection connection, String string, char[] cArray, MessageListener messageListener) throws Exception {
        String string2 = iServer.getName() + "_BS";
        String string3 = this.getSrvNetName(this.message, connection, string2);
        this.setSysserversEntry(string2, string2, connection, true, this.message);
        this.interfacesHelper = new InterfacesHelper(AseBackupServer.getInterfacePath(iCluster));
        this.interfacesHelper.deleteEntry(string3);
        this.deleteRunFileForInstance(iCluster, iServer, string, cArray, messageListener);
        this.shutdownServer(connection, string3);
    }

    int deleteRunFileForInstance(ICluster iCluster, IServer iServer, String string, char[] cArray, MessageListener messageListener) {
        String string2;
        int n = 0;
        String string3 = iCluster.areMultipleBackupServersPresent() ? iServer.getBackupServerName() : iCluster.getBackupServerName();
        boolean bl = this.isLocalConfig(iCluster);
        String string4 = string2 = bl ? iServer.getAseHome() : iCluster.getAseHome();
        if (bl && !PortUtil.isThisHost(iServer.getNode())) {
            String string5 = iServer.getNode();
            String string6 = iServer.getAgentPort();
            Object[] objectArray = new Object[]{"_BS", string3, string2, messageListener};
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "com.sybase.ua.util.MessageListener"};
            try {
                AgentClient agentClient = new AgentClient(iCluster.getName(), string5, string6, string, cArray);
                n = (Integer)agentClient.invokeAseClusterMethod("deleteRunFile", objectArray, stringArray);
            }
            catch (Exception exception) {
                System.out.println(exception);
                LOG.error((Object)exception, (Throwable)exception);
                return 7;
            }
        } else {
            this.deleteRunFile(string3, string2);
        }
        return n;
    }

    public int addBackupServerToNodes(ICluster iCluster, HashMap hashMap, int n, String string, String string2, String string3, char[] cArray) throws Exception {
        Object object;
        String string4;
        String string5 = this.getBackupServerName(this.message, iCluster, n, string, string2);
        iCluster.setBackupServerName(string5);
        Iterator iterator = hashMap.keySet().iterator();
        HashMap hashMap2 = new HashMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            string4 = (String)iterator.next();
            object = (String)hashMap.get(string4);
            this.addBackupServerToNode(iCluster, string4, (String)object, string3, cArray);
            if (!this.isLocalConfig(iCluster) || iCluster.isLDAPconfigured()) continue;
            arrayList.add("query:" + string4 + ":" + (String)object + ":0");
            arrayList.add("master:" + string4 + ":" + (String)object + ":0");
        }
        if (this.isLocalConfig(iCluster) && !iCluster.isLDAPconfigured()) {
            string4 = AseBackupServer.getInterfacePath(iCluster);
            this.interfacesHelper = new InterfacesHelper(string4);
            object = this.interfacesHelper.getServices(string5);
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                Service service = (Service)iterator2.next();
                arrayList.add(service.getType() + ":" + service.getHost() + ":" + service.getPort() + ":0");
            }
            hashMap2.put(string5, arrayList);
            InterfacesHelper.addToRemoteInterfaces(iCluster, hashMap2, string3, cArray, string4);
        }
        return 0;
    }

    public int addBackupServerToNode(ICluster iCluster, String string, String string2, String string3, char[] cArray) throws Exception {
        String string4 = AseBackupServer.getInterfacePath(iCluster);
        this.interfacesHelper = new InterfacesHelper(string4);
        String string5 = iCluster.getBackupServerName();
        if (!this.interfacesHelper.serviceExists(string5, string, string2)) {
            IServer iServer;
            this.interfacesHelper.addServiceToServer(string5, "master", string, string2);
            this.interfacesHelper.addServiceToServer(string5, "query", string, string2);
            if (this.isLocalConfig(iCluster) && (iServer = this.getInstanceOnNode(iCluster, string)) != null) {
                this.createRunFileForInstance(iCluster, iServer, string3, cArray, string4);
            }
        }
        return 0;
    }

    private IServer getInstanceOnNode(ICluster iCluster, String string) {
        IServer[] iServerArray = iCluster.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            if (!PortUtil.isSameHost(iServerArray[i].getNode(), string)) continue;
            return iServerArray[i];
        }
        return null;
    }

    public int removeBackupServerFromNode(ICluster iCluster, String string, int n, String string2, String string3, String string4, char[] cArray) throws ClusterConfigException {
        String string5 = this.getBackupServerName(this.message, iCluster, n, string2, string3);
        iCluster.setBackupServerName(string5);
        String string6 = AseBackupServer.getInterfacePath(iCluster);
        try {
            this.interfacesHelper = new InterfacesHelper(string6);
            List list = this.interfacesHelper.getServices(string5);
            String string7 = null;
            for (int i = 0; i < list.size(); ++i) {
                Service service = (Service)list.get(i);
                if (!PortUtil.isSameHost(service.getHost(), string)) continue;
                string7 = service.getPort();
                break;
            }
            if (string7 != null) {
                this.interfacesHelper.dropServiceFromServer(string5, "master", string, string7);
                this.interfacesHelper.dropServiceFromServer(string5, "query", string, string7);
                if (this.isLocalConfig(iCluster)) {
                    this.deleteRunFileForInstance(iCluster, this.getInstanceOnNode(iCluster, string), string4, cArray, null);
                }
            }
        }
        catch (Exception exception) {
            this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, string5, exception.getMessage());
            return 9;
        }
        return 0;
    }

    public String getBackupServerName(Message message, String string, int n, String string2, String string3) throws ClusterConfigException {
        ICluster iCluster = XMLCluster.getICluster(string);
        return this.getBackupServerName(message, iCluster, n, string2, string3);
    }

    public String getBackupServerName(Message message, ICluster iCluster, int n, String string, String string2) throws ClusterConfigException {
        String string3 = null;
        if (iCluster.areMultipleBackupServersPresent()) {
            return null;
        }
        Connection connection = this.getClusterJdbcConnection(message, iCluster, n, string, string2);
        if (connection != null) {
            string3 = this.getSrvNetName(message, connection, "SYB_BACKUP");
        }
        return string3;
    }

    public boolean isBackupServerActive(Message message, String string, int n, String string2, String string3) throws ClusterConfigException {
        LOG.debug((Object)"AseBackupServer - isBackupServerActive - begins");
        boolean bl = false;
        LOG.debug((Object)"AseBackupServer - isBackupServerActive");
        ICluster iCluster = XMLCluster.getICluster(string);
        Connection connection = this.getClusterJdbcConnection(message, iCluster, n, string2, string3);
        if (connection != null) {
            bl = this.isBackupServerActive(connection);
        }
        LOG.debug((Object)("AseBackupServer - isBackupServerActive completed - Returns " + bl));
        return bl;
    }

    public int getNumberOfBackupServersDefined(Message message, String string, int n, String string2, String string3) {
        ICluster iCluster = XMLCluster.getICluster(string);
        Connection connection = this.getClusterJdbcConnection(message, iCluster, n, string2, string3);
        if (connection != null) {
            return this.getNumberOfBackupServersDefined(connection);
        }
        return 0;
    }

    public int getNumberOfBackupServersDefined(Connection connection) {
        String string;
        if (connection != null && (string = this.getSrvNetName(this.message, connection, "SYB_BACKUP")) != null && !string.equalsIgnoreCase("SYB_BACKUP")) {
            if (string.equalsIgnoreCase("$DEDICATED") || string.equalsIgnoreCase("$ROUNDROBIN")) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public List getBackupServerNodes(String string, Message message, int n, String string2, String string3) throws Exception {
        ICluster iCluster = XMLCluster.getICluster(string);
        LOG.debug((Object)"AseBackupServer - getBackupServerNodes - begins");
        if (this.interfacesHelper == null) {
            this.interfacesHelper = new InterfacesHelper(AseBackupServer.getInterfacePath(iCluster));
        }
        String string4 = this.getBackupServerName(message, string, n, string2, string3);
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = this.interfacesHelper.getServices(string4);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Service service = (Service)list.get(i);
                if (arrayList.contains(service.getHost())) continue;
                arrayList.add(service.getHost());
            }
        }
        LOG.debug((Object)"AseBackupServer - getBackupServerNodes - returns");
        return arrayList;
    }

    public String getBackupserverPoperties(ICluster iCluster, String string, String string2, Message message) throws ClusterConfigException {
        Connection connection = this.getClusterJdbcConnection(message, iCluster, this.timeoutInSeconds, string, string2);
        if (connection != null) {
            String string3 = this.getSrvNetName(message, connection, "SYB_BACKUP");
            InterfacesHelper interfacesHelper = new InterfacesHelper(AseBackupServer.getInterfacePath(iCluster));
            if (string3 != null && !string3.equalsIgnoreCase("SYB_BACKUP") && (string3.equalsIgnoreCase("$DEDICATED") || string3.equalsIgnoreCase("$ROUNDROBIN"))) {
                iCluster.setMultipleBackupServersPresent(true);
                iCluster.setBackupServersPolicy(string3);
                IServer[] iServerArray = iCluster.getServersArray();
                for (int i = 0; i < iServerArray.length; ++i) {
                    String string4 = this.getSrvNetName(message, connection, iServerArray[i].getName() + "_BS");
                    String string5 = null;
                    try {
                        string5 = interfacesHelper.getPort(string4);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                    iServerArray[i].setBackupServerName(string4);
                    iServerArray[i].setBackupServerPort(string5);
                }
            }
        }
        return XMLCluster.getXMLClusterString(iCluster);
    }

    public void setMultipleBackupServerProperties(String string, String string2, String string3, String string4, char[] cArray, Message message) {
        ICluster iCluster = XMLCluster.getICluster(string);
        Connection connection = this.getClusterJdbcConnection(message, iCluster, this.timeoutInSeconds, string2, string3);
        if (connection != null) {
            String string5 = AseBackupServer.getInterfacePath(iCluster);
            InterfacesHelper interfacesHelper = new InterfacesHelper(string5);
            if (iCluster.areMultipleBackupServersPresent()) {
                String string6 = this.getSrvNetName(message, connection, "SYB_BACKUP");
                if (!string6.equalsIgnoreCase(iCluster.getBackupServersPolicy())) {
                    this.setSysserversEntry("SYB_BACKUP", iCluster.getBackupServersPolicy(), connection, true, message);
                }
                IServer[] iServerArray = iCluster.getServersArray();
                boolean bl = this.isLocalConfig(iCluster);
                HashMap hashMap = new HashMap();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < iServerArray.length; ++i) {
                    String string7 = iServerArray[i].getBackupServerName();
                    try {
                        String string8 = interfacesHelper.getPort(string7);
                        String string9 = iServerArray[i].getNode();
                        if (string8.equalsIgnoreCase(iServerArray[i].getBackupServerPort())) continue;
                        interfacesHelper.deleteEntry(string7);
                        interfacesHelper.addEntry(string7, string9, iServerArray[i].getBackupServerPort());
                        if (!bl) continue;
                        arrayList.add(string7);
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        String string10 = "master:" + string9 + ":" + iServerArray[i].getBackupServerPort() + ":0";
                        arrayList2.add(string10);
                        string10 = "query:" + string9 + ":" + iServerArray[i].getBackupServerPort() + ":0";
                        arrayList2.add(string10);
                        hashMap.put(string7, arrayList2);
                        continue;
                    }
                    catch (Exception exception) {
                        message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, string7, exception.getMessage());
                    }
                }
                if (bl && !iCluster.isLDAPconfigured() && arrayList.size() != 0) {
                    InterfacesHelper.deleteFromRemoteInterfaces(iCluster, arrayList, string4, cArray, string5);
                    InterfacesHelper.addToRemoteInterfaces(iCluster, hashMap, string4, cArray, string5);
                }
            }
        }
    }

    private int addInterfaces(ICluster iCluster, String string) {
        int n = 0;
        this.interfacesHelper = new InterfacesHelper(string);
        if (!iCluster.areMultipleBackupServersPresent()) {
            boolean bl = false;
            try {
                bl = this.interfacesHelper.entryExists(iCluster.getBackupServerName());
            }
            catch (Exception exception) {
                this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, iCluster.getName(), iCluster.getBackupServerName(), exception.getMessage());
                return 9;
            }
            if (!bl) {
                try {
                    this.interfacesHelper.addBackupServer(iCluster);
                }
                catch (Exception exception) {
                    this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, iCluster.getName(), iCluster.getBackupServerName(), exception.getMessage());
                    n = 9;
                }
            }
        } else {
            IServer[] iServerArray = iCluster.getServersArray();
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < iServerArray.length; ++i) {
                try {
                    bl = this.interfacesHelper.entryExists(iServerArray[i].getBackupServerName());
                    if (!bl) {
                        this.interfacesHelper.addEntry(iServerArray[i].getBackupServerName(), iServerArray[i].getNode(), iServerArray[i].getBackupServerPort());
                    } else {
                        bl2 = true;
                    }
                }
                catch (Exception exception) {
                    this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, iServerArray[i].getName(), iServerArray[i].getBackupServerName(), exception.getMessage());
                    bl2 = true;
                }
                if (!bl2) continue;
                for (int j = 0; j < i; ++j) {
                    try {
                        this.interfacesHelper.deleteEntry(iServerArray[j].getBackupServerName());
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                        LOG.error((Object)exception, (Throwable)exception);
                    }
                }
                return 9;
            }
        }
        return n;
    }

    private void cleanUp(ICluster iCluster, int n, Connection connection, boolean bl) {
        this.cleanUp(iCluster, n, connection, bl, null, new char[0]);
    }

    private void cleanUp(ICluster iCluster, int n, Connection connection, boolean bl, String string, char[] cArray) {
        Object object;
        int n2;
        IServer[] iServerArray = iCluster.getServersArray();
        if ((n & 4) != 0) {
            try {
                this.setSysserversEntry("SYB_BACKUP", "SYB_BACKUP", connection, bl, this.message);
                if (iCluster.areMultipleBackupServersPresent()) {
                    for (n2 = 0; n2 < iServerArray.length; ++n2) {
                        object = iServerArray[n2].getName() + "_BS";
                        this.setSysserversEntry((String)object, (String)object, connection, bl, this.message);
                    }
                }
            }
            catch (Exception exception) {
                LOG.error((Object)exception);
            }
        }
        if ((n & 8) != 0) {
            try {
                this.setHABackup(connection, bl);
            }
            catch (Exception exception) {
                LOG.error((Object)exception);
            }
        }
        if ((n & 2) != 0) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                LOG.debug((Object)sQLException);
            }
        }
        if ((n & 1) != 0) {
            n2 = this.isLocalConfig(iCluster);
            if (n2 == 0 || iCluster.isLDAPconfigured()) {
                if (bl) {
                    this.addInterfaces(iCluster, iCluster.getInterfacesPath());
                } else {
                    this.deleteInterfaces(iCluster, iCluster.getInterfacesPath());
                }
            } else if (!bl) {
                int n3;
                object = new ArrayList();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (n3 = 0; n3 < iServerArray.length; ++n3) {
                    object.add(iServerArray[n3].getBackupServerName());
                }
                for (n3 = 0; n3 < iServerArray.length; ++n3) {
                    Object[] objectArray = new Object[]{iServerArray[n3].getInterfacesPath(), object, null};
                    String[] stringArray = new String[]{"java.lang.String", "java.util.List", "com.sybase.ua.util.MessageListener"};
                    if (PortUtil.isThisHost(iServerArray[n3].getNode())) {
                        if (arrayList.contains(iServerArray[n3].getInterfacesPath())) continue;
                        arrayList.add(iServerArray[n3].getInterfacesPath());
                        this.deleteInterfaces(iCluster, iServerArray[n3].getInterfacesPath());
                        continue;
                    }
                    String string2 = iServerArray[n3].getNode();
                    String string3 = iServerArray[1].getAgentPort();
                    try {
                        AgentClient agentClient = new AgentClient(iCluster.getName(), string2, string3, string, cArray);
                        ((Integer)agentClient.invokeAseClusterMethod("deleteFromInterfaces", objectArray, stringArray)).intValue();
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                        LOG.error((Object)exception, (Throwable)exception);
                    }
                }
            }
        }
    }

    private int deleteInterfaces(ICluster iCluster, String string) {
        int n = 0;
        this.interfacesHelper = new InterfacesHelper(string);
        try {
            if (iCluster.areMultipleBackupServersPresent()) {
                IServer[] iServerArray = iCluster.getServersArray();
                for (int i = 0; i < iServerArray.length; ++i) {
                    this.interfacesHelper.deleteEntry(iServerArray[i].getBackupServerName());
                }
            } else {
                this.interfacesHelper.deleteEntry(iCluster.getBackupServerName());
            }
        }
        catch (Exception exception) {
            this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, iCluster.getName(), iCluster.getBackupServerName(), exception.getMessage());
            n = 9;
        }
        return n;
    }

    private boolean isBackupServerActive(Connection connection) {
        boolean bl = false;
        String string = this.getSrvNetName(this.message, connection, "SYB_BACKUP");
        if (string != null && !"SYB_BACKUP".equalsIgnoreCase(string)) {
            bl = true;
        }
        return bl;
    }

    private int setHABackup(Connection connection, boolean bl) {
        int n = 0;
        if (this.isConfigParamAvailable(this.message, connection, "enable backupserver HA")) {
            LOG.debug((Object)("AseBackupServerServer - Preparing to activate the \"enable backupserver HA\" with sp_configure using a connection to " + this.dataSource.getInstanceName() + "."));
            int n2 = 1;
            if (!bl) {
                n2 = 0;
            }
            n = this.callSpConfigure(this.message, connection, "enable backupserver HA", n2);
        } else {
            LOG.error((Object)"INTERNAL ERROR - The sysconfigures parameter \"enable backupserver HA\" is not implemented in this dataserver version.");
        }
        return n;
    }

    public int setSysserversEntry(String string, String string2, Connection connection, boolean bl, Message message) {
        String string3 = this.getSrvNetName(message, connection, string);
        if (string3 == null) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.missing.sysserver.entry.error", "SYB_BACKUP");
            return 10;
        }
        if (string3.equals(string2)) {
            return 0;
        }
        try {
            LOG.debug((Object)("AseBackupServerServer - Preparing to modify syservers by calling sp_addserver using an instance using a connection to " + this.dataSource.getInstanceName() + "."));
            CallableStatement callableStatement = connection.prepareCall("sp_addserver ?,?,?");
            callableStatement.clearWarnings();
            callableStatement.setString(1, string);
            if (bl) {
                callableStatement.setString(2, "rpcserver");
                callableStatement.setString(3, string2);
            } else {
                callableStatement.setNull(2, 12);
                callableStatement.setString(3, string);
            }
            callableStatement.executeUpdate();
            callableStatement.close();
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.sql.error", this.commandName, this.dataSource.getClusterName(), this.dataSource.getInstanceName(), "sp_addserver ?,?,?(" + string + "," + "rpcserver" + "," + string2 + ")", exception.getMessage());
            return 5;
        }
        return 0;
    }

    private static String getHostName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "<unknown>";
        }
    }

    private static String getUserName() {
        return System.getProperty("user.name");
    }

    private static String getDateTimeString() {
        return DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime());
    }

    public int createRunFile(String string, String string2, String string3, String string4, String string5, String string6, Message message) {
        File file = new File(string4, "bin");
        File file2 = new File(file, "backupserver");
        String string7 = System.getProperty("line.separator");
        File file3 = this.makeRunfileName(string2, string4);
        if (file3.exists()) {
            this.deleteRunFile(string2, string4);
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file3));
            bufferedWriter.write("#!/bin/sh" + string7);
            bufferedWriter.write("##############################################################################" + string7);
            bufferedWriter.write("#" + string7);
            bufferedWriter.write("#       Cluster Backup Server RUN file for Sybase Adaptive Server Enterprise" + string7);
            bufferedWriter.write("#" + string7);
            bufferedWriter.write("#               This file was generated by the cluster administration tools to" + string7);
            bufferedWriter.write("#               define the startup of the backup server.\n");
            bufferedWriter.write("#" + string7);
            bufferedWriter.write("#       File generation data:" + string7);
            bufferedWriter.write("#               Cluster Name:" + string + string7);
            bufferedWriter.write("#               Quorum Device:" + string3 + string7);
            bufferedWriter.write("#               File Creation Date:" + AseBackupServer.getDateTimeString() + string7);
            bufferedWriter.write("#               User: " + AseBackupServer.getUserName() + string7);
            bufferedWriter.write("#               Host: " + AseBackupServer.getHostName() + string7);
            bufferedWriter.write("#" + string7);
            bufferedWriter.write("##############################################################################" + string7);
            bufferedWriter.write("#" + string7);
            bufferedWriter.flush();
            bufferedWriter.write(file2.getAbsolutePath() + " \\" + string7);
            bufferedWriter.write("-S" + string2 + " \\" + string7);
            if (string6 == null) {
                bufferedWriter.write("-e" + string4 + "/install/" + string2 + ".log" + " \\" + string7);
            } else if (string6.indexOf(File.separator) == -1) {
                bufferedWriter.write("-e" + string4 + "/install/" + string6 + " \\" + string7);
            } else {
                bufferedWriter.write("-e" + string6 + " \\" + string7);
            }
            if (string5 != null) {
                bufferedWriter.write("-I" + InterfacesHelper.getInterfacePathspec(string5) + " \\" + string7);
            }
            File file4 = new File(file, "sybmultbuf");
            bufferedWriter.write("-M" + file4.getAbsolutePath() + " \\" + string7);
            bufferedWriter.write("-N25 \\" + string7);
            bufferedWriter.write("-C20" + string7 + string7);
            bufferedWriter.flush();
            bufferedWriter.close();
            Runtime.getRuntime().exec("chmod u+x " + file3.getAbsolutePath());
        }
        catch (IOException iOException) {
            message.output(this.resourceBundle, "runfile.backupserver.io.error", this.commandName, this.dataSource.getClusterName(), this.dataSource.getInstanceName(), iOException.getMessage());
            return 3;
        }
        return 0;
    }

    public int deleteRunFile(String string, String string2) {
        File file = this.makeRunfileName(string, string2);
        if (file.exists()) {
            file.delete();
        }
        return 0;
    }

    private File makeRunfileName(String string, String string2) {
        File file = new File(string2, "install");
        File file2 = new File(file, "RUN_" + string);
        return file2;
    }
}

