/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.sdk;

import com.sybase.ase.sdcadmin.config.ClusterConfigException;
import com.sybase.ase.sdcadmin.config.ClusterConfigFactory;
import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.ex.SdClusterException;
import com.sybase.ase.sdcadmin.sdk.AseCfgBase;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import com.sybase.ase.sdcadmin.util.Message;
import com.sybase.ase.sdcadmin.util.PortUtil;
import com.sybase.ase.sdcadmin.util.XMLCluster;
import com.sybase.ua.util.MessageListener;
import com.sybase.ua.util.jdom.JDomUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;

public class AseDiagnose
extends AseCfgBase
implements ISdConstants {
    private static final Log LOG = LogFactory.getLog(AseDiagnose.class);

    public int diagnoseCluster(MessageListener messageListener, String string, String string2, String string3, int n, String string4) throws ClusterConfigException {
        try {
            int n2;
            int n3;
            Message message = new Message(messageListener);
            if (string == null || string.equals("")) {
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.input.clustername.error", this.commandName, "", "");
                return 1;
            }
            Document document = null;
            try {
                document = JDomUtil.getDocument((String)string4);
            }
            catch (IOException iOException) {
                LOG.error((Object)iOException);
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.cluster.xml.error", this.commandName, string, "");
                return 10;
            }
            Element element = document.getRootElement();
            ICluster iCluster = ClusterConfigFactory.createCluster(string);
            iCluster = XMLCluster.getCluster(iCluster, element);
            IServer[] iServerArray = iCluster.getServersArray();
            String string5 = this.resourceBundle.getString("sdcadmin.display.yes");
            String string6 = this.resourceBundle.getString("sdcadmin.display.no");
            message.output(this.resourceBundle, "sdcadmin.display.newline");
            message.output(this.resourceBundle, "sdcadmin.diagnose.info.cluster.name", iCluster.getName());
            message.output(this.resourceBundle, "sdcadmin.display.newline");
            message.output(this.resourceBundle, "sdcadmin.diagnose.info.maxinstances", iCluster.getMaxInstances());
            message.output(this.resourceBundle, "sdcadmin.diagnose.info.number.nodes", new Integer(iCluster.getNodeCount()));
            message.output(this.resourceBundle, "sdcadmin.diagnose.info.number.instances", new Integer(iServerArray.length));
            int n4 = iCluster.getStatus();
            message.output(this.resourceBundle, "sdcadmin.diagnose.info.cluster.locked", n4 == 6 || n4 == 0 || n4 == 1 ? string6 : string5);
            message.output(this.resourceBundle, "sdcadmin.display.newline");
            for (n3 = 0; n3 < iServerArray.length; ++n3) {
                message.output(this.resourceBundle, "sdcadmin.diagnose.info.jdbc.connection", iServerArray[n3].getId(), iServerArray[n3].getName(), this.canContactInstance(iCluster, iServerArray[n3], string2, string3, this.timeoutInSeconds) ? string5 : string6);
            }
            message.output(this.resourceBundle, "sdcadmin.display.newline");
            for (n3 = 0; n3 < iServerArray.length; ++n3) {
                String string7 = "";
                String string8 = "";
                n2 = 0;
                try {
                    InetAddress inetAddress = InetAddress.getByName(iServerArray[n3].getNode());
                    string8 = inetAddress.getHostAddress();
                    n2 = 1;
                }
                catch (UnknownHostException unknownHostException) {
                    string7 = unknownHostException.getMessage();
                }
                message.output(this.resourceBundle, "sdcadmin.diagnose.info.network.address", iServerArray[n3].getId(), iServerArray[n3].getName(), iServerArray[n3].getNode(), string8, n2 != 0 ? string5 : string6, string7);
            }
            message.output(this.resourceBundle, "sdcadmin.display.newline");
            n3 = PortUtil.hasPrivateNetwork(iCluster) ? 1 : 0;
            message.output(this.resourceBundle, "sdcadmin.diagnose.info.private.primary.network", n3 != 0 ? string5 : string6);
            boolean bl = false;
            if (n3 != 0) {
                bl = PortUtil.hasSecondaryNetwork(iCluster);
            }
            message.output(this.resourceBundle, "sdcadmin.diagnose.info.private.secondary.network", bl ? string5 : string6);
            int n5 = PortUtil.getPortsRequiredPerInstancePerInterconnect(iCluster);
            message.output(this.resourceBundle, "sdcadmin.diagnose.info.private.port.required", new Integer(n5));
            message.output(this.resourceBundle, "sdcadmin.diagnose.info.port.minimum", String.valueOf(1025));
            message.output(this.resourceBundle, "sdcadmin.diagnose.info.port.maximum", String.valueOf(65535));
            message.output(this.resourceBundle, "sdcadmin.display.newline");
            n2 = PortUtil.getCurrentPortStrategy(iCluster);
            message.output(this.resourceBundle, "sdcadmin.diagnose.info.port.current.strategy", PortUtil.getPortStrategyString(this.resourceBundle, n2));
            message.output(this.resourceBundle, "sdcadmin.display.newline");
            int n6 = PortUtil.getRecommendedPortStrategy(iCluster);
            message.output(this.resourceBundle, "sdcadmin.diagnose.info.port.recommended.strategy", PortUtil.getPortStrategyString(this.resourceBundle, n6));
            message.output(this.resourceBundle, "sdcadmin.display.newline");
        }
        catch (Exception exception) {
            LOG.error((Object)exception);
            if (LOG.isDebugEnabled()) {
                System.out.println(exception);
                LOG.debug((Object)exception, (Throwable)exception);
            }
            throw new ClusterConfigException("sdcadmin.diagnose.exception.error", exception.getMessage());
        }
        return 0;
    }

    public int diagnoseInstance(MessageListener messageListener, String string, String string2, String string3, String string4, int n, String string5) throws ClusterConfigException {
        try {
            Message message = new Message(messageListener);
            if (string == null || string.equals("")) {
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.input.clustername.error", this.commandName, "", string2);
                return 1;
            }
            Document document = null;
            try {
                document = JDomUtil.getDocument((String)string5);
            }
            catch (IOException iOException) {
                LOG.error((Object)iOException);
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.cluster.xml.error", this.commandName, string, string2);
                return 10;
            }
            Element element = document.getRootElement();
            ICluster iCluster = ClusterConfigFactory.createCluster(string);
            iCluster = XMLCluster.getCluster(iCluster, element);
            IServer iServer = iCluster.getServer(string2);
            if (iServer == null) {
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.cluster.notfound.error", this.commandName, string, string2);
                return 10;
            }
            String string6 = this.resourceBundle.getString("sdcadmin.display.yes");
            String string7 = this.resourceBundle.getString("sdcadmin.display.no");
            message.output(this.resourceBundle, "sdcadmin.display.newline");
            message.output(this.resourceBundle, "sdcadmin.diagnose.info.cluster.name", iCluster.getName());
            message.output(this.resourceBundle, "sdcadmin.diagnose.info.instance.id", iServer.getId());
            message.output(this.resourceBundle, "sdcadmin.diagnose.info.instance.name", iServer.getName());
            message.output(this.resourceBundle, "sdcadmin.diagnose.info.node.name", iServer.getNode());
            message.output(this.resourceBundle, "sdcadmin.diagnose.info.query.port", iServer.getQueryPort());
            message.output(this.resourceBundle, "sdcadmin.display.newline");
            message.output(this.resourceBundle, "sdcadmin.diagnose.info.jdbc.connection", this.canContactInstance(iCluster, iServer, string3, string4, this.timeoutInSeconds) ? string6 : string7, "", "");
            message.output(this.resourceBundle, "sdcadmin.display.newline");
            boolean bl = false;
            String string8 = "";
            String string9 = "";
            try {
                InetAddress inetAddress = InetAddress.getByName(iServer.getNode());
                string8 = inetAddress.getHostAddress();
                bl = true;
            }
            catch (UnknownHostException unknownHostException) {
                string9 = unknownHostException.getMessage();
            }
            message.output(this.resourceBundle, "sdcadmin.diagnose.info.network.address", iServer.getId(), iServer.getName(), iServer.getNode(), string8, bl ? string6 : string7, string9);
            message.output(this.resourceBundle, "sdcadmin.display.newline");
            message.output(this.resourceBundle, "sdcadmin.diagnose.info.port.minimum", String.valueOf(1025));
            message.output(this.resourceBundle, "sdcadmin.diagnose.info.port.maximum", String.valueOf(65535));
            message.output(this.resourceBundle, "sdcadmin.display.newline");
        }
        catch (Exception exception) {
            LOG.error((Object)exception);
            throw new ClusterConfigException("sdcadmin.diagnose.exception.error", exception.getMessage());
        }
        return 0;
    }

    private boolean canContactInstance(ICluster iCluster, IServer iServer, String string, String string2, int n) {
        this.dataSource.setClusterName(iCluster.getName());
        this.dataSource.setUSER(string);
        this.dataSource.setPassword(string2);
        this.dataSource.setServerName(iServer.getNode());
        this.dataSource.setPortNumber(Integer.parseInt(iServer.getQueryPort()));
        this.dataSource.setTimeoutInSeconds(n);
        Connection connection = null;
        try {
            connection = AseDiagnose.getJdbcConnection(this.dataSource);
        }
        catch (SdClusterException sdClusterException) {
            return false;
        }
        if (connection == null) {
            return false;
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return true;
    }
}

