/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.sdk;

import com.sybase.ase.sdcadmin.IAgentConstants;
import com.sybase.ase.sdcadmin.IConstants;
import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.sdk.AseCfgBase;
import com.sybase.ase.sdcadmin.sdk.DatabaseDevice;
import com.sybase.ase.sdcadmin.ua.AgentClient;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import com.sybase.ase.sdcadmin.util.InterfacesHelper;
import com.sybase.ase.sdcadmin.util.Message;
import com.sybase.ase.sdcadmin.util.PortUtil;
import com.sybase.ua.util.MessageListener;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AseDropCluster
extends AseCfgBase
implements ISdConstants,
IConstants,
IAgentConstants {
    private static final Log LOG = LogFactory.getLog(AseDropCluster.class);

    public int dropCluster(MessageListener messageListener, ICluster iCluster, DatabaseDevice[] databaseDeviceArray, String string, char[] cArray, int n) {
        int n2;
        int n3 = 0;
        Message message = new Message(messageListener);
        IServer[] iServerArray = iCluster.getServersArray();
        String string2 = iCluster.getName();
        if (string2 == null || string2.equals("")) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.input.clustername.error", this.commandName, "", "");
            return 1;
        }
        if ((n & 4) != 0) {
            for (n2 = 0; n2 < iServerArray.length; ++n2) {
                if (iCluster.getInstallationMode().equalsIgnoreCase("shared") || PortUtil.isThisHost(iServerArray[n2].getNode())) {
                    this.deleteDevice(message, iServerArray[n2].getLogFile());
                    continue;
                }
                this.deleteRemoteFile(string2, iServerArray[n2].getLogFile(), iServerArray[n2].getNode(), iServerArray[n2].getAgentPort(), string, cArray, message);
            }
        }
        if ((n & 2) != 0) {
            for (n2 = 0; n2 < databaseDeviceArray.length; ++n2) {
                this.deleteDevice(message, databaseDeviceArray[n2].getDevicePath());
            }
        }
        if ((n & 1) != 0) {
            this.deleteDevice(message, iCluster.getQuorum());
        }
        if ((n & 0x10) != 0) {
            if (iCluster.getInstallationMode().equalsIgnoreCase("shared")) {
                this.deleteDevice(message, iCluster.getConfigFile());
            } else {
                for (n2 = 0; n2 < iServerArray.length; ++n2) {
                    if (PortUtil.isThisHost(iServerArray[n2].getNode())) {
                        this.deleteDevice(message, iServerArray[n2].getConfigFile());
                        continue;
                    }
                    this.deleteRemoteFile(string2, iServerArray[n2].getConfigFile(), iServerArray[n2].getNode(), iServerArray[n2].getAgentPort(), string, cArray, message);
                }
            }
        }
        String[] stringArray = null;
        if ((n & 8) != 0) {
            stringArray = new String[iServerArray.length + 1];
            for (int i = 0; i < iServerArray.length; ++i) {
                stringArray[i] = iServerArray[i].getName();
            }
            stringArray[i] = string2;
        } else {
            stringArray = new String[]{};
        }
        String string3 = AseDropCluster.getInterfacePath(iCluster);
        try {
            InterfacesHelper interfacesHelper = new InterfacesHelper(string3);
            interfacesHelper.dropCluster(string2, stringArray);
            if (iCluster.getInstallationMode().equals("private") && !iCluster.isLDAPconfigured()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList.add(stringArray[i]);
                }
                InterfacesHelper.deleteFromRemoteInterfaces(iCluster, arrayList, string, cArray, string3);
            }
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, string2, exception.getMessage());
            return 10;
        }
        return n3;
    }

    private int deleteDevice(Message message, String string) {
        LOG.debug((Object)("Request to delete the file " + string));
        File file = new File(string);
        if (file.exists()) {
            if (file.isFile()) {
                LOG.debug((Object)("Deleting the regular file: " + file.getAbsolutePath()));
                message.output(this.resourceBundle, "sdcadmin.file.delete.info", file.getAbsolutePath());
                if (!file.delete()) {
                    message.output(this.resourceBundle, "sdcadmin.device.delete.error", file.getAbsolutePath());
                }
            } else {
                if (file.isDirectory()) {
                    message.output(this.resourceBundle, "sdcadmin.device.directory.error", file.getAbsolutePath());
                    return -128;
                }
                LOG.debug((Object)("File: " + file.getAbsolutePath() + " is most likely a raw device."));
            }
        }
        return 0;
    }

    void deleteRemoteFile(String string, String string2, String string3, String string4, String string5, char[] cArray, Message message) {
        Object object;
        if (!(null != string2 && 0 != string2.length() || null != (object = new File(string2)) && ((File)object).exists())) {
            return;
        }
        try {
            object = new AgentClient(string, string3, string4, string5, cArray);
            ((AgentClient)object).deleteFile(string2);
            message.output(this.resourceBundle, "sdcadmin.file.delete.info", string2);
        }
        catch (Exception exception) {
            LOG.debug((Object)exception.getMessage());
            message.output(this.resourceBundle, "sdcadmin.device.delete.error", string2);
        }
    }
}

