/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.sdk;

import com.sybase.ase.sdcadmin.config.ClusterConfigException;
import com.sybase.ase.sdcadmin.config.ClusterConfigFactory;
import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.ex.SdClusterException;
import com.sybase.ase.sdcadmin.quorum.Quorum;
import com.sybase.ase.sdcadmin.quorum.QuorumException;
import com.sybase.ase.sdcadmin.sdk.AseBackupServer;
import com.sybase.ase.sdcadmin.sdk.AseCfgBase;
import com.sybase.ase.sdcadmin.sdk.AseMonitorServer;
import com.sybase.ase.sdcadmin.sdk.AseXPServer;
import com.sybase.ase.sdcadmin.sdk.DatabaseDevice;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import com.sybase.ase.sdcadmin.util.InterfacesHelper;
import com.sybase.ase.sdcadmin.util.Message;
import com.sybase.ase.sdcadmin.util.XMLCluster;
import com.sybase.ua.util.MessageListener;
import com.sybase.ua.util.jdom.JDomUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;

public class AseDropServer
extends AseCfgBase
implements ISdConstants {
    private static final Log LOG = LogFactory.getLog(AseDropServer.class);

    public int dropServer(MessageListener messageListener, String string, String string2, String string3, String string4, int n, String string5, String string6, char[] cArray) throws ClusterConfigException, SdClusterException {
        AseBackupServer aseBackupServer;
        int n2;
        Message message = new Message(messageListener);
        if (string2 == null || string2.equals("")) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.input.servername.error", this.commandName, "", string2);
            return 1;
        }
        if (string == null || string.equals("")) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.input.clustername.error", this.commandName, "", string2);
            return 1;
        }
        this.dataSource.setClusterName(string);
        try {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.start.debug", this.commandName, this.dataSource.getClusterName(), string2);
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.showInfo.warn", this.commandName, string, string2);
        }
        Document document = null;
        try {
            document = JDomUtil.getDocument((String)string5);
        }
        catch (IOException iOException) {
            LOG.error((Object)iOException);
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.cluster.xml.error", this.commandName, string, string2);
            return 10;
        }
        Element element = document.getRootElement();
        ICluster iCluster = ClusterConfigFactory.createCluster(string);
        iCluster = XMLCluster.getCluster(iCluster, element);
        IServer iServer = iCluster.getServer(string2);
        if (iServer == null) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.cluster.notfound.error", this.commandName, string, string2);
            return 10;
        }
        int n3 = iServer.getId();
        try {
            LOG.debug((Object)("Removing instance " + string2 + " from the cluster " + string + " configuration in memory. "));
            iCluster.dropServer(string2);
        }
        catch (ClusterConfigException clusterConfigException) {
            message.output(this.resourceBundle, clusterConfigException.getMessage(), clusterConfigException.getArgs());
            return 10;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        this.dataSource.setClusterName(string);
        this.dataSource.setUSER(string3);
        this.dataSource.setPassword(string4);
        this.dataSource.setTimeoutInSeconds(this.timeoutInSeconds);
        Connection connection = null;
        try {
            connection = this.getClusterJdbcConnection(message, iCluster, this.dataSource, null);
        }
        catch (SdClusterException sdClusterException) {
            message.output(this.resourceBundle, sdClusterException.getMessage(), sdClusterException.getArgs());
            return 4;
        }
        int n4 = 0;
        if (connection == null) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.noservers.error", this.commandName, this.dataSource.getClusterName(), "");
            return 7;
        }
        try {
            DatabaseDevice.dropLstDatabase(message, connection, n3);
        }
        catch (SQLException sQLException) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.droplstdb.error", this.commandName, string, string2, sQLException.getMessage());
            return 5;
        }
        Object object = this.getQuorum(message, new File(iServer.getAseHome(), "lib"), new File(iCluster.getQuorum()));
        try {
            if (((Quorum)object).isClusterDefined()) {
                ((Quorum)object).dropQuorumInstance(n3);
            }
        }
        catch (QuorumException quorumException) {
            if (quorumException.getCause() != null && quorumException.getCause() != quorumException) {
                message.output(this.resourceBundle, "sdcadmin.sdk.qrmdropinstance.error", this.commandName, string, string2, quorumException.getMessage(), quorumException.getCause());
                LOG.error((Object)quorumException);
                LOG.error((Object)quorumException.getCause());
                throw new ClusterConfigException("sdcadmin.sdk.qrmdropinstance.error", quorumException, this.commandName, string, string2, quorumException.getMessage(), quorumException.getCause());
            }
            message.output(this.resourceBundle, "sdcadmin.sdk.qrmdropinstance.error", this.commandName, string, string2, quorumException.getMessage(), "");
            LOG.error((Object)quorumException);
            throw new ClusterConfigException("sdcadmin.sdk.qrmdropinstance.error", quorumException, this.commandName, string, string2, quorumException.getMessage(), "");
        }
        ISdConstants iSdConstants = new AseXPServer();
        Boolean[] booleanArray = ((AseXPServer)iSdConstants).isXPServerActive(message, string5, n, string3, string4);
        boolean bl = false;
        if (booleanArray != null) {
            for (int i = 0; i < booleanArray.length; ++i) {
                if (booleanArray[i] == null || !booleanArray[i].booleanValue()) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            String string7 = AseXPServer.makeXPServerName(string2);
            ((AseXPServer)iSdConstants).dropXPServerInstance(connection, iServer, iCluster, string7);
            if (iCluster.getInstallationMode().equals("private") && !iCluster.isLDAPconfigured()) {
                arrayList.add(string7);
            }
        }
        bl = false;
        AseMonitorServer aseMonitorServer = new AseMonitorServer();
        Boolean[] booleanArray2 = aseMonitorServer.isMonitorServerActive(message, string5);
        if (booleanArray2 != null) {
            for (int i = 0; i < booleanArray2.length; ++i) {
                if (booleanArray2[i] == null || !booleanArray2[i].booleanValue()) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            aseMonitorServer.dropMonitorServerInstance(iServer, iCluster, connection);
            if (iCluster.getInstallationMode().equals("private") && !iCluster.isLDAPconfigured()) {
                String string8 = AseMonitorServer.makeMonitorServerName(iServer.getName());
                arrayList.add(string8);
            }
        }
        if ((n2 = (aseBackupServer = new AseBackupServer()).getNumberOfBackupServersDefined(connection)) > 1) {
            String string9 = aseBackupServer.getSrvNetName(message, connection, iServer.getName() + "_BS");
            iServer.setBackupServerName(string9);
            try {
                aseBackupServer.dropBackupServerForInstance(iCluster, iServer, connection, string6, cArray, messageListener);
            }
            catch (Exception exception) {
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, string, string2, exception.getMessage());
                return 9;
            }
            if (iCluster.getInstallationMode().equals("private") && !iCluster.isLDAPconfigured()) {
                arrayList.add(string9);
            }
        } else if (n2 == 1) {
            boolean bl2 = false;
            IServer[] iServerArray = iCluster.getServersArray();
            for (int i = 0; i < iServerArray.length; ++i) {
                if (iServerArray[i].getName().equalsIgnoreCase(iServer.getName()) || !iServerArray[i].getNode().equalsIgnoreCase(iServer.getNode())) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                aseBackupServer.removeBackupServerFromNode(iCluster, iServer.getNode(), n, string3, string4, string6, cArray);
                if (iCluster.getInstallationMode().equals("private") && !iCluster.isLDAPconfigured()) {
                    String string10 = aseBackupServer.getSrvNetName(message, connection, "SYB_BACKUP");
                    arrayList.add(string10 + ":" + iServer.getNode());
                }
            }
        }
        try {
            this.clusterAdmin(message, iCluster, connection, "drop_server", string2, n3, null);
            LOG.debug((Object)("select cluster_admin(\"drop_server\", " + n3 + ", null)"));
        }
        catch (SQLException sQLException) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clusteradmin.error", this.commandName, string, string2);
            message.output(this.resourceBundle, "sdcadmin.sqlexception.message.error", sQLException.getMessage());
            return 5;
        }
        object = AseDropServer.getInterfacePath(iCluster);
        try {
            iSdConstants = new InterfacesHelper((String)object);
            ((InterfacesHelper)iSdConstants).dropInstance(iCluster, iServer.getName(), iServer.getNode(), iServer.getQueryPort());
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, string, string2, exception.getMessage());
            return 10;
        }
        if (iCluster.getInstallationMode().equals("private") && !iCluster.isLDAPconfigured()) {
            arrayList.add(iServer.getName());
            InterfacesHelper.deleteFromRemoteInterfaces(iCluster, arrayList, string6, cArray, (String)object);
        }
        return n4;
    }
}

