/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.sdk;

import com.sybase.ase.sdcadmin.IConstants;
import com.sybase.ase.sdcadmin.config.ClusterConfigException;
import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.sdk.AseCfgBase;
import com.sybase.ase.sdcadmin.ua.AgentClient;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import com.sybase.ase.sdcadmin.util.InterfacesHelper;
import com.sybase.ase.sdcadmin.util.Message;
import com.sybase.ase.sdcadmin.util.PortUtil;
import com.sybase.ase.sdcadmin.util.XMLCluster;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AseMonitorServer
extends AseCfgBase
implements ISdConstants,
IConstants {
    private static final Log LOG = LogFactory.getLog(AseMonitorServer.class);
    private static final int CLEANUP_FLAG_JDBC_CONNECTION = 1;
    private static final int CLEANUP_FLAG_INTERFACES = 2;
    private static final int CLEANUP_FLAG_RUN_FILES = 4;

    public int createMonitorServer(Message message, String string, int n, String string2, String string3, String string4, char[] cArray) throws ClusterConfigException {
        int n2 = 0;
        ICluster iCluster = XMLCluster.getICluster(string);
        IServer[] iServerArray = iCluster.getServersArray();
        Connection connection = this.getClusterJdbcConnection(message, iCluster, n, string2, string3);
        if (connection == null) {
            return 4;
        }
        if (!this.isStoredProcedureAvailable(message, connection, "mon_rpc_attach")) {
            message.output(this.resourceBundle, "sdcadmin.installmon.warn", this.commandName, iCluster.getName(), "", "INSTALLMON");
        }
        if ((n2 = this.addAllInterfaces(iCluster, iServerArray, string4, cArray)) != 0) {
            this.cleanUp(3, iCluster, iServerArray, connection, false, string4, cArray);
            return n2;
        }
        n2 = this.createRunFiles(iCluster, iServerArray, string2, string3, string4, cArray);
        if (n2 != 0) {
            this.cleanUp(3, iCluster, iServerArray, connection, false, string4, cArray);
        }
        return n2;
    }

    public int configureMonitorServer(ICluster iCluster, IServer iServer, String string, String string2) {
        Connection connection = this.getClusterJdbcConnection(this.message, iCluster, this.timeoutInSeconds, string, string2);
        if (connection == null) {
            return 4;
        }
        if (!this.isStoredProcedureAvailable(this.message, connection, "mon_rpc_attach")) {
            this.message.output(this.resourceBundle, "sdcadmin.installmon.warn", this.commandName, iCluster.getName(), "", "INSTALLMON");
        }
        String string3 = AseMonitorServer.makeMonitorServerName(iServer.getName());
        this.createRunFile(iCluster.getName(), string3, iCluster.getQuorum(), iServer.getAseHome(), iServer.getSybaseHome(), iServer.getName(), iServer.getInterfacesPath(), iServer.getMonitorServerLogFile(), string, string2, this.message);
        return 0;
    }

    int addMonitorServerInstance(Connection connection, IServer iServer, ICluster iCluster, String string, String string2) {
        int n = 0;
        if (!this.isStoredProcedureAvailable(this.message, connection, "mon_rpc_attach")) {
            this.message.output(this.resourceBundle, "sdcadmin.installmon.warn", this.commandName, iCluster.getName(), "", "INSTALLMON");
        }
        this.addInterfaces(iCluster, iServer);
        String string3 = AseMonitorServer.makeMonitorServerName(iServer.getName());
        this.createRunFile(iCluster.getName(), string3, iCluster.getQuorum(), iServer.getAseHome(), iServer.getSybaseHome(), iServer.getName(), iServer.getInterfacesPath(), iServer.getMonitorServerLogFile(), string, string2, this.message);
        return n;
    }

    public int dropMonitorServer(Message message, String string, String string2, String string3, String string4, char[] cArray) throws ClusterConfigException {
        int n = 0;
        ICluster iCluster = XMLCluster.getICluster(string);
        IServer[] iServerArray = iCluster.getServersArray();
        try {
            this.deleteAllInterfaces(iCluster, iServerArray, string4, cArray);
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, iCluster.getName(), "", exception.getMessage());
            return 10;
        }
        n = this.deleteRunFiles(iCluster, iServerArray);
        Connection connection = this.getClusterJdbcConnection(message, iCluster, this.timeoutInSeconds, string2, string3);
        if (connection == null) {
            return 4;
        }
        for (int i = 0; i < iServerArray.length; ++i) {
            this.shutdownServer(connection, AseMonitorServer.makeMonitorServerName(iServerArray[i].getName()));
        }
        return n;
    }

    int dropMonitorServerInstance(IServer iServer, ICluster iCluster, Connection connection) {
        int n = 0;
        this.deleteInterfaces(iCluster, iServer);
        String string = AseMonitorServer.makeMonitorServerName(iServer.getName());
        String string2 = iServer.getAseHome();
        if (string2 == null) {
            string2 = iCluster.getAseHome();
        }
        this.deleteRunFile(string, string2);
        this.shutdownServer(connection, string);
        return n;
    }

    public static String makeMonitorServerName(String string) {
        return string.trim() + "_MS";
    }

    public Boolean[] isMonitorServerActive(Message message, String string) throws ClusterConfigException {
        ICluster iCluster = XMLCluster.getICluster(string);
        IServer[] iServerArray = iCluster.getServersArray();
        Boolean[] booleanArray = new Boolean[iCluster.getMaxInstances().intValue()];
        for (int i = 0; i < iServerArray.length; ++i) {
            String string2 = AseMonitorServer.makeMonitorServerName(iServerArray[i].getName());
            if (this.interfacesHelper == null) {
                this.interfacesHelper = new InterfacesHelper(AseMonitorServer.getInterfacePath(iCluster));
            }
            boolean bl = false;
            try {
                bl = this.interfacesHelper.entryExists(string2);
            }
            catch (Exception exception) {
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, iCluster.getName(), string2, exception.getMessage());
            }
            if (bl) {
                booleanArray[iServerArray[i].getId().intValue() - 1] = Boolean.TRUE;
                LOG.debug((Object)("MonitorServer: " + string2 + " was defined."));
                continue;
            }
            booleanArray[iServerArray[i].getId().intValue() - 1] = Boolean.FALSE;
            LOG.debug((Object)("MonitorServer: " + string2 + " was not defined."));
        }
        return booleanArray;
    }

    private int addInterfaces(ICluster iCluster, IServer iServer) {
        int n = 0;
        String string = AseMonitorServer.makeMonitorServerName(iServer.getName());
        if (this.interfacesHelper == null) {
            this.interfacesHelper = new InterfacesHelper(AseMonitorServer.getInterfacePath(iCluster));
        }
        boolean bl = false;
        try {
            bl = this.interfacesHelper.entryExists(string);
        }
        catch (Exception exception) {
            this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, iCluster.getName(), string, exception.getMessage());
            return 9;
        }
        if (bl) {
            try {
                this.interfacesHelper.deleteEntry(string);
            }
            catch (Exception exception) {
                this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, iCluster.getName(), string, exception.getMessage());
                n = 9;
            }
        }
        try {
            this.interfacesHelper.addEntry(AseMonitorServer.makeMonitorServerName(iServer.getName()), iServer.getNode(), iServer.getMonitorServerPort());
        }
        catch (Exception exception) {
            this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, iCluster.getName(), string, exception.getMessage());
            n = 9;
        }
        return n;
    }

    private int addAllInterfaces(ICluster iCluster, IServer[] iServerArray, String string, char[] cArray) {
        int n = 0;
        for (int i = 0; i < iServerArray.length; ++i) {
            n = this.addInterfaces(iCluster, iServerArray[i]);
            if (n == 0) continue;
            this.deleteAllInterfaces(iCluster, iServerArray, string, cArray);
            break;
        }
        if (iCluster.getInstallationMode().equals("private") && !iCluster.isLDAPconfigured()) {
            String string2 = AseMonitorServer.getInterfacePath(iCluster);
            HashMap hashMap = new HashMap();
            for (int i = 0; i < iServerArray.length; ++i) {
                String string3 = AseMonitorServer.makeMonitorServerName(iServerArray[i].getName());
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("query:" + iServerArray[i].getNode() + ":" + iServerArray[i].getMonitorServerPort() + ":0");
                arrayList.add("master:" + iServerArray[i].getNode() + ":" + iServerArray[i].getMonitorServerPort() + ":0");
                hashMap.put(string3, arrayList);
            }
            InterfacesHelper.addToRemoteInterfaces(iCluster, hashMap, string, cArray, string2);
        }
        return n;
    }

    private void cleanUp(int n, ICluster iCluster, IServer[] iServerArray, Connection connection, boolean bl, String string, char[] cArray) {
        if ((n & 1) != 0) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                LOG.debug((Object)sQLException);
            }
        }
        if ((n & 2) != 0) {
            if (bl) {
                this.addAllInterfaces(iCluster, iServerArray, string, cArray);
            } else {
                this.deleteAllInterfaces(iCluster, iServerArray, string, cArray);
            }
        }
    }

    private int deleteInterfaces(ICluster iCluster, IServer iServer) {
        int n = 0;
        String string = AseMonitorServer.makeMonitorServerName(iServer.getName());
        if (this.interfacesHelper == null) {
            this.interfacesHelper = new InterfacesHelper(AseMonitorServer.getInterfacePath(iCluster));
        }
        boolean bl = false;
        try {
            bl = this.interfacesHelper.entryExists(string);
        }
        catch (Exception exception) {
            this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, iCluster.getName(), string, exception.getMessage());
            return 9;
        }
        if (bl) {
            try {
                this.interfacesHelper.deleteEntry(string);
            }
            catch (Exception exception) {
                this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, iCluster.getName(), string, exception.getMessage());
                n = 9;
            }
        }
        return n;
    }

    private int deleteAllInterfaces(ICluster iCluster, IServer[] iServerArray, String string, char[] cArray) {
        int n = 0;
        for (int i = 0; i < iServerArray.length; ++i) {
            n = this.deleteInterfaces(iCluster, iServerArray[i]);
            if (n == 0) continue;
            this.addAllInterfaces(iCluster, iServerArray, string, cArray);
            break;
        }
        if (iCluster.getInstallationMode().equals("private") && !iCluster.isLDAPconfigured()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = AseMonitorServer.getInterfacePath(iCluster);
            for (int i = 0; i < iServerArray.length; ++i) {
                String string3 = AseMonitorServer.makeMonitorServerName(iServerArray[i].getName());
                arrayList.add(string3);
            }
            InterfacesHelper.deleteFromRemoteInterfaces(iCluster, arrayList, string, cArray, string2);
        }
        return n;
    }

    private int createRunFiles(ICluster iCluster, IServer[] iServerArray, String string, String string2, String string3, char[] cArray) {
        int n = 0;
        String string4 = AseMonitorServer.getInterfacePath(iCluster);
        for (int i = 0; i < iServerArray.length; ++i) {
            String string5;
            if (PortUtil.isThisHost(iServerArray[i].getNode()) || !iCluster.getInstallationMode().equals("private")) {
                string5 = AseMonitorServer.makeMonitorServerName(iServerArray[i].getName());
                n = this.createRunFile(iCluster.getName(), string5, iCluster.getQuorum(), iServerArray[i].getAseHome(), iServerArray[i].getSybaseHome(), iServerArray[i].getName(), string4, iServerArray[i].getMonitorServerLogFile(), string, string2, this.message);
                if (n == 0) continue;
                this.deleteRunFiles(iCluster, iServerArray);
                break;
            }
            string5 = iServerArray[i].getNode();
            String string6 = iServerArray[i].getAgentPort();
            this.createRunFileOnRemoteHost(iCluster, iServerArray[i], string5, string6, string, string2, string3, cArray);
        }
        return n;
    }

    private int deleteRunFiles(ICluster iCluster, IServer[] iServerArray) {
        String string;
        int n = 0;
        for (int i = 0; i < iServerArray.length && (n = this.deleteRunFile(string = AseMonitorServer.makeMonitorServerName(iServerArray[i].getName()), iServerArray[i].getAseHome())) == 0; ++i) {
        }
        return n;
    }

    private void createRunFileOnRemoteHost(ICluster iCluster, IServer iServer, String string, String string2, String string3, String string4, String string5, char[] cArray) {
        AgentClient agentClient = new AgentClient();
        String string6 = "service:jmx:rmi:///jndi/rmi://" + string + ":" + string2 + "/agent";
        Object[] objectArray = new Object[]{"_MS", iCluster.getName(), iServer.getName(), iCluster.getQuorum(), iServer.getAseHome(), iServer.getSybaseHome(), iServer.getInterfacesPath(), iServer.getMonitorServerLogFile(), string3, string4, null};
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "com.sybase.ua.util.MessageListener"};
        try {
            agentClient.setConnectionParamaters(string6);
            agentClient.connect(iCluster.getName(), string, string5, new String(cArray));
            agentClient.setAseClusterInstanceNumber(1);
            agentClient.setAseClusterPluginVersion("15.0.1");
            agentClient.invokeAseClusterMethod("createRunFile", objectArray, stringArray);
        }
        catch (Exception exception) {
            System.out.println(exception);
            LOG.error((Object)exception, (Throwable)exception);
        }
    }

    public int createRunFile(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, Message message) {
        File file = new File(string5);
        File file2 = new File(string4, "bin");
        File file3 = new File(file2, "monserver");
        File file4 = new File(string4, "install");
        String string11 = System.getProperty("line.separator");
        File file5 = this.makeRunfileName(string2, string4);
        if (file5.exists()) {
            this.deleteRunFile(string2, string4);
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file5));
            bufferedWriter.write("##############################################################################" + string11);
            bufferedWriter.write("#" + string11);
            bufferedWriter.write("#       Cluster Monitor Server RUN file for Sybase Adaptive Server Enterprise" + string11);
            bufferedWriter.write("#" + string11);
            bufferedWriter.write("#               This file was generated by the cluster administration tools to" + string11);
            bufferedWriter.write("#               define the startup of the backup server.\n");
            bufferedWriter.write("#" + string11);
            bufferedWriter.write("#       File generation data:" + string11);
            bufferedWriter.write("#               Cluster Name:" + string + string11);
            bufferedWriter.write("#               Instance Name:" + string6 + string11);
            bufferedWriter.write("#               Quorum Device:" + string + string11);
            bufferedWriter.write("#               File Creation Date:" + AseMonitorServer.getDateTimeString() + string11);
            bufferedWriter.write("#               User: " + AseMonitorServer.getUserName() + string11);
            bufferedWriter.write("#               Host: " + AseMonitorServer.getHostName() + string11);
            bufferedWriter.write("#" + string11);
            bufferedWriter.write("##############################################################################" + string11);
            bufferedWriter.write("#" + string11);
            bufferedWriter.flush();
            bufferedWriter.write(file3.getAbsolutePath() + " \\" + string11);
            bufferedWriter.write("-M" + string2 + " \\" + string11);
            bufferedWriter.write("-S" + string6 + " \\" + string11);
            bufferedWriter.write("-U" + string9 + " \\" + string11);
            bufferedWriter.write("-P" + string10 + " \\" + string11);
            if (string8 == null) {
                string8 = file4.getAbsolutePath() + "/" + string2 + ".log";
            }
            if (string8.indexOf(File.separator) == -1) {
                string8 = file4.getAbsolutePath() + "/" + string8;
            }
            bufferedWriter.write("-l" + string8 + " \\" + string11);
            File file6 = new File(file4, string2 + ".cfg");
            bufferedWriter.write("-L" + file6.getAbsolutePath() + " \\" + string11);
            if (string7 != null && !string7.trim().equals("")) {
                bufferedWriter.write("-i" + InterfacesHelper.getInterfacePathspec(string7) + " \\" + string11);
            }
            bufferedWriter.write("-m" + file + string11 + string11);
            bufferedWriter.flush();
            bufferedWriter.close();
            try {
                Runtime.getRuntime().exec("chmod u+x " + file5.getAbsolutePath());
            }
            catch (RuntimeException runtimeException) {
                message.output(this.resourceBundle, "runfile.monitorserver.chmod", this.commandName, string, string6, runtimeException.getMessage());
                return 3;
            }
        }
        catch (IOException iOException) {
            message.output(this.resourceBundle, "runfile.monitorserver.io.error", this.commandName, string, string6, iOException.getMessage());
            return 3;
        }
        return 0;
    }

    private int deleteRunFile(String string, String string2) {
        File file = this.makeRunfileName(string, string2);
        if (file.exists()) {
            file.delete();
        }
        return 0;
    }

    private File makeRunfileName(String string, String string2) {
        File file = null;
        file = new File(string2, "install");
        File file2 = new File(file, "RUN_" + string);
        return file2;
    }

    private static String getHostName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "<unknown>";
        }
    }

    private static String getUserName() {
        return System.getProperty("user.name");
    }

    private static String getDateTimeString() {
        return DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime());
    }
}

