/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.sdk;

import com.sybase.ase.sdcadmin.ex.SdClusterException;
import com.sybase.ase.sdcadmin.quorum.Quorum;
import com.sybase.ase.sdcadmin.quorum.QuorumCluster;
import com.sybase.ase.sdcadmin.quorum.QuorumException;
import com.sybase.ase.sdcadmin.quorum.QuorumInstance;
import com.sybase.ase.sdcadmin.quorum.QuorumStatus;
import com.sybase.ase.sdcadmin.sdk.AseStartBase;
import com.sybase.ase.sdcadmin.util.AseRunner;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import com.sybase.ase.sdcadmin.util.Message;
import com.sybase.ase.sdcadmin.util.PortUtil;
import com.sybase.ase.sdcadmin.util.ShellCommand;
import com.sybase.ua.util.MessageListener;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AseStartServer
extends AseStartBase
implements ISdConstants {
    private static final Log LOG = LogFactory.getLog(AseStartServer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startServer(MessageListener messageListener, String string, String string2, File file, File file2, File file3, int n, boolean bl, boolean bl2, File file4) throws SdClusterException {
        Object object;
        String string3;
        Message message = new Message(messageListener);
        if (string2 == null || string2.equals("")) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.input.servername.error", this.commandName, string, string2);
            return 1;
        }
        LOG.debug((Object)("Instance " + string2 + " Start - Quorum Library Open."));
        Quorum quorum = this.getQuorum(message, new File(file2, "lib"), file3);
        QuorumCluster quorumCluster = null;
        try {
            LOG.debug((Object)("Instance " + string2 + " Start - Quorum Retrieve Cluster."));
            quorumCluster = quorum.getQuorumCluster();
        }
        catch (QuorumException quorumException) {
            this.sendMessage(message, quorumException, string);
            return 15;
        }
        QuorumInstance quorumInstance = null;
        try {
            LOG.debug((Object)("Instance " + string2 + " Start - Quorum Retrieve Instance."));
            quorumInstance = quorum.getQuorumInstance(string2);
            if (quorumInstance == null) {
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.server.config.missing.error", this.commandName, string, string2);
                return 7;
            }
        }
        catch (QuorumException quorumException) {
            this.sendMessage(message, quorumException, string);
            return 15;
        }
        if (!PortUtil.isThisHost(quorumInstance.getInstanceNode())) {
            LOG.debug((Object)("Instance " + string2 + " Start - Node Name not defined."));
            return 16;
        }
        QuorumStatus quorumStatus = null;
        try {
            LOG.debug((Object)("Instance " + string2 + " Start - Quorum status quick check."));
            quorumStatus = quorum.getQuorumStatus();
            if (quorumStatus.isRunning(quorumInstance.getInstanceId()).booleanValue()) {
                message.output(this.resourceBundle, "sdcadmin.quorum.verify.status.info", this.commandName, string, string2);
                LOG.debug((Object)("Instance " + string2 + " Start - Reports that is is running. Checking to see if the instance has a heartbeat."));
                Boolean[] booleanArray = quorum.getInstancePulse();
                if (booleanArray[quorumInstance.getInstanceId() - 1].booleanValue()) {
                    message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.server.start.allready.running.error", this.commandName, string, string2);
                    return 13;
                }
            }
        }
        catch (QuorumException quorumException) {
            this.sendMessage(message, quorumException, string);
            return 15;
        }
        LOG.debug((Object)("Instance " + string2 + " Start - Quorum confirmed that instance is not running."));
        int n2 = this.checkLogPath(message, string, string2, file2, quorum, quorumInstance);
        if (n2 != 0) {
            return n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = stringBuffer.append(" --quorum_dev=" + file3.getAbsolutePath());
        stringBuffer = stringBuffer.append(" --instance_name=" + string2.trim());
        String string4 = quorumCluster.getAddlRunParameters();
        if (string4 != null && !string4.equals("")) {
            stringBuffer.append(" " + string4);
        }
        if ((string3 = quorumInstance.getAddlRunParameters()) != null && !string3.equals("")) {
            stringBuffer.append(" " + string3);
        }
        if (bl2) {
            stringBuffer = stringBuffer.append(" --cluster_takeover ");
            LOG.info((Object)("Cluster " + string + " Instance " + string2 + " using --cluster_takeover"));
            message.output(this.resourceBundle, "sdcadmin.sdk.startserver.takeover.info", this.commandName, string, string2);
        }
        if (file4 == null) {
            object = new File(file2, "bin");
            if (!((File)object).exists()) {
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.server.bin.missing.error", this.commandName, string, string2, ((File)object).getAbsolutePath());
                return 8;
            }
            file4 = new File((File)object, "dataserver");
            if (!file4.exists()) {
                file4 = new File((File)object, "s_dataserver");
            }
        }
        LOG.debug((Object)("Dataserver executable is " + file4.getAbsolutePath()));
        if (!file4.exists()) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.server.dataserver.missing.error", this.commandName, string, string2, file4.getAbsolutePath());
            return 8;
        }
        object = file4.getAbsolutePath() + stringBuffer.toString();
        LOG.debug((Object)("Run command: " + (String)object));
        LOG.debug((Object)("Arguments so far are: " + stringBuffer.toString()));
        message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.dataserver.start.info", string, string2, object);
        String[] stringArray = null;
        try {
            stringArray = this.getEnvironment(message, file);
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.server.dataserver.envp.error", this.commandName, string, string2, file.getAbsolutePath());
            return 8;
        }
        Object object2 = new Object();
        AseRunner aseRunner = new AseRunner(message, string + "_" + string2 + "_runner", object2, this.resourceBundle);
        aseRunner.setSybaseHomeDir(file);
        aseRunner.setAseHomeDir(file2);
        aseRunner.setQuorumDevice(file3);
        aseRunner.setClusterName(quorumCluster.getName());
        aseRunner.setInstanceName(quorumInstance.getName());
        aseRunner.setInstanceId(quorumInstance.getInstanceId());
        aseRunner.setCommand((String)object);
        aseRunner.setRetries(6);
        aseRunner.setInterval(10);
        aseRunner.setEnvp(stringArray);
        aseRunner.setQuorum(quorum);
        aseRunner.setQuorumCluster(quorumCluster);
        aseRunner.setQuorumInstance(quorumInstance);
        aseRunner.start();
        if (n == -1) {
            n = 2147483;
        } else if (n == 0) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.command.timedout.warn", string2, new Integer(n));
        }
        Object object3 = object2;
        synchronized (object3) {
            try {
                object2.wait(n * 1000);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return aseRunner.isSucceeded() ? 0 : 7;
    }

    private int checkLogPath(Message message, String string, String string2, File file, Quorum quorum, QuorumInstance quorumInstance) {
        boolean bl = false;
        File file2 = null;
        String string3 = quorumInstance.getLogFile();
        if (string3 == null || string3.equals("")) {
            LOG.info((Object)("Instance " + string2 + " Start - The log file was not set in the quorum..."));
            String string4 = string + "_" + string2 + ".log";
            File file3 = new File(file, "install");
            file2 = new File(file3, string4);
            LOG.info((Object)("Instance " + string2 + " Start - Defaulting the log file to: " + file2.getAbsolutePath()));
            quorumInstance.setLogFile(file2.getAbsolutePath());
        } else {
            file2 = new File(string3);
        }
        if (!file2.getParentFile().exists()) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.runlog.directory.missing.error", this.commandName, string, string2, file2.getParentFile().getAbsolutePath());
            return 7;
        }
        if (bl) {
            try {
                LOG.debug((Object)("Instance " + string2 + " Start - Updating the log file path in the quorum."));
                quorum.saveQuorumInstance(quorumInstance);
            }
            catch (QuorumException quorumException) {
                this.sendMessage(message, quorumException, string);
                return 15;
            }
        }
        return 0;
    }

    private String[] getEnvironment(Message message, File file) throws Exception {
        String[] stringArray = new String[]{};
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("win") != -1) {
            File file2 = new File(file, "SYBASE.bat");
            if (!file2.exists()) {
                stringArray = AseStartServer.makeBestGuess(file);
            } else {
                String[] stringArray2 = new String[]{"cmd.exe", "/c", "@echo off && SYBASE.bat && @echo on && set"};
                stringArray = ShellCommand.exec(message, this.resourceBundle, stringArray2, file);
            }
        } else {
            File file3 = new File(file, "SYBASE.sh");
            if (!file3.exists()) {
                LOG.debug((Object)("Making best guess " + stringArray.length));
                stringArray = AseStartServer.makeBestGuess(file);
            } else {
                String[] stringArray3 = new String[]{"sh", "-c", ". ./SYBASE.sh;env"};
                LOG.debug((Object)("Home directory for shell script is " + file.getAbsolutePath()));
                stringArray = ShellCommand.exec(null, this.resourceBundle, stringArray3, file);
            }
        }
        LOG.debug((Object)("Number of environment variables returned were " + stringArray.length));
        return stringArray;
    }

    private static String[] makeBestGuess(File file) {
        String string = File.pathSeparator;
        String string2 = file.getAbsolutePath();
        String string3 = "ASE-15_0";
        String string4 = "OCS-15_0";
        String[] stringArray = new String[]{"SYBASE=" + string2, "SYBROOT=" + string2, "SYBASE_ASE=" + string3, "SYBASE_OCS=" + string4, "LD_LIBRARY_PATH=" + string2 + string + string3 + string + "lib" + ":" + string2 + string + string4 + string + "lib" + ":" + string2 + string + string4 + string + "lib3p", "INCLUDE=" + string2 + string + string4 + string + "include", "LIB=" + string2 + string + string4 + string + "lib", "SYBASE_JRE=" + string2 + string + "shared" + string + "jre142", "SYBASE_SYSAM=SYSAM-2_0", "SYBASE_UA=" + string2 + string + "ua", "SCROOT=" + string2 + string + "shared" + string + "sybcentral43", "PATH=" + string2 + string + string3 + string + "bin" + ":" + string2 + string + string3 + string + "install" + ":" + string2 + string + string4 + string + "bin" + ":" + string2 + string + "ua" + string + "bin" + ":" + string2 + string + "sdcadmin" + string + "bin" + ":" + string2 + string + "RPL-15_0" + string + "bin"};
        return stringArray;
    }
}

