/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.sdk;

import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.ex.SdClusterException;
import com.sybase.ase.sdcadmin.sdk.AseStopBase;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import com.sybase.ase.sdcadmin.util.Message;
import com.sybase.ua.util.MessageListener;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AseStopCluster
extends AseStopBase
implements ISdConstants {
    private static final Log LOG = LogFactory.getLog(AseStopCluster.class);

    public int stopCluster(MessageListener messageListener, ICluster iCluster, String string, String string2, String string3, File file, File file2, File file3, File file4, int n, boolean bl, boolean bl2) throws SdClusterException {
        Message message = new Message(messageListener);
        String string4 = iCluster.getName();
        if (string4 == null || string4.equals("")) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.input.clustername.error", this.commandName, "", "");
            return 1;
        }
        this.dataSource.setClusterName(string4);
        if (string != null && !string.equals("")) {
            this.dataSource.setClusterName(string);
        }
        this.dataSource.setUSER(string2);
        this.dataSource.setPassword(string3);
        try {
            if (n > 0) {
                this.dataSource.setTimeoutInSeconds(n);
            } else {
                this.dataSource.setTimeoutInSeconds(60);
            }
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.input.timeout.warning", this.commandName, string4, string);
        }
        Connection connection = null;
        try {
            connection = this.getClusterJdbcConnection(message, iCluster, this.dataSource, string);
        }
        catch (SdClusterException sdClusterException) {
            message.output(this.resourceBundle, sdClusterException.getMessage(), sdClusterException.getArgs());
            return 4;
        }
        try {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.start.debug", this.getCommandName(), this.dataSource.getClusterName(), this.dataSource.getInstanceName());
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.timeout.debug", this.commandName, this.dataSource.getClusterName(), this.dataSource.getInstanceName(), new Integer(this.dataSource.getTimeoutInSeconds()));
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.showInfo.warn", this.commandName, string4, string);
        }
        int n2 = 0;
        if (connection == null) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.noservers.info", this.commandName, this.dataSource.getClusterName(), "Any");
            n2 = 4;
        } else {
            n2 = this.stopCluster(messageListener, connection, bl);
        }
        if (n2 == 0) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.shutdown.completed.info", this.commandName, this.dataSource.getClusterName(), this.dataSource.getInstanceName());
        } else {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.shutdown.completed.error", this.commandName, this.dataSource.getClusterName(), this.dataSource.getInstanceName());
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int stopCluster(MessageListener messageListener, Connection connection, boolean bl) {
        String string;
        Message message;
        block11: {
            message = new Message(messageListener);
            Statement statement = null;
            try {
                statement = connection.createStatement();
            }
            catch (SQLException sQLException) {
                return 5;
            }
            string = bl ? "shutdown cluster with nowait" : "shutdown cluster";
            try {
                statement.execute(string);
                statement.close();
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equalsIgnoreCase("JZ006")) break block11;
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.sql.error", this.commandName, this.dataSource.getClusterName(), this.dataSource.getInstanceName(), string, sQLException.getMessage());
                return 5;
            }
        }
        try {
            int n = 0;
            while (!connection.isClosed()) {
                if (this.dataSource.getTimeoutInSeconds() <= 0) {
                    return 2;
                }
                if (n > this.dataSource.getTimeoutInSeconds()) {
                    connection.close();
                    return 2;
                }
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.shutdown.info", this.commandName, this.dataSource.getClusterName(), this.dataSource.getInstanceName(), new Integer(++n));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    return 5;
                }
            }
            return 0;
        }
        catch (SQLException sQLException) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.sql.error", this.commandName, this.dataSource.getClusterName(), this.dataSource.getInstanceName(), string, sQLException.getMessage());
            return 5;
        }
    }
}

