/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.sdk;

import com.sybase.ase.sdcadmin.ex.SdClusterException;
import com.sybase.ase.sdcadmin.quorum.Quorum;
import com.sybase.ase.sdcadmin.quorum.QuorumException;
import com.sybase.ase.sdcadmin.quorum.QuorumStatus;
import com.sybase.ase.sdcadmin.sdk.AseStopBase;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import com.sybase.ase.sdcadmin.util.InterfacesHelper;
import com.sybase.ase.sdcadmin.util.Message;
import com.sybase.ase.sdcadmin.util.SdDataSource;
import com.sybase.ua.util.MessageListener;
import java.io.File;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AseStopServer
extends AseStopBase
implements ISdConstants {
    private boolean localServer = true;
    private static final Log LOG = LogFactory.getLog(AseStopServer.class);

    public int stopServer(MessageListener messageListener, String string, String string2, String string3, String string4, File file, File file2, File file3, File file4, String string5, boolean bl, int n, boolean bl2) throws SdClusterException {
        Message message = new Message(messageListener);
        int n2 = this.processArguments(message, string, string2, string3, string4, n);
        if (n2 != 0) {
            return n2;
        }
        n2 = this.loadHostPort(message, string, string2, string5);
        if (n2 != 0) {
            return n2;
        }
        n2 = this.checkIfLocal(message, string2);
        if (n2 != 0) {
            return n2;
        }
        n2 = this.stopServer(message, string2, bl2);
        if (n2 == 0) {
            int n3 = 0;
            while (this.isInstanceRunning(messageListener, string, string2, file2, file3, bl, n)) {
                if (this.dataSource.getTimeoutInSeconds() <= 0) {
                    n2 = 2;
                    break;
                }
                if (n3 > this.dataSource.getTimeoutInSeconds() / 5) {
                    n2 = 2;
                    break;
                }
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.shutdown.instance.info", this.commandName, this.dataSource.getClusterName(), this.dataSource.getInstanceName(), new Integer(++n3));
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    n2 = 8;
                    break;
                }
            }
        }
        if (n2 == 0) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.shutdown.instance.completed.info", this.commandName, this.dataSource.getClusterName(), string2);
        } else {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.shutdown.instance.completed.error", this.commandName, this.dataSource.getClusterName(), string2);
        }
        return n2;
    }

    private boolean isInstanceRunning(MessageListener messageListener, String string, String string2, File file, File file2, boolean bl, int n) throws SdClusterException {
        Quorum quorum = this.getQuorum(this.message, new File(file, "lib"), file2);
        try {
            Boolean[] booleanArray;
            int n2;
            QuorumStatus quorumStatus;
            if (quorum.isClusterDefined() && (quorumStatus = quorum.getQuorumStatus()).isRunning(n2 = quorum.getInstanceId(string2)).booleanValue() && (booleanArray = quorum.getInstancePulse())[n2 - 1].booleanValue()) {
                return true;
            }
        }
        catch (QuorumException quorumException) {
            this.sendMessage(this.message, quorumException, string);
            return false;
        }
        return false;
    }

    private int checkIfLocal(Message message, String string) {
        try {
            if (AseStopServer.isHostThisHost(this.dataSource.getServerName())) {
                this.localServer = true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.input.servername.error", this.commandName, this.dataSource.getClusterName(), string);
            return 8;
        }
        return 0;
    }

    private int loadHostPort(Message message, String string, String string2, String string3) throws SdClusterException {
        this.interfacesHelper = new InterfacesHelper(string3);
        try {
            String string4 = this.interfacesHelper.getHost(string2);
            this.dataSource.setServerName(string4);
            String string5 = this.interfacesHelper.getPort(string2);
            int n = Integer.parseInt(string5);
            this.dataSource.setPortNumber(n);
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.interfaces.hostport.error", this.commandName, string, string2);
            return 9;
        }
        return 0;
    }

    private int processArguments(Message message, String string, String string2, String string3, String string4, int n) {
        if (string == null || string.equals("")) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.input.clustername.error", this.commandName, "", "");
            return 1;
        }
        this.dataSource.setClusterName(string);
        if (string2 == null || string2.equals("")) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.input.servername.error", this.commandName, string, string2);
            return 1;
        }
        this.dataSource.setDataserverName(string2);
        this.dataSource.setUSER(string3);
        this.dataSource.setPassword(string4);
        try {
            if (n > 0) {
                this.dataSource.setTimeoutInSeconds(n);
            } else {
                this.dataSource.setTimeoutInSeconds(60);
            }
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.input.timeout.warning", this.commandName, string, string2);
        }
        try {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.start.debug", this.getCommandName(), string, string2);
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.timeout.debug", this.commandName, string, string2, new Integer(this.dataSource.getTimeoutInSeconds()));
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.showInfo.warn", this.commandName, string, string2);
        }
        return 0;
    }

    private int stopServer(Message message, String string, boolean bl) {
        int n = 0;
        try {
            StopServerThread stopServerThread = new StopServerThread(message, this.dataSource, string, bl);
            stopServerThread.run();
            n = stopServerThread.status;
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.server.stop.normal.error", this.commandName, this.dataSource.getClusterName(), this.dataSource.getInstanceName());
            n = 5;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int stopServerConnected(Message message, SdDataSource sdDataSource, String string, boolean bl) throws SQLException {
        Connection connection = null;
        try {
            connection = AseStopServer.getJdbcConnection(sdDataSource);
        }
        catch (SdClusterException sdClusterException) {
            message.output(this.resourceBundle, sdClusterException.getMessage(), sdClusterException.getArgs());
            return 4;
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
        }
        catch (SQLException sQLException) {
            return 5;
        }
        String string2 = "shutdown " + string;
        if (bl) {
            string2 = string2 + " " + "with nowait";
        }
        LOG.debug((Object)("Cluster " + sdDataSource.getClusterName() + " - Executing \"" + string2 + "\" on instance " + sdDataSource.getInstanceName()));
        try {
            statement.execute(string2);
            statement.close();
        }
        catch (SQLException sQLException) {
            LOG.debug((Object)"Connection terminated to the server.");
            return 0;
        }
        LOG.debug((Object)"Connection is still active after shutdown instance request.");
        try {
            int n = 0;
            while (!connection.isClosed()) {
                if (n > sdDataSource.getTimeoutInSeconds()) {
                    connection.close();
                    return 5;
                }
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.shutdown.instance.info", this.commandName, sdDataSource.getClusterName(), sdDataSource.getInstanceName(), new Integer(++n));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    return 5;
                }
            }
            return 0;
        }
        catch (SQLException sQLException) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.sql.error", this.commandName, sdDataSource.getClusterName(), sdDataSource.getInstanceName(), string2, sQLException.getMessage());
            return 5;
        }
    }

    class StopServerThread
    extends Thread {
        private boolean useDataConnection;
        private SdDataSource threadDatasource = null;
        private String stopServerName;
        private boolean nowait;
        private Message message = null;
        public Exception ex = null;
        int status = 0;

        public StopServerThread(Message message, SdDataSource sdDataSource, String string, boolean bl) {
            this.threadDatasource = sdDataSource;
            this.stopServerName = string;
            this.nowait = bl;
            this.useDataConnection = true;
            this.message = message;
        }

        public StopServerThread(String string, boolean bl) {
            this.stopServerName = string;
            this.nowait = bl;
            this.useDataConnection = false;
        }

        @Override
        public void run() {
            if (this.useDataConnection) {
                try {
                    this.status = AseStopServer.this.stopServerConnected(this.message, AseStopServer.this.dataSource, this.stopServerName, this.nowait);
                }
                catch (SQLException sQLException) {
                    this.ex = sQLException;
                }
            }
        }
    }
}

