/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.sdk;

import com.sybase.ase.sdcadmin.IConstants;
import com.sybase.ase.sdcadmin.config.ClusterConfigException;
import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.sdk.AseCfgBase;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import com.sybase.ase.sdcadmin.util.InterfacesHelper;
import com.sybase.ase.sdcadmin.util.Message;
import com.sybase.ase.sdcadmin.util.XMLCluster;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AseXPServer
extends AseCfgBase
implements ISdConstants,
IConstants {
    private static final Log LOG = LogFactory.getLog(AseXPServer.class);
    private static final int CLEANUP_FLAG_INTERFACES = 1;
    private static final int CLEANUP_FLAG_JDBC_CONNECTION = 2;
    private static final int CLEANUP_FLAG_SYSERVERS = 4;

    public int createXPServer(Message message, String string, int n, String string2, String string3, String string4, char[] cArray) throws ClusterConfigException {
        int n2 = 0;
        ICluster iCluster = XMLCluster.getICluster(string);
        IServer[] iServerArray = iCluster.getServersArray();
        Connection connection = this.getClusterJdbcConnection(message, iCluster, n, string2, string3);
        if (connection == null) {
            return 4;
        }
        n2 = this.setAllSysserversEntry(iServerArray, connection, true);
        if (n2 != 0) {
            this.cleanUp(2, iCluster, iServerArray, connection, false, string4, cArray);
            return n2;
        }
        n2 = this.addAllInterfaces(iCluster, iServerArray, string4, cArray);
        if (n2 != 0) {
            this.cleanUp(6, iCluster, iServerArray, connection, false, string4, cArray);
            return n2;
        }
        this.cleanUp(2, iCluster, iServerArray, connection, false, string4, cArray);
        return n2;
    }

    public int dropXPServer(Message message, String string, int n, String string2, String string3, String string4, char[] cArray) throws ClusterConfigException {
        int n2 = 0;
        ICluster iCluster = XMLCluster.getICluster(string);
        IServer[] iServerArray = iCluster.getServersArray();
        Connection connection = this.getClusterJdbcConnection(message, iCluster, n, string2, string3);
        if (connection == null) {
            return 4;
        }
        LOG.info((Object)"Calling stopXPServer");
        for (int i = 0; i < iServerArray.length; ++i) {
            String string5 = AseXPServer.makeXPServerName(iServerArray[i].getName());
            this.shutdownServer(connection, string5);
        }
        n2 = this.setAllSysserversEntry(iServerArray, connection, false);
        if (n2 != 0) {
            this.cleanUp(2, iCluster, iServerArray, connection, true, string4, cArray);
            return n2;
        }
        try {
            this.deleteAllInterfaces(iCluster, iServerArray, string4, cArray);
        }
        catch (Exception exception) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, iCluster.getName(), "", exception.getMessage());
            this.cleanUp(6, iCluster, iServerArray, connection, true, string4, cArray);
            return 10;
        }
        this.cleanUp(2, iCluster, iServerArray, connection, true, string4, cArray);
        return n2;
    }

    public static String makeXPServerName(String string) {
        return string.toUpperCase().trim() + "_XP";
    }

    public Boolean[] isXPServerActive(Message message, String string, int n, String string2, String string3) {
        Boolean[] booleanArray = null;
        ICluster iCluster = XMLCluster.getICluster(string);
        IServer[] iServerArray = iCluster.getServersArray();
        Connection connection = this.getClusterJdbcConnection(message, iCluster, n, string2, string3);
        if (connection != null) {
            booleanArray = new Boolean[iCluster.getMaxInstances().intValue()];
            for (int i = 0; i < iServerArray.length; ++i) {
                String string4 = AseXPServer.makeXPServerName(iServerArray[i].getName());
                String string5 = this.getSrvNetName(message, connection, string4);
                if (string5 != null) {
                    booleanArray[iServerArray[i].getId().intValue() - 1] = Boolean.TRUE;
                    LOG.debug((Object)("XPServer: " + string4 + " was defined."));
                    continue;
                }
                booleanArray[iServerArray[i].getId().intValue() - 1] = Boolean.FALSE;
                LOG.debug((Object)("XPServer: " + string4 + " was not defined."));
            }
        }
        return booleanArray;
    }

    private int addInterfaces(ICluster iCluster, IServer iServer) {
        int n = 0;
        String string = AseXPServer.makeXPServerName(iServer.getName());
        if (this.interfacesHelper == null) {
            this.interfacesHelper = new InterfacesHelper(AseXPServer.getInterfacePath(iCluster));
        }
        boolean bl = false;
        try {
            bl = this.interfacesHelper.entryExists(string);
        }
        catch (Exception exception) {
            this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, iCluster.getName(), string, exception.getMessage());
            return 9;
        }
        if (bl) {
            try {
                this.interfacesHelper.deleteEntry(string);
            }
            catch (Exception exception) {
                this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, iCluster.getName(), string, exception.getMessage());
                n = 9;
            }
        }
        try {
            this.interfacesHelper.addEntry(string, iServer.getNode(), iServer.getXpServerPort());
        }
        catch (Exception exception) {
            this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, iCluster.getName(), string, exception.getMessage());
            n = 9;
        }
        return n;
    }

    private int addAllInterfaces(ICluster iCluster, IServer[] iServerArray, String string, char[] cArray) {
        int n = 0;
        for (int i = 0; i < iServerArray.length; ++i) {
            n = this.addInterfaces(iCluster, iServerArray[i]);
            if (n == 0) continue;
            this.deleteAllInterfaces(iCluster, iServerArray, string, cArray);
            break;
        }
        if (iCluster.getInstallationMode().equals("private") && !iCluster.isLDAPconfigured()) {
            String string2 = AseXPServer.getInterfacePath(iCluster);
            HashMap hashMap = new HashMap();
            for (int i = 0; i < iServerArray.length; ++i) {
                ArrayList<String> arrayList = new ArrayList<String>();
                String string3 = AseXPServer.makeXPServerName(iServerArray[i].getName());
                arrayList.add("query:" + iServerArray[i].getNode() + ":" + iServerArray[i].getXpServerPort() + ":0");
                arrayList.add("master:" + iServerArray[i].getNode() + ":" + iServerArray[i].getXpServerPort() + ":0");
                hashMap.put(string3, arrayList);
            }
            InterfacesHelper.addToRemoteInterfaces(iCluster, hashMap, string, cArray, string2);
        }
        return n;
    }

    private void cleanUp(int n, ICluster iCluster, IServer[] iServerArray, Connection connection, boolean bl, String string, char[] cArray) {
        if ((n & 4) != 0) {
            try {
                this.setAllSysserversEntry(iServerArray, connection, bl);
            }
            catch (Exception exception) {
                LOG.error((Object)exception);
            }
        }
        if ((n & 2) != 0) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                LOG.debug((Object)sQLException);
            }
        }
        if ((n & 1) != 0) {
            if (bl) {
                this.addAllInterfaces(iCluster, iServerArray, string, cArray);
            } else {
                this.deleteAllInterfaces(iCluster, iServerArray, string, cArray);
            }
        }
    }

    private int deleteInterfaces(ICluster iCluster, IServer iServer) {
        int n = 0;
        String string = AseXPServer.makeXPServerName(iServer.getName());
        if (this.interfacesHelper == null) {
            this.interfacesHelper = new InterfacesHelper(AseXPServer.getInterfacePath(iCluster));
        }
        boolean bl = false;
        try {
            bl = this.interfacesHelper.entryExists(string);
        }
        catch (Exception exception) {
            this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, iCluster.getName(), string, exception.getMessage());
            return 9;
        }
        if (bl) {
            try {
                this.interfacesHelper.deleteEntry(string);
            }
            catch (Exception exception) {
                this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.interfaceshelper.error", this.commandName, iCluster.getName(), string, exception.getMessage());
                n = 9;
            }
        }
        return n;
    }

    private int deleteAllInterfaces(ICluster iCluster, IServer[] iServerArray, String string, char[] cArray) {
        int n = 0;
        for (int i = 0; i < iServerArray.length; ++i) {
            n = this.deleteInterfaces(iCluster, iServerArray[i]);
            if (n == 0) continue;
            this.addAllInterfaces(iCluster, iServerArray, string, cArray);
            break;
        }
        if (iCluster.getInstallationMode().equals("private") && !iCluster.isLDAPconfigured()) {
            String string2 = AseXPServer.getInterfacePath(iCluster);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < iServerArray.length; ++i) {
                String string3 = AseXPServer.makeXPServerName(iServerArray[i].getName());
                arrayList.add(string3);
            }
            InterfacesHelper.deleteFromRemoteInterfaces(iCluster, arrayList, string, cArray, string2);
        }
        return n;
    }

    private int setSysserversEntry(Connection connection, IServer iServer, boolean bl) {
        String string = AseXPServer.makeXPServerName(iServer.getName());
        String string2 = this.getSrvNetName(this.message, connection, string);
        if (bl && string2 != null || !bl && string2 == null) {
            return 0;
        }
        try {
            CallableStatement callableStatement = null;
            if (bl) {
                LOG.debug((Object)("AseXPServer - Preparing to modify syservers by calling sp_addserver for " + string + " using an instance using a connection to " + this.dataSource.getInstanceName() + "."));
                callableStatement = connection.prepareCall("sp_addserver ?,?,?");
                callableStatement.clearWarnings();
                callableStatement.setString(1, string);
                callableStatement.setString(2, "rpcserver");
                callableStatement.setString(3, string);
            } else {
                LOG.debug((Object)("AseXPServer - Preparing to modify syservers by calling sp_dropserver for " + string + " using an instance using a connection to " + this.dataSource.getInstanceName() + "."));
                callableStatement = connection.prepareCall("sp_dropserver ?");
                callableStatement.clearWarnings();
                callableStatement.setString(1, string);
            }
            callableStatement.executeUpdate();
            callableStatement.close();
        }
        catch (SQLException sQLException) {
            if (bl) {
                this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.sql.error", this.commandName, this.dataSource.getClusterName(), this.dataSource.getInstanceName(), "sp_addserver ?,?,?(" + string + "," + "rpcserver" + "," + string + ")", sQLException.getMessage());
            } else {
                this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.sql.error", this.commandName, this.dataSource.getClusterName(), this.dataSource.getInstanceName(), "sp_dropserver ?(" + string + ")", sQLException.getMessage());
            }
            return 5;
        }
        return 0;
    }

    private int setAllSysserversEntry(IServer[] iServerArray, Connection connection, boolean bl) {
        int n = 0;
        for (int i = 0; i < iServerArray.length && (n = this.setSysserversEntry(connection, iServerArray[i], bl)) == 0; ++i) {
        }
        return n;
    }

    public int addXPServerToSysTable(ICluster iCluster, IServer iServer, String string, String string2) {
        Connection connection = this.getClusterJdbcConnection(this.message, iCluster, this.timeoutInSeconds, string, string2);
        if (connection == null) {
            return 4;
        }
        String string3 = AseXPServer.makeXPServerName(iServer.getName());
        String string4 = this.getSrvNetName(this.message, connection, string3);
        if (string4 == null) {
            this.setSysserversEntry(connection, iServer, true);
        }
        return 0;
    }

    int addXPServerInstance(Connection connection, IServer iServer, ICluster iCluster, String string) {
        int n = 0;
        this.setSysserversEntry(connection, iServer, true);
        this.addInterfaces(iCluster, iServer);
        return n;
    }

    int dropXPServerInstance(Connection connection, IServer iServer, ICluster iCluster, String string) {
        int n = 0;
        String string2 = AseXPServer.makeXPServerName(iServer.getName());
        this.shutdownServer(connection, string2);
        this.setSysserversEntry(connection, iServer, false);
        this.deleteInterfaces(iCluster, iServer);
        return n;
    }
}

