/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.sdk;

import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.ex.SdClusterException;
import com.sybase.ase.sdcadmin.sdk.SdClusterBase;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import com.sybase.ase.sdcadmin.util.Message;
import com.sybase.ase.sdcadmin.util.SdDataSource;
import com.sybase.ua.util.MessageListener;
import java.sql.Connection;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ClusterAccessBase
implements ISdConstants {
    private static final Log LOG = LogFactory.getLog(ClusterAccessBase.class);

    public static Connection connectToCluster(MessageListener messageListener, ICluster iCluster, String string, String string2, int n) {
        String string3 = iCluster.getName();
        SdDataSource sdDataSource = new SdDataSource();
        sdDataSource.setDataSourceName(string3 + "_admin");
        String string4 = "ClusterAccessBase";
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.sybase.ase.sdcadmin.lang.Res");
        Message message = new Message(messageListener);
        if (string3 == null || string3.equals("")) {
            message.output(resourceBundle, "com.sybase.ase.sdcadmin.input.clustername.error", string4, "", "");
            return null;
        }
        sdDataSource.setClusterName(string3);
        sdDataSource.setUSER(string);
        sdDataSource.setPassword(string2);
        try {
            if (n > 0) {
                sdDataSource.setTimeoutInSeconds(n);
            } else {
                sdDataSource.setTimeoutInSeconds(60);
            }
        }
        catch (Exception exception) {
            message.output(resourceBundle, "com.sybase.ase.sdcadmin.input.timeout.warning", string4, string3, "");
        }
        String string5 = SdClusterBase.getInterfacePath(iCluster);
        LOG.debug((Object)("ConnectToCluster - " + string3 + " - InterfacePath = " + string5));
        Connection connection = null;
        IServer[] iServerArray = iCluster.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            LOG.debug((Object)("ConnectToCluster - " + string3 + " - Checking dataserver " + iServerArray[i].getName()));
            sdDataSource.setDataserverName(iServerArray[i].getName());
            sdDataSource.setServerName(iServerArray[i].getHost());
            sdDataSource.setPortNumber(Integer.parseInt(iServerArray[i].getQueryPort()));
            try {
                connection = SdClusterBase.getJdbcConnection(sdDataSource);
                if (connection == null) {
                    LOG.debug((Object)("ConnectToCluster - " + string3 + " - Cannot connect to dataserver " + sdDataSource.getInstanceName() + " at " + sdDataSource.getServerName() + ":" + sdDataSource.getPortNumber()));
                    continue;
                }
                LOG.debug((Object)("ConnectToCluster - " + string3 + " - Successfully connected to dataserver " + sdDataSource.getInstanceName() + " at " + sdDataSource.getServerName() + ":" + sdDataSource.getPortNumber()));
                break;
            }
            catch (SdClusterException sdClusterException) {
                message.output(resourceBundle, sdClusterException.getMessage(), sdClusterException.getArgs());
                continue;
            }
            catch (Exception exception) {
                message.output(resourceBundle, "com.sybase.ase.sdcadmin.sdk.jdbc.connect.debug", "connectToCluster", sdDataSource.getClusterName(), sdDataSource.getInstanceName(), sdDataSource.getServerName() + ":" + String.valueOf(sdDataSource.getPortNumber()), sdDataSource.getUser(), exception.getMessage());
            }
        }
        return connection;
    }
}

