/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.sdk;

import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.create.ServerConfig;
import com.sybase.ase.sdcadmin.ex.SdClusterException;
import com.sybase.ase.sdcadmin.sdk.ClusterAccessBase;
import com.sybase.ase.sdcadmin.util.FileUtil;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import com.sybase.ase.sdcadmin.util.Message;
import com.sybase.ase.sdcadmin.util.SdDataSource;
import com.sybase.ua.util.MessageListener;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class DatabaseDevice
extends ClusterAccessBase
implements ISdConstants {
    private static final Log LOG = LogFactory.getLog(DatabaseDevice.class);
    public static final int DEVICE_TYPE_SPECIAL = 1;
    public static final int DEVICE_TYPE_DISK = 2;
    public static final int DEVICE_TYPE_TAPE = 3;
    public static final int DEVICE_TYPE_CHANNEL = 4;
    private static final int DEFAULT_TAPE_BLOCK_SIZE = 32768;
    private static final String SQL_LOAD_DEVICES = "select d.status,d.cntrltype,d.vdevno,d.name,d.phyname,d.low,d.high from master.dbo.sysdevices d";
    private static final String SQL_FIND_SPT_TYPE_NAME = "select * from master.dbo.spt_values where type = ? and name = ?";
    private static final String SQL_FIND_SPT_TYPE_NUMBER = "select * from master.dbo.spt_values where type = ? and number = ?";
    private static final String SQL_LST_DATABASE = "select name from master.dbo.sysdatabases  where (status3 & ?) != 0 and instanceid = ?";
    private static final String SQL_DROP_DATABASE = "drop database ?";
    private int volumeNumber;
    private String name;
    private String devicePath;
    private long sizeInMegabytes;
    private long sizeUsedInMegabytes;
    private long volumePageNumberLow;
    private long volumePageNumberHigh;
    private int controlType;
    private int deviceType;
    private int deviceStatus;
    private long tapeBlockSize;

    public DatabaseDevice() {
    }

    public DatabaseDevice(int n, String string, String string2, String string3, String string4) {
        this.setVolumeNumber(n);
        this.setName(string);
        this.setDevicePath(string2);
        long l = Long.parseLong(string3);
        this.setSizeInMegabytes(l);
        long l2 = Long.parseLong(string4);
        this.setSizeUsedInMegabytes(l2);
    }

    public static DatabaseDevice[] getDevices(MessageListener messageListener, ICluster iCluster, String string, String string2, int n) {
        Connection connection = DatabaseDevice.connectToCluster(messageListener, iCluster, string, string2, n);
        DatabaseDevice[] databaseDeviceArray = DatabaseDevice.getDevices(messageListener, iCluster, string, string2, n, connection);
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            LOG.warn((Object)sQLException);
        }
        return databaseDeviceArray;
    }

    public static DatabaseDevice[] getDevices(MessageListener messageListener, ICluster iCluster, String string, String string2, int n, Connection connection) {
        DatabaseDevice[] databaseDeviceArray = null;
        String string3 = iCluster.getName();
        String string4 = "getDevices()";
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.sybase.ase.sdcadmin.lang.Res");
        Message message = new Message(messageListener);
        if (connection == null) {
            message.output(resourceBundle, "com.sybase.ase.sdcadmin.noservers.info", string4, string3, "Any");
            return null;
        }
        databaseDeviceArray = DatabaseDevice.getDatabaseDevices(message, iCluster.getName(), connection);
        return databaseDeviceArray;
    }

    public static DatabaseDevice[] getDatabaseDevices(Message message, String string, Connection connection) {
        DatabaseDevice[] databaseDeviceArray = DatabaseDevice.preloadDevices(message, string, connection);
        databaseDeviceArray = DatabaseDevice.updateTapeDevices(message, string, connection, databaseDeviceArray);
        databaseDeviceArray = DatabaseDevice.updateDatabaseDevices(message, string, connection, databaseDeviceArray);
        return databaseDeviceArray;
    }

    public static DatabaseDevice[] getDatabaseDevices(Message message, String string, String string2) throws SdClusterException {
        DatabaseDevice[] databaseDeviceArray = null;
        try {
            LOG.debug((Object)"Obtaining the database devices from the cluster creation.");
            ServerConfig serverConfig = new ServerConfig();
            ICluster iCluster = serverConfig.convertXmlToICluster(message, string, string2);
            HashMap<String, DatabaseDevice> hashMap = new HashMap<String, DatabaseDevice>();
            int n = 0;
            if (FileUtil.isExisting(iCluster.getMasterDevice())) {
                hashMap.put("master", new DatabaseDevice(n++, "master", iCluster.getMasterDevice(), iCluster.getMasterDeviceSize(), iCluster.getMasterDatabaseSize()));
            }
            if (FileUtil.isExisting(iCluster.getSystemProcedureDevice())) {
                hashMap.put("sysprocsdev", new DatabaseDevice(n++, "sysprocsdev", iCluster.getSystemProcedureDevice(), iCluster.getSystemProcedureDeviceSize(), iCluster.getSystemProcedureDatabaseSize()));
            }
            if (FileUtil.isExisting(iCluster.getSystemDevice())) {
                hashMap.put("systemdbdev", new DatabaseDevice(n++, "systemdbdev", iCluster.getSystemDevice(), iCluster.getSystemDeviceSize(), iCluster.getSystemDatabaseSize()));
            }
            if (iCluster.getPCIDevice() != null && FileUtil.isExisting(iCluster.getPCIDevice())) {
                hashMap.put("pci", new DatabaseDevice(n++, "pci", iCluster.getPCIDevice(), iCluster.getPCIDeviceSize(), iCluster.getPCIDatabaseSize()));
            }
            IServer[] iServerArray = iCluster.getServersArray();
            for (int i = 0; i < iServerArray.length; ++i) {
                String string3 = iServerArray[i].getTempdbDeviceName().trim();
                long l = Long.parseLong(iServerArray[i].getTempdbDbSize().trim());
                if (hashMap.containsKey(string3)) {
                    DatabaseDevice databaseDevice = (DatabaseDevice)hashMap.get(string3);
                    long l2 = databaseDevice.getSizeUsedInMegabytes() - l;
                    databaseDevice.setSizeUsedInMegabytes(l2);
                    continue;
                }
                if (!FileUtil.isExisting(iServerArray[i].getTempdbDevicePath())) continue;
                hashMap.put(string3, new DatabaseDevice(n++, string3, iServerArray[i].getTempdbDevicePath(), iServerArray[i].getTempdbDeviceSize(), iServerArray[i].getTempdbDbSize()));
            }
            LOG.debug((Object)"Preparing the keyset for the devices.");
            String[] stringArray = hashMap.keySet().toArray(new String[hashMap.size()]);
            LOG.debug((Object)("Devices identified is " + stringArray.length));
            databaseDeviceArray = new DatabaseDevice[hashMap.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                databaseDeviceArray[i] = (DatabaseDevice)hashMap.get(stringArray[i]);
            }
            LOG.debug((Object)("The number of database devices defined is " + databaseDeviceArray.length));
        }
        catch (Exception exception) {
            LOG.warn((Object)exception);
        }
        return databaseDeviceArray;
    }

    public static long getSptValueTypeName(Message message, Connection connection, String string, String string2, String string3) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall(SQL_FIND_SPT_TYPE_NAME);
        callableStatement.clearWarnings();
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        ResultSet resultSet = callableStatement.executeQuery();
        resultSet.next();
        long l = resultSet.getLong(string3);
        resultSet.close();
        callableStatement.close();
        return l;
    }

    public static long getSptValueTypeNumber(Message message, Connection connection, String string, int n, String string2) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall(SQL_FIND_SPT_TYPE_NUMBER);
        callableStatement.clearWarnings();
        callableStatement.setString(1, string);
        callableStatement.setInt(2, n);
        ResultSet resultSet = callableStatement.executeQuery();
        resultSet.next();
        long l = resultSet.getLong(string2);
        resultSet.close();
        callableStatement.close();
        return l;
    }

    public static void dropLstDatabase(Message message, Connection connection, int n) throws SQLException {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.sybase.ase.sdcadmin.lang.Res");
        long l = DatabaseDevice.getSptValueTypeName(message, connection, "D3", "local system temp db", "number");
        CallableStatement callableStatement = connection.prepareCall(SQL_LST_DATABASE);
        callableStatement.clearWarnings();
        callableStatement.setLong(1, l);
        callableStatement.setInt(2, n);
        Vector<String> vector = new Vector<String>();
        ResultSet resultSet = callableStatement.executeQuery();
        if (resultSet.next()) {
            String string = resultSet.getString(1);
            LOG.debug((Object)FileUtil.removeControlCharacter("The Local System Temporary Database " + string + " is assigned to instance id " + n + "."));
            vector.add(string);
        }
        resultSet.close();
        callableStatement.close();
        callableStatement = connection.prepareCall(SQL_DROP_DATABASE);
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            message.output(resourceBundle, "sdcadmin.temporary.database.drop.info", string);
            callableStatement.clearWarnings();
            callableStatement.setString(1, string);
            callableStatement.executeUpdate();
        }
        callableStatement.close();
        connection.commit();
    }

    private static DatabaseDevice[] preloadDevices(Message message, String string, Connection connection) {
        DatabaseDevice[] databaseDeviceArray = null;
        if (connection == null) {
            return null;
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
        }
        catch (SQLException sQLException) {
            return null;
        }
        Vector<DatabaseDevice> vector = new Vector<DatabaseDevice>(32);
        try {
            ResultSet resultSet = statement.executeQuery(SQL_LOAD_DEVICES);
            while (resultSet.next()) {
                DatabaseDevice databaseDevice = new DatabaseDevice();
                databaseDevice.deviceStatus = resultSet.getInt(1);
                databaseDevice.controlType = resultSet.getInt(2);
                databaseDevice.volumeNumber = resultSet.getInt(3);
                databaseDevice.name = resultSet.getString(4);
                databaseDevice.devicePath = resultSet.getString(5);
                databaseDevice.volumePageNumberLow = resultSet.getInt(6);
                databaseDevice.volumePageNumberHigh = resultSet.getInt(7);
                if (databaseDevice.controlType == 0) {
                    databaseDevice.deviceType = 1;
                }
                if (databaseDevice.controlType == 2) {
                    databaseDevice.deviceType = 2;
                }
                if (databaseDevice.controlType >= 3 && databaseDevice.controlType <= 8) {
                    databaseDevice.deviceType = 3;
                }
                if (databaseDevice.controlType >= 9 && databaseDevice.controlType <= 14) {
                    databaseDevice.deviceType = 4;
                }
                vector.add(databaseDevice);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            return null;
        }
        databaseDeviceArray = new DatabaseDevice[vector.size()];
        databaseDeviceArray = vector.toArray(databaseDeviceArray);
        return databaseDeviceArray;
    }

    private static DatabaseDevice[] updateTapeDevices(Message message, String string, Connection connection, DatabaseDevice[] databaseDeviceArray) {
        for (int i = 0; i < databaseDeviceArray.length; ++i) {
            if (databaseDeviceArray[i].controlType != 3 || databaseDeviceArray[i].volumePageNumberHigh <= 0L) continue;
            long l = 32768L;
            try {
                l = DatabaseDevice.getSptValueTypeNumber(null, connection, "E", 4, "low");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            databaseDeviceArray[i].tapeBlockSize = l;
            databaseDeviceArray[i].sizeInMegabytes = (long)((double)databaseDeviceArray[i].volumePageNumberHigh * ((double)databaseDeviceArray[i].tapeBlockSize / 1048576.0));
        }
        return databaseDeviceArray;
    }

    public static long getMaxPageSize(Message message, String string, Connection connection) {
        long l = 0L;
        if (connection == null) {
            return l;
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
        }
        catch (SQLException sQLException) {
            return l;
        }
        try {
            ResultSet resultSet = statement.executeQuery("select @@maxpagesize");
            if (resultSet.next()) {
                l = resultSet.getLong(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            LOG.error((Object)sQLException);
        }
        return l;
    }

    public static long getPageSize(Message message, String string, Connection connection) {
        long l = 0L;
        if (connection == null) {
            return l;
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
        }
        catch (SQLException sQLException) {
            return l;
        }
        try {
            ResultSet resultSet = statement.executeQuery("select @@pagesize");
            if (resultSet.next()) {
                l = resultSet.getLong(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            LOG.error((Object)sQLException);
        }
        return l;
    }

    public static long getDeviceSumSize(Connection connection, int n) {
        long l = 0L;
        if (connection == null) {
            return l;
        }
        CallableStatement callableStatement = null;
        try {
            callableStatement = connection.prepareCall("select sum(u.size) from master.dbo.sysusages u  where u.vdevno = ?");
            callableStatement.setInt(1, n);
            ResultSet resultSet = callableStatement.executeQuery();
            resultSet.next();
            l = resultSet.getLong(1);
            resultSet.close();
            callableStatement.close();
        }
        catch (SQLException sQLException) {
            return l;
        }
        return l;
    }

    private static DatabaseDevice[] updateDatabaseDevices(Message message, String string, Connection connection, DatabaseDevice[] databaseDeviceArray) {
        long l = DatabaseDevice.getMaxPageSize(message, string, connection);
        long l2 = DatabaseDevice.getPageSize(message, string, connection);
        long l3 = 0x100000L / l2;
        for (int i = 0; i < databaseDeviceArray.length; ++i) {
            if (databaseDeviceArray[i].deviceType != 1 && databaseDeviceArray[i].deviceType != 2 || (databaseDeviceArray[i].deviceStatus & 2) == 0) continue;
            databaseDeviceArray[i].sizeInMegabytes = (long)(1.0 + (double)(databaseDeviceArray[i].volumePageNumberHigh - databaseDeviceArray[i].volumePageNumberLow)) / l3;
            long l4 = DatabaseDevice.getDeviceSumSize(connection, databaseDeviceArray[i].volumeNumber);
            databaseDeviceArray[i].sizeUsedInMegabytes = (long)((double)l4 / 512.0) * (l / l2);
        }
        return databaseDeviceArray;
    }

    public int getVolumeNumber() {
        return this.volumeNumber;
    }

    public void setVolumeNumber(int n) {
        this.volumeNumber = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDevicePath() {
        return this.devicePath;
    }

    public void setDevicePath(String string) {
        this.devicePath = string;
    }

    public long getSizeInMegabytes() {
        return this.sizeInMegabytes;
    }

    public void setSizeInMegabytes(long l) {
        this.sizeInMegabytes = l;
    }

    public long getSizeUsedInMegabytes() {
        return this.sizeUsedInMegabytes;
    }

    public void setSizeUsedInMegabytes(long l) {
        this.sizeUsedInMegabytes = l;
    }

    public long getVolumePageNumberLow() {
        return this.volumePageNumberLow;
    }

    public void setVolumePageNumberLow(long l) {
        this.volumePageNumberLow = l;
    }

    public long getVolumePageNumberHigh() {
        return this.volumePageNumberHigh;
    }

    public void setVolumePageNumberHigh(long l) {
        this.volumePageNumberHigh = l;
    }

    public int getControlType() {
        return this.controlType;
    }

    public void setControlType(int n) {
        this.controlType = n;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(int n) {
        this.deviceType = n;
    }

    public int getDeviceStatus() {
        return this.deviceStatus;
    }

    public void setDeviceStatus(int n) {
        this.deviceStatus = n;
    }

    public long getTapeBlockSize() {
        return this.tapeBlockSize;
    }

    public void setTapeBlockSize(long l) {
        this.tapeBlockSize = l;
    }

    public static final void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage: <host> <port> [<login> [<password>]]");
            System.out.println("       (Defaults to the login sa with no password)");
            System.exit(-1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        int n = 5000;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(numberFormatException);
            LOG.error((Object)numberFormatException, (Throwable)numberFormatException);
            System.exit(-1);
        }
        String string3 = "sa";
        if (stringArray.length > 2) {
            string3 = stringArray[2];
        }
        String string4 = "";
        if (stringArray.length > 3) {
            string4 = stringArray[3];
        }
        Logger logger = Logger.getRootLogger();
        logger.removeAllAppenders();
        logger.setLevel(Level.ALL);
        PatternLayout patternLayout = new PatternLayout("%d [%-5p] [%t] [%c.%M(%L)] - %m%n");
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)patternLayout, "System.out");
        consoleAppender.setThreshold((Priority)Level.ALL);
        logger.addAppender((Appender)consoleAppender);
        SdDataSource sdDataSource = new SdDataSource();
        sdDataSource.setUser(string3);
        sdDataSource.setPassword(string4);
        sdDataSource.setHOSTNAME(string);
        sdDataSource.setServerName(string);
        sdDataSource.setPortNumber(n);
        try {
            Connection connection = sdDataSource.getConnection();
            DatabaseDevice[] databaseDeviceArray = DatabaseDevice.getDatabaseDevices(null, "", connection);
            for (int i = 0; i < databaseDeviceArray.length; ++i) {
                System.out.println("Device Name: " + databaseDeviceArray[i].name + "; Used: " + databaseDeviceArray[i].sizeUsedInMegabytes + " MB" + "; Size: " + databaseDeviceArray[i].sizeInMegabytes + " MB");
            }
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
            LOG.error((Object)sQLException, (Throwable)sQLException);
        }
    }
}

