/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.sdk;

import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.ex.SdClusterException;
import com.sybase.ase.sdcadmin.lang.IResourceConstants;
import com.sybase.ase.sdcadmin.quorum.Quorum;
import com.sybase.ase.sdcadmin.quorum.QuorumException;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import com.sybase.ase.sdcadmin.util.InterfacesHelper;
import com.sybase.ase.sdcadmin.util.Logging;
import com.sybase.ase.sdcadmin.util.Message;
import com.sybase.ase.sdcadmin.util.PortUtil;
import com.sybase.ase.sdcadmin.util.SdDataSource;
import com.sybase.ase.sdcadmin.util.UserArguments;
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybMessageHandler;
import com.sybase.ua.util.MessageListener;
import com.sybase.ua.util.xmlmessage.XMLMessage;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.log4j.Level;

public abstract class SdClusterBase
implements ISdConstants,
SybMessageHandler,
MessageListener,
IResourceConstants {
    private static final Log LOG = LogFactory.getLog(SdClusterBase.class);
    protected int verbose;
    protected UserArguments aseUtil = null;
    protected ResourceBundle resourceBundle = null;
    protected String commandName;
    protected SdDataSource dataSource = null;
    protected int timeoutInSeconds = 60;
    protected InterfacesHelper interfacesHelper = null;
    protected String lastMessage = null;
    protected Message message = new Message(this);

    public SdClusterBase() {
        this.dataSource = new SdDataSource();
        this.dataSource.setDataSourceName(this.getClass().getPackage().getName());
        this.aseUtil = new UserArguments();
        this.resourceBundle = ResourceBundle.getBundle("com.sybase.ase.sdcadmin.lang.Res");
    }

    public void setDataSource(SdDataSource sdDataSource) {
        this.dataSource = sdDataSource;
    }

    public void setCommandName(String string) {
        this.commandName = string;
    }

    public String getCommandName() {
        return this.commandName;
    }

    protected void setVerboseMode(Log log, int n) {
        Level level = Level.WARN;
        switch (n) {
            case 0: {
                level = Level.OFF;
                break;
            }
            case 1: {
                level = Level.FATAL;
                break;
            }
            case 2: {
                level = Level.WARN;
                break;
            }
            default: {
                level = Level.INFO;
                break;
            }
            case 4: {
                level = Level.DEBUG;
                break;
            }
            case 5: {
                level = Level.ALL;
            }
        }
        Log4JLogger log4JLogger = (Log4JLogger)log;
        log4JLogger.getLogger().setLevel(level);
    }

    protected Quorum getQuorum(Message message, File file, File file2) throws SdClusterException {
        Quorum quorum = null;
        try {
            quorum = new Quorum(file, file2);
        }
        catch (QuorumException quorumException) {
            message.output(this.resourceBundle, "sdcadmin.sdk.qrminst.error", file.getAbsoluteFile(), file2.getAbsoluteFile(), quorumException.getMessage());
            throw new SdClusterException("sdcadmin.sdk.qrminst.error", quorumException, (Object)file.getAbsoluteFile(), (Object)file2.getAbsoluteFile(), (Object)quorumException.getMessage());
        }
        return quorum;
    }

    protected File getClusterConfigFile(MessageListener messageListener, File file, String string, String string2, String string3) {
        Message message = new Message(messageListener);
        File file2 = new File(file, string);
        if (!file2.exists()) {
            try {
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.missing.info", this.commandName, string2, string3, file2.getCanonicalPath());
            }
            catch (IOException iOException) {
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clustercfg.open.error", this.commandName, string2, string3, string);
            }
            return null;
        }
        return file2;
    }

    protected void validateDataSource() throws Exception {
        if (this.dataSource.getClusterName() == null || this.dataSource.getClusterName().equals("")) {
            throw new Exception("com.sybase.ase.sdcadmin.datasource.ClusterName.notset");
        }
        if (this.dataSource.getInstanceName() == null || this.dataSource.getInstanceName().equals("")) {
            throw new Exception("com.sybase.ase.sdcadmin.datasource.AseServerName.notset");
        }
        if (this.dataSource.getServerName() == null || this.dataSource.getServerName().equals("")) {
            throw new Exception("com.sybase.ase.sdcadmin.datasource.ServerName.notset");
        }
        if (this.dataSource.getPortNumber() == 0) {
            throw new Exception("com.sybase.ase.sdcadmin.datasource.PortNumber.notset");
        }
        if (this.dataSource.getUSER() == null || this.dataSource.getUSER().equals("")) {
            throw new Exception("com.sybase.ase.sdcadmin.datasource.USER.notset");
        }
    }

    protected int discoverHostPort(SdDataSource sdDataSource) {
        String string;
        LOG.debug((Object)("Getting node for " + sdDataSource.getInstanceName()));
        try {
            string = this.interfacesHelper.getHost(sdDataSource.getInstanceName());
            if (string == null || string.equals("")) {
                LOG.debug((Object)("The nodet name for " + sdDataSource.getInstanceName() + " was null or blank."));
                return 9;
            }
            sdDataSource.setServerName(string);
        }
        catch (Exception exception) {
            LOG.debug((Object)"Unable to get host name", (Throwable)exception);
            return 9;
        }
        try {
            string = this.interfacesHelper.getPort(sdDataSource.getInstanceName());
            if (string == null || string.equals("")) {
                LOG.debug((Object)("The port number returned for " + sdDataSource.getInstanceName() + " was null or blank."));
                return 9;
            }
            int n = Integer.parseInt(string);
            sdDataSource.setPortNumber(n);
        }
        catch (Exception exception) {
            LOG.debug((Object)"Unable to get port number", (Throwable)exception);
            return 9;
        }
        return 0;
    }

    protected Connection getJdbcConnection() throws SdClusterException {
        return SdClusterBase.getJdbcConnection(this.dataSource);
    }

    public static Connection getJdbcConnection(SdDataSource sdDataSource) throws SdClusterException {
        try {
            LOG.debug((Object)("Attempting to connect to the datasource at " + sdDataSource.getServerName() + ":" + sdDataSource.getPortNumber()));
            Connection connection = sdDataSource.getConnection();
            if (!connection.isClosed()) {
                LOG.debug((Object)("Successfully connected to the datasource at " + sdDataSource.getServerName() + ":" + sdDataSource.getPortNumber()));
                return connection;
            }
            LOG.debug((Object)("The datasource connection is closed at " + sdDataSource.getServerName() + ":" + sdDataSource.getPortNumber()));
        }
        catch (SQLException sQLException) {
            if (sdDataSource.getCHARSET() == null || !sdDataSource.getCHARSET().equalsIgnoreCase("utf8")) {
                LOG.debug((Object)"Trying to connect with default charset UTF8");
                sdDataSource.setCHARSET("utf8");
                try {
                    Connection connection = sdDataSource.getConnection();
                    if (!connection.isClosed()) {
                        LOG.debug((Object)("Successfully connected to the datasource at " + sdDataSource.getServerName() + ":" + sdDataSource.getPortNumber()));
                        return connection;
                    }
                    LOG.debug((Object)("The datasource connection is closed at " + sdDataSource.getServerName() + ":" + sdDataSource.getPortNumber()));
                }
                catch (SQLException sQLException2) {
                    sQLException.setNextException(sQLException2);
                    LOG.debug((Object)"Could not connect using UTF8 charset");
                }
            }
            if (sQLException.getSQLState().equalsIgnoreCase("JZ00L")) {
                throw new SdClusterException("com.sybase.ase.sdcadmin.authentication.error", "SQLConnect", (Object)sdDataSource.getClusterName(), (Object)sdDataSource.getInstanceName(), (Object)sdDataSource.getUser());
            }
            if (sQLException.getSQLState().equalsIgnoreCase("JZ006")) {
                LOG.debug((Object)("Failed to connect to the datasource connection at " + sdDataSource.getServerName() + ":" + sdDataSource.getPortNumber() + " because the dataserver defined for that address is not accepting connections."));
            }
            LOG.debug((Object)("Failed to connect to the datasource connection at " + sdDataSource.getServerName() + ":" + sdDataSource.getPortNumber() + " because " + sQLException.getMessage()));
        }
        return null;
    }

    public SQLException messageHandler(SQLException sQLException) {
        this.lastMessage = sQLException.getMessage();
        LOG.debug((Object)("SQLException Message: " + this.lastMessage));
        return sQLException;
    }

    protected String clusterAdmin(Message message, ICluster iCluster, Connection connection, String string, String string2, int n, String string3) throws SQLException {
        int n2 = -1;
        this.lastMessage = null;
        SybConnection sybConnection = (SybConnection)connection;
        sybConnection.setSybMessageHandler((SybMessageHandler)this);
        CallableStatement callableStatement = connection.prepareCall("select cluster_admin( ?, ?, ?, ?)");
        callableStatement.clearWarnings();
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.setInt(3, n);
        if (string3 == null) {
            callableStatement.setNull(4, 12);
        } else {
            callableStatement.setString(4, string3);
        }
        ResultSet resultSet = null;
        try {
            resultSet = callableStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            int n3 = sQLException.getErrorCode();
            if (n3 == 2812) {
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.clusteradmin.spmissing", this.commandName, this.dataSource.getClusterName(), this.dataSource.getInstanceName(), "cluster_admin");
            }
            throw sQLException;
        }
        if (resultSet.next()) {
            n2 = resultSet.getInt(1);
            LOG.debug((Object)("Status returned from cluster_admin is " + n2));
        }
        if (n2 == 0) {
            if (this.lastMessage == null) {
                this.lastMessage = "";
            } else if (string.equalsIgnoreCase("cluster_status")) {
                this.getStatus(iCluster, message);
            } else if (string.equalsIgnoreCase("server_status")) {
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.instance.status", new Integer(n), string2, this.lastMessage);
            }
        }
        callableStatement.close();
        return this.lastMessage;
    }

    private void getStatus(ICluster iCluster, Message message) {
        IServer[] iServerArray;
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.lastMessage, "\n");
        while (stringTokenizer.hasMoreElements()) {
            iServerArray = stringTokenizer.nextToken();
            if (iServerArray.startsWith("Instance")) continue;
            StringTokenizer stringTokenizer2 = new StringTokenizer((String)iServerArray, "\t");
            String string = stringTokenizer2.nextToken().trim();
            String string2 = stringTokenizer2.nextToken().trim();
            hashMap.put(Integer.valueOf(string), string2);
        }
        iServerArray = iCluster.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            if (hashMap.containsKey(iServerArray[i].getId())) {
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.cluster.status", iServerArray[i].getId(), iServerArray[i].getName(), (String)hashMap.get(iServerArray[i].getId()));
                continue;
            }
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.cluster.status", iServerArray[i].getId(), iServerArray[i].getName(), this.resourceBundle.getString(ISdConstants.CLUSTER_STATES_RESOURCE_KEYS[6]));
        }
    }

    protected Connection getClusterJdbcConnection(Message message, ICluster iCluster, SdDataSource sdDataSource, String string) throws SdClusterException {
        Connection connection = null;
        sdDataSource.setDataserverName(string);
        String string2 = SdClusterBase.getInterfacePath(iCluster);
        this.interfacesHelper = new InterfacesHelper(string2);
        if (string != null && !string.equals("")) {
            if (this.discoverHostPort(sdDataSource) == 0) {
                connection = this.getJdbcConnection();
                if (connection == null) {
                    message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.input.suggestedserver.info", this.commandName, sdDataSource.getClusterName(), sdDataSource.getInstanceName(), sdDataSource.getServerName(), String.valueOf(sdDataSource.getPortNumber()));
                }
            } else {
                message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.interfaces.hostport.info", this.commandName, sdDataSource.getClusterName(), sdDataSource.getInstanceName(), string2);
            }
        }
        if (connection == null) {
            IServer[] iServerArray = iCluster.getServersArray();
            for (int i = 0; i < iServerArray.length; ++i) {
                LOG.debug((Object)("Checking dataserver " + iServerArray[i].getName()));
                sdDataSource.setDataserverName(iServerArray[i].getName());
                try {
                    if (this.discoverHostPort(sdDataSource) == 0) {
                        connection = this.getJdbcConnection();
                        if (connection == null) {
                            LOG.debug((Object)("Cannot connect to dataserver " + sdDataSource.getInstanceName() + " at " + sdDataSource.getServerName() + ":" + sdDataSource.getPortNumber()));
                            continue;
                        }
                        LOG.debug((Object)("Successfully connected to dataserver " + sdDataSource.getInstanceName() + " at " + sdDataSource.getServerName() + ":" + sdDataSource.getPortNumber()));
                        break;
                    }
                    message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.interfaces.hostport.info", this.commandName, sdDataSource.getClusterName(), sdDataSource.getInstanceName(), string2);
                    continue;
                }
                catch (Exception exception) {
                    message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.input.servername.error", this.commandName, sdDataSource.getClusterName(), sdDataSource.getInstanceName());
                }
            }
        }
        return connection;
    }

    protected Connection getClusterJdbcConnection(Message message, ICluster iCluster, int n, String string, String string2) {
        Connection connection = null;
        this.dataSource.setUSER(string);
        this.dataSource.setPassword(string2);
        try {
            connection = this.getClusterJdbcConnection(message, iCluster, this.dataSource, null);
        }
        catch (SdClusterException sdClusterException) {
            message.output(this.resourceBundle, sdClusterException.getMessage(), sdClusterException.getArgs());
        }
        return connection;
    }

    public static boolean isHostThisHost(String string) throws UnknownHostException {
        InetAddress inetAddress;
        InetAddress inetAddress2 = InetAddress.getLocalHost();
        return inetAddress2.equals(inetAddress = InetAddress.getByName(string));
    }

    public static String getHostSpecificInterfacesPath(ICluster iCluster) {
        IServer[] iServerArray = iCluster.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            if (!PortUtil.isThisHost(iServerArray[i].getNode())) continue;
            return iServerArray[i].getInterfacesPath();
        }
        return null;
    }

    public static String getInterfacePath(ICluster iCluster) {
        return iCluster.isLDAPconfigured() ? null : (iCluster.getInstallationMode().equalsIgnoreCase("private") ? SdClusterBase.getHostSpecificInterfacesPath(iCluster) : iCluster.getInterfacesPath());
    }

    public void setVerboseMode(int n) {
        this.verbose = n;
        this.setVerboseMode(LOG);
    }

    public void setVerboseMode(Log log) {
        Level level = Level.WARN;
        switch (this.verbose) {
            case 0: {
                level = Level.OFF;
                break;
            }
            case 1: {
                level = Level.FATAL;
                break;
            }
            case 2: {
                level = Level.ERROR;
                break;
            }
            default: {
                level = Level.WARN;
                break;
            }
            case 4: {
                level = Level.INFO;
                break;
            }
            case 5: {
                level = Level.DEBUG;
                break;
            }
            case 6: {
                level = Level.ALL;
            }
        }
        Log4JLogger log4JLogger = (Log4JLogger)log;
        log4JLogger.getLogger().setLevel(level);
    }

    public int onMessage(String string, String string2) throws RemoteException {
        try {
            XMLMessage xMLMessage = new XMLMessage("sybcluster");
            xMLMessage.decodeMessages(string2);
            Object[] objectArray = xMLMessage.getMessageEntries();
            Message.showMessages(objectArray);
        }
        catch (Exception exception) {
            System.out.println(exception);
            LOG.error((Object)exception, (Throwable)exception);
        }
        return 0;
    }

    public void setDefaultLogging() {
        try {
            Logging.setLogging(this.resourceBundle, "com.sybase", "System.out", 0, "sdcadmin.log", 4, true);
        }
        catch (Exception exception) {
            System.err.println("ERROR - The Default logging could not be set.");
            System.out.println(exception);
            LOG.error((Object)exception, (Throwable)exception);
        }
    }

    protected void sendMessage(Message message, QuorumException quorumException, String string, String string2) throws SdClusterException {
        if (quorumException.getCause() != null && quorumException.getCause() != quorumException) {
            message.output(this.resourceBundle, "sdcadmin.sdk.qrmget.error", string2, this.commandName, string, quorumException.getMessage(), quorumException.getCause().getMessage());
            LOG.error((Object)quorumException);
            LOG.error((Object)quorumException.getCause());
        } else {
            message.output(this.resourceBundle, "sdcadmin.sdk.qrmget.error", string2, this.commandName, string, quorumException.getMessage(), "");
            LOG.error((Object)quorumException);
        }
    }

    protected String sendMessage(Message message, QuorumException quorumException, String string) {
        String string2 = null;
        if (quorumException.getCause() != null && quorumException.getCause() != quorumException) {
            string2 = message.output(this.resourceBundle, "sdcadmin.sdk.quorum.error", this.commandName, string, quorumException.getMessage(), quorumException.getCause());
            LOG.error((Object)message, (Throwable)quorumException);
            LOG.error((Object)message, quorumException.getCause());
        } else {
            string2 = message.output(this.resourceBundle, "sdcadmin.sdk.quorum.error", this.commandName, string, quorumException.getMessage(), "");
            LOG.error((Object)message, (Throwable)quorumException);
        }
        return string2;
    }

    protected String getSrvNetName(Message message, Connection connection, String string) {
        String string2 = null;
        try {
            LOG.debug((Object)("SdClusterBase - Obtain the Server Network Name from the sysservers table given the server name \"" + string + "\" is available" + " on a connection to " + this.dataSource.getInstanceName() + "."));
            CallableStatement callableStatement = connection.prepareCall("select srvnetname from sysservers where srvname = ?");
            callableStatement.clearWarnings();
            callableStatement.setString(1, string);
            ResultSet resultSet = callableStatement.executeQuery();
            if (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
            resultSet.close();
            callableStatement.close();
        }
        catch (SQLException sQLException) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.sql.error", this.commandName, this.dataSource.getClusterName(), this.dataSource.getInstanceName(), "select srvnetname from sysservers where srvname = ?(" + string + ")", sQLException.getMessage());
        }
        if (string2 == null) {
            LOG.debug((Object)("SdClusterBase -  srvNetName " + string + " was not found."));
        } else {
            LOG.debug((Object)("SdClusterBase -  srvNetName " + string + " was found!"));
        }
        return string2;
    }

    protected boolean isConfigParamAvailable(Message message, Connection connection, String string) {
        boolean bl = false;
        try {
            int n;
            LOG.debug((Object)("SdClusterBase - Looking to see if the database value \"" + string + "\" is available" + " on a connection to " + this.dataSource.getInstanceName() + "."));
            CallableStatement callableStatement = connection.prepareCall("select count(*) from sysconfigures where name = ?");
            callableStatement.clearWarnings();
            callableStatement.setString(1, string);
            ResultSet resultSet = callableStatement.executeQuery();
            if (resultSet.next() && (n = resultSet.getInt(1)) == 1) {
                bl = true;
            }
            resultSet.close();
            callableStatement.close();
        }
        catch (SQLException sQLException) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.sql.error", this.commandName, this.dataSource.getClusterName(), this.dataSource.getInstanceName(), "select count(*) from sysconfigures where name = ?(" + string + ")", sQLException.getMessage());
        }
        return bl;
    }

    protected int callSpConfigure(Message message, Connection connection, String string, int n) {
        try {
            LOG.debug((Object)("SdClusterBase - Changing the database value \"" + string + "\" to \"" + n + "\" using sp_configure" + " on a connection to " + this.dataSource.getInstanceName() + "."));
            CallableStatement callableStatement = connection.prepareCall("sp_configure ?,?");
            callableStatement.clearWarnings();
            callableStatement.setString(1, string);
            callableStatement.setInt(2, n);
            callableStatement.execute();
            callableStatement.close();
        }
        catch (SQLException sQLException) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.sql.error", this.commandName, this.dataSource.getClusterName(), this.dataSource.getInstanceName(), "sp_configure ?,? ( \"" + string + "\", " + n + " )", sQLException.getMessage());
            return 5;
        }
        return 0;
    }

    protected boolean isStoredProcedureAvailable(Message message, Connection connection, String string) {
        boolean bl = false;
        try {
            int n;
            LOG.debug((Object)("SdClusterBase - Looking to see if the stored procedure \"" + string + "\" is available" + " on a connection to " + this.dataSource.getInstanceName() + "."));
            CallableStatement callableStatement = connection.prepareCall("select count(*) from sysobjects where type = 'P' and name = ?");
            callableStatement.clearWarnings();
            callableStatement.setString(1, string);
            ResultSet resultSet = callableStatement.executeQuery();
            if (resultSet.next() && (n = resultSet.getInt(1)) == 1) {
                bl = true;
            }
            resultSet.close();
            callableStatement.close();
        }
        catch (SQLException sQLException) {
            message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.sql.error", this.commandName, this.dataSource.getClusterName(), this.dataSource.getInstanceName(), "select count(*) from sysobjects where type = 'P' and name = ?(" + string + ")", sQLException.getMessage());
        }
        return bl;
    }

    int shutdownServer(Connection connection, String string) {
        int n = 0;
        Statement statement = null;
        try {
            statement = connection.createStatement();
            String string2 = "shutdown " + string;
            LOG.debug((Object)("Cluster " + this.dataSource.getClusterName() + " - Executing \"" + string2));
            statement.execute(string2);
            statement.close();
        }
        catch (Exception exception) {
            LOG.debug((Object)("Connection terminated to the server: " + string + "\n" + exception.getLocalizedMessage()));
            return 5;
        }
        return n;
    }
}

