/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.ua;

import com.sybase.ase.sdcadmin.ex.SdClusterException;
import com.sybase.ase.sdcadmin.ua.ASEClusterDiscoveryFilter;
import com.sybase.ase.sdcadmin.ua.ASEDiscoveryFilter;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import com.sybase.ua.AgentConnection;
import com.sybase.ua.AgentConnectionException;
import com.sybase.ua.AgentConnectionFactory;
import com.sybase.ua.AgentDiscovery;
import com.sybase.ua.DiscoveryFilter;
import com.sybase.ua.PluginInfo;
import com.sybase.ua.discovery.DiscoveryException;
import com.sybase.ua.util.AgentClientUtil;
import java.io.ByteArrayInputStream;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AgentClient
implements ISdConstants {
    private static Log log = LogFactory.getLog(AgentClient.class);
    public static final String ASE_PLUGIN_ID = "com.sybase.ase";
    public static final String ASE_CLUSTER_PLUGIN_ID = "com.sybase.ase.cluster";
    public static final String ASE_MINIMUM_PLUGIN_VERSION = "0.1.0";
    public static final int ASE_MINIMUM_PLUGIN_VERSION_INT = 1000;
    public static final String ASE_CLUSTER_MINIMUM_PLUGIN_VERSION = "0.1.0";
    public static final int ASE_CLUSTER_MINIMUM_PLUGIN_VERSION_INT = 1000;
    public static final String ASE_CLUSTER_AGENT_PLUGIN_PLUGIN_VERSION = "15.0.1";
    public static final String AGENT_PROP_CLUSTER_NAME = "ClusterName";
    public static final String AGENT_PROP_ASE_NAME = "ServerName";
    public static final int CONNECTION_MODE_DISCOVERY = 1;
    public static final int CONNECTION_MODE_POINT_TO_POINT = 2;
    private int agentConnectionMode = 2;
    private AgentConnection agentConnection = null;
    private String asePluginVersion = null;
    private String aseClusterPluginVersion = null;
    private int aseInstanceNumber = 0;
    private int aseClusterInstanceNumber = 0;
    private String directConnectionUrl = null;
    private String discoveryService = null;
    private String discoveryServiceHost = null;
    private String discoveryServicePort = null;

    public AgentClient() {
    }

    public AgentClient(String string, String string2, String string3, String string4, char[] cArray) throws Exception {
        this.setDirectConnectionURL(string2, string3);
        this.connect(string, string2, string4, new String(cArray));
    }

    public void setDirectConnectionURL(String string, String string2) {
        this.directConnectionUrl = "service:jmx:rmi:///jndi/rmi://" + string + ":" + string2 + "/agent";
        this.agentConnectionMode = 2;
    }

    public void setConnectionParamaters(String string) throws Exception {
        if (string == null || string.equals("")) {
            log.debug((Object)"No agent specification.  Setting Discovery mode.");
            this.agentConnectionMode = 1;
        } else if (string.toUpperCase().startsWith("SERVICE:JMX:")) {
            this.agentConnectionMode = 2;
            this.directConnectionUrl = string;
        } else {
            String string2 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            if (stringTokenizer.countTokens() > 1) {
                string2 = (String)stringTokenizer.nextElement();
                if (string2.equalsIgnoreCase("JINI")) {
                    this.agentConnectionMode = 1;
                } else if (string2.equalsIgnoreCase("LDAP")) {
                    this.agentConnectionMode = 1;
                } else if (string2.equalsIgnoreCase("SLP")) {
                    this.agentConnectionMode = 1;
                }
            }
            String string3 = null;
            if (stringTokenizer.countTokens() > 0 && (string3 = (String)stringTokenizer.nextElement()).startsWith("//")) {
                string3 = string3.substring(2);
            }
            String string4 = null;
            if (stringTokenizer.countTokens() > 0) {
                string4 = (String)stringTokenizer.nextElement();
            }
            if (this.agentConnectionMode == 1) {
                this.discoveryService = string2;
                this.discoveryServiceHost = string3;
                this.discoveryServicePort = string4;
                log.debug((Object)"Agent Discovery Mode Set");
            } else if (this.agentConnectionMode == 2) {
                if (string2 == null) {
                    string2 = "rmi";
                }
                if (string4 == null) {
                    string4 = "9999";
                }
                this.directConnectionUrl = "service:jmx:" + string2 + ":///jndi/" + string2 + "://" + string3 + ":" + string4 + "/agent";
                log.debug((Object)("Agent Direct Connect Mode Set.  URL: " + this.directConnectionUrl));
            }
        }
    }

    public boolean connect(String string, String string2, String string3, String string4) throws Exception {
        if (this.agentConnectionMode == 1) {
            return this.discoverASEClusterPlugin(string, string2, this.discoveryServiceHost, this.discoveryServicePort, string3, string4);
        }
        if (this.agentConnectionMode == 2) {
            Object object;
            AgentConnection agentConnection = null;
            try {
                agentConnection = AgentConnectionFactory.createAgentConnection((String)this.directConnectionUrl);
            }
            catch (RemoteException remoteException) {
                throw new SdClusterException("agent.connection.failed", this.directConnectionUrl, (Object)remoteException.getMessage());
            }
            try {
                object = new Properties();
                object.put("username", string3);
                object.put("password", string4.toCharArray());
                agentConnection.connect((Map)object);
            }
            catch (AgentConnectionException agentConnectionException) {
                throw new SdClusterException("agent.connection.failed", this.directConnectionUrl, (Object)agentConnectionException.getMessage());
            }
            if (agentConnection != null) {
                this.agentConnection = agentConnection;
                try {
                    Object object2;
                    object = agentConnection.getAgentInfo().getPluginInfos(ASE_CLUSTER_PLUGIN_ID);
                    ASEClusterDiscoveryFilter aSEClusterDiscoveryFilter = new ASEClusterDiscoveryFilter(string, string2);
                    Object object3 = object.iterator();
                    while (object3.hasNext()) {
                        object2 = (PluginInfo)object3.next();
                        if (!aSEClusterDiscoveryFilter.acceptAgentPlugin((PluginInfo)object2)) continue;
                        this.aseClusterPluginVersion = object2.getVersion();
                        this.aseClusterInstanceNumber = object2.getInstanceNumber();
                        break;
                    }
                    if (this.aseClusterPluginVersion != null) {
                        object = agentConnection.getAgentInfo().getPluginInfos(ASE_PLUGIN_ID);
                        object3 = new ASEDiscoveryFilter(string2);
                        object2 = object.iterator();
                        while (object2.hasNext()) {
                            PluginInfo pluginInfo = (PluginInfo)object2.next();
                            if (!((ASEDiscoveryFilter)((Object)object3)).acceptAgentPlugin(pluginInfo)) continue;
                            this.asePluginVersion = pluginInfo.getVersion();
                            this.aseInstanceNumber = pluginInfo.getInstanceNumber();
                            return true;
                        }
                    }
                }
                catch (AgentConnectionException agentConnectionException) {
                    throw new SdClusterException("agent.plugin.infoerror", (Exception)((Object)agentConnectionException), (Object)this.directConnectionUrl);
                }
            }
        }
        return false;
    }

    private boolean discoverASEClusterPlugin(String string, String string2, String string3, String string4, String string5, String string6) throws SdClusterException {
        Object object;
        Object object22;
        AgentDiscovery agentDiscovery = null;
        try {
            agentDiscovery = new AgentDiscovery(this.discoveryService, string3, string4);
        }
        catch (DiscoveryException discoveryException) {
            log.error((Object)("Unable to connect to " + string3 + ":" + string4 + " for discovery."), (Throwable)discoveryException);
            throw new SdClusterException("agent.discovery.exception", (Exception)((Object)discoveryException), (Object)string3, (Object)string4);
        }
        if (string2 == null) {
            log.debug((Object)("Looking for agents that are supporting a cluster by the name " + string + "."));
        } else if (string == null) {
            log.debug((Object)("Looking for an agent that is residing on a host by the name " + string2 + "."));
        } else {
            log.debug((Object)("Looking for a cluster/host by the name " + string + "/" + string2 + "."));
        }
        ASEClusterDiscoveryFilter aSEClusterDiscoveryFilter = new ASEClusterDiscoveryFilter(string, string2);
        try {
            agentDiscovery.discover((DiscoveryFilter)aSEClusterDiscoveryFilter);
        }
        catch (DiscoveryException discoveryException) {
            log.error((Object)"Unable to discover the cluster/server", (Throwable)discoveryException);
            throw new SdClusterException("agent.discovery.exception", (Exception)((Object)discoveryException));
        }
        List list = agentDiscovery.getAgentInfos();
        if (string2 == null) {
            log.debug((Object)("Found " + list.size() + " agents supporting a cluster by the name " + string + "."));
        } else if (string == null) {
            log.debug((Object)("Found " + list.size() + " agents supporting a cluster on host " + string2 + "."));
        } else {
            log.debug((Object)("Found " + list.size() + " agents supporting a cluster/host by the name " + string + "/" + string2 + "."));
        }
        for (Object object22 : list) {
            object = object22.getHost() + "\t" + object22.getRMIPort() + "\t" + object22.getVersion() + "\t" + object22.getOSName() + " " + object22.getOSVersion() + " " + object22.getOSArchitecture();
            log.debug(object);
        }
        Object object3 = null;
        try {
            object3 = agentDiscovery.getAgentConnections();
        }
        catch (AgentConnectionException agentConnectionException) {
            log.error((Object)"Getting the list of Agent Connections", (Throwable)agentConnectionException);
            throw new SdClusterException("agent.connection.list", (Exception)((Object)agentConnectionException));
        }
        object22 = object3.iterator();
        while (object22.hasNext()) {
            Object object4;
            object = (AgentConnection)object22.next();
            try {
                Object object5;
                try {
                    object5 = new Properties();
                    object5.put("username", string5);
                    object5.put("password", string6.toCharArray());
                    object.connect((Map)object5);
                }
                catch (AgentConnectionException agentConnectionException) {
                    throw new SdClusterException("agent.connection.failed", this.directConnectionUrl, (Object)agentConnectionException.getMessage());
                }
                if (this.agentConnection != null) {
                    this.agentConnection.disconnect();
                }
                this.agentConnection = object;
                object5 = object.getAgentInfo().getPluginInfos(ASE_CLUSTER_PLUGIN_ID);
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    PluginInfo pluginInfo = (PluginInfo)object4.next();
                    if (!aSEClusterDiscoveryFilter.acceptAgentPlugin(pluginInfo)) continue;
                    this.aseClusterPluginVersion = pluginInfo.getVersion();
                    this.aseClusterInstanceNumber = pluginInfo.getInstanceNumber();
                    return true;
                }
            }
            catch (Exception exception) {
                object4 = null;
                try {
                    object4 = object.getAgentURLAsString();
                    log.warn((Object)("Failed to connect to agent " + (String)object4));
                    log.warn((Object)exception.getMessage());
                }
                catch (AgentConnectionException agentConnectionException) {
                    log.warn((Object)agentConnectionException.getMessage());
                }
            }
            try {
                object.disconnect();
            }
            catch (AgentConnectionException agentConnectionException) {
                object4 = null;
                try {
                    object4 = object.getAgentURLAsString();
                    log.warn((Object)("Failed to disconnect from agent " + (String)object4));
                    log.warn((Object)agentConnectionException.getMessage());
                }
                catch (AgentConnectionException agentConnectionException2) {
                    log.warn((Object)agentConnectionException2.getMessage());
                }
            }
        }
        return false;
    }

    public static int getVersionValue(String string) throws NumberFormatException {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n2 = stringTokenizer.countTokens();
        Integer[] integerArray = null;
        integerArray = new Integer[n2];
        for (n = 0; n < n2; ++n) {
            integerArray[n] = new Integer((String)stringTokenizer.nextElement());
        }
        n = integerArray[0] * 1000000 + integerArray[1] * 1000 + integerArray[2];
        return n;
    }

    public AgentConnection getAgentConnection() {
        return this.agentConnection;
    }

    public String getAseProperty(String string) throws Exception {
        return (String)this.agentConnection.getAgentPluginProperty(ASE_PLUGIN_ID, this.asePluginVersion, this.aseInstanceNumber, string);
    }

    public String getAseClusterProperty(String string) throws Exception {
        return (String)this.agentConnection.getAgentPluginProperty(ASE_CLUSTER_PLUGIN_ID, this.aseClusterPluginVersion, this.aseClusterInstanceNumber, string);
    }

    public String getEnvironmentProperty(String string) throws Exception {
        return (String)this.agentConnection.getAgentServiceProperty("EnvironmentDiscoveryService", string);
    }

    public String getTextFile(String string) throws Exception {
        String string2 = null;
        if (string == null || string.equals("")) {
            throw new SdClusterException("agent.file.notspecified");
        }
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        string2 = (String)this.agentConnection.invokeAgentServiceMethod("FileTransferService", "downloadTextFile", objectArray, stringArray);
        return string2;
    }

    public void putTextFile(String string, String string2) throws Exception {
        if (string == null || string.equals("")) {
            throw new SdClusterException("agent.cluster.config.pathspec.unspecified");
        }
        byte[] byArray = string2.getBytes();
        long l = byArray.length;
        String[] stringArray = new String[]{"java.lang.String", "[B", "java.lang.String"};
        Object[] objectArray = new Object[]{string, byArray, new String("ASE_CLUSTER_CONFIG_FILE_TRANSFER")};
        log.debug((Object)("Started to transfer " + string + ". Size: " + l + " bytes."));
        this.agentConnection.invokeAgentServiceMethod("FileTransferService", "upload", objectArray, stringArray);
        log.debug((Object)"File transfer finished.");
    }

    public byte[] getByteArray(String string) throws Exception {
        byte[] byArray = null;
        if (string == null || string.equals("")) {
            throw new SdClusterException("agent.file.notspecified");
        }
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        byArray = (byte[])this.agentConnection.invokeAgentServiceMethod("FileTransferService", "downloadBinaryFile", objectArray, stringArray);
        return byArray;
    }

    public void deleteFile(String string) throws Exception {
        if (string == null || string.equals("")) {
            throw new SdClusterException("agent.file.notspecified");
        }
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        this.agentConnection.invokeAgentServiceMethod("FileTransferService", "delete", objectArray, stringArray);
    }

    public ByteArrayInputStream getInputStream(String string) throws Exception {
        byte[] byArray = this.getByteArray(string);
        return new ByteArrayInputStream(byArray);
    }

    public int getAgentConnectionMode() {
        return this.agentConnectionMode;
    }

    public Object invokeAseMethod(String string, Object[] objectArray, String[] stringArray) throws AgentConnectionException {
        String string2 = AgentClientUtil.getPluginMBeanName((String)ASE_PLUGIN_ID, (String)this.asePluginVersion, (int)this.aseInstanceNumber);
        return this.agentConnection.invokeAgentPluginMethod(string2, string, objectArray, stringArray);
    }

    public Object invokeAseClusterMethod(String string, Object[] objectArray, String[] stringArray) throws AgentConnectionException {
        this.setAseClusterInstanceNumber(1);
        this.setAseClusterPluginVersion(ASE_CLUSTER_AGENT_PLUGIN_PLUGIN_VERSION);
        String string2 = AgentClientUtil.getPluginMBeanName((String)ASE_CLUSTER_PLUGIN_ID, (String)this.aseClusterPluginVersion, (int)this.aseClusterInstanceNumber);
        return this.agentConnection.invokeAgentPluginMethod(string2, string, objectArray, stringArray);
    }

    public String getLineSeparator() {
        String string = null;
        try {
            string = this.getEnvironmentProperty("LineSeparator");
        }
        catch (Exception exception) {
            string = "\n";
        }
        return string;
    }

    public String getAsePluginVersion() {
        return this.asePluginVersion;
    }

    public String getAseClusterPluginVersion() {
        return this.aseClusterPluginVersion;
    }

    public void setAseClusterPluginVersion(String string) {
        this.aseClusterPluginVersion = string;
    }

    public int getAseInstanceNumber() {
        return this.aseInstanceNumber;
    }

    public int getAseClusterInstanceNumber() {
        return this.aseClusterInstanceNumber;
    }

    public void setAseClusterInstanceNumber(int n) {
        this.aseClusterInstanceNumber = n;
    }

    public void setAgentConnectionMode(int n) {
        this.agentConnectionMode = n;
    }
}

