/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.util;

import com.sybase.ase.sdcadmin.lang.IResourceConstants;
import com.sybase.ase.sdcadmin.quorum.Quorum;
import com.sybase.ase.sdcadmin.quorum.QuorumCluster;
import com.sybase.ase.sdcadmin.quorum.QuorumInstance;
import com.sybase.ase.sdcadmin.quorum.QuorumStatus;
import com.sybase.ase.sdcadmin.util.FileUtil;
import com.sybase.ase.sdcadmin.util.Message;
import com.sybase.ase.sdcadmin.util.ProcessLogThread;
import com.sybase.ase.sdcadmin.util.ShellCommand;
import java.io.File;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AseRunner
extends Thread
implements IResourceConstants {
    private static Log log = LogFactory.getLog(AseRunner.class);
    private boolean succeeded = false;
    private String command;
    private Object monitor;
    private ResourceBundle resourceBundle;
    private String[] envp = null;
    private String clusterName = null;
    private String instanceName = null;
    private int instanceId = 0;
    private File aseHomeDir = null;
    private File sybaseHomeDir = null;
    private File quorumDevice = null;
    private File masterDevice = null;
    private String username = null;
    private char[] password = null;
    private Quorum quorum = null;
    private QuorumCluster quorumCluster = null;
    private QuorumInstance quorumInstance = null;
    private int retries = 6;
    private int interval = 10;
    private Message message = null;

    public AseRunner(Message message, String string, Object object, ResourceBundle resourceBundle) {
        super(string);
        this.message = message;
        this.monitor = object;
        this.resourceBundle = resourceBundle;
    }

    @Override
    public void run() {
        Object object;
        Process process = null;
        try {
            log.debug((Object)FileUtil.removeControlCharacter("Executing " + this.command));
            object = ShellCommand.parseCommandWithoutArgs(this.command);
            if (!ShellCommand.isInCommandRoutine((String)object, null)) {
                this.succeeded = false;
                this.notifyCaller();
                return;
            }
            process = Runtime.getRuntime().exec(this.command, this.envp, this.sybaseHomeDir);
        }
        catch (Exception exception) {
            log.error((Object)("Failed to execute " + this.command + ". " + exception.getMessage()));
            this.succeeded = false;
            this.notifyCaller();
            return;
        }
        object = new ProcessLogThread(this.message, this.resourceBundle, "ASERunnerLogThread", process);
        ((Thread)object).start();
        try {
            Thread.sleep(this.interval * 1000);
        }
        catch (Exception exception) {
            log.debug((Object)exception);
        }
        this.quorum.setConservative(false);
        boolean bl = false;
        for (int i = 0; i < this.retries; ++i) {
            try {
                QuorumStatus quorumStatus = this.quorum.getQuorumStatus();
                int n = quorumStatus.getInstanceStatus()[this.instanceId - 1];
                String[] stringArray = quorumStatus.getStatusStrings(this.resourceBundle);
                String string = stringArray[this.instanceId - 1];
                if (n == 4) {
                    this.succeeded = true;
                    ((ProcessLogThread)object).setDone();
                    this.notifyCaller();
                    return;
                }
                if (n != 6) {
                    bl = true;
                }
                if (n == 6 && bl) {
                    this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.aserunner.failed", this.instanceName);
                    break;
                }
                this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.aserunner.waiting.info", this.instanceName, string, new Integer(this.interval), new Integer(this.retries - i));
                if (i == this.retries - 1) {
                    this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.aserunner.timedout.warn", this.instanceName);
                    break;
                }
                Thread.sleep(this.interval * 1000);
                continue;
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            catch (Exception exception) {
                log.debug((Object)exception);
            }
        }
        ((ProcessLogThread)object).setDone();
        this.notifyCaller();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCaller() {
        log.debug((Object)"Notify the caller that ASERunner thread is done.");
        if (this.monitor != null) {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
            }
        }
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }

    public void setSucceeded(boolean bl) {
        this.succeeded = bl;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public String getCommand() {
        return this.command;
    }

    public File getAseHomeDir() {
        return this.aseHomeDir;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public File getSybaseHomeDir() {
        return this.sybaseHomeDir;
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public String[] getEnvp() {
        return this.envp;
    }

    public File getQuorumDevice() {
        return this.quorumDevice;
    }

    public File getMasterDevice() {
        return this.masterDevice;
    }

    public void setAseHomeDir(File file) {
        this.aseHomeDir = file;
    }

    public void setClusterName(String string) {
        this.clusterName = string;
    }

    public void setInstanceName(String string) {
        this.instanceName = string;
    }

    public void setSybaseHomeDir(File file) {
        this.sybaseHomeDir = file;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(char[] cArray) {
        this.password = cArray;
    }

    public void setEnvp(String[] stringArray) {
        this.envp = stringArray;
    }

    public void setQuorumDevice(File file) {
        this.quorumDevice = file;
    }

    public void setMasterDevice(File file) {
        this.masterDevice = file;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(int n) {
        this.instanceId = n;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int n) {
        this.retries = n;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int n) {
        this.interval = n;
    }

    public Quorum getQuorum() {
        return this.quorum;
    }

    public void setQuorum(Quorum quorum) {
        this.quorum = quorum;
    }

    public QuorumCluster getQuorumCluster() {
        return this.quorumCluster;
    }

    public void setQuorumCluster(QuorumCluster quorumCluster) {
        this.quorumCluster = quorumCluster;
    }

    public QuorumInstance getQuorumInstance() {
        return this.quorumInstance;
    }

    public void setQuorumInstance(QuorumInstance quorumInstance) {
        this.quorumInstance = quorumInstance;
    }
}

