/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.util;

import java.io.File;
import java.io.IOException;

public class FileUtil {
    public static boolean isNormalPath(String string) {
        return string != null && string.length() > 0 && string.indexOf("..") < 0;
    }

    public static boolean isExisting(String string) {
        if (!FileUtil.isNormalPath(string)) {
            return false;
        }
        File file = new File(string);
        return file.exists();
    }

    public static boolean isExistingFile(String string) {
        if (!FileUtil.isNormalPath(string)) {
            return false;
        }
        File file = new File(string);
        return file.isFile();
    }

    public static File sanitizedFile(File file, String string) throws IOException {
        String string2;
        String string3 = string2 = string == null ? "" : string.trim();
        if (string2.length() == 0) {
            return file;
        }
        if (new File(string2).isAbsolute()) {
            throw new PathTraversalException(file, string2);
        }
        String string4 = file.getCanonicalPath();
        String string5 = new File(file, string2).getCanonicalPath();
        if (!string5.startsWith(string4)) {
            throw new PathTraversalException(file, string2);
        }
        return new File(string5);
    }

    public static File sanitizedFile(String string, String string2) throws IOException {
        return FileUtil.sanitizedFile(new File(string), string2);
    }

    public static boolean isInSubdirectory(String string, String string2) throws IllegalStateException {
        return FileUtil.isInSubdirectory(string, new File(string2));
    }

    public static boolean isInSubdirectory(String string, File file) throws IllegalStateException {
        return FileUtil.isInSubdirectory(new File(string), file);
    }

    public static boolean isInSubdirectory(File file, String string) throws IllegalStateException {
        return FileUtil.isInSubdirectory(file, new File(string));
    }

    public static boolean isInSubdirectory(File file, File file2) throws IllegalStateException {
        if (file == null || file2 == null) {
            return false;
        }
        try {
            String string = file.getCanonicalPath();
            String string2 = file2.getCanonicalPath();
            return string2.startsWith(string);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to convert file to canonical path", iOException);
        }
    }

    public static final String removeControlCharacter(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.codePointCount(0, string.length()); ++i) {
            int n = string.codePointAt(i);
            if (Character.isISOControl(n)) continue;
            stringBuilder.appendCodePoint(n);
        }
        return stringBuilder.toString();
    }

    public static class PathTraversalException
    extends IOException {
        private static final long serialVersionUID = 1L;

        static String asCanonicalPath(File file) {
            try {
                return file != null ? file.getCanonicalPath() : "null";
            }
            catch (IOException iOException) {
                return file.getAbsolutePath();
            }
        }

        protected PathTraversalException() {
        }

        public PathTraversalException(File file, String string) {
            super("The specified path (" + string + ") is a " + (new File(string).isAbsolute() ? "absolute" : "relative") + " path to a location outside of the specified base directory (" + PathTraversalException.asCanonicalPath(file) + ").");
        }
    }
}

