/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.util;

import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import com.sybase.ase.sdcadmin.ua.AgentClient;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import com.sybase.ase.sdcadmin.util.Message;
import com.sybase.ase.sdcadmin.util.PortUtil;
import com.sybase.ua.util.MessageListener;
import com.sybase.util.ds.DirectoryServiceHelper;
import com.sybase.util.ds.Utils;
import com.sybase.util.ds.interfaces.InterfacesException;
import com.sybase.util.ds.interfaces.Service;
import com.sybase.util.ds.interfaces.SyInterfacesEntry;
import com.sybase.util.ds.ldap.SyLDAPServer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.directory.AttributeInUseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InterfacesHelper
implements ISdConstants {
    private static Log log = LogFactory.getLog(InterfacesHelper.class);
    DirectoryServiceHelper dsHelper = null;
    private String interfacesPathspec = null;
    private ResourceBundle resourceBundle;
    private String commandName;
    private Message message;
    private boolean useLDAP = false;
    String ldapHost;
    String ldapPort;

    public InterfacesHelper(String string) {
        if (string != null) {
            this.interfacesPathspec = InterfacesHelper.getInterfacePathspec(string);
            this.loadInterfaces();
        } else {
            this.loadLDAP();
        }
    }

    public InterfacesHelper(String string, boolean bl, MessageListener messageListener) {
        this.message = new Message(messageListener);
        if (string != null) {
            File file;
            this.interfacesPathspec = InterfacesHelper.getInterfacePathspec(string);
            if (bl && !(file = new File(this.interfacesPathspec)).exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    log.error((Object)"Could not create the interfaces file.");
                    this.message.output(this.resourceBundle, "sdcadmin.create.serverconfig.interface.create.error", file.getPath());
                }
            }
            this.loadInterfaces();
        } else {
            this.loadLDAP();
        }
    }

    public String getHost(String string) throws Exception {
        if (this.useLDAP) {
            return this.dsHelper.getHostFromLDAP(this.ldapHost, this.ldapPort, string);
        }
        return this.dsHelper.getHostFromInterfaces(string);
    }

    public String getPort(String string) throws Exception {
        if (this.useLDAP) {
            return this.dsHelper.getPortFromLDAP(this.ldapHost, this.ldapPort, string);
        }
        return this.dsHelper.getPortFromInterfaces(string);
    }

    private int loadInterfaces() {
        System.setProperty("interfaces.file", this.interfacesPathspec);
        try {
            this.dsHelper = new DirectoryServiceHelper(true, false);
            this.dsHelper.initInterfacesDriver(this.interfacesPathspec);
        }
        catch (InterfacesException interfacesException) {
            log.debug((Object)("The Interfaces file at " + this.interfacesPathspec + " reports Id: " + interfacesException.getId() + "; Reason: " + interfacesException.getDetailId() + "; Message: " + interfacesException.getMessage()));
            return 9;
        }
        catch (Exception exception) {
            this.message.output(this.resourceBundle, "com.sybase.ase.sdcadmin.interfaces.load.error", this.commandName, "", "", this.interfacesPathspec);
            return 9;
        }
        return 0;
    }

    private int loadLDAP() {
        this.useLDAP = true;
        try {
            this.dsHelper = new DirectoryServiceHelper(false, true);
            String string = this.getLDAPServer();
            if (string != null) {
                String[] stringArray = string.split(":");
                this.ldapHost = stringArray[0];
                this.ldapPort = stringArray[1];
            }
        }
        catch (InterfacesException interfacesException) {
            log.debug((Object)("The Interfaces file at " + this.interfacesPathspec + " reports Id: " + interfacesException.getId() + "; Reason: " + interfacesException.getDetailId() + "; Message: " + interfacesException.getMessage()));
            return 9;
        }
        catch (Exception exception) {
            log.debug((Object)("Could not initialise for LDAP: " + exception.getMessage()));
            return 8;
        }
        return 0;
    }

    public static String getInterfacePathspec(String string) {
        String string2 = null;
        string2 = System.getProperty("os.name").toLowerCase().indexOf("win") != -1 ? string + File.separator + "ini" + File.separator + "sql.ini" : string + File.separator + "interfaces";
        return string2;
    }

    public void addInstance(ICluster iCluster, String string, String string2, String string3) throws Exception {
        this.addEntry(string, string2, string3);
        this.updateClusterEntry(iCluster);
    }

    public void dropInstance(ICluster iCluster, String string, String string2, String string3) throws Exception {
        this.deleteEntry(string);
        this.updateClusterEntry(iCluster);
    }

    public void addClusterEntry(ICluster iCluster) throws Exception {
        int n;
        IServer[] iServerArray = iCluster.getServersArray();
        SyInterfacesEntry syInterfacesEntry = new SyInterfacesEntry(iCluster.getName());
        List list = syInterfacesEntry.getServices();
        for (n = 0; n < iServerArray.length; ++n) {
            Service service = new Service(1, this.getProtocol(), iServerArray[n].getNode(), iServerArray[n].getQueryPort());
            list.add(service);
        }
        this.addEntry(syInterfacesEntry);
        for (n = 0; n < iServerArray.length; ++n) {
            this.addEntry(iServerArray[n].getName(), iServerArray[n].getNode(), iServerArray[n].getQueryPort());
        }
    }

    public void updateClusterEntry(ICluster iCluster) throws Exception {
        this.deleteEntry(iCluster.getName());
        IServer[] iServerArray = iCluster.getServersArray();
        SyInterfacesEntry syInterfacesEntry = new SyInterfacesEntry(iCluster.getName());
        List list = syInterfacesEntry.getServices();
        for (int i = 0; i < iServerArray.length; ++i) {
            Service service = new Service(1, this.getProtocol(), iServerArray[i].getNode(), iServerArray[i].getQueryPort());
            list.add(service);
        }
        this.addEntry(syInterfacesEntry);
    }

    public void deleteEntry(String string) throws Exception {
        if (this.useLDAP) {
            this.dsHelper.deleteEntryFromLDAP(this.ldapHost, this.ldapPort, string);
        } else {
            this.dsHelper.deleteEntry(string);
        }
    }

    public void dropCluster(String string, String[] stringArray) throws Exception {
        this.deleteEntry(string);
        for (int i = 0; i < stringArray.length; ++i) {
            this.deleteEntry(stringArray[i]);
        }
    }

    public boolean entryExists(String string) throws Exception {
        if (this.useLDAP) {
            return this.dsHelper.doesServerEntryExistInLDAP(this.ldapHost, this.ldapPort, string) != null;
        }
        return this.dsHelper.doesServerEntryExistInInterfaces(string) != null;
    }

    public boolean hostPortEntryExists(String string, String string2) throws Exception {
        List list = this.useLDAP ? this.dsHelper.doesHostPortExistInLDAP(this.ldapHost, this.ldapPort, string, string2) : this.dsHelper.doesHostPortExistInInterfaces(string, string2);
        return list != null && list.size() != 0;
    }

    public boolean serviceExists(String string, String string2, String string3) throws Exception {
        Service service;
        List list = this.getServices(string);
        return list.contains(service = new Service(1, this.getProtocol(), string2, string3));
    }

    public void addBackupServer(ICluster iCluster) throws Exception {
        IServer[] iServerArray = iCluster.getServersArray();
        SyInterfacesEntry syInterfacesEntry = new SyInterfacesEntry(iCluster.getBackupServerName());
        List list = syInterfacesEntry.getServices();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getProtocol();
        for (int i = 0; i < iServerArray.length; ++i) {
            Service service;
            String string2;
            if (iServerArray[i].getBackupServerPort() == null || arrayList.contains(string2 = iServerArray[i].getNode()) || Integer.parseInt(iServerArray[i].getBackupServerPort()) <= 0) continue;
            arrayList.add(string2);
            if (!this.useLDAP) {
                service = new Service(0, string, iServerArray[i].getNode(), iServerArray[i].getBackupServerPort());
                list.add(service);
            }
            service = new Service(1, string, iServerArray[i].getNode(), iServerArray[i].getBackupServerPort());
            list.add(service);
        }
        this.addEntry(syInterfacesEntry);
    }

    public void addEntry(String string, String string2, String string3) throws Exception {
        Service service;
        SyInterfacesEntry syInterfacesEntry = new SyInterfacesEntry(string);
        List list = syInterfacesEntry.getServices();
        String string4 = this.getProtocol();
        if (!this.useLDAP) {
            service = new Service(0, string4, string2, string3);
            list.add(service);
        }
        service = new Service(1, string4, string2, string3);
        list.add(service);
        this.addEntry(syInterfacesEntry);
    }

    public List getServices(String string) throws NamingException {
        if (this.useLDAP) {
            return this.dsHelper.getServicesForEntryFromLDAP(this.ldapHost, this.ldapPort, string);
        }
        return this.dsHelper.getServices(string);
    }

    public void dropServiceFromServer(String string, String string2, String string3, String string4) throws Exception {
        Service service = new Service(string2, this.getProtocol(), string3, string4);
        if (this.useLDAP) {
            if (!string2.equalsIgnoreCase("master")) {
                this.dsHelper.deleteServiceFromEntryInLDAP(this.ldapHost, this.ldapPort, string, service);
            }
        } else {
            this.dsHelper.deleteServiceFromEntry(string, service);
        }
    }

    public void addServiceToServer(String string, String string2, String string3, String string4) throws Exception {
        Service service = new Service(string2, this.getProtocol(), string3, string4);
        if (this.useLDAP) {
            if (!string2.equalsIgnoreCase("master")) {
                this.dsHelper.addServiceToEntryInLDAP(this.ldapHost, this.ldapPort, string, service);
            }
        } else {
            this.dsHelper.addServiceToEntry(string, service);
        }
    }

    public String getProtocol() {
        if (Utils.OS_WINDOWS) {
            return "NLWNSCK";
        }
        return "tcp ether";
    }

    public void addEntry(SyInterfacesEntry syInterfacesEntry) throws IOException, NamingException {
        if (this.useLDAP) {
            try {
                this.dsHelper.addEntryToLDAP(this.ldapHost, this.ldapPort, syInterfacesEntry);
            }
            catch (AttributeInUseException attributeInUseException) {
                System.out.println(attributeInUseException);
                log.error((Object)attributeInUseException, (Throwable)attributeInUseException);
            }
        } else {
            this.dsHelper.addEntryToInterfaces(syInterfacesEntry);
        }
    }

    public String getLDAPServer() {
        String string = null;
        Vector vector = this.dsHelper.getLDAPServers();
        if (vector != null && vector.size() != 0) {
            SyLDAPServer syLDAPServer = (SyLDAPServer)vector.get(0);
            string = syLDAPServer.getHost() + ":" + syLDAPServer.getPort();
        }
        return string;
    }

    public static int addToRemoteInterfaces(ICluster iCluster, HashMap hashMap, String string, char[] cArray, String string2) {
        int n = 0;
        IServer[] iServerArray = iCluster.getServersArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        for (int i = 0; i < iServerArray.length; ++i) {
            if (arrayList.contains(iServerArray[i].getInterfacesPath()) && PortUtil.isThisHost(iServerArray[i].getNode())) continue;
            Object[] objectArray = new Object[]{iServerArray[i].getInterfacesPath(), hashMap, null};
            String[] stringArray = new String[]{"java.lang.String", "java.util.HashMap", "com.sybase.ua.util.MessageListener"};
            String string3 = iServerArray[i].getNode();
            String string4 = iServerArray[i].getAgentPort();
            try {
                AgentClient agentClient = new AgentClient(iCluster.getName(), string3, string4, string, cArray);
                n = (Integer)agentClient.invokeAseClusterMethod("addToInterfaces", objectArray, stringArray);
                if (n != 0) {
                    return n;
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
                log.error((Object)exception, (Throwable)exception);
                return 7;
            }
            arrayList.add(iServerArray[i].getInterfacesPath());
        }
        return n;
    }

    public static int deleteFromRemoteInterfaces(ICluster iCluster, List list, String string, char[] cArray, String string2) {
        int n = 0;
        IServer[] iServerArray = iCluster.getServersArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        for (int i = 0; i < iServerArray.length; ++i) {
            if (arrayList.contains(iServerArray[i].getInterfacesPath()) && PortUtil.isThisHost(iServerArray[i].getNode())) continue;
            Object[] objectArray = new Object[]{iServerArray[i].getInterfacesPath(), list, null};
            String[] stringArray = new String[]{"java.lang.String", "java.util.List", "com.sybase.ua.util.MessageListener"};
            String string3 = iServerArray[i].getNode();
            String string4 = iServerArray[i].getAgentPort();
            try {
                AgentClient agentClient = new AgentClient(iCluster.getName(), string3, string4, string, cArray);
                n = (Integer)agentClient.invokeAseClusterMethod("deleteFromInterfaces", objectArray, stringArray);
                if (n != 0) {
                    return n;
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
                log.error((Object)exception, (Throwable)exception);
                return 7;
            }
            arrayList.add(iServerArray[i].getInterfacesPath());
        }
        return n;
    }
}

