/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.util;

import com.sybase.ase.sdcadmin.ex.LocalizationException;
import com.sybase.ase.sdcadmin.util.ISdConstants;
import com.sybase.ase.sdcadmin.util.ShellCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalizationUtil
implements ISdConstants {
    private static final Log log = LogFactory.getLog(LocalizationUtil.class);
    private final String SYB_UNICODE_DIR = "unicode";
    public static final String JBDC_DRIVER_CLASS = "com.sybase.jdbc3.jdbc.SybDriver";
    public static final String JDBC_URL_PREFIX = "jdbc:sybase:Tds:";
    public static final String GET_DEFAULT_LANG_ID = "select value from master..syscurconfigs where config=124";
    public static final String GET_LANG_NAME_FROM_ID = "select name from master..syslanguages where langid = ?";
    public static final String GET_DEFAULT_CHARSET = "select name from master..syscharsets, master..syscurconfigs where id = value and config = 131 and csid = 0 and master..syscharsets.type between 1000 and 1999 ";
    public static final String GET_DEFAULT_SORTORDER = "select name from master..syscharsets where id = (select distinct value from master..syscurconfigs where config = 123) and csid = (select distinct value from master..syscurconfigs where config = 131) and type between 2000 and 2999";
    public static final String GET_LANGUAGES = "select name from master..syslanguages";
    public static final String GET_CHARSETS = "select name from master..syscharsets where type between 1000 and 1999";
    public static final String GET_SORTORDERS_UTF8 = "select  name, description from master..syscharsets where type between 2000 and 2999 and csid = 190";
    public static final String GET_SORTORDERS_FOR_CHARSET = "select name, description from master..syscharsets where type between 2000 and 2999 and csid in (select id from master..syscharsets where type between 1000 and 1999 and name = ?)";
    public static final String GET_LANG_ID = "select langid from master..syslanguages where name = ?";
    public static final String SET_DEFAULT_LANGUAGE = "sp_configure 'default language', ?";
    public static final String GET_CHARSET_ID = "select id from master..syscharsets where name = ? and type between 1000 and 1999";
    public static final String SET_DEFAULT_CHARSET = "sp_configure 'default character set id',  ?, ?";
    public static final String GET_SORTORDER_ID = "select id from master..syscharsets where name = ? and type between 2000 and 2999  ";
    public static final String SET_DEFAULT_SORTORDER = "sp_configure 'default sortorder id', ?, ?  ";
    public static final String REMOVE_LANGUAGE = "sp_droplanguage ?, dropmessages";
    public static final String REMOVE_CHARSET = "delete from master..syscharsets where name = ?";
    public static final String REMOVE_SORT_ORDER = "delete from master..syscharsets where name = ? and type between 2000 and 2999";
    public static final String ENABLE_SYSTEM_UPDATES = "sp_configure 'allow updates to system tables', ?";
    Connection jdbcConnection = null;
    String sybaseHomePath = null;
    String sybaseASEHomePath = null;

    public LocalizationUtil(Connection connection, String string, String string2) {
        this.jdbcConnection = connection;
        this.sybaseHomePath = string;
        this.sybaseASEHomePath = string2;
    }

    public int configureCharset(String string, String string2, String string3, String string4, String string5) throws LocalizationException {
        String string6;
        List list = this.getServerConfiguredCharsets();
        if (list != null && list.contains(string)) {
            log.info((Object)("The charset " + string + "is already installed in the server"));
            return 0;
        }
        HashMap hashMap = this.getServerConfiguredSortOrders(string);
        if (hashMap.containsKey(string6 = "bin_" + string)) {
            this.removeSortOrder(string6);
        }
        String string7 = "binary.srt";
        String string8 = this.getASEHomePath();
        String[] stringArray = new String[]{"sh", "-c", string5 != null ? string8 + "/bin/charset -S" + string2 + " -U" + string3 + " -P" + string4 + " -I" + string5 + " " + string7 + " " + string : string8 + "/bin/charset -S" + string2 + " -U" + string3 + " -P" + string4 + " " + string7 + " " + string};
        log.info((Object)("Running charset: " + stringArray[2]));
        try {
            ShellCommand.exec(null, null, stringArray, null, new File(string8, "bin"));
        }
        catch (Exception exception) {
            throw new LocalizationException("Exception while invoking charset command" + stringArray[2] + "\n" + exception.getMessage());
        }
        return 0;
    }

    public int configureLanguage(String string, String string2, String string3, String string4, String string5) throws LocalizationException {
        if (string.equalsIgnoreCase("us_english")) {
            log.info((Object)"English is already installed in the server");
            return 0;
        }
        if (this.getServerConfiguredLanguages().contains(string)) {
            log.info((Object)("The language " + string + " is already installed in the server"));
            return 0;
        }
        String string6 = this.getServerDefaultCharset();
        List list = this.getAllCharsets(string);
        if (!list.contains(string6)) {
            throw new LocalizationException("Language " + string + " is not compatible with default charset " + string6);
        }
        String string7 = this.getASEHomePath();
        String[] stringArray = new String[]{"sh", "-c", string5 != null ? string7 + "/bin/langinstall -S" + string2 + " -U" + string3 + " -P" + string4 + " -I" + string5 + " " + string + " " + string6 : string7 + "/bin/langinstall -S" + string2 + " -U" + string3 + " -P" + string4 + " " + string + " " + string6};
        log.info((Object)("Running langinstall: " + stringArray[2]));
        try {
            ShellCommand.exec(null, null, stringArray, null, new File(string7, "bin"));
        }
        catch (Exception exception) {
            throw new LocalizationException("Exception while invoking langinstall command: " + stringArray[2] + "\n" + exception.getMessage());
        }
        return 0;
    }

    public int configureSortOrder(String string, String string2, String string3, String string4, String string5, String string6) throws LocalizationException {
        String string7 = this.getASEHomePath();
        String[] stringArray = new String[]{"sh", "-c", string6 != null ? string7 + "/bin/charset -S" + string3 + " -U" + string4 + " -P" + string5 + " -I" + string6 + " " + string + " " + string2 : string7 + "/bin/charset -S" + string3 + " -U" + string4 + " -P" + string5 + " " + string + " " + string2};
        log.info((Object)("Running charset: " + stringArray[2]));
        try {
            ShellCommand.exec(null, null, stringArray, null, new File(string7, "bin"));
        }
        catch (Exception exception) {
            throw new LocalizationException("Exception while invoking charset utility - " + stringArray[2] + "\n" + exception.getMessage());
        }
        return 0;
    }

    public List getAllCharsets(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            String string2 = this.getSybaseHomePath();
            File file = new File(string2 + "/charsets");
            File[] fileArray = file.listFiles();
            block0: for (int i = 0; i < fileArray.length; ++i) {
                String[] stringArray = fileArray[i].list();
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!stringArray[j].equalsIgnoreCase("charset.loc")) continue;
                    arrayList.add(fileArray[i].getName());
                    continue block0;
                }
            }
        } else {
            arrayList.addAll(this.getRelDirCharsetsFromLocFile(string));
            if (arrayList.isEmpty()) {
                arrayList.addAll(this.getRelDirCharsets(string));
            }
        }
        return arrayList;
    }

    public List getAllLanguages() throws LocalizationException {
        return this.getRelDirLanguages(null);
    }

    public HashMap getAllSortOrders(String string) throws LocalizationException {
        HashMap hashMap = this.getRelDirSortOrders(string);
        if (string.equalsIgnoreCase("utf8")) {
            hashMap.putAll(this.getServerConfiguredSortOrders(string));
        }
        return hashMap;
    }

    public HashMap getAllLocaleInformation() throws LocalizationException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        List list = this.getAllLanguages();
        for (String string : list) {
            List list2 = this.getAllCharsets(string);
            HashMap<String, HashMap> hashMap2 = new HashMap<String, HashMap>();
            for (String string2 : list2) {
                HashMap hashMap3 = this.getAllSortOrders(string2);
                hashMap2.put(string2, hashMap3);
            }
            Properties properties = new Properties();
            boolean bl = this.isLanguageInstalled(string);
            properties.put("INSTALLED", new Boolean(bl));
            properties.put("VALID_CHARSETS", hashMap2);
            hashMap.put(string, properties);
        }
        return hashMap;
    }

    public Properties getDefaultLocalization() throws LocalizationException {
        Properties properties = new Properties();
        properties.put("DEFAULT_LANGUAGE", this.getServerDefaultLanguage());
        properties.put("DEFAULT_CHARSET", this.getServerDefaultCharset());
        properties.put("DEFAULT_SORTORDER", this.getServerDefaultSortOrder());
        return properties;
    }

    public List getRelDirCharsets(String string) {
        String string2 = this.getASEHomePath();
        File file = new File(string2 + "/locales/" + string);
        File[] fileArray = file.listFiles();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.equalsIgnoreCase("us_english")) {
            arrayList.add("ascii_8");
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2;
            if (fileArray[i].isFile() || !(file2 = new File(fileArray[i] + "/sybinit/auditinit.loc")).exists()) continue;
            arrayList.add(fileArray[i].getName());
        }
        if (!arrayList.contains("utf8")) {
            arrayList.add("utf8");
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getRelDirCharsetsFromLocFile(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.equalsIgnoreCase("us_english")) {
            arrayList.add("ascii_8");
        }
        String string2 = this.getASEHomePath();
        File file = new File(string2 + "/locales/" + string);
        String string3 = "server.loc";
        File file2 = new File(file.getAbsolutePath() + File.separator + string3);
        if (!file2.exists()) {
            return arrayList;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file2));
            String string4 = this.getCharsetLine(bufferedReader);
            String[] stringArray = string4.split(",");
            int n = 0;
            for (n = 0; n < stringArray.length; ++n) {
                arrayList.add(stringArray[n]);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        return arrayList;
    }

    private String getCharsetLine(BufferedReader bufferedReader) throws IOException {
        String string = null;
        boolean bl = false;
        String string2 = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith(";")) continue;
            if (!bl && string.indexOf("[charset choices]") != -1) {
                bl = true;
                continue;
            }
            if (!bl || string.indexOf("charset =") == -1) continue;
            string2 = string.substring(string.indexOf("=") + 1);
            string2 = string2.replaceAll(" ", "");
            break;
        }
        return string2;
    }

    public List getRelDirLanguages(String string) {
        String string2 = this.getASEHomePath();
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string2 + "/locales");
        String[] stringArray = file.list();
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (string3.equalsIgnoreCase("unicode")) continue;
            bl = true;
            if (string != null && !this.getAllCharsets(string3).contains(string)) {
                bl = false;
            }
            if (!bl) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public HashMap getRelDirSortOrders(String string) throws LocalizationException {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = this.getSybaseHomePath();
        File file = new File(string2 + "/charsets/" + string);
        File[] fileArray = file.listFiles();
        block2: for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].getName().endsWith(".srt")) continue;
            try {
                String string3;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(fileArray[i]));
                String string4 = null;
                String string5 = null;
                while ((string3 = bufferedReader.readLine()) != null) {
                    if ((string3 = string3.trim()).indexOf(59) == 0) continue;
                    if (string3.indexOf("name") == 0) {
                        string4 = string3.indexOf(";") != -1 ? string3.substring(string3.indexOf("=") + 1, string3.indexOf(";") - 1) : string3.substring(string3.indexOf("=") + 1);
                        string4 = string4.trim();
                    }
                    if (string3.indexOf("menuname") != -1) {
                        string5 = string3.indexOf(";") != -1 ? string3.substring(string3.indexOf("=") + 1, string3.indexOf(";") - 1) : string3.substring(string3.indexOf("=") + 1);
                        if (string5.indexOf("\"") != -1) {
                            string5 = string5.replace('\"', ' ');
                        }
                        string5 = string5.trim();
                    }
                    if (string4 == null || string5 == null) continue;
                    hashMap.put(string4, string5);
                    continue block2;
                }
                continue;
            }
            catch (Exception exception) {
                throw new LocalizationException("Exception while retrieving sortorders for charset: " + string + "::\n" + exception.getMessage());
            }
        }
        return hashMap;
    }

    public String getSortOrderFileName(String string, String string2) throws LocalizationException {
        String string3 = this.getSybaseHomePath();
        File file = new File(string3 + "/charsets/" + string2);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].getName().endsWith(".srt")) continue;
            try {
                String string4;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(fileArray[i]));
                String string5 = null;
                while ((string4 = bufferedReader.readLine()) != null) {
                    if ((string4 = string4.trim()).indexOf(59) == 0 || string4.indexOf("name") != 0) continue;
                    string5 = string4.indexOf(";") != -1 ? string4.substring(string4.indexOf("=") + 1, string4.indexOf(";") - 1) : string4.substring(string4.indexOf("=") + 1);
                    if (string.indexOf(string5 = string5.trim()) == -1) continue;
                    return fileArray[i].getName();
                }
                continue;
            }
            catch (Exception exception) {
                throw new LocalizationException("Could not get sort order file name for " + string + "\n Exception :" + exception.getMessage());
            }
        }
        return null;
    }

    public List getServerConfiguredCharsets() throws LocalizationException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Statement statement = this.jdbcConnection.createStatement();
            ResultSet resultSet = statement.executeQuery(GET_CHARSETS);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            throw new LocalizationException("Exception while modifying default charset: " + sQLException.getMessage());
        }
        return arrayList;
    }

    public List getServerConfiguredLanguages() throws LocalizationException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("us_english");
        try {
            Statement statement = this.jdbcConnection.createStatement();
            ResultSet resultSet = statement.executeQuery(GET_LANGUAGES);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            throw new LocalizationException("Exception while retrieving installed languages: " + sQLException.getMessage());
        }
        return arrayList;
    }

    public HashMap getServerConfiguredSortOrders(String string) throws LocalizationException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            PreparedStatement preparedStatement;
            if (string.equalsIgnoreCase("utf8")) {
                preparedStatement = this.jdbcConnection.prepareStatement(GET_SORTORDERS_UTF8);
            } else {
                preparedStatement = this.jdbcConnection.prepareStatement(GET_SORTORDERS_FOR_CHARSET);
                preparedStatement.setString(1, string);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                hashMap.put(resultSet.getString(1), resultSet.getString(2));
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            throw new LocalizationException("Exception while retrieving installed sortorders for charset: " + string + "::\n" + sQLException.getMessage());
        }
        return hashMap;
    }

    public String getServerDefaultCharset() throws LocalizationException {
        String string = null;
        try {
            Statement statement = this.jdbcConnection.createStatement();
            ResultSet resultSet = statement.executeQuery(GET_DEFAULT_CHARSET);
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            throw new LocalizationException("Exception while retrieving default charset : " + sQLException.getMessage());
        }
        return string;
    }

    public String getServerDefaultLanguage() throws LocalizationException {
        String string = null;
        try {
            Statement statement = this.jdbcConnection.createStatement();
            ResultSet resultSet = statement.executeQuery(GET_DEFAULT_LANG_ID);
            int n = -1;
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
            statement.close();
            if (n == 0) {
                string = "us_english";
            } else {
                PreparedStatement preparedStatement = this.jdbcConnection.prepareStatement(GET_LANG_NAME_FROM_ID);
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    string = resultSet.getString(1);
                }
                resultSet.close();
                preparedStatement.close();
            }
        }
        catch (SQLException sQLException) {
            throw new LocalizationException("Exception while retrieving default language : " + sQLException.getMessage());
        }
        if (string == null) {
            string = "us_english";
        }
        return string;
    }

    public String getServerDefaultSortOrder() throws LocalizationException {
        String string = null;
        try {
            Statement statement = this.jdbcConnection.createStatement();
            ResultSet resultSet = statement.executeQuery(GET_DEFAULT_SORTORDER);
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            throw new LocalizationException("Exception while retrieving default sortorder: " + sQLException.getMessage());
        }
        return string;
    }

    public int removeCharset(String string) throws LocalizationException {
        int n = 0;
        this.enableSystemUpdates(true);
        try {
            CallableStatement callableStatement = this.jdbcConnection.prepareCall(REMOVE_CHARSET);
            callableStatement.clearWarnings();
            callableStatement.setString(1, string);
            n = callableStatement.executeUpdate();
            callableStatement.close();
            this.enableSystemUpdates(false);
        }
        catch (SQLException sQLException) {
            throw new LocalizationException("Exception while removing charset " + string + "::\n " + sQLException.getMessage());
        }
        return n;
    }

    void enableSystemUpdates(boolean bl) throws LocalizationException {
        int n = 0;
        if (bl) {
            n = 1;
        }
        try {
            CallableStatement callableStatement = this.jdbcConnection.prepareCall(ENABLE_SYSTEM_UPDATES);
            callableStatement.clearWarnings();
            callableStatement.setInt(1, n);
            callableStatement.execute();
            callableStatement.close();
        }
        catch (SQLException sQLException) {
            throw new LocalizationException("Exception while enabling system updates : " + sQLException.getMessage());
        }
    }

    public int removeLanguage(String string) throws LocalizationException {
        if (string.equalsIgnoreCase("us_english")) {
            throw new LocalizationException("Cannot remove English");
        }
        int n = 0;
        String string2 = this.getServerDefaultLanguage();
        if (string.equalsIgnoreCase(string2)) {
            throw new LocalizationException("Cannot remove " + string2 + "since it is the default language");
        }
        List list = this.getServerConfiguredLanguages();
        if (!list.contains(string)) {
            throw new LocalizationException("Cannot remove " + string2 + " since it is not installed in the server");
        }
        this.enableSystemUpdates(true);
        try {
            CallableStatement callableStatement = this.jdbcConnection.prepareCall(REMOVE_LANGUAGE);
            callableStatement.clearWarnings();
            callableStatement.setString(1, string);
            n = callableStatement.executeUpdate();
            callableStatement.close();
        }
        catch (SQLException sQLException) {
            throw new LocalizationException("Exception while removing language" + string + "::\n " + sQLException.getMessage());
        }
        this.enableSystemUpdates(false);
        return n;
    }

    public int removeSortOrder(String string) throws LocalizationException {
        int n = 0;
        this.enableSystemUpdates(true);
        try {
            CallableStatement callableStatement = this.jdbcConnection.prepareCall(REMOVE_SORT_ORDER);
            callableStatement.clearWarnings();
            callableStatement.setString(1, string);
            n = callableStatement.executeUpdate();
            callableStatement.close();
        }
        catch (SQLException sQLException) {
            throw new LocalizationException("Exception while removing sort order " + string + "::\n " + sQLException.getMessage());
        }
        this.enableSystemUpdates(false);
        return n;
    }

    public int setServerDefaultCharset(String string, String string2) throws LocalizationException {
        int n = 0;
        try {
            String string3 = this.getServerDefaultCharset();
            if (string3.equalsIgnoreCase(string)) {
                log.info((Object)"The selected charset is already default charset");
                return n;
            }
            if (string2 == null) {
                string2 = this.getServerDefaultSortOrder();
            }
            PreparedStatement preparedStatement = this.jdbcConnection.prepareStatement(GET_CHARSET_ID);
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            int n2 = -1;
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.close();
            if (n2 == -1) {
                throw new LocalizationException("Could not find charset id for charset " + string);
            }
            CallableStatement callableStatement = this.jdbcConnection.prepareCall(SET_DEFAULT_CHARSET);
            callableStatement.clearWarnings();
            callableStatement.setInt(1, n2);
            callableStatement.setString(2, string2);
            callableStatement.execute();
            callableStatement.close();
        }
        catch (SQLException sQLException) {
            throw new LocalizationException("Exception while modifying default charset : " + sQLException.getMessage());
        }
        return n;
    }

    public int setServerDefaultLanguage(String string) throws LocalizationException {
        int n = 0;
        try {
            PreparedStatement preparedStatement;
            int n2 = -1;
            if (string.equalsIgnoreCase("us_english")) {
                n2 = 0;
            } else {
                preparedStatement = this.jdbcConnection.prepareStatement(GET_LANG_ID);
                preparedStatement.setString(1, string);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n2 = resultSet.getInt(1);
                }
                resultSet.close();
                preparedStatement.close();
            }
            if (n2 == -1) {
                throw new LocalizationException("Could not find language id for language" + string);
            }
            preparedStatement = this.jdbcConnection.prepareCall(SET_DEFAULT_LANGUAGE);
            preparedStatement.clearWarnings();
            preparedStatement.setInt(1, n2);
            preparedStatement.execute();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            throw new LocalizationException("Exception while modifying default language : " + sQLException.getMessage());
        }
        return n;
    }

    public int setServerDefaultSortOrder(String string, String string2) throws LocalizationException {
        int n = 0;
        try {
            String string3;
            if (string2 == null) {
                string2 = this.getServerDefaultCharset();
            }
            if ((string3 = this.getServerDefaultSortOrder()).equalsIgnoreCase(string)) {
                log.info((Object)"Given sort order is already the default");
                return n;
            }
            PreparedStatement preparedStatement = this.jdbcConnection.prepareStatement(GET_SORTORDER_ID);
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            int n2 = -1;
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.close();
            if (n2 == -1) {
                throw new LocalizationException("Could not find sortorder id for sortorder" + string);
            }
            CallableStatement callableStatement = this.jdbcConnection.prepareCall(SET_DEFAULT_SORTORDER);
            callableStatement.clearWarnings();
            callableStatement.setInt(1, n2);
            callableStatement.setString(2, string2);
            callableStatement.execute();
            callableStatement.close();
        }
        catch (SQLException sQLException) {
            throw new LocalizationException("Exception while modifying default sortorder : " + sQLException.getMessage());
        }
        return n;
    }

    String getSybaseHomePath() {
        return this.sybaseHomePath;
    }

    String getASEHomePath() {
        return this.sybaseASEHomePath;
    }

    private boolean isLanguageInstalled(String string) throws LocalizationException {
        List list = this.getServerConfiguredLanguages();
        return list.contains(string);
    }
}

