/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.util;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class Logging {
    public static final int MESSAGE_LEVEL_OFF = 0;
    public static final int MESSAGE_LEVEL_FATAL = 1;
    public static final int MESSAGE_LEVEL_ERROR = 2;
    public static final int MESSAGE_LEVEL_WARN = 3;
    public static final int MESSAGE_LEVEL_INFO = 4;
    public static final int MESSAGE_LEVEL_DEBUG = 5;
    public static final int MESSAGE_LEVEL_ALL = 6;
    public static final int MESSAGE_LEVEL_DEFAULT = 4;
    private static final String DEFAULT_ROLLING_DATEPATTERN = ".yyyy-MM-dd";
    private static final String DEFAULT_FILE_PATTERNLAYOUT = "%d{ABSOLUTE} [%-5p] [%t] [%c.%M(%L)] - %m%n";
    private static final String DEFAULT_CONSOLE_PATTERNLAYOUT = "%m%n";
    private static final String RSKEY_FILENAME = "logging.file.filename";
    private static final String RSKEY_ROLLING_DATEPATTERN = "logging.file.rolling.datepattern";
    private static final String RSKEY_FILE_PATTERNLAYOUT = "logging.file.patternlayout";
    private static final String RSKEY_CONSOLE_PATTERNLAYOUT = "logging.console.patternlayout";
    private static final String RSKEY_ERROR_FILE = "logging.error.file";
    private static final String RSKEY_ERROR_ROLLINGFILE = "logging.error.file.rolling";

    public static void setLogging(ResourceBundle resourceBundle, String string, String string2, int n, String string3, int n2, boolean bl) throws Exception {
        Logger logger = Logger.getRootLogger();
        logger.removeAllAppenders();
        Logger logger2 = Logger.getLogger((String)string);
        logger2.removeAllAppenders();
        int n3 = Math.max(n, n2);
        logger2.setLevel(Logging.getLevel(n3));
        logger2.setResourceBundle(resourceBundle);
        if (n != 0) {
            logger2.addAppender(Logging.getConsoleAppender(resourceBundle, string2, (Priority)Logging.getLevel(n)));
        }
        if (n2 != 0) {
            try {
                if (bl) {
                    logger2.addAppender(Logging.getRollingLogFileAppender(resourceBundle, string3, (Priority)Logging.getLevel(n2)));
                } else {
                    logger2.addAppender(Logging.getLogFileAppender(resourceBundle, string3, (Priority)Logging.getLevel(n2)));
                }
            }
            catch (Exception exception) {
                throw new Exception("Unable to add the appender for logging.");
            }
        }
    }

    private static Appender getConsoleAppender(ResourceBundle resourceBundle, String string, Priority priority) {
        String string2 = Logging.getValue(resourceBundle, RSKEY_CONSOLE_PATTERNLAYOUT, DEFAULT_CONSOLE_PATTERNLAYOUT);
        PatternLayout patternLayout = new PatternLayout(string2);
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)patternLayout, string);
        consoleAppender.setThreshold(priority);
        return consoleAppender;
    }

    private static Appender getLogFileAppender(ResourceBundle resourceBundle, String string, Priority priority) throws Exception {
        FileAppender fileAppender = null;
        try {
            String string2 = Logging.getValue(resourceBundle, RSKEY_FILENAME, string);
            String string3 = Logging.getValue(resourceBundle, RSKEY_FILE_PATTERNLAYOUT, DEFAULT_FILE_PATTERNLAYOUT);
            PatternLayout patternLayout = new PatternLayout(string3);
            fileAppender = new FileAppender((Layout)patternLayout, string2, true);
            fileAppender.setThreshold(priority);
        }
        catch (IOException iOException) {
            if (resourceBundle != null) {
                String string4 = resourceBundle.getString(RSKEY_ERROR_FILE);
                MessageFormat messageFormat = new MessageFormat(string4);
                Object[] objectArray = new Object[]{iOException.getMessage()};
                throw new Exception(messageFormat.format(objectArray));
            }
            throw iOException;
        }
        return fileAppender;
    }

    private static Appender getRollingLogFileAppender(ResourceBundle resourceBundle, String string, Priority priority) throws Exception {
        DailyRollingFileAppender dailyRollingFileAppender = null;
        try {
            String string2 = Logging.getValue(resourceBundle, RSKEY_FILENAME, string);
            String string3 = Logging.getValue(resourceBundle, RSKEY_ROLLING_DATEPATTERN, DEFAULT_ROLLING_DATEPATTERN);
            String string4 = Logging.getValue(resourceBundle, RSKEY_FILE_PATTERNLAYOUT, DEFAULT_FILE_PATTERNLAYOUT);
            PatternLayout patternLayout = new PatternLayout(string4);
            dailyRollingFileAppender = new DailyRollingFileAppender((Layout)patternLayout, string2, string3);
            dailyRollingFileAppender.setThreshold(priority);
        }
        catch (IOException iOException) {
            if (resourceBundle != null) {
                String string5 = resourceBundle.getString(RSKEY_ERROR_ROLLINGFILE);
                MessageFormat messageFormat = new MessageFormat(string5);
                Object[] objectArray = new Object[]{iOException.getMessage()};
                throw new Exception(messageFormat.format(objectArray));
            }
            throw iOException;
        }
        return dailyRollingFileAppender;
    }

    private static Level getLevel(int n) {
        Level level;
        switch (n) {
            case 0: {
                level = Level.OFF;
                break;
            }
            case 1: {
                level = Level.FATAL;
                break;
            }
            default: {
                level = Level.WARN;
                break;
            }
            case 4: {
                level = Level.INFO;
                break;
            }
            case 5: {
                level = Level.DEBUG;
                break;
            }
            case 6: {
                level = Level.ALL;
            }
        }
        return level;
    }

    private static String getValue(ResourceBundle resourceBundle, String string, String string2) {
        String string3 = null;
        if (resourceBundle != null) {
            string3 = resourceBundle.getString(string);
        }
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }
}

