/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.util;

import com.sybase.ase.sdcadmin.config.ICluster;
import com.sybase.ase.sdcadmin.config.IServer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PortUtil {
    private static Log log = LogFactory.getLog(PortUtil.class);
    public static final int MINIMUM_PORT_VALUE = 1025;
    public static final int MAXIMUM_PORT_VALUE = 65535;
    public static final int RECOMMENDED_PORT_VALUE = 15000;
    public static final int PORTS_REQUIRED = 5;
    private static final Log LOG = LogFactory.getLog(PortUtil.class);
    public static final int PORT_STRATEGY_UNKNOWN = 0;
    public static final int PORT_STRATEGY_PUBLIC_PRIM_SEC_REPEATED = 1;
    public static final int PORT_STRATEGY_PUBLIC_PRIM_SEC_UNIQUE = 2;
    public static final int PORT_STRATEGY_PRIVATE_REPEATED = 3;
    public static final int PORT_STRATEGY_PRIVATE_PRIM_SEC_UNIQUE = 4;

    public static void calculatePortNumbers(ICluster iCluster, Integer n) {
        boolean bl = true;
        if (iCluster.getSecondaryInterconnect() == null || iCluster.getSecondaryInterconnect().equals("")) {
            bl = false;
        }
        int n2 = n;
        int n3 = n;
        int n4 = 5 * iCluster.getMaxInstances();
        int n5 = n2 + n4 * iCluster.getMaxInstances() - 1;
        n3 = n5 + 1;
        IServer[] iServerArray = iCluster.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            int n6 = iServerArray[i].getId();
            int n7 = n2 + n4 * (n6 - 1);
            iServerArray[i].setPrimaryPortStart(String.valueOf(n7));
            if (!bl) continue;
            int n8 = n3 + n4 * (n6 - 1);
            iServerArray[i].setSecondaryPortStart(String.valueOf(n8));
        }
    }

    public static int calculatePortEnd(int n, int n2) {
        int n3 = 5 * n;
        return n2 + n3 - 1;
    }

    public static int calculatePortEnd(Integer n, String string) {
        int n2 = 5 * n;
        int n3 = Integer.parseInt(string);
        return n3 + n2 - 1;
    }

    public static int getRecommendedPortStrategy(ICluster iCluster) {
        int n = 0;
        int n2 = iCluster.getNodeInstanceStrategy();
        switch (n2) {
            case 1: {
                boolean bl = PortUtil.hasPrivateNetwork(iCluster);
                if (bl) {
                    if (PortUtil.hasSecondaryNetwork(iCluster)) {
                        n = 3;
                        break;
                    }
                    n = 4;
                    break;
                }
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
        }
        return n;
    }

    public static boolean isPortRangeRepeated(ICluster iCluster) {
        if (iCluster.getSecondaryInterconnect() == null || iCluster.getSecondaryInterconnect().equals("")) {
            return false;
        }
        boolean bl = true;
        IServer[] iServerArray = iCluster.getServersArray();
        int n = Integer.parseInt(iServerArray[0].getPrimaryPortStart());
        for (int i = 0; i < iServerArray.length; ++i) {
            if (n == Integer.parseInt(iServerArray[i].getPrimaryPortStart()) && n == Integer.parseInt(iServerArray[i].getSecondaryPortStart())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean isPortPrimSecUnique(ICluster iCluster) {
        boolean bl = true;
        if (iCluster.getSecondaryInterconnect() != null && !iCluster.getSecondaryInterconnect().equals("")) {
            IServer[] iServerArray = iCluster.getServersArray();
            for (int i = 0; i < iServerArray.length; ++i) {
                int n;
                int n2 = Integer.parseInt(iServerArray[i].getPrimaryPortStart());
                if (n2 != (n = Integer.parseInt(iServerArray[i].getSecondaryPortStart()))) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static boolean isPortAllUnique(ICluster iCluster) {
        boolean bl = false;
        if (iCluster.getSecondaryInterconnect() != null && !iCluster.getSecondaryInterconnect().equals("")) {
            bl = true;
        }
        Hashtable<String, IServer> hashtable = new Hashtable<String, IServer>();
        boolean bl2 = true;
        IServer[] iServerArray = iCluster.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            if (hashtable.contains(iServerArray[i].getPrimaryPortStart())) {
                bl2 = false;
                break;
            }
            if (bl && hashtable.contains(iServerArray[i].getSecondaryPortStart())) {
                bl2 = false;
                break;
            }
            hashtable.put(iServerArray[i].getPrimaryPortStart(), iServerArray[i]);
            if (!bl) continue;
            hashtable.put(iServerArray[i].getSecondaryPortStart(), iServerArray[i]);
        }
        return bl2;
    }

    public static int getCurrentPortStrategy(ICluster iCluster) {
        int n = 0;
        boolean bl = PortUtil.isPortRangeRepeated(iCluster);
        boolean bl2 = PortUtil.isPortPrimSecUnique(iCluster);
        boolean bl3 = PortUtil.isPortAllUnique(iCluster);
        boolean bl4 = PortUtil.hasPrivateNetwork(iCluster);
        boolean bl5 = false;
        if (bl4) {
            bl5 = PortUtil.hasSecondaryNetwork(iCluster);
        }
        if (bl && bl4) {
            n = 3;
        }
        if (bl2) {
            n = bl4 ? 4 : 2;
        }
        if (bl3) {
            n = 2;
        }
        return n;
    }

    public static int getPortsRequiredPerInstancePerInterconnect(ICluster iCluster) {
        return 5 * iCluster.getMaxInstances();
    }

    public static void calculateInstancePortNumbers(ICluster iCluster, IServer iServer) {
        boolean bl = true;
        if (iCluster.getSecondaryInterconnect() == null || iCluster.getSecondaryInterconnect().equals("")) {
            bl = false;
        }
        int n = PortUtil.getCurrentPortStrategy(iCluster);
        IServer[] iServerArray = iCluster.getServersArray();
        int n2 = PortUtil.getPortsRequiredPerInstancePerInterconnect(iCluster);
        int n3 = Integer.parseInt(iServerArray[0].getPrimaryPortStart());
        int n4 = PortUtil.calculatePortEnd(iCluster.getMaxInstances(), iServerArray[0].getPrimaryPortStart());
        int n5 = 0;
        int n6 = 0;
        if (bl) {
            n5 = Integer.parseInt(iServerArray[0].getSecondaryPortStart());
            n6 = PortUtil.calculatePortEnd(iCluster.getMaxInstances(), iServerArray[0].getSecondaryPortStart());
        }
        switch (n) {
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                int n7 = iServer.getId();
                int n8 = iServerArray[0].getId();
                int n9 = (n8 - 1) * n2;
                n3 = n3 - n9 + (n7 - 1) * n2;
                n4 = n4 - n9 + (n7 - 1) * n2;
                n5 = n5 - n9 + (n7 - 1) * n2;
                n6 = n6 - n9 + (n7 - 1) * n2;
                break;
            }
            case 0: {
                int n10 = 0;
                for (int i = 0; i < iServerArray.length; ++i) {
                    n10 = Math.max(n10, PortUtil.calculatePortEnd(iCluster.getMaxInstances(), iServerArray[i].getPrimaryPortStart()));
                    n10 = Math.max(n10, PortUtil.calculatePortEnd(iCluster.getMaxInstances(), iServerArray[i].getSecondaryPortStart()));
                }
                n3 = n10 + 1;
                n4 = n3 + n2;
                n5 = n4 + 1;
                n6 = n5 + n2;
            }
        }
        iServer.setPrimaryPortStart(String.valueOf(n3));
        if (bl) {
            iServer.setSecondaryPortStart(String.valueOf(n5));
        }
    }

    public static boolean hasPrivateNetwork(ICluster iCluster) {
        boolean bl = false;
        IServer[] iServerArray = iCluster.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            try {
                InetAddress inetAddress = InetAddress.getByName(iServerArray[i].getNode());
                InetAddress inetAddress2 = InetAddress.getByName(iServerArray[i].getPrimaryAddress());
                if (iServerArray[i].getSecondaryAddress() != null && !iServerArray[i].getSecondaryAddress().equals("")) {
                    InetAddress inetAddress3 = InetAddress.getByName(iServerArray[i].getSecondaryAddress());
                    if (inetAddress.equals(inetAddress2) && inetAddress.equals(inetAddress3)) continue;
                    bl = true;
                    break;
                }
                if (inetAddress.equals(inetAddress2)) continue;
                bl = true;
                break;
            }
            catch (UnknownHostException unknownHostException) {
                System.out.println(unknownHostException);
                log.error((Object)unknownHostException, (Throwable)unknownHostException);
            }
        }
        return bl;
    }

    public static boolean hasSecondaryNetwork(ICluster iCluster) {
        boolean bl = false;
        if (iCluster.getSecondaryInterconnect() != null && !iCluster.getSecondaryInterconnect().equals("")) {
            IServer[] iServerArray = iCluster.getServersArray();
            for (int i = 0; i < iServerArray.length; ++i) {
                try {
                    InetAddress inetAddress = InetAddress.getByName(iServerArray[i].getPrimaryAddress());
                    InetAddress inetAddress2 = InetAddress.getByName(iServerArray[i].getSecondaryAddress());
                    if (inetAddress.equals(inetAddress2)) continue;
                    bl = true;
                    break;
                }
                catch (UnknownHostException unknownHostException) {
                    System.out.println(unknownHostException);
                    log.error((Object)unknownHostException, (Throwable)unknownHostException);
                }
            }
        }
        return bl;
    }

    public static boolean isSameHost(String string, String string2) {
        InetAddress inetAddress = null;
        InetAddress inetAddress2 = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        try {
            inetAddress2 = InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        return inetAddress.equals(inetAddress2);
    }

    public static boolean isThisHost(String string) {
        InetAddress inetAddress = null;
        InetAddress inetAddress2 = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        try {
            inetAddress2 = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        return inetAddress.equals(inetAddress2);
    }

    public static int getMinimumPort(ICluster iCluster) {
        int n = Integer.MAX_VALUE;
        IServer[] iServerArray = iCluster.getServersArray();
        for (int i = 0; i < iServerArray.length; ++i) {
            n = PortUtil.getMinimumPort(n, iServerArray[i].getPrimaryPortStart());
            n = PortUtil.getMinimumPort(n, iServerArray[i].getSecondaryPortStart());
        }
        return n;
    }

    private static int getMinimumPort(int n, String string) {
        int n2;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.warn((Object)("Unable to convert the port number string " + string + " to an integer."));
            return n;
        }
        if (n2 < 1025) {
            return n;
        }
        return Math.min(n, n2);
    }

    public static String getPortStrategyString(ResourceBundle resourceBundle, int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = resourceBundle.getString("sdcadmin.diagnose.port.strategy.unknown");
                break;
            }
            case 1: {
                string = resourceBundle.getString("sdcadmin.diagnose.port.strategy.public.prim.sec.repeated");
                break;
            }
            case 2: {
                string = resourceBundle.getString("sdcadmin.diagnose.port.strategy.public.prim.sec.unique");
                break;
            }
            case 3: {
                string = resourceBundle.getString("sdcadmin.diagnose.port.strategy.private.repeated");
                break;
            }
            case 4: {
                string = resourceBundle.getString("sdcadmin.diagnose.port.strategy.private.prim.sec.unique");
            }
        }
        return string;
    }
}

