/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.sdcadmin.util;

import com.sybase.ase.sdcadmin.util.FileUtil;
import com.sybase.ase.sdcadmin.util.Message;
import com.sybase.ase.sdcadmin.util.OutputReader;
import java.io.File;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShellCommand {
    public static final String[] DEFAULT_COMMAND_ROUTINES = new String[]{"charset", "dataserver", "qrmutil", "srvbuildres", "SYBASE.sh", "SYBASE.bat"};
    private static final Log LOG = LogFactory.getLog(ShellCommand.class);

    public static String[] exec(Message message, ResourceBundle resourceBundle, String[] stringArray) throws Exception {
        return ShellCommand.exec(message, resourceBundle, stringArray, null, null);
    }

    public static String[] exec(Message message, ResourceBundle resourceBundle, String[] stringArray, String[] stringArray2) throws Exception {
        return ShellCommand.exec(message, resourceBundle, stringArray, stringArray2, null);
    }

    public static String[] exec(Message message, ResourceBundle resourceBundle, String[] stringArray, File file) throws Exception {
        return ShellCommand.exec(message, resourceBundle, stringArray, null, file);
    }

    public static synchronized String[] exec(Message message, ResourceBundle resourceBundle, String[] stringArray, String[] stringArray2, File file) throws Exception {
        return ShellCommand.exec(message, resourceBundle, stringArray, null, file, null);
    }

    public static synchronized String[] exec(Message message, ResourceBundle resourceBundle, String[] stringArray, String[] stringArray2, File file, String[] stringArray3) throws Exception {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        String string = ShellCommand.parseCommandWithoutArgs(stringArray[2]);
        if (!ShellCommand.isInCommandRoutine(string, stringArray3)) {
            return new String[0];
        }
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        process = runtime.exec(stringArray, stringArray2, file);
        OutputReader outputReader = new OutputReader(message, resourceBundle, process.getInputStream(), vector);
        outputReader.start();
        OutputReader outputReader2 = new OutputReader(message, resourceBundle, process.getErrorStream(), vector2);
        outputReader2.start();
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n = 0;
        while (!outputReader.outputCompleted && !outputReader2.outputCompleted) {
            Thread.sleep(100L);
            Thread.yield();
            ++n;
        }
        LOG.debug((Object)("Waited " + n * 100 + " milliseconds."));
        for (int i = 0; i < vector2.size(); ++i) {
            LOG.debug((Object)FileUtil.removeControlCharacter((String)vector2.get(i)));
        }
        if (process.exitValue() != 0) {
            throw new Exception("Command returned " + process.exitValue());
        }
        String[] stringArray4 = null;
        int n2 = vector.size();
        stringArray4 = new String[n2];
        vector.toArray(stringArray4);
        return stringArray4;
    }

    public static String parseCommandWithoutArgs(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f;&", false);
        String string2 = "";
        while (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken()).equals(".")) {
        }
        return string2;
    }

    public static boolean isInCommandRoutine(String string, String[] stringArray) {
        String[] stringArray2 = stringArray;
        if (null == stringArray || stringArray.length == 0) {
            stringArray2 = DEFAULT_COMMAND_ROUTINES;
        }
        if (null == string || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!string.endsWith(stringArray2[i])) continue;
            return true;
        }
        return false;
    }
}

